/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class FileUtil {
    public static void writeObject(Serializable o, File file) throws FileNotFoundException, IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        oos.writeObject(o);
        oos.close();
    }

    public static void writeObject(Serializable o, String file) throws FileNotFoundException, IOException {
        FileUtil.writeObject(o, new File(file));
    }

    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public static Object readObject(String file) throws IOException, ClassNotFoundException {
        return FileUtil.readObject(new File(file));
    }

    public static <T> T readObject(File file, Class<T> class1) throws IOException, ClassNotFoundException {
        return class1.cast(FileUtil.readObject(file));
    }

    public static String readLine(RandomAccessFile file, long startPos) throws IOException {
        file.seek(startPos);
        return file.readLine();
    }

    public static List<String> readLines(File file) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = in.readLine()) != null) {
            result.add(line);
        }
        in.close();
        return result;
    }

    public static String readToString(File file) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StringBuilder result = new StringBuilder();
        while ((line = in.readLine()) != null) {
            result.append(line).append("\n");
        }
        in.close();
        return result.toString();
    }

    public static void printString(File file, String s) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(file));
        out.print(s);
        out.close();
    }
}

