/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util;

import com.hughes.util.LRUCacheMap;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class CachingList<T>
extends AbstractList<T>
implements RandomAccess {
    private final List<T> list;
    private final int size;
    private final LRUCacheMap<Integer, T> cache;

    public CachingList(List<T> list, int cacheSize) {
        this.list = list;
        this.size = list.size();
        this.cache = new LRUCacheMap(cacheSize);
    }

    public static <T> CachingList<T> create(List<T> list, int cacheSize) {
        return new CachingList<T>(list, cacheSize);
    }

    public static <T> CachingList<T> createFullyCached(List<T> list) {
        return new CachingList<T>(list, list.size());
    }

    @Override
    public T get(int i) {
        Object t = this.cache.get(i);
        if (t == null) {
            t = this.list.get(i);
            this.cache.put(i, t);
        }
        return (T)t;
    }

    @Override
    public int size() {
        return this.size;
    }
}

