/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.util;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class PersistentObjectCache {
    private final File dir;
    private final Map<String, Object> objects = new LinkedHashMap<String, Object>();
    private static PersistentObjectCache instance = null;

    public synchronized <T> T read(String filename, Class<T> resultClass) {
        File src;
        Object object;
        block7: {
            try {
                object = this.objects.get(filename);
                if (object != null) {
                    return resultClass.cast(object);
                }
                Log.d((String)this.getClass().getSimpleName(), (String)"Cache miss.");
                src = new File(this.dir, filename);
                if (src.canRead()) break block7;
                Log.d((String)this.getClass().getSimpleName(), (String)("File empty: " + src));
            }
            catch (ClassCastException e) {
                return null;
            }
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(src));
            object = in.readObject();
            in.close();
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)("Deserialization failed: " + src), (Throwable)e);
            return null;
        }
        this.objects.put(filename, object);
        return resultClass.cast(object);
    }

    public synchronized void write(String filename, Object object) {
        this.objects.put(filename, object);
        File dest = new File(this.dir, filename);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(dest));
            out.writeObject(object);
            out.close();
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)("Serialization failed: " + dest), (Throwable)e);
        }
    }

    private PersistentObjectCache(Context context) {
        File filesDir = context.getFilesDir();
        File file = this.dir = filesDir != null ? filesDir : Environment.getExternalStorageDirectory();
        if (this.dir == null) {
            throw new RuntimeException("context.getFilesDir() == " + context.getFilesDir() + ", Environment.getExternalStorageDirectory()=" + Environment.getExternalStorageDirectory());
        }
    }

    public static synchronized PersistentObjectCache getInstance() {
        if (instance == null) {
            throw new RuntimeException("getInstance called before init.");
        }
        return instance;
    }

    public static synchronized PersistentObjectCache init(Context context) {
        if (instance == null) {
            instance = new PersistentObjectCache(context);
        } else if (!PersistentObjectCache.instance.dir.equals(context.getFilesDir())) {
            throw new RuntimeException("File dir changed.  old=" + PersistentObjectCache.instance.dir + ", new=" + context.getFilesDir());
        }
        return instance;
    }
}

