/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.Language;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;

public class WiktionaryLangs {
    public static final Map<String, String> isoCodeToEnWikiName = new LinkedHashMap<String, String>();
    public static final Map<String, Map<String, String>> wikiCodeToIsoCodeToWikiName;

    static {
        isoCodeToEnWikiName.put("AF", "Afrikaans");
        isoCodeToEnWikiName.put("SQ", "Albanian");
        isoCodeToEnWikiName.put("AR", "Arabic");
        isoCodeToEnWikiName.put("HY", "Armenian");
        isoCodeToEnWikiName.put("BE", "Belarusian");
        isoCodeToEnWikiName.put("BN", "Bengali");
        isoCodeToEnWikiName.put("BG", "Bulgarian");
        isoCodeToEnWikiName.put("CA", "Catalan");
        isoCodeToEnWikiName.put("SH", "Serbo-Croatian");
        isoCodeToEnWikiName.put("HR", "Croatian");
        isoCodeToEnWikiName.put("CS", "Czech");
        isoCodeToEnWikiName.put("ZH", "Chinese");
        isoCodeToEnWikiName.put("cmn", "Mandarin");
        isoCodeToEnWikiName.put("yue", "Cantonese");
        isoCodeToEnWikiName.put("DA", "Danish");
        isoCodeToEnWikiName.put("NL", "Dutch");
        isoCodeToEnWikiName.put("EN", "English");
        isoCodeToEnWikiName.put("EO", "Esperanto");
        isoCodeToEnWikiName.put("ET", "Estonian");
        isoCodeToEnWikiName.put("FI", "Finnish");
        isoCodeToEnWikiName.put("FR", "French");
        isoCodeToEnWikiName.put("DE", "German");
        isoCodeToEnWikiName.put("EL", "Greek");
        isoCodeToEnWikiName.put("grc", "Ancient Greek");
        isoCodeToEnWikiName.put("haw", "Hawaiian");
        isoCodeToEnWikiName.put("HE", "Hebrew");
        isoCodeToEnWikiName.put("HI", "Hindi");
        isoCodeToEnWikiName.put("HU", "Hungarian");
        isoCodeToEnWikiName.put("IS", "Icelandic");
        isoCodeToEnWikiName.put("ID", "Indonesian");
        isoCodeToEnWikiName.put("GA", "Irish");
        isoCodeToEnWikiName.put("GD", "Gaelic");
        isoCodeToEnWikiName.put("IT", "Italian");
        isoCodeToEnWikiName.put("LA", "Latin");
        isoCodeToEnWikiName.put("LV", "Latvian");
        isoCodeToEnWikiName.put("LT", "Lithuanian");
        isoCodeToEnWikiName.put("JA", "Japanese");
        isoCodeToEnWikiName.put("KO", "Korean");
        isoCodeToEnWikiName.put("KU", "Kurdish");
        isoCodeToEnWikiName.put("LO", "Lao");
        isoCodeToEnWikiName.put("MS", "Malay$");
        isoCodeToEnWikiName.put("ML", "Malayalam");
        isoCodeToEnWikiName.put("MI", "Maori");
        isoCodeToEnWikiName.put("MN", "Mongolian");
        isoCodeToEnWikiName.put("NE", "Nepali");
        isoCodeToEnWikiName.put("NO", "Norwegian");
        isoCodeToEnWikiName.put("FA", "Persian");
        isoCodeToEnWikiName.put("PL", "Polish");
        isoCodeToEnWikiName.put("PT", "Portuguese");
        isoCodeToEnWikiName.put("PA", "Punjabi");
        isoCodeToEnWikiName.put("RO", "Romanian");
        isoCodeToEnWikiName.put("RU", "Russian");
        isoCodeToEnWikiName.put("SA", "Sanskrit");
        isoCodeToEnWikiName.put("SK", "Slovak");
        isoCodeToEnWikiName.put("SL", "Slovene|Slovenian");
        isoCodeToEnWikiName.put("SO", "Somali");
        isoCodeToEnWikiName.put("ES", "Spanish");
        isoCodeToEnWikiName.put("SW", "Swahili");
        isoCodeToEnWikiName.put("SV", "Swedish");
        isoCodeToEnWikiName.put("TL", "Tagalog");
        isoCodeToEnWikiName.put("TG", "Tajik");
        isoCodeToEnWikiName.put("TA", "Tamil");
        isoCodeToEnWikiName.put("TH", "Thai");
        isoCodeToEnWikiName.put("BO", "Tibetan");
        isoCodeToEnWikiName.put("TR", "Turkish");
        isoCodeToEnWikiName.put("UK", "Ukrainian");
        isoCodeToEnWikiName.put("UR", "Urdu");
        isoCodeToEnWikiName.put("VI", "Vietnamese");
        isoCodeToEnWikiName.put("CI", "Welsh");
        isoCodeToEnWikiName.put("YI", "Yiddish");
        isoCodeToEnWikiName.put("ZU", "Zulu");
        isoCodeToEnWikiName.put("AZ", "Azeri");
        isoCodeToEnWikiName.put("EU", "Basque");
        isoCodeToEnWikiName.put("BR", "Breton");
        isoCodeToEnWikiName.put("MR", "Burmese");
        isoCodeToEnWikiName.put("FO", "Faroese");
        isoCodeToEnWikiName.put("GL", "Galician");
        isoCodeToEnWikiName.put("KA", "Georgian");
        isoCodeToEnWikiName.put("HT", "Haitian Creole");
        isoCodeToEnWikiName.put("LB", "Luxembourgish");
        isoCodeToEnWikiName.put("MK", "Macedonian");
        LinkedHashSet<String> missing = new LinkedHashSet<String>(isoCodeToEnWikiName.keySet());
        missing.removeAll(Language.isoCodeToResources.keySet());
        assert (Language.isoCodeToResources.keySet().containsAll(isoCodeToEnWikiName.keySet()));
        wikiCodeToIsoCodeToWikiName = new LinkedHashMap<String, Map<String, String>>();
        wikiCodeToIsoCodeToWikiName.put("en", isoCodeToEnWikiName);
        LinkedHashMap<String, String> isoCodeToWikiName = new LinkedHashMap<String, String>();
        wikiCodeToIsoCodeToWikiName.put("de", isoCodeToWikiName);
        isoCodeToWikiName.put("DE", "Deutsch");
        isoCodeToWikiName.put("EN", "Englisch");
        isoCodeToWikiName.put("IT", "Italienisch");
        isoCodeToWikiName.put("PL", "Polnisch");
        isoCodeToWikiName.put("FR", "Franz\u00f6sisch");
        isoCodeToWikiName.put("EO", "Esperanto");
        isoCodeToWikiName.put("CA", "Katalanisch");
        isoCodeToWikiName.put("LA", "Lateinisch");
        isoCodeToWikiName.put("CS", "Tschechisch");
        isoCodeToWikiName.put("HU", "Ungarisch");
        isoCodeToWikiName.put("SV", "Schwedisch");
        isoCodeToWikiName.put("ES", "Spanisch");
        isoCodeToWikiName = new LinkedHashMap();
        wikiCodeToIsoCodeToWikiName.put("fr", isoCodeToWikiName);
        isoCodeToWikiName.put("FR", Pattern.quote("{{langue|fr}}"));
        isoCodeToWikiName.put("RU", Pattern.quote("{{langue|ru}}"));
        isoCodeToWikiName.put("BG", Pattern.quote("{{langue|bg}}"));
        isoCodeToWikiName.put("EN", Pattern.quote("{{langue|en}}"));
        isoCodeToWikiName.put("LA", Pattern.quote("{{langue|la}}"));
        isoCodeToWikiName.put("IT", Pattern.quote("{{langue|it}}"));
        isoCodeToWikiName.put("EO", Pattern.quote("{{langue|eo}}"));
        isoCodeToWikiName.put("CS", Pattern.quote("{{langue|cs}}"));
        isoCodeToWikiName.put("NL", Pattern.quote("{{langue|nl}}"));
        isoCodeToWikiName.put("ZH", Pattern.quote("{{langue|zh}}"));
        isoCodeToWikiName.put("cmn", Pattern.quote("{{langue|cmn}}"));
        isoCodeToWikiName.put("yue", Pattern.quote("{{langue|yue}}"));
        isoCodeToWikiName.put("JA", Pattern.quote("{{langue|ja}}"));
        isoCodeToWikiName.put("DE", Pattern.quote("{{langue|de}}"));
        isoCodeToWikiName.put("IS", Pattern.quote("{{langue|is}}"));
        isoCodeToWikiName.put("ES", Pattern.quote("{{langue|es}}"));
        isoCodeToWikiName.put("UK", Pattern.quote("{{langue|uk}}"));
        isoCodeToWikiName = new LinkedHashMap();
        wikiCodeToIsoCodeToWikiName.put("it", isoCodeToWikiName);
        isoCodeToWikiName.put("IT", "\\{\\{-(it|scn|nap|cal|lmo)-\\}\\}");
        isoCodeToWikiName.put("EN", Pattern.quote("{{-en-}}"));
        isoCodeToWikiName.put("FR", Pattern.quote("{{-fr-}}"));
        isoCodeToWikiName.put("DE", Pattern.quote("{{-de-}}"));
        isoCodeToWikiName.put("ES", Pattern.quote("{{-es-}}"));
        isoCodeToWikiName.put("JA", Pattern.quote("{{-ja-}}"));
        isoCodeToWikiName.put("PL", Pattern.quote("{{-pl-}}"));
        isoCodeToWikiName.put("NL", Pattern.quote("{{-nl-}}"));
        isoCodeToWikiName.put("LV", Pattern.quote("{{-lv-}}"));
        isoCodeToWikiName.put("LA", Pattern.quote("{{-la-}}"));
        isoCodeToWikiName.put("HU", Pattern.quote("{{-hu-}}"));
        isoCodeToWikiName.put("EL", Pattern.quote("{{-grc-}}"));
        isoCodeToWikiName.put("SV", Pattern.quote("{{-sv-}}"));
    }

    public static String getEnglishName(String langCode) {
        String name = isoCodeToEnWikiName.get(langCode);
        if (name == null) {
            name = isoCodeToEnWikiName.get(langCode.toUpperCase());
        }
        if (name == null) {
            return null;
        }
        if (name.indexOf(124) != -1) {
            return name.substring(name.indexOf(124));
        }
        return name;
    }
}

