/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.AbstractWiktionaryParser;
import com.hughes.android.dictionary.parser.wiktionary.DeFunctionCallbacks;
import com.hughes.android.dictionary.parser.wiktionary.EnFunctionCallbacks;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import com.hughes.android.dictionary.parser.wiktionary.FrFunctionCallbacks;
import com.hughes.android.dictionary.parser.wiktionary.FunctionCallback;
import com.hughes.android.dictionary.parser.wiktionary.ItFunctionCallbacks;
import com.hughes.util.StringUtil;
import com.sun.xml.internal.rngom.util.Uri;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class WholeSectionToHtmlParser
extends AbstractWiktionaryParser {
    public static final String NAME = "WholeSectionToHtmlParser";
    static final Map<String, LangConfig> isoToLangConfig = new LinkedHashMap<String, LangConfig>();
    final IndexBuilder titleIndexBuilder;
    final IndexBuilder defIndexBuilder;
    final String skipLangIso;
    final LangConfig langConfig;
    final String webUrlTemplate;
    IndexedEntry indexedEntry = null;

    static {
        final Pattern enSkipSections = Pattern.compile(".*(Translations|Anagrams|References).*");
        isoToLangConfig.put("EN", new LangConfig(){

            @Override
            public boolean skipSection(String headingText) {
                return enSkipSections.matcher(headingText).matches();
            }

            @Override
            public EntryTypeName sectionNameToEntryType(String sectionName) {
                if (sectionName.equalsIgnoreCase("Synonyms")) {
                    return EntryTypeName.SYNONYM_MULTI;
                }
                if (sectionName.equalsIgnoreCase("Antonyms")) {
                    return EntryTypeName.ANTONYM_MULTI;
                }
                if (EnParser.partOfSpeechHeader.matcher(sectionName).matches()) {
                    return null;
                }
                if (sectionName.equalsIgnoreCase("Derived Terms")) {
                    return null;
                }
                return null;
            }

            @Override
            public boolean skipWikiLink(WikiTokenizer wikiTokenizer) {
                String wikiText = wikiTokenizer.wikiLinkText();
                return wikiText.startsWith("Category:");
            }

            @Override
            public String adjustWikiLink(String wikiLinkDest, String wikiLinkText) {
                if (wikiLinkDest.startsWith("w:") || wikiLinkDest.startsWith("Image:")) {
                    return null;
                }
                int hashPos = wikiLinkDest.indexOf("#");
                if (hashPos != -1 && (wikiLinkDest = wikiLinkDest.substring(0, hashPos)).isEmpty()) {
                    wikiLinkDest = wikiLinkText;
                }
                return wikiLinkDest;
            }

            @Override
            public void addFunctionCallbacks(Map<String, FunctionCallback<WholeSectionToHtmlParser>> functionCallbacks) {
                EnFunctionCallbacks.addGenericCallbacks(functionCallbacks);
            }
        });
        final Pattern deSkipSections = Pattern.compile(".*(\u00dcbersetzungen|Referenzen|Quellen).*");
        isoToLangConfig.put("DE", new LangConfig(){

            @Override
            public boolean skipSection(String headingText) {
                return deSkipSections.matcher(headingText).matches();
            }

            @Override
            public EntryTypeName sectionNameToEntryType(String sectionName) {
                if (sectionName.equalsIgnoreCase("Synonyme")) {
                    return EntryTypeName.SYNONYM_MULTI;
                }
                if (sectionName.equalsIgnoreCase("Gegenw\u00f6rter")) {
                    return EntryTypeName.ANTONYM_MULTI;
                }
                return null;
            }

            @Override
            public boolean skipWikiLink(WikiTokenizer wikiTokenizer) {
                String wikiText = wikiTokenizer.wikiLinkText();
                return wikiText.startsWith("???Category:");
            }

            @Override
            public String adjustWikiLink(String wikiLinkDest, String wikiLinkText) {
                if (wikiLinkDest.startsWith("w:") || wikiLinkDest.startsWith("Image:")) {
                    return null;
                }
                int hashPos = wikiLinkDest.indexOf("#");
                if (hashPos != -1 && (wikiLinkDest = wikiLinkDest.substring(0, hashPos)).isEmpty()) {
                    wikiLinkDest = wikiLinkText;
                }
                return wikiLinkDest;
            }

            @Override
            public void addFunctionCallbacks(Map<String, FunctionCallback<WholeSectionToHtmlParser>> functionCallbacks) {
                DeFunctionCallbacks.addGenericCallbacks(functionCallbacks);
            }
        });
        final Pattern itSkipSections = Pattern.compile(".*(Traduzione|Note / Riferimenti).*");
        isoToLangConfig.put("IT", new LangConfig(){

            @Override
            public boolean skipSection(String headingText) {
                return itSkipSections.matcher(headingText).matches();
            }

            @Override
            public EntryTypeName sectionNameToEntryType(String sectionName) {
                if (sectionName.equalsIgnoreCase("Sinonimi")) {
                    return EntryTypeName.SYNONYM_MULTI;
                }
                if (sectionName.equalsIgnoreCase("Antonimi/Contrari")) {
                    return EntryTypeName.ANTONYM_MULTI;
                }
                return null;
            }

            @Override
            public boolean skipWikiLink(WikiTokenizer wikiTokenizer) {
                String wikiText = wikiTokenizer.wikiLinkText();
                return wikiText.startsWith("???Category:");
            }

            @Override
            public String adjustWikiLink(String wikiLinkDest, String wikiLinkText) {
                if (wikiLinkDest.startsWith("w:") || wikiLinkDest.startsWith("Image:")) {
                    return null;
                }
                int hashPos = wikiLinkDest.indexOf("#");
                if (hashPos != -1 && (wikiLinkDest = wikiLinkDest.substring(0, hashPos)).isEmpty()) {
                    wikiLinkDest = wikiLinkText;
                }
                return wikiLinkDest;
            }

            @Override
            public void addFunctionCallbacks(Map<String, FunctionCallback<WholeSectionToHtmlParser>> functionCallbacks) {
                ItFunctionCallbacks.addGenericCallbacks(functionCallbacks);
            }
        });
        final Pattern frSkipSections = Pattern.compile(".*(Traductions).*");
        isoToLangConfig.put("FR", new LangConfig(){

            @Override
            public boolean skipSection(String headingText) {
                return frSkipSections.matcher(headingText).matches();
            }

            @Override
            public EntryTypeName sectionNameToEntryType(String sectionName) {
                if (sectionName.equalsIgnoreCase("Synonymes")) {
                    return EntryTypeName.SYNONYM_MULTI;
                }
                return null;
            }

            @Override
            public boolean skipWikiLink(WikiTokenizer wikiTokenizer) {
                return false;
            }

            @Override
            public String adjustWikiLink(String wikiLinkDest, String wikiLinkText) {
                if (wikiLinkDest.startsWith("w:") || wikiLinkDest.startsWith("Image:")) {
                    return null;
                }
                int hashPos = wikiLinkDest.indexOf("#");
                if (hashPos != -1 && (wikiLinkDest = wikiLinkDest.substring(0, hashPos)).isEmpty()) {
                    wikiLinkDest = wikiLinkText;
                }
                return wikiLinkDest;
            }

            @Override
            public void addFunctionCallbacks(Map<String, FunctionCallback<WholeSectionToHtmlParser>> functionCallbacks) {
                FrFunctionCallbacks.addGenericCallbacks(functionCallbacks);
            }
        });
    }

    public WholeSectionToHtmlParser(IndexBuilder titleIndexBuilder, IndexBuilder defIndexBuilder, String wiktionaryIso, String skipLangIso, String webUrlTemplate) {
        this.titleIndexBuilder = titleIndexBuilder;
        this.defIndexBuilder = defIndexBuilder;
        assert (isoToLangConfig.containsKey(wiktionaryIso)) : wiktionaryIso;
        this.langConfig = isoToLangConfig.get(wiktionaryIso);
        this.skipLangIso = skipLangIso;
        this.webUrlTemplate = webUrlTemplate;
    }

    @Override
    public void parseSection(String heading, String text) {
        assert (this.entrySource != null);
        HtmlEntry htmlEntry = new HtmlEntry(this.entrySource, this.title);
        this.indexedEntry = new IndexedEntry(htmlEntry);
        AppendCallback callback = new AppendCallback(this);
        this.langConfig.addFunctionCallbacks(callback.functionCallbacks);
        callback.builder = new StringBuilder();
        callback.indexedEntry = this.indexedEntry;
        callback.dispatch(text, null);
        if (this.webUrlTemplate != null) {
            String webUrl = String.format(this.webUrlTemplate, this.title);
            callback.builder.append(String.format("<p> <a href=\"%s\">%s</a>", Uri.escapeDisallowedChars((String)webUrl), WholeSectionToHtmlParser.escapeHtmlLiteral(webUrl)));
        }
        htmlEntry.html = callback.builder.toString();
        this.indexedEntry.isValid = true;
        IndexBuilder.TokenData tokenData = this.titleIndexBuilder.getOrCreateTokenData(this.title);
        tokenData.hasMainEntry = true;
        htmlEntry.addToDictionary(this.titleIndexBuilder.index.dict);
        tokenData.htmlEntries.add(htmlEntry);
        this.indexedEntry = null;
    }

    @Override
    void removeUselessArgs(Map<String, String> namedArgs) {
    }

    @Override
    public void addLinkToCurrentEntry(String token, String lang, EntryTypeName entryTypeName) {
        if (lang == null || lang.equals(this.skipLangIso)) {
            this.titleIndexBuilder.addEntryWithString(this.indexedEntry, token, entryTypeName);
        }
    }

    public static String escapeHtmlLiteral(String plainText) {
        String htmlEscaped = StringEscapeUtils.escapeHtml3(plainText);
        if (StringUtil.isAscii(htmlEscaped)) {
            return htmlEscaped;
        }
        return StringUtil.escapeUnicodeToPureHtml(plainText);
    }

    class AppendCallback
    extends AbstractWiktionaryParser.AppendAndIndexWikiCallback<WholeSectionToHtmlParser> {
        EntryTypeName sectionEntryTypeName;
        IndexBuilder currentIndexBuilder;
        final List<Character> listPrefixStack;
        boolean boldOn;
        boolean italicOn;

        public AppendCallback(WholeSectionToHtmlParser parser) {
            super(parser);
            this.listPrefixStack = new ArrayList<Character>();
            this.boldOn = false;
            this.italicOn = false;
        }

        @Override
        public void onPlainText(String plainText) {
            super.onPlainText(WholeSectionToHtmlParser.escapeHtmlLiteral(plainText));
        }

        @Override
        public void onWikiLink(WikiTokenizer wikiTokenizer) {
            if (wikiTokenizer.wikiLinkText().endsWith(":" + WholeSectionToHtmlParser.this.title)) {
                return;
            }
            if (WholeSectionToHtmlParser.this.langConfig.skipWikiLink(wikiTokenizer)) {
                return;
            }
            String linkDest = wikiTokenizer.wikiLinkDest() != null ? WholeSectionToHtmlParser.this.langConfig.adjustWikiLink(wikiTokenizer.wikiLinkDest(), wikiTokenizer.wikiLinkText()) : wikiTokenizer.wikiLinkText();
            if (this.sectionEntryTypeName != null) {
                WholeSectionToHtmlParser.this.titleIndexBuilder.addEntryWithString(this.indexedEntry, wikiTokenizer.wikiLinkText(), this.sectionEntryTypeName);
            }
            if (!StringUtil.isNullOrEmpty(linkDest)) {
                this.builder.append(String.format("<a href=\"%s\">", HtmlEntry.formatQuickdicUrl("", linkDest)));
                super.onWikiLink(wikiTokenizer);
                this.builder.append(String.format("</a>", new Object[0]));
            } else {
                super.onWikiLink(wikiTokenizer);
            }
        }

        @Override
        public void onFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs) {
            if (WholeSectionToHtmlParser.this.skipLangIso.equalsIgnoreCase(namedArgs.get("lang"))) {
                namedArgs.remove("lang");
            }
            super.onFunction(wikiTokenizer, name, args, namedArgs);
        }

        @Override
        public void onHtml(WikiTokenizer wikiTokenizer) {
            super.onHtml(wikiTokenizer);
        }

        @Override
        public void onNewline(WikiTokenizer wikiTokenizer) {
        }

        @Override
        public void onHeading(WikiTokenizer wikiTokenizer) {
            String headingText = wikiTokenizer.headingWikiText();
            this.sectionEntryTypeName = WholeSectionToHtmlParser.this.langConfig.sectionNameToEntryType(headingText);
            int depth = wikiTokenizer.headingDepth();
            if (WholeSectionToHtmlParser.this.langConfig.skipSection(headingText)) {
                while ((wikiTokenizer = wikiTokenizer.nextToken()) != null) {
                    if (!wikiTokenizer.isHeading() || wikiTokenizer.headingDepth() > depth) continue;
                    wikiTokenizer.returnToLineStart();
                    return;
                }
                return;
            }
            this.builder.append(String.format("\n<h%d>", depth));
            this.dispatch(headingText, null);
            this.builder.append(String.format("</h%d>\n", depth));
        }

        @Override
        public void onListItem(WikiTokenizer wikiTokenizer) {
            if (this.builder.length() != 0 && this.builder.charAt(this.builder.length() - 1) != '\n') {
                this.builder.append("\n");
            }
            String prefix = wikiTokenizer.listItemPrefix();
            while (this.listPrefixStack.size() < prefix.length()) {
                this.builder.append(String.format("<%s>", WikiTokenizer.getListTag(prefix.charAt(this.listPrefixStack.size()))));
                this.listPrefixStack.add(Character.valueOf(prefix.charAt(this.listPrefixStack.size())));
            }
            this.builder.append("<li>");
            this.dispatch(wikiTokenizer.listItemWikiText(), null);
            this.builder.append("</li>\n");
            WikiTokenizer nextToken = wikiTokenizer.nextToken();
            boolean returnToLineStart = false;
            if (nextToken != null && nextToken.isNewline()) {
                nextToken = nextToken.nextToken();
                returnToLineStart = true;
            }
            String nextListHeader = nextToken == null || !nextToken.isListItem() ? "" : nextToken.listItemPrefix();
            if (returnToLineStart) {
                wikiTokenizer.returnToLineStart();
            }
            while (this.listPrefixStack.size() > nextListHeader.length()) {
                char prefixChar = this.listPrefixStack.remove(this.listPrefixStack.size() - 1).charValue();
                this.builder.append(String.format("</%s>\n", WikiTokenizer.getListTag(prefixChar)));
            }
        }

        @Override
        public void onMarkup(WikiTokenizer wikiTokenizer) {
            if ("'''".equals(wikiTokenizer.token())) {
                if (!this.boldOn) {
                    this.builder.append("<b>");
                } else {
                    this.builder.append("</b>");
                }
                this.boldOn = !this.boldOn;
            } else if ("''".equals(wikiTokenizer.token())) {
                if (!this.italicOn) {
                    this.builder.append("<em>");
                } else {
                    this.builder.append("</em>");
                }
                this.italicOn = !this.italicOn;
            } else assert (false);
        }
    }

    static interface LangConfig {
        public boolean skipSection(String var1);

        public EntryTypeName sectionNameToEntryType(String var1);

        public boolean skipWikiLink(WikiTokenizer var1);

        public String adjustWikiLink(String var1, String var2);

        public void addFunctionCallbacks(Map<String, FunctionCallback<WholeSectionToHtmlParser>> var1);
    }
}

