/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.AbstractWiktionaryParser;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import com.hughes.android.dictionary.parser.wiktionary.FunctionCallback;
import java.util.List;
import java.util.Map;

class ItFunctionCallbacks {
    static final AbstractWiktionaryParser.NameAndArgs<EnParser> NAME_AND_ARGS = new AbstractWiktionaryParser.NameAndArgs();

    ItFunctionCallbacks() {
    }

    static <T extends AbstractWiktionaryParser> void addGenericCallbacks(Map<String, FunctionCallback<T>> callbacks) {
        callbacks.put("-hyph-", new Redispatch("\n==== Sillabazione ====\n"));
        callbacks.put("-pron-", new Redispatch("\n==== Pronuncia ====\n"));
        callbacks.put("-etim-", new Redispatch("\n==== Etimologia / Derivazione ====\n"));
        callbacks.put("-syn-", new Redispatch("\n==== Sinonimi ====\n"));
        callbacks.put("-ant-", new Redispatch("\n==== Antonimi/Contrari ====\n"));
        callbacks.put("-drv-", new Redispatch("\n==== Parole derivate ====\n"));
        callbacks.put("-prov-", new Redispatch("\n==== Proverbi e modi di dire ====\n"));
        callbacks.put("-ref-", new Redispatch("\n==== Note / Riferimenti ====\n"));
        callbacks.put("-rel-", new Redispatch("\n==== Termini correlati ====\n"));
        callbacks.put("-var-", new Redispatch("\n==== Varianti ====\n"));
        callbacks.put("-trans1-", new SkipSection());
        callbacks.put("-trans2-", new SkipSection());
        callbacks.put("-ref-", new SkipSection());
    }

    static final class Redispatch<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        final String newText;

        public Redispatch(String newText) {
            this.newText = newText;
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            if (!namedArgs.isEmpty() || args.size() != 0) {
                return false;
            }
            appendAndIndexWikiCallback.dispatch(this.newText, null);
            return true;
        }
    }

    static final class SkipSection<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            while (wikiTokenizer.nextToken() != null) {
                if (!wikiTokenizer.isFunction() || !wikiTokenizer.functionName().startsWith("-") || !wikiTokenizer.functionName().endsWith("-") || wikiTokenizer.functionName().contains("trans")) continue;
                wikiTokenizer.returnToLineStart();
                return true;
            }
            return true;
        }
    }
}

