/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.AbstractWiktionaryParser;
import com.hughes.android.dictionary.parser.wiktionary.EnFunctionCallbacks;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import com.hughes.util.ListUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class EnTranslationToTranslationParser
extends AbstractWiktionaryParser {
    final List<IndexBuilder> indexBuilders;
    final Pattern[] langCodePatterns;
    PairEntry pairEntry = null;
    IndexedEntry indexedEntry = null;
    StringBuilder[] builders = null;
    public static final String NAME = "EnTranslationToTranslation";
    final Set<String> Ts = new LinkedHashSet<String>(Arrays.asList("t", "t+", "t-", "t\u00f8", "apdx-t", "ttbc"));
    final EnFunctionCallbacks.TranslationCallback<EnTranslationToTranslationParser> translationCallback = new EnFunctionCallbacks.TranslationCallback();
    final AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnTranslationToTranslationParser> appendAndIndexWikiCallback = new AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnTranslationToTranslationParser>(this);

    public EnTranslationToTranslationParser(List<IndexBuilder> indexBuilders, Pattern[] langCodePatterns) {
        for (String t : this.Ts) {
            this.appendAndIndexWikiCallback.functionCallbacks.put(t, this.translationCallback);
        }
        this.indexBuilders = indexBuilders;
        this.langCodePatterns = langCodePatterns;
    }

    @Override
    void removeUselessArgs(Map<String, String> namedArgs) {
        namedArgs.keySet().removeAll(EnParser.USELESS_WIKI_ARGS);
    }

    @Override
    void parseSection(String heading, String text) {
        if (EnParser.isIgnorableTitle(this.title)) {
            return;
        }
        WikiTokenizer.DoNothingCallback callback = new WikiTokenizer.DoNothingCallback(){

            @Override
            public void onFunction(WikiTokenizer wikiTokenizer, String name, List<String> functionPositionArgs, Map<String, String> functionNamedArgs) {
                if (EnTranslationToTranslationParser.this.Ts.contains(name)) {
                    EnTranslationToTranslationParser.this.onT(wikiTokenizer);
                } else if (name.equals("trans-top") || name.equals("checktrans-top") || name.equals("checktrans")) {
                    EnTranslationToTranslationParser.this.startEntry(EnTranslationToTranslationParser.this.title, wikiTokenizer.token());
                } else if (name.equals("trans-bottom")) {
                    EnTranslationToTranslationParser.this.finishEntry(EnTranslationToTranslationParser.this.title);
                }
            }

            @Override
            public void onListItem(WikiTokenizer wikiTokenizer) {
                WikiTokenizer.dispatch(wikiTokenizer.listItemWikiText(), false, this);
            }
        };
        WikiTokenizer.dispatch(text, true, callback);
        if (this.builders != null) {
            LOG.warning("unended translations: " + this.title);
            this.finishEntry(this.title);
        }
    }

    private void onT(WikiTokenizer wikiTokenizer) {
        List<String> args;
        String langCode;
        if (this.builders == null) {
            LOG.warning("{{t...}} section outside of {{trans-top}}: " + this.title);
            this.startEntry(this.title, "QUICKDIC_OUTSIDE");
        }
        if ((langCode = ListUtil.get(args = wikiTokenizer.functionPositionArgs(), 0)) == null) {
            LOG.warning("Missing langCode: " + wikiTokenizer.token());
            return;
        }
        int p = 0;
        while (p < 2) {
            if (this.langCodePatterns[p].matcher(langCode).matches()) {
                this.appendAndIndexWikiCallback.builder = this.builders[p];
                if (this.appendAndIndexWikiCallback.builder.length() > 0) {
                    this.appendAndIndexWikiCallback.builder.append(", ");
                }
                this.appendAndIndexWikiCallback.indexBuilder = this.indexBuilders.get(p);
                this.appendAndIndexWikiCallback.onFunction(wikiTokenizer, wikiTokenizer.functionName(), wikiTokenizer.functionPositionArgs(), wikiTokenizer.functionNamedArgs());
            }
            ++p;
        }
    }

    void startEntry(String title, String func) {
        if (this.pairEntry != null) {
            LOG.warning("startEntry() twice: " + title + ", " + func);
            this.finishEntry(title);
        }
        this.pairEntry = new PairEntry(this.entrySource);
        this.indexedEntry = new IndexedEntry(this.pairEntry);
        this.builders = new StringBuilder[]{new StringBuilder(), new StringBuilder()};
        this.appendAndIndexWikiCallback.indexedEntry = this.indexedEntry;
    }

    void finishEntry(String title) {
        if (this.pairEntry == null) {
            LOG.warning("finalizeEntry() twice: " + title);
            return;
        }
        String lang1 = this.builders[0].toString();
        String lang2 = this.builders[1].toString();
        if (lang1.length() > 0 && lang2.length() > 0) {
            this.pairEntry.pairs.add(new PairEntry.Pair(lang1, lang2));
            this.indexedEntry.isValid = true;
        }
        this.pairEntry = null;
        this.indexedEntry = null;
        this.builders = null;
    }
}

