/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import java.util.List;
import java.util.regex.Pattern;

public final class EnToTranslationParser
extends EnParser {
    public EnToTranslationParser(IndexBuilder enIndexBuilder, IndexBuilder otherIndexBuilder, Pattern langPattern, Pattern langCodePattern, boolean swap) {
        super(enIndexBuilder, otherIndexBuilder, langPattern, langCodePattern, swap);
    }

    @Override
    void parseSection(String heading, String text) {
        if (EnToTranslationParser.isIgnorableTitle(this.title)) {
            return;
        }
        if (!(heading = heading.replaceAll("=", "").trim()).contains("English")) {
            return;
        }
        String pos = null;
        int posDepth = -1;
        WikiTokenizer wikiTokenizer = new WikiTokenizer(text);
        while (wikiTokenizer.nextToken() != null) {
            String name;
            if (wikiTokenizer.isHeading()) {
                String headerName = wikiTokenizer.headingWikiText();
                if (wikiTokenizer.headingDepth() <= posDepth) {
                    pos = null;
                    posDepth = -1;
                }
                if (partOfSpeechHeader.matcher(headerName).matches()) {
                    posDepth = wikiTokenizer.headingDepth();
                    pos = wikiTokenizer.headingWikiText();
                    continue;
                }
                if (headerName.equals("Translations")) {
                    if (pos == null) {
                        LOG.info("Translations without POS (but using anyway): " + this.title);
                    }
                    this.doTranslations(wikiTokenizer, pos);
                    continue;
                }
                headerName.equals("Pronunciation");
                continue;
            }
            if (!wikiTokenizer.isFunction() || !(name = wikiTokenizer.functionName()).equals("head") || pos != null) continue;
            LOG.warning("{{head}} without POS: " + this.title);
        }
    }

    private void doTranslations(WikiTokenizer wikiTokenizer, String pos) {
        this.title.equals("absolutely");
        String topLevelLang = null;
        String sense = null;
        boolean done = false;
        while (wikiTokenizer.nextToken() != null) {
            String token;
            if (wikiTokenizer.isHeading()) {
                wikiTokenizer.returnToLineStart();
                return;
            }
            if (done) continue;
            if (wikiTokenizer.isFunction()) {
                String functionName = wikiTokenizer.functionName();
                List<String> positionArgs = wikiTokenizer.functionPositionArgs();
                if (functionName.equals("trans-top")) {
                    sense = null;
                    if (wikiTokenizer.functionPositionArgs().size() < 1) continue;
                    sense = positionArgs.get(0);
                    sense = WikiTokenizer.toPlainText(sense);
                    continue;
                }
                if (functionName.equals("trans-bottom")) {
                    sense = null;
                    continue;
                }
                if (functionName.equals("trans-mid")) continue;
                if (functionName.equals("trans-see")) {
                    this.incrementCount("WARNING:trans-see");
                    continue;
                }
                if (functionName.startsWith("picdic")) continue;
                if (functionName.startsWith("checktrans")) {
                    done = true;
                    continue;
                }
                if (functionName.startsWith("ttbc")) {
                    wikiTokenizer.nextLine();
                    continue;
                }
                LOG.warning("Unexpected translation wikifunction: " + wikiTokenizer.token() + ", title=" + this.title);
                continue;
            }
            if (wikiTokenizer.isListItem()) {
                boolean appendLang;
                String line = wikiTokenizer.listItemWikiText();
                int colonIndex = line.indexOf(":");
                if (colonIndex == -1) continue;
                String lang = EnToTranslationParser.trim(WikiTokenizer.toPlainText(line.substring(0, colonIndex)));
                this.incrementCount("tCount:" + lang);
                if (wikiTokenizer.listItemPrefix().length() == 1) {
                    topLevelLang = lang;
                    boolean thisFind = this.langPattern.matcher(lang).find();
                    if (!thisFind) continue;
                    appendLang = !this.langPattern.matcher(lang).matches();
                } else {
                    if (topLevelLang == null || !this.langPattern.matcher(lang).matches() && !this.langPattern.matcher(topLevelLang).find()) continue;
                    appendLang = !this.langPattern.matcher(lang).matches();
                }
                String rest = line.substring(colonIndex + 1).trim();
                if (rest.length() <= 0) continue;
                this.doTranslationLine(line, appendLang ? lang : null, pos, sense, rest);
                continue;
            }
            if (wikiTokenizer.remainderStartsWith("''See''")) {
                wikiTokenizer.nextLine();
                this.incrementCount("WARNING: ''See''");
                LOG.fine("Skipping See line: " + wikiTokenizer.token());
                continue;
            }
            if (wikiTokenizer.isWikiLink()) {
                String wikiLink = wikiTokenizer.wikiLinkText();
                if (wikiLink.contains(":") && wikiLink.contains(this.title) || wikiLink.contains("Category:")) continue;
                this.incrementCount("WARNING: Unexpected wikiLink");
                LOG.warning("Unexpected wikiLink: " + wikiTokenizer.token() + ", title=" + this.title);
                continue;
            }
            if (wikiTokenizer.isNewline() || wikiTokenizer.isMarkup() || wikiTokenizer.isComment() || (token = wikiTokenizer.token()).equals("----")) continue;
            LOG.warning("Unexpected translation token: " + wikiTokenizer.token() + ", title=" + this.title);
            this.incrementCount("WARNING: Unexpected translation token");
        }
    }

    private void doTranslationLine(String line, String lang, String pos, String sense, String rest) {
        this.state = EnParser.State.TRANSLATION_LINE;
        PairEntry pairEntry = new PairEntry(this.entrySource);
        IndexedEntry indexedEntry = new IndexedEntry(pairEntry);
        indexedEntry.isValid = true;
        StringBuilder foreignText = new StringBuilder();
        this.appendAndIndexWikiCallback.reset(foreignText, indexedEntry);
        this.appendAndIndexWikiCallback.dispatch(rest, this.foreignIndexBuilder, EntryTypeName.WIKTIONARY_TRANSLATION_OTHER_TEXT);
        if (foreignText.length() == 0) {
            LOG.warning("Empty foreignText: " + line);
            this.incrementCount("WARNING: Empty foreignText");
            return;
        }
        if (lang != null) {
            foreignText.insert(0, String.format("(%s) ", lang));
        }
        StringBuilder englishText = new StringBuilder();
        englishText.append(this.title);
        if (sense != null) {
            englishText.append(" (").append(sense).append(")");
            this.enIndexBuilder.addEntryWithString(indexedEntry, sense, EntryTypeName.WIKTIONARY_TRANSLATION_SENSE);
        }
        if (pos != null) {
            englishText.append(" (").append(pos.toLowerCase()).append(")");
        }
        this.enIndexBuilder.addEntryWithString(indexedEntry, this.title, EntryTypeName.WIKTIONARY_TITLE_MULTI);
        PairEntry.Pair pair = new PairEntry.Pair(EnToTranslationParser.trim(englishText.toString()), EnToTranslationParser.trim(foreignText.toString()), this.swap);
        pairEntry.pairs.add(pair);
        if (!this.pairsAdded.add(pair.toString())) {
            LOG.warning("Duplicate pair: " + pair.toString());
            this.incrementCount("WARNING: Duplicate pair");
        }
    }
}

