/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.AbstractWiktionaryParser;
import com.hughes.android.dictionary.parser.wiktionary.EnFunctionCallbacks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class EnParser
extends AbstractWiktionaryParser {
    public static final Pattern partOfSpeechHeader = Pattern.compile("Noun|Verb|Adjective|Adverb|Pronoun|Conjunction|Interjection|Preposition|Proper noun|Article|Prepositional phrase|Acronym|Abbreviation|Initialism|Contraction|Prefix|Suffix|Symbol|Letter|Ligature|Idiom|Phrase|\\{\\{acronym\\}\\}|\\{\\{initialism\\}\\}|\\{\\{abbreviation\\}\\}|Noun form|Verb form|Adjective form|Nominal phrase|Noun phrase|Verb phrase|Transitive verb|Intransitive verb|Reflexive verb|Determiner|Numeral|Number|Cardinal number|Ordinal number|Proverb|Particle|Interjection|Pronominal adverbHan character|Hanzi|Hanja|Kanji|Katakana character|Syllable");
    static final Set<String> USELESS_WIKI_ARGS = new LinkedHashSet<String>(Arrays.asList("lang", "sc", "sort", "cat", "cat2", "xs", "nodot"));
    final IndexBuilder enIndexBuilder;
    final IndexBuilder foreignIndexBuilder;
    final Pattern langPattern;
    final Pattern langCodePattern;
    final boolean swap;
    State state = null;
    public boolean entryIsFormOfSomething = false;
    final Collection<String> wordForms = new ArrayList<String>();
    boolean titleAppended = false;
    final AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> appendAndIndexWikiCallback = new AppendAndIndexCallback(this);

    static boolean isIgnorableTitle(String title) {
        return title.startsWith("Wiktionary:") || title.startsWith("Template:") || title.startsWith("Appendix:") || title.startsWith("Category:") || title.startsWith("Index:") || title.startsWith("MediaWiki:") || title.startsWith("TransWiki:") || title.startsWith("Citations:") || title.startsWith("Concordance:") || title.startsWith("Help:");
    }

    EnParser(IndexBuilder enIndexBuilder, IndexBuilder otherIndexBuilder, Pattern langPattern, Pattern langCodePattern, boolean swap) {
        this.appendAndIndexWikiCallback.functionCallbacks.putAll(EnFunctionCallbacks.DEFAULT);
        for (String key : new ArrayList<String>(this.appendAndIndexWikiCallback.functionCallbacks.keySet())) {
            if (!key.startsWith("it-conj")) continue;
            this.appendAndIndexWikiCallback.functionCallbacks.remove(key);
        }
        this.enIndexBuilder = enIndexBuilder;
        this.foreignIndexBuilder = otherIndexBuilder;
        this.langPattern = langPattern;
        this.langCodePattern = langCodePattern;
        this.swap = swap;
    }

    @Override
    void removeUselessArgs(Map<String, String> namedArgs) {
        namedArgs.keySet().removeAll(USELESS_WIKI_ARGS);
    }

    static class AppendAndIndexCallback
    extends AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> {
        public AppendAndIndexCallback(EnParser parser) {
            super(parser);
        }

        @Override
        public void onWikiLink(WikiTokenizer wikiTokenizer) {
            String text = wikiTokenizer.wikiLinkText();
            String link = wikiTokenizer.wikiLinkDest();
            if (link != null) {
                if (link.contains("#English")) {
                    this.dispatch(text, ((EnParser)this.parser).enIndexBuilder, EntryTypeName.WIKTIONARY_ENGLISH_DEF_WIKI_LINK);
                } else if (link.contains("#") && ((EnParser)this.parser).langPattern.matcher(link).find()) {
                    this.dispatch(text, ((EnParser)this.parser).foreignIndexBuilder, EntryTypeName.WIKTIONARY_ENGLISH_DEF_OTHER_LANG);
                } else if (link.equals("plural")) {
                    this.builder.append(text);
                } else {
                    this.dispatch(text, EntryTypeName.WIKTIONARY_ENGLISH_DEF_WIKI_LINK);
                }
            } else {
                EntryTypeName entryTypeName;
                switch (((EnParser)this.parser).state) {
                    case TRANSLATION_LINE: {
                        entryTypeName = EntryTypeName.WIKTIONARY_TRANSLATION_WIKI_TEXT;
                        break;
                    }
                    case ENGLISH_DEF_OF_FOREIGN: {
                        entryTypeName = EntryTypeName.WIKTIONARY_ENGLISH_DEF_WIKI_LINK;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid enum value: " + (Object)((Object)((EnParser)this.parser).state));
                    }
                }
                this.dispatch(text, entryTypeName);
            }
        }
    }

    static enum State {
        TRANSLATION_LINE,
        ENGLISH_DEF_OF_FOREIGN,
        ENGLISH_EXAMPLE,
        FOREIGN_EXAMPLE;

    }
}

