/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.AbstractWiktionaryParser;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import com.hughes.android.dictionary.parser.wiktionary.FunctionCallback;
import com.hughes.android.dictionary.parser.wiktionary.WiktionaryLangs;
import com.hughes.util.ListUtil;
import com.hughes.util.MapUtil;
import com.hughes.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class EnFunctionCallbacks {
    static final Map<String, FunctionCallback<EnParser>> DEFAULT = new LinkedHashMap<String, FunctionCallback<EnParser>>();
    static final AbstractWiktionaryParser.NameAndArgs<EnParser> NAME_AND_ARGS;
    static final FormOf FORM_OF;
    static final Map<String, String> it_indicativePronouns;
    static final Map<String, String> it_subjunctivePronouns;
    static final Map<String, String> it_imperativePronouns;
    static final List<String> it_number_s_p;
    static final List<String> it_person_1_2_3;
    static final List<String> it_reflexive_pronouns;
    static final List<String> it_empty;

    static {
        EnFunctionCallbacks.addGenericCallbacks(DEFAULT);
        FunctionCallback callback = new TranslationCallback();
        DEFAULT.put("t", callback);
        DEFAULT.put("t+", callback);
        DEFAULT.put("t-", callback);
        DEFAULT.put("t\u00f8", callback);
        DEFAULT.put("apdx-t", callback);
        callback = new l_term();
        DEFAULT.put("l", callback);
        DEFAULT.put("term", callback);
        callback = new FormOf();
        DEFAULT.put("form of", callback);
        DEFAULT.put("conjugation of", callback);
        DEFAULT.put("participle of", callback);
        DEFAULT.put("present participle of", callback);
        DEFAULT.put("past participle of", callback);
        DEFAULT.put("feminine past participle of", callback);
        DEFAULT.put("gerund of", callback);
        DEFAULT.put("feminine of", callback);
        DEFAULT.put("plural of", callback);
        DEFAULT.put("feminine plural of", callback);
        DEFAULT.put("inflected form of", callback);
        DEFAULT.put("alternative form of", callback);
        DEFAULT.put("dated form of", callback);
        DEFAULT.put("apocopic form of", callback);
        callback = new InflOrHead();
        DEFAULT.put("infl", callback);
        DEFAULT.put("head", callback);
        NAME_AND_ARGS = new AbstractWiktionaryParser.NameAndArgs();
        FORM_OF = new FormOf();
        DEFAULT.put("it-noun", new it_noun());
        DEFAULT.put("it-proper noun", new it_proper_noun());
        it_indicativePronouns = new LinkedHashMap<String, String>();
        it_indicativePronouns.put("1s", "io");
        it_indicativePronouns.put("2s", "tu");
        it_indicativePronouns.put("3s", "lui/lei");
        it_indicativePronouns.put("1p", "noi");
        it_indicativePronouns.put("2p", "voi");
        it_indicativePronouns.put("3p", "essi/esse");
        it_subjunctivePronouns = new LinkedHashMap<String, String>();
        it_subjunctivePronouns.put("1s", "che io");
        it_subjunctivePronouns.put("2s", "che tu");
        it_subjunctivePronouns.put("3s", "che lui/lei");
        it_subjunctivePronouns.put("1p", "che noi");
        it_subjunctivePronouns.put("2p", "che voi");
        it_subjunctivePronouns.put("3p", "che essi/esse");
        it_imperativePronouns = new LinkedHashMap<String, String>();
        it_imperativePronouns.put("1s", "-");
        it_imperativePronouns.put("2s", "tu");
        it_imperativePronouns.put("3s", "lui/lei");
        it_imperativePronouns.put("1p", "noi");
        it_imperativePronouns.put("2p", "voi");
        it_imperativePronouns.put("3p", "essi/esse");
        it_number_s_p = Arrays.asList("s", "p");
        it_person_1_2_3 = Arrays.asList("1", "2", "3");
        it_reflexive_pronouns = Arrays.asList("mi ", "ti ", "si ", "ci ", "vi ", "si ");
        it_empty = Arrays.asList("", "", "", "", "", "");
    }

    EnFunctionCallbacks() {
    }

    static <T extends AbstractWiktionaryParser> void addGenericCallbacks(Map<String, FunctionCallback<T>> callbacks) {
        FunctionCallback callback = new Gender();
        callbacks.put("m", callback);
        callbacks.put("f", callback);
        callbacks.put("n", callback);
        callbacks.put("p", callback);
        callbacks.put("g", callback);
        callbacks.put("etyl", new etyl());
        callbacks.put("term", new term());
        callback = new EncodingCallback();
        LinkedHashSet<String> encodings = new LinkedHashSet<String>(Arrays.asList("IPA", "IPAchar", "zh-ts", "zh-tsp", "sd-Arab", "ku-Arab", "Arab", "unicode", "Laoo", "ur-Arab", "Thai", "fa-Arab", "Khmr", "Cyrl", "ug-Arab", "ko-inline", "Jpan", "Kore", "Hebr", "rfscript", "Beng", "Mong", "Knda", "Cyrs", "yue-tsj", "Mlym", "Tfng", "Grek", "yue-yue-j"));
        for (String encoding : encodings) {
            callbacks.put(encoding, callback);
        }
        callback = new Ignore();
        callbacks.put("trreq", callback);
        callbacks.put("t-image", callback);
        callbacks.put("defn", callback);
        callbacks.put("rfdef", callback);
        callbacks.put("rfdate", callback);
        callbacks.put("rfex", callback);
        callbacks.put("rfquote", callback);
        callbacks.put("attention", callback);
        callbacks.put("zh-attention", callback);
        callbacks.put("top2", callback);
        callbacks.put("mid2", callback);
        callbacks.put("top3", callback);
        callbacks.put("mid3", callback);
        callbacks.put("bottom", callback);
        callbacks.put("rel-mid", callback);
        callbacks.put("rel-mid3", callback);
        callbacks.put("rel-mid4", callback);
        callbacks.put("rel-bottom", callback);
        callbacks.put("der-top", callback);
        callbacks.put("der-mid", callback);
        callbacks.put("der-mid3", callback);
        callbacks.put("der-bottom", callback);
        callback = new AppendName();
        callbacks.put("...", callback);
        callbacks.put("qualifier", new QualifierCallback());
        callbacks.put("italbrac", new italbrac());
        callbacks.put("gloss", new gloss());
        callbacks.put("not used", new not_used());
        callbacks.put("wikipedia", new wikipedia());
        it_conj it_conj_cb = new it_conj();
        callbacks.put("it-conj", it_conj_cb);
        callbacks.put("it-conj-are", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-arsi", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-care", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-carsi", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-ciare", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-ciarsi", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-iare", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-iarsi", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-iare-b", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-iarsi-b", new it_conj_are(it_conj_cb));
        callbacks.put("it-conj-ire", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-irsi", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-ire-b", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-irsi-b", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-cire", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-cirsi", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-ire", new it_conj_ire(it_conj_cb));
        callbacks.put("it-conj-ere", new it_conj_ere(it_conj_cb));
        callbacks.put("it-conj-ersi", new it_conj_ere(it_conj_cb));
        callbacks.put("it-conj-urre", new it_conj_urre(it_conj_cb));
        callbacks.put("it-conj-ursi", new it_conj_urre(it_conj_cb));
        callbacks.put("it-conj-fare", new it_conj_fare(it_conj_cb));
    }

    private static void cleanList(List<String> asList) {
        int pos;
        while ((pos = asList.indexOf("")) != -1) {
            asList.remove(pos);
        }
        while ((pos = asList.indexOf(null)) != -1) {
            asList.remove(pos);
        }
    }

    static void passThroughOrFillIn(Map<String, String> namedArgs, String key, String fillIn, boolean quoteToEmpty) {
        String value = namedArgs.get(key);
        if (quoteToEmpty && "''".equals(value)) {
            namedArgs.put(key, "");
            return;
        }
        if (value == null || value.equals("")) {
            namedArgs.put(key, fillIn);
        }
    }

    static void it_conj_passMood(Map<String, String> namedArgs, String moodName, boolean quoteToEmpty, String root, List<String> suffixes) {
        assert (suffixes.size() == 6);
        int i = 0;
        for (String number : it_number_s_p) {
            for (String person : it_person_1_2_3) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, String.format("%s%s%s", moodName, person, number), String.valueOf(root) + suffixes.get(i), quoteToEmpty);
                ++i;
            }
        }
    }

    private static <T extends AbstractWiktionaryParser> void outputKeyVariations(AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback, StringBuilder builder, String keyBase, Map<String, String> namedArgs, boolean isForm) {
        int suffix = 0;
        while (suffix <= 4) {
            String key = suffix == 0 ? keyBase : String.valueOf(keyBase) + suffix;
            String val = namedArgs.remove(key);
            if (val != null && !val.trim().equals("")) {
                if (suffix > 0) {
                    builder.append(", ");
                }
                appendAndIndexWikiCallback.dispatch(val, null);
                if (isForm) {
                    ((AbstractWiktionaryParser)appendAndIndexWikiCallback.parser).addLinkToCurrentEntry(val, null, EntryTypeName.WIKTIONARY_INFLECTED_FORM_MULTI);
                }
            }
            ++suffix;
        }
    }

    static final class AppendArg0<T extends AbstractWiktionaryParser>
    implements FunctionCallback<EnParser> {
        AppendArg0() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, EnParser parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> appendAndIndexWikiCallback) {
            if (args.size() != 1 || !namedArgs.isEmpty()) {
                return false;
            }
            appendAndIndexWikiCallback.dispatch(args.get(0), EntryTypeName.WIKTIONARY_TRANSLATION_OTHER_TEXT);
            String tr = namedArgs.remove("tr");
            if (tr != null) {
                appendAndIndexWikiCallback.builder.append(" (");
                appendAndIndexWikiCallback.dispatch(tr, EntryTypeName.WIKTIONARY_TRANSLATION_OTHER_TEXT);
                appendAndIndexWikiCallback.builder.append(")");
                parser.wordForms.add(tr);
            }
            return true;
        }
    }

    static final class AppendName<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        AppendName() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            if (!args.isEmpty() || !namedArgs.isEmpty()) {
                return false;
            }
            appendAndIndexWikiCallback.builder.append(name);
            return true;
        }
    }

    static final class EncodingCallback<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        EncodingCallback() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            namedArgs.remove("lang");
            if (!namedArgs.isEmpty()) {
                EnParser.LOG.warning("weird encoding: " + wikiTokenizer.token());
                return false;
            }
            if (args.size() == 0) {
                return true;
            }
            if (name.equals("IPA")) {
                appendAndIndexWikiCallback.dispatch("IPA: ", null);
            }
            int i = 0;
            while (i < args.size()) {
                if (i > 0) {
                    appendAndIndexWikiCallback.builder.append(", ");
                }
                String arg = args.get(i);
                appendAndIndexWikiCallback.dispatch(arg, appendAndIndexWikiCallback.entryTypeName);
                ++i;
            }
            return true;
        }
    }

    static final class FormOf
    implements FunctionCallback<EnParser> {
        FormOf() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, EnParser parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> appendAndIndexWikiCallback) {
            String baseForm;
            parser.entryIsFormOfSomething = true;
            String formName = name;
            if (name.equals("form of")) {
                formName = ListUtil.remove(args, 0, null);
            }
            if (formName == null) {
                EnParser.LOG.warning("Missing form name: " + parser.title);
                formName = "form of";
            }
            if ("".equals(baseForm = ListUtil.get(args, 1, ""))) {
                baseForm = ListUtil.get(args, 0, null);
                ListUtil.remove(args, 1, "");
            } else {
                ListUtil.remove(args, 0, null);
            }
            namedArgs.keySet().removeAll(EnParser.USELESS_WIKI_ARGS);
            appendAndIndexWikiCallback.builder.append("{");
            NAME_AND_ARGS.onWikiFunction(wikiTokenizer, formName, args, namedArgs, parser, appendAndIndexWikiCallback);
            appendAndIndexWikiCallback.builder.append("}");
            if (baseForm != null && appendAndIndexWikiCallback.indexedEntry != null) {
                parser.foreignIndexBuilder.addEntryWithString(appendAndIndexWikiCallback.indexedEntry, baseForm, EntryTypeName.WIKTIONARY_BASE_FORM_MULTI);
            } else {
                EnParser.LOG.warning("Null baseform: " + parser.title);
            }
            return true;
        }
    }

    static final class Gender<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        Gender() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            if (!namedArgs.isEmpty()) {
                return false;
            }
            appendAndIndexWikiCallback.builder.append("{");
            appendAndIndexWikiCallback.builder.append(name);
            int i = 0;
            while (i < args.size()) {
                appendAndIndexWikiCallback.builder.append("|").append(args.get(i));
                ++i;
            }
            appendAndIndexWikiCallback.builder.append("}");
            return true;
        }
    }

    static final class Ignore<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        Ignore() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            return true;
        }
    }

    static final class InflOrHead
    implements FunctionCallback<EnParser> {
        InflOrHead() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, EnParser parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> appendAndIndexWikiCallback) {
            String pos;
            String langCode = ListUtil.get(args, 0);
            String head = namedArgs.remove("head");
            if (head == null) {
                head = namedArgs.remove("title");
            }
            if (head == null) {
                head = parser.title;
            }
            namedArgs.keySet().removeAll(EnParser.USELESS_WIKI_ARGS);
            String tr = namedArgs.remove("tr");
            String g = namedArgs.remove("g");
            if (g == null) {
                g = namedArgs.remove("gender");
            }
            String g2 = namedArgs.remove("g2");
            String g3 = namedArgs.remove("g3");
            if (!parser.titleAppended) {
                appendAndIndexWikiCallback.dispatch(head, EntryTypeName.WIKTIONARY_TITLE_MULTI);
                parser.titleAppended = true;
            }
            if (g != null) {
                appendAndIndexWikiCallback.builder.append(" {").append(g);
                if (g2 != null) {
                    appendAndIndexWikiCallback.builder.append("|").append(g2);
                }
                if (g3 != null) {
                    appendAndIndexWikiCallback.builder.append("|").append(g3);
                }
                appendAndIndexWikiCallback.builder.append("}");
            }
            if (tr != null) {
                appendAndIndexWikiCallback.builder.append(" (");
                appendAndIndexWikiCallback.dispatch(tr, EntryTypeName.WIKTIONARY_TITLE_MULTI);
                appendAndIndexWikiCallback.builder.append(")");
                parser.wordForms.add(tr);
            }
            if ((pos = ListUtil.get(args, 1)) != null) {
                appendAndIndexWikiCallback.builder.append(" (").append(pos).append(")");
            }
            int i = 2;
            while (i < args.size()) {
                String inflName = ListUtil.get(args, i);
                String inflValue = ListUtil.get(args, i + 1);
                appendAndIndexWikiCallback.builder.append(", ");
                appendAndIndexWikiCallback.dispatch(inflName, null, null);
                if (inflValue != null && inflValue.length() > 0) {
                    appendAndIndexWikiCallback.builder.append(": ");
                    appendAndIndexWikiCallback.dispatch(inflValue, null, null);
                    parser.wordForms.add(inflValue);
                }
                i += 2;
            }
            for (String key : namedArgs.keySet()) {
                String value = WikiTokenizer.toPlainText(namedArgs.get(key));
                appendAndIndexWikiCallback.builder.append(" ");
                appendAndIndexWikiCallback.dispatch(key, null, null);
                appendAndIndexWikiCallback.builder.append("=");
                appendAndIndexWikiCallback.dispatch(value, null, null);
                parser.wordForms.add(value);
            }
            return true;
        }
    }

    static final class QualifierCallback<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        QualifierCallback() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            namedArgs.remove("lang");
            if (!namedArgs.isEmpty()) {
                EnParser.LOG.warning("weird qualifier: " + wikiTokenizer.token());
                return false;
            }
            appendAndIndexWikiCallback.builder.append("(");
            int i = 0;
            while (i < args.size()) {
                appendAndIndexWikiCallback.dispatch(args.get(i), null);
                if (i > 0) {
                    appendAndIndexWikiCallback.builder.append(", ");
                }
                ++i;
            }
            appendAndIndexWikiCallback.builder.append(")");
            return true;
        }
    }

    static final class TranslationCallback<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        TranslationCallback() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String transliteration = namedArgs.remove("tr");
            String alt = namedArgs.remove("alt");
            namedArgs.keySet().removeAll(EnParser.USELESS_WIKI_ARGS);
            if (args.size() < 2) {
                if (!name.equals("ttbc")) {
                    EnParser.LOG.warning("{{t...}} with wrong args: title=" + ((AbstractWiktionaryParser)parser).title + ", " + wikiTokenizer.token());
                }
                return false;
            }
            String langCode = ListUtil.get(args, 0);
            if (!appendAndIndexWikiCallback.langCodeToTCount.containsKey(langCode)) {
                appendAndIndexWikiCallback.langCodeToTCount.put(langCode, new AtomicInteger());
            }
            appendAndIndexWikiCallback.langCodeToTCount.get(langCode).incrementAndGet();
            String word = ListUtil.get(args, 1);
            appendAndIndexWikiCallback.dispatch(alt != null ? alt : word, EntryTypeName.WIKTIONARY_TITLE_MULTI);
            if (args.size() > 2) {
                appendAndIndexWikiCallback.builder.append(" {");
                int i = 2;
                while (i < args.size()) {
                    if (i > 2) {
                        appendAndIndexWikiCallback.builder.append("|");
                    }
                    appendAndIndexWikiCallback.builder.append(args.get(i));
                    ++i;
                }
                appendAndIndexWikiCallback.builder.append("}");
            }
            if (transliteration != null) {
                appendAndIndexWikiCallback.builder.append(" (");
                appendAndIndexWikiCallback.dispatch(transliteration, EntryTypeName.WIKTIONARY_TRANSLITERATION);
                appendAndIndexWikiCallback.builder.append(")");
            }
            if (alt != null) {
                appendAndIndexWikiCallback.builder.append(" (");
                appendAndIndexWikiCallback.dispatch(word, EntryTypeName.WIKTIONARY_TITLE_MULTI);
                appendAndIndexWikiCallback.builder.append(")");
            }
            if (!namedArgs.isEmpty()) {
                appendAndIndexWikiCallback.builder.append(" {");
                EnParser.appendNamedArgs(namedArgs, appendAndIndexWikiCallback);
                appendAndIndexWikiCallback.builder.append("}");
            }
            return true;
        }
    }

    static final class etyl<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        etyl() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String langCode = ListUtil.get(args, 0);
            if (langCode == null) {
                return false;
            }
            String langName = WiktionaryLangs.getEnglishName(langCode);
            if (langName != null) {
                appendAndIndexWikiCallback.dispatch(langName, null);
            } else {
                appendAndIndexWikiCallback.dispatch("lang:" + langCode, null);
            }
            return true;
        }
    }

    static final class gloss<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        gloss() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            if (args.size() != 1 || !namedArgs.isEmpty()) {
                return false;
            }
            appendAndIndexWikiCallback.builder.append("(");
            appendAndIndexWikiCallback.dispatch(args.get(0), EntryTypeName.WIKTIONARY_TRANSLATION_OTHER_TEXT);
            appendAndIndexWikiCallback.builder.append(")");
            return true;
        }
    }

    static final class it_conj<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        it_conj() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            StringBuilder builder = appendAndIndexWikiCallback.builder;
            String inf = namedArgs.get("inf");
            builder.append("<table style=\"background:#F0F0F0\">");
            builder.append("<tr>");
            builder.append("<th colspan=\"1\" style=\"background:#e2e4c0\">infinito</th>");
            builder.append("<td colspan=\"1\">");
            appendAndIndexWikiCallback.dispatch(MapUtil.safeRemove(namedArgs, "inf", "-"), null);
            builder.append("</td>");
            builder.append("</tr>\n");
            builder.append("<tr>");
            builder.append("<th colspan=\"1\" style=\"background:#e2e4c0\">verbo ausiliare</th>");
            builder.append("<td colspan=\"1\">");
            appendAndIndexWikiCallback.dispatch(MapUtil.safeRemove(namedArgs, "aux", "-"), null);
            builder.append("</td>");
            builder.append("<th colspan=\"1\" style=\"background:#e2e4c0\">gerundio</th>");
            builder.append("<td colspan=\"1\">");
            EnFunctionCallbacks.outputKeyVariations(appendAndIndexWikiCallback, builder, "ger", namedArgs, true);
            builder.append("</td>");
            builder.append("</tr>\n");
            builder.append("<tr>");
            builder.append("<th colspan=\"1\" style=\"background:#e2e4c0\">participio presente</th>");
            builder.append("<td colspan=\"1\">");
            EnFunctionCallbacks.outputKeyVariations(appendAndIndexWikiCallback, builder, "presp", namedArgs, true);
            builder.append("</td>");
            builder.append("<th colspan=\"1\" style=\"background:#e2e4c0\">participio passato</th>");
            builder.append("<td colspan=\"1\">");
            EnFunctionCallbacks.outputKeyVariations(appendAndIndexWikiCallback, builder, "pastp", namedArgs, true);
            builder.append("</td>");
            builder.append("</tr>\n");
            List<String> prefixes = inf != null && inf.endsWith("si") ? it_reflexive_pronouns : it_empty;
            String style2 = " style=\"background:#c0cfe4\"";
            this.outputDataRow(appendAndIndexWikiCallback, style2, "indicativo", style2, "th", "", new LinkedHashMap<String, String>(it_indicativePronouns), it_empty, false);
            this.outputDataRow(appendAndIndexWikiCallback, style2, "presente", "", "td", "pres", namedArgs, prefixes, true);
            this.outputDataRow(appendAndIndexWikiCallback, style2, "imperfetto", "", "td", "imperf", namedArgs, prefixes, true);
            this.outputDataRow(appendAndIndexWikiCallback, style2, "passato remoto", "", "td", "prem", namedArgs, prefixes, true);
            this.outputDataRow(appendAndIndexWikiCallback, style2, "futuro", "", "td", "fut", namedArgs, prefixes, true);
            style2 = " style=\"background:#c0d8e4\"";
            this.outputDataRow(appendAndIndexWikiCallback, style2, "condizionale", style2, "th", "", new LinkedHashMap<String, String>(it_indicativePronouns), it_empty, false);
            this.outputDataRow(appendAndIndexWikiCallback, style2, "presente", "", "td", "cond", namedArgs, prefixes, true);
            style2 = " style=\"background:#c0e4c0\"";
            this.outputDataRow(appendAndIndexWikiCallback, style2, "congiuntivo", style2, "th", "", new LinkedHashMap<String, String>(it_subjunctivePronouns), it_empty, false);
            namedArgs.put("sub3s2", namedArgs.remove("sub3s"));
            namedArgs.put("sub1s", namedArgs.get("sub123s"));
            namedArgs.put("sub2s", namedArgs.get("sub123s"));
            namedArgs.put("sub3s", namedArgs.remove("sub123s"));
            namedArgs.put("sub1s2", namedArgs.get("sub123s2"));
            namedArgs.put("sub2s2", namedArgs.get("sub123s2"));
            namedArgs.put("sub3s2", namedArgs.remove("sub123s2"));
            this.outputDataRow(appendAndIndexWikiCallback, style2, "presente", "", "td", "sub", namedArgs, prefixes, true);
            namedArgs.put("impsub1s", namedArgs.get("impsub12s"));
            namedArgs.put("impsub2s", namedArgs.remove("impsub12s"));
            namedArgs.put("impsub1s2", namedArgs.get("impsub12s2"));
            namedArgs.put("impsub2s2", namedArgs.remove("impsub12s2"));
            this.outputDataRow(appendAndIndexWikiCallback, style2, "imperfetto", "", "td", "impsub", namedArgs, prefixes, true);
            style2 = " style=\"background:#e4d4c0\"";
            this.outputDataRow(appendAndIndexWikiCallback, style2, "imperativo", style2, "th", "", new LinkedHashMap<String, String>(it_imperativePronouns), it_empty, false);
            this.outputDataRow(appendAndIndexWikiCallback, style2, "", "", "td", "imp", namedArgs, it_empty, false);
            builder.append("</table>\n");
            if (!namedArgs.isEmpty()) {
                System.err.println("NON-EMPTY namedArgs: " + namedArgs);
                if ("muovesse".equals(namedArgs.get("impsib3s2"))) {
                    return false;
                }
                if ("percuotesse".equals(namedArgs.get("impsib3s2"))) {
                    return false;
                }
                return false;
            }
            return true;
        }

        private void outputDataRow(AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback, String col1Style, String headerName, String col2Style, String type2, String moodName, Map<String, String> namedArgs, List<String> prefixes, boolean isForm) {
            StringBuilder builder = appendAndIndexWikiCallback.builder;
            builder.append("<tr>");
            builder.append("<th colspan=\"1\"").append(col1Style).append(">").append(headerName).append("</th>");
            int i = 0;
            for (String number : it_number_s_p) {
                for (String person : it_person_1_2_3) {
                    builder.append("<").append(type2).append("").append(col2Style).append(">");
                    String keyBase = String.format("%s%s%s", moodName, person, number);
                    appendAndIndexWikiCallback.dispatch(prefixes.get(i++), null);
                    EnFunctionCallbacks.outputKeyVariations(appendAndIndexWikiCallback, builder, keyBase, namedArgs, isForm);
                    builder.append("</").append(type2).append(">");
                }
            }
            builder.append("</tr>\n");
        }
    }

    static final class it_conj_are<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        final it_conj<T> dest;

        it_conj_are(it_conj<T> dest) {
            this.dest = dest;
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String h = name.equals("it-conj-care") || name.equals("it-conj-carsi") ? "h" : "";
            String i = name.equals("it-conj-ciare") || name.equals("it-conj-ciarsi") ? "i" : "";
            String i2 = name.equals("it-conj-iare") || name.equals("it-conj-iarsi") ? "" : "i";
            boolean si = name.equals("it-conj-arsi") || name.equals("it-conj-iarsi") || name.equals("it-conj-iarsi-b") || name.equals("it-conj-carsi") || name.equals("it-conj-ciarsi");
            String root = args.get(0);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "inf", String.valueOf(root) + i + (si ? "arsi" : "are"), false);
            namedArgs.put("aux", ListUtil.get(args, 1, ""));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "ger", String.valueOf(root) + i + "ando" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "presp", String.valueOf(root) + i + "ante" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp", String.valueOf(root) + i + "ato", true);
            if (si) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp2", String.valueOf(root) + i + "atosi", true);
            }
            String i2b = name.equals("it-conj-iare-b") || name.equals("it-conj-iarsi-b") ? "" : i2;
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "pres", false, root, Arrays.asList(String.valueOf(i) + "o", String.valueOf(h) + i2, String.valueOf(i) + "a", String.valueOf(h) + i2 + "amo", String.valueOf(i) + "ate", String.valueOf(i) + "ano"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "imperf", false, root, Arrays.asList(String.valueOf(i) + "avo", String.valueOf(i) + "avi", String.valueOf(i) + "ava", String.valueOf(i) + "avamo", String.valueOf(i) + "avate", String.valueOf(i) + "avano"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "prem", false, root, Arrays.asList(String.valueOf(i) + "ai", String.valueOf(i) + "asti", String.valueOf(i) + "\u00f2", String.valueOf(i) + "ammo", String.valueOf(i) + "aste", String.valueOf(i) + "arono"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "fut", true, root, Arrays.asList(String.valueOf(h) + "er\u00f2", String.valueOf(h) + "erai", String.valueOf(h) + "er\u00e0", String.valueOf(h) + "eremo", String.valueOf(h) + "erete", String.valueOf(h) + "eranno"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "cond", true, root, Arrays.asList(String.valueOf(h) + "erei", String.valueOf(h) + "eresti", String.valueOf(h) + "erebbe", String.valueOf(h) + "eremmo", String.valueOf(h) + "ereste", String.valueOf(h) + "erebbero"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub123s", String.valueOf(root) + h + i2, false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub1p", String.valueOf(root) + h + i2b + "amo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub2p", String.valueOf(root) + h + i2b + "ate", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub3p", String.valueOf(root) + h + i2 + "no", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub12s", String.valueOf(root) + i + "assi", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3s", String.valueOf(root) + i + "asse", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub1p", String.valueOf(root) + i + "assimo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub2p", String.valueOf(root) + i + "aste", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3p", String.valueOf(root) + i + "assero", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2s", String.valueOf(root) + i + "a" + (si ? "ti" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3s", String.valueOf(si ? "si " : "") + root + h + i2, true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp1p", String.valueOf(root) + h + i2b + "amo" + (si ? "ci" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2p", String.valueOf(root) + i + "ate" + (si ? "vi" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3p", String.valueOf(si ? "si " : "") + root + h + i2 + "no", true);
            return this.dest.onWikiFunction(wikiTokenizer, name, args, namedArgs, parser, appendAndIndexWikiCallback);
        }
    }

    static final class it_conj_ere<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        final it_conj<T> dest;

        it_conj_ere(it_conj<T> dest) {
            this.dest = dest;
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String root = args.get(0);
            boolean si = name.equals("it-conj-ersi");
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "inf", String.valueOf(root) + (si ? "ersi" : "ere"), false);
            namedArgs.put("aux", ListUtil.get(args, 1, ""));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "ger", String.valueOf(root) + "endo" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "presp", String.valueOf(root) + "ente" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp", String.valueOf(root) + "uto", true);
            if (si) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp2", String.valueOf(root) + "utosi", true);
            }
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "pres", false, root, Arrays.asList("o", "i", "e", "iamo", "ete", "ono"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "imperf", false, root, Arrays.asList("evo", "evi", "eva", "evamo", "evate", "evano"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "prem", false, root, Arrays.asList("ei", "esti", "ette", "emmo", "este", "ettero"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "prem3s2", String.valueOf(root) + "\u00e9", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "prem3p2", String.valueOf(root) + "erono", true);
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "fut", true, root, Arrays.asList("er\u00f2", "erai", "er\u00e0", "eremo", "erete", "eranno"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "cond", true, root, Arrays.asList("erei", "eresti", "erebbe", "eremmo", "ereste", "erebbero"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub123s", String.valueOf(root) + "a", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub1p", String.valueOf(root) + "iamo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub2p", String.valueOf(root) + "iate", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub3p", String.valueOf(root) + "ano", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub12s", String.valueOf(root) + "essi", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3s", String.valueOf(root) + "esse", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub1p", String.valueOf(root) + "essimo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub2p", String.valueOf(root) + "este", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3p", String.valueOf(root) + "essero", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2s", String.valueOf(root) + "i" + (si ? "ti" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3s", String.valueOf(si ? "si " : "") + root + "a", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp1p", String.valueOf(root) + "iamo" + (si ? "ci" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2p", String.valueOf(root) + "ete" + (si ? "vi" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3p", String.valueOf(si ? "si " : "") + root + "ano", true);
            return this.dest.onWikiFunction(wikiTokenizer, name, args, namedArgs, parser, appendAndIndexWikiCallback);
        }
    }

    static final class it_conj_fare<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        final it_conj<T> dest;

        it_conj_fare(it_conj<T> dest) {
            this.dest = dest;
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String root = args.get(0);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "inf", String.valueOf(root) + "fare", false);
            namedArgs.put("aux", ListUtil.get(args, 1, ""));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "ger", String.valueOf(root) + "facendo", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "presp", String.valueOf(root) + "facente", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp", String.valueOf(root) + "fatto", true);
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "pres", false, root, Arrays.asList("faccio", "fai", "f\u00e0", "facciamo", "fate", "fanno"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pres1s2", String.valueOf(root) + "f\u00f2", true);
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "imperf", false, root, Arrays.asList("facevo", "facevi", "faceva", "facevamo", "facevate", "facevano"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "prem", false, root, Arrays.asList("feci", "facesti", "fece", "facemmo", "faceste", "fecero"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "fut", true, root, Arrays.asList("far\u00f2", "farai", "far\u00e0", "faremo", "farete", "faranno"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "cond", true, root, Arrays.asList("farei", "faresti", "farebbe", "faremmo", "fareste", "farebbero"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub123s", String.valueOf(root) + "faccia", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub1p", String.valueOf(root) + "facciamo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub2p", String.valueOf(root) + "facciate", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub3p", String.valueOf(root) + "facciano", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub12s", String.valueOf(root) + "facessi", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3s", String.valueOf(root) + "facesse", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub1p", String.valueOf(root) + "facessimo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub2p", String.valueOf(root) + "faceste", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3p", String.valueOf(root) + "facessero", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2s", String.valueOf(root) + "fa", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3s", String.valueOf(root) + "faccia", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp1p", String.valueOf(root) + "facciamo", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2p", String.valueOf(root) + "fate", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3p", String.valueOf(root) + "facciano", true);
            return this.dest.onWikiFunction(wikiTokenizer, name, args, namedArgs, parser, appendAndIndexWikiCallback);
        }
    }

    static final class it_conj_ire<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        final it_conj<T> dest;

        it_conj_ire(it_conj<T> dest) {
            this.dest = dest;
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String root = args.get(0);
            String i = name.equals("it-conj-cire") || name.equals("it-conj-cirsi") ? "i" : "";
            boolean si = name.equals("it-conj-irsi") || name.equals("it-conj-irsi-b") || name.equals("it-conj-cirsi");
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "inf", String.valueOf(root) + (si ? "irsi" : "ire"), false);
            namedArgs.put("aux", ListUtil.get(args, 1, ""));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "ger", String.valueOf(root) + "endo" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "presp", String.valueOf(root) + "ente" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp", String.valueOf(root) + "ito", true);
            if (si) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp2", String.valueOf(root) + "itosi", true);
            }
            if (!name.endsWith("-b")) {
                EnFunctionCallbacks.it_conj_passMood(namedArgs, "pres", false, root, Arrays.asList(String.valueOf(i) + "o", "i", "e", "iamo", "ite", String.valueOf(i) + "ono"));
            } else {
                EnFunctionCallbacks.it_conj_passMood(namedArgs, "pres", false, root, Arrays.asList("isco", "isci", "isce", "iamo", "ite", "iscono"));
            }
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "imperf", false, root, Arrays.asList("ivo", "ivi", "iva", "ivamo", "ivate", "ivano"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "prem", false, root, Arrays.asList("ii", "isti", "\u00ec", "immo", "iste", "irono"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "prem3s2", String.valueOf(root) + "\u00e9", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "prem3p2", String.valueOf(root) + "erono", true);
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "fut", true, root, Arrays.asList("ir\u00f2", "irai", "ir\u00e0", "iremo", "irete", "iranno"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "cond", true, root, Arrays.asList("irei", "iresti", "irebbe", "iremmo", "ireste", "irebbero"));
            if (!name.endsWith("-b")) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub123s", String.valueOf(root) + i + "a", false);
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub3p", String.valueOf(root) + i + "ano", false);
            } else {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub123s", String.valueOf(root) + "isca", false);
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub3p", String.valueOf(root) + "iscano", false);
            }
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub1p", String.valueOf(root) + "iamo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub2p", String.valueOf(root) + "iate", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub12s", String.valueOf(root) + "issi", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3s", String.valueOf(root) + "isse", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub1p", String.valueOf(root) + "issimo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub2p", String.valueOf(root) + "iste", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3p", String.valueOf(root) + "issero", false);
            if (!name.endsWith("-b")) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2s", String.valueOf(root) + "i" + (si ? "ti" : ""), true);
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3s", String.valueOf(si ? "si " : "") + root + i + "a", true);
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3p", String.valueOf(si ? "si " : "") + root + i + "ano", true);
            } else {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2s", String.valueOf(root) + "isci" + (si ? "ti" : ""), true);
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3s", String.valueOf(si ? "si " : "") + root + "isca", true);
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3p", String.valueOf(si ? "si " : "") + root + "iscano", true);
            }
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp1p", String.valueOf(root) + "iamo" + (si ? "ci" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2p", String.valueOf(root) + "ite" + (si ? "vi" : ""), true);
            return this.dest.onWikiFunction(wikiTokenizer, name, args, namedArgs, parser, appendAndIndexWikiCallback);
        }
    }

    static final class it_conj_urre<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        final it_conj<T> dest;

        it_conj_urre(it_conj<T> dest) {
            this.dest = dest;
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            String root = args.get(0);
            boolean si = name.equals("it-conj-ursi");
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "inf", String.valueOf(root) + (si ? "ursi" : "urre"), false);
            namedArgs.put("aux", ListUtil.get(args, 1, ""));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "ger", String.valueOf(root) + "ucendo" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "presp", String.valueOf(root) + "ucente" + (si ? "si" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp", String.valueOf(root) + "otto", true);
            if (si) {
                EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "pastp2", String.valueOf(root) + "ottosi", true);
            }
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "pres", false, root, Arrays.asList("uco", "uci", "uce", "uciamo", "ucete", "ucono"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "imperf", false, root, Arrays.asList("ucevo", "ucevi", "uceva", "ucevamo", "ucevate", "ucevano"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "prem", false, root, Arrays.asList("ussi", "ucesti", "usse", "ucemmo", "uceste", "ussero"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "fut", true, root, Arrays.asList("urr\u00f2", "urrai", "urr\u00e0", "urremo", "urrete", "urranno"));
            EnFunctionCallbacks.it_conj_passMood(namedArgs, "cond", true, root, Arrays.asList("urrei", "urresti", "urrebbe", "urremmo", "urreste", "urrebbero"));
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub123s", String.valueOf(root) + "uca", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub1p", String.valueOf(root) + "uciamo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub2p", String.valueOf(root) + "uciate", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "sub3p", String.valueOf(root) + "ucano", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub12s", String.valueOf(root) + "ucessi", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3s", String.valueOf(root) + "ucesse", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub1p", String.valueOf(root) + "ucessimo", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub2p", String.valueOf(root) + "uceste", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "impsub3p", String.valueOf(root) + "ucessero", false);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2s", String.valueOf(root) + "uci" + (si ? "ti" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3s", String.valueOf(si ? "si" : "") + root + "uca", true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp1p", String.valueOf(root) + "uciamo" + (si ? "ci" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp2p", String.valueOf(root) + "ucete" + (si ? "vi" : ""), true);
            EnFunctionCallbacks.passThroughOrFillIn(namedArgs, "imp3p", String.valueOf(si ? "si" : "") + root + "ucano", true);
            return this.dest.onWikiFunction(wikiTokenizer, name, args, namedArgs, parser, appendAndIndexWikiCallback);
        }
    }

    static final class it_noun
    implements FunctionCallback<EnParser> {
        it_noun() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, EnParser parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> appendAndIndexWikiCallback) {
            String m;
            parser.titleAppended = true;
            String base = ListUtil.get(args, 0);
            String gender = ListUtil.get(args, 1);
            String singular = String.valueOf(base) + (String)ListUtil.get(args, 2, null);
            String plural = String.valueOf(base) + (String)ListUtil.get(args, 3, null);
            appendAndIndexWikiCallback.builder.append(" ");
            appendAndIndexWikiCallback.dispatch(singular, null, null);
            appendAndIndexWikiCallback.builder.append(" {").append(gender).append("}, ");
            appendAndIndexWikiCallback.dispatch(plural, null, null);
            appendAndIndexWikiCallback.builder.append(" {pl}");
            String f = namedArgs.remove("f");
            if (f != null) {
                appendAndIndexWikiCallback.builder.append(", ");
                appendAndIndexWikiCallback.dispatch(f, null, null);
                appendAndIndexWikiCallback.builder.append(" {f}");
            }
            if ((m = namedArgs.remove("f")) != null) {
                appendAndIndexWikiCallback.builder.append(", ");
                appendAndIndexWikiCallback.dispatch(m, null, null);
                appendAndIndexWikiCallback.builder.append(" {m}");
            }
            parser.wordForms.add(singular);
            parser.wordForms.add(plural);
            if (!namedArgs.isEmpty() || args.size() > 4) {
                EnParser.LOG.warning("Invalid it-noun: " + wikiTokenizer.token());
            }
            return true;
        }
    }

    static final class it_proper_noun<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        it_proper_noun() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            return false;
        }
    }

    static final class italbrac<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        italbrac() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            if (args.size() != 1 || !namedArgs.isEmpty()) {
                return false;
            }
            appendAndIndexWikiCallback.builder.append("(");
            appendAndIndexWikiCallback.dispatch(args.get(0), EntryTypeName.WIKTIONARY_TRANSLATION_OTHER_TEXT);
            appendAndIndexWikiCallback.builder.append(")");
            return true;
        }
    }

    static final class l_term
    implements FunctionCallback<EnParser> {
        l_term() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, EnParser parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<EnParser> appendAndIndexWikiCallback) {
            String gloss2;
            EntryTypeName entryTypeName;
            if (name.equals("term")) {
                args.add(0, "");
            }
            switch (parser.state) {
                case TRANSLATION_LINE: {
                    entryTypeName = EntryTypeName.WIKTIONARY_TRANSLATION_OTHER_TEXT;
                    break;
                }
                case ENGLISH_DEF_OF_FOREIGN: {
                    entryTypeName = EntryTypeName.WIKTIONARY_ENGLISH_DEF_WIKI_LINK;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid enum value: " + (Object)((Object)parser.state));
                }
            }
            String langCode = args.get(0);
            IndexBuilder indexBuilder = "".equals(langCode) ? parser.foreignIndexBuilder : ("en".equals(langCode) ? parser.enIndexBuilder : parser.foreignIndexBuilder);
            String displayText = ListUtil.get(args, 2, "");
            if (displayText.equals("")) {
                displayText = ListUtil.get(args, 1, null);
            }
            if (displayText != null) {
                appendAndIndexWikiCallback.dispatch(displayText, indexBuilder, entryTypeName);
            } else {
                EnParser.LOG.warning("no display text: " + wikiTokenizer.token());
            }
            String tr = namedArgs.remove("tr");
            if (tr != null) {
                appendAndIndexWikiCallback.builder.append(" (");
                appendAndIndexWikiCallback.dispatch(tr, indexBuilder, EntryTypeName.WIKTIONARY_TRANSLITERATION);
                appendAndIndexWikiCallback.builder.append(")");
            }
            if (!(gloss2 = ListUtil.get(args, 3, "")).equals("")) {
                appendAndIndexWikiCallback.builder.append(" (");
                appendAndIndexWikiCallback.dispatch(gloss2, parser.enIndexBuilder, EntryTypeName.WIKTIONARY_ENGLISH_DEF);
                appendAndIndexWikiCallback.builder.append(")");
            }
            namedArgs.keySet().removeAll(EnParser.USELESS_WIKI_ARGS);
            if (!namedArgs.isEmpty()) {
                appendAndIndexWikiCallback.builder.append(" {").append(name);
                EnParser.appendNamedArgs(namedArgs, appendAndIndexWikiCallback);
                appendAndIndexWikiCallback.builder.append("}");
            }
            return true;
        }
    }

    static final class not_used<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        not_used() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            appendAndIndexWikiCallback.builder.append("(not used)");
            return true;
        }
    }

    static final class term<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        term() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            namedArgs.remove("sc");
            String lang = namedArgs.remove("lang");
            String head = ListUtil.get(args, 0);
            String display = ListUtil.get(args, 1);
            if (StringUtil.isNullOrEmpty(head) && StringUtil.isNullOrEmpty(display)) {
                head = display = ((AbstractWiktionaryParser)parser).title;
            }
            if (StringUtil.isNullOrEmpty(head)) {
                appendAndIndexWikiCallback.dispatch(display, null);
            } else {
                if (StringUtil.isNullOrEmpty(display)) {
                    display = head;
                }
                appendAndIndexWikiCallback.dispatch(String.format("[[%s|%s]]", display, head), null);
            }
            String tr = namedArgs.remove("tr");
            String pos = namedArgs.remove("pos");
            String gloss2 = ListUtil.get(args, 2);
            String literally = namedArgs.remove("lit");
            if (!StringUtil.isNullOrEmpty(gloss2)) {
                gloss2 = String.format("\"%s\"", gloss2);
            }
            if (!StringUtil.isNullOrEmpty(literally)) {
                literally = String.format("literally %s", literally);
            }
            ArrayList<String> inParens = new ArrayList<String>(Arrays.asList(tr, pos, gloss2, literally));
            EnFunctionCallbacks.cleanList(inParens);
            this.appendCommaSeparatedList(appendAndIndexWikiCallback, inParens);
            if (tr != null) {
                ((AbstractWiktionaryParser)parser).addLinkToCurrentEntry(tr, lang, EntryTypeName.WIKTIONARY_MENTIONED);
            }
            return namedArgs.isEmpty();
        }

        private void appendCommaSeparatedList(AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback, List<String> inParens) {
            if (!inParens.isEmpty()) {
                appendAndIndexWikiCallback.dispatch(" (", null);
                int i = 0;
                while (i < inParens.size()) {
                    if (i > 0) {
                        appendAndIndexWikiCallback.dispatch(", ", null);
                    }
                    appendAndIndexWikiCallback.dispatch(inParens.get(i), null);
                    ++i;
                }
                appendAndIndexWikiCallback.dispatch(")", null);
            }
        }
    }

    static final class wikipedia<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        wikipedia() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AbstractWiktionaryParser.AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            namedArgs.remove("lang");
            if (args.size() > 1 || !namedArgs.isEmpty()) {
                return false;
            }
            return args.size() != 1;
        }
    }
}

