/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public final class EnForeignParser
extends EnParser {
    int foreignCount = 0;

    public EnForeignParser(IndexBuilder enIndexBuilder, IndexBuilder otherIndexBuilder, Pattern langPattern, Pattern langCodePattern, boolean swap) {
        super(enIndexBuilder, otherIndexBuilder, langPattern, langCodePattern, swap);
    }

    @Override
    void parseSection(String heading, String text) {
        if (EnForeignParser.isIgnorableTitle(this.title)) {
            return;
        }
        String lang = heading.replaceAll("=", "").trim();
        if (!this.langPattern.matcher(lang).find()) {
            return;
        }
        WikiTokenizer wikiTokenizer = new WikiTokenizer(text);
        while (wikiTokenizer.nextToken() != null) {
            if (!wikiTokenizer.isHeading()) continue;
            String headingName = wikiTokenizer.headingWikiText();
            if (headingName.equals("Translations")) {
                LOG.warning("Translations not in English section: " + this.title);
                this.incrementCount("WARNING: Translations not in English section");
                continue;
            }
            if (headingName.equals("Pronunciation") || !partOfSpeechHeader.matcher(headingName).matches()) continue;
            this.doForeignPartOfSpeech(lang, headingName, wikiTokenizer.headingDepth(), wikiTokenizer);
        }
    }

    /*
     * Exception decompiling
     */
    private void doForeignPartOfSpeech(String lang, String posHeading, int posDepth, WikiTokenizer wikiTokenizer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doForeignListSection(String foreignText, String title, Collection<String> forms, ListSection listSection) {
        this.state = EnParser.State.ENGLISH_DEF_OF_FOREIGN;
        String prefix = listSection.firstPrefix;
        if (prefix.length() > 1) {
            LOG.warning("Prefix too long: " + listSection);
            this.incrementCount("WARNING: Prefix too long");
            return;
        }
        PairEntry pairEntry = new PairEntry(this.entrySource);
        IndexedEntry indexedEntry = new IndexedEntry(pairEntry);
        indexedEntry.isValid = true;
        this.entryIsFormOfSomething = false;
        StringBuilder englishBuilder = new StringBuilder();
        String mainLine = listSection.firstLine;
        this.appendAndIndexWikiCallback.reset(englishBuilder, indexedEntry);
        this.appendAndIndexWikiCallback.dispatch(mainLine, this.enIndexBuilder, EntryTypeName.WIKTIONARY_ENGLISH_DEF);
        String english = EnForeignParser.trim(englishBuilder.toString());
        if (english.length() > 0) {
            PairEntry.Pair pair = new PairEntry.Pair(english, EnForeignParser.trim(foreignText), this.swap);
            pairEntry.pairs.add(pair);
            this.foreignIndexBuilder.addEntryWithString(indexedEntry, title, this.entryIsFormOfSomething ? EntryTypeName.WIKTIONARY_IS_FORM_OF_SOMETHING_ELSE : EntryTypeName.WIKTIONARY_TITLE_MULTI);
            for (String form : forms) {
                this.foreignIndexBuilder.addEntryWithString(indexedEntry, form, EntryTypeName.WIKTIONARY_INFLECTED_FORM_MULTI);
            }
        }
        String lastForeign = null;
        int i = 0;
        while (i < listSection.nextPrefixes.size()) {
            PairEntry.Pair pair;
            String nextPrefix = listSection.nextPrefixes.get(i);
            String nextLine = listSection.nextLines.get(i);
            int dash = nextLine.indexOf("&mdash;");
            int mdashLen = 7;
            if (dash == -1) {
                dash = nextLine.indexOf("\u2014");
                mdashLen = 1;
            }
            if (dash == -1) {
                dash = nextLine.indexOf(" - ");
                mdashLen = 3;
            }
            if ((nextPrefix.equals("#:") || nextPrefix.equals("##:")) && dash != -1) {
                String foreignEx = nextLine.substring(0, dash);
                String englishEx = nextLine.substring(dash + mdashLen);
                PairEntry.Pair pair2 = new PairEntry.Pair(this.formatAndIndexExampleString(englishEx, this.enIndexBuilder, indexedEntry), this.formatAndIndexExampleString(foreignEx, this.foreignIndexBuilder, indexedEntry), this.swap);
                if (pair2.lang1 != "--" && pair2.lang1 != "--") {
                    pairEntry.pairs.add(pair2);
                }
                lastForeign = null;
            } else if (nextPrefix.equals("#:") || nextPrefix.equals("##:")) {
                pair = new PairEntry.Pair("--", this.formatAndIndexExampleString(nextLine, null, indexedEntry), this.swap);
                lastForeign = nextLine;
                if (pair.lang1 != "--" && pair.lang1 != "--") {
                    pairEntry.pairs.add(pair);
                }
            } else if (nextPrefix.equals("#::") || nextPrefix.equals("#**")) {
                if (lastForeign != null && pairEntry.pairs.size() > 0) {
                    pairEntry.pairs.remove(pairEntry.pairs.size() - 1);
                    pair = new PairEntry.Pair(this.formatAndIndexExampleString(nextLine, this.enIndexBuilder, indexedEntry), this.formatAndIndexExampleString(lastForeign, this.foreignIndexBuilder, indexedEntry), this.swap);
                    if (pair.lang1 != "--" || pair.lang2 != "--") {
                        pairEntry.pairs.add(pair);
                    }
                    lastForeign = null;
                } else {
                    LOG.warning("TODO: English example with no foreign: " + title + ", " + nextLine);
                    pair = new PairEntry.Pair("--", this.formatAndIndexExampleString(nextLine, null, indexedEntry), this.swap);
                    if (pair.lang1 != "--" || pair.lang2 != "--") {
                        pairEntry.pairs.add(pair);
                    }
                }
            } else if (nextPrefix.equals("#*")) {
                pair = new PairEntry.Pair("--", this.formatAndIndexExampleString(nextLine, null, indexedEntry), this.swap);
                lastForeign = nextLine;
                if (pair.lang1 != "--" || pair.lang2 != "--") {
                    pairEntry.pairs.add(pair);
                }
            } else {
                if (!(nextPrefix.equals("#::*") || nextPrefix.equals("##") || nextPrefix.equals("#*:"))) {
                    nextPrefix.equals("#:*");
                }
                pair = new PairEntry.Pair("--", this.formatAndIndexExampleString(nextLine, null, indexedEntry), this.swap);
                if (pair.lang1 != "--" || pair.lang2 != "--") {
                    pairEntry.pairs.add(pair);
                }
            }
            ++i;
        }
    }

    private String formatAndIndexExampleString(String example, IndexBuilder indexBuilder, IndexedEntry indexedEntry) {
        StringBuilder builder = new StringBuilder();
        this.appendAndIndexWikiCallback.reset(builder, indexedEntry);
        this.appendAndIndexWikiCallback.entryTypeName = EntryTypeName.WIKTIONARY_EXAMPLE;
        this.appendAndIndexWikiCallback.entryTypeNameSticks = true;
        try {
            this.appendAndIndexWikiCallback.dispatch(example, indexBuilder, EntryTypeName.WIKTIONARY_EXAMPLE);
        }
        catch (AssertionError e) {
            return "--";
        }
        String result = EnForeignParser.trim(builder.toString());
        return result.length() > 0 ? result : "--";
    }

    static final class ListSection {
        final String firstPrefix;
        final String firstLine;
        final List<String> nextPrefixes = new ArrayList<String>();
        final List<String> nextLines = new ArrayList<String>();

        public ListSection(String firstPrefix, String firstLine) {
            this.firstPrefix = firstPrefix;
            this.firstLine = firstLine;
        }

        public String toString() {
            return String.valueOf(this.firstPrefix) + this.firstLine + "{ " + this.nextPrefixes + "}";
        }
    }
}

