/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser.wiktionary;

import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.parser.Parser;
import com.hughes.android.dictionary.parser.WikiTokenizer;
import com.hughes.android.dictionary.parser.wiktionary.FunctionCallback;
import com.hughes.util.EnumUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class AbstractWiktionaryParser
implements Parser {
    static final Logger LOG = Logger.getLogger("WiktionaryParser");
    final SortedMap<String, AtomicInteger> counters = new TreeMap<String, AtomicInteger>();
    final Set<String> pairsAdded = new LinkedHashSet<String>();
    public EntrySource entrySource;
    public String title;
    static final Pattern whitespace = Pattern.compile("\\s+");
    static NameAndArgs<AbstractWiktionaryParser> NAME_AND_ARGS = new NameAndArgs();

    abstract void parseSection(String var1, String var2);

    abstract void removeUselessArgs(Map<String, String> var1);

    /*
     * Unable to fully structure code
     */
    @Override
    public void parse(File file, EntrySource entrySource, int pageLimit) throws IOException {
        this.entrySource = entrySource;
        pageCount = 0;
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        while (true) {
            block11: {
                block10: {
                    if (pageLimit < 0 || pageCount < pageLimit) break block10;
                    dis.close();
                    AbstractWiktionaryParser.LOG.info("***COUNTERS***");
                    for (Map.Entry<String, AtomicInteger> entry : this.counters.entrySet()) {
                        AbstractWiktionaryParser.LOG.info(String.valueOf(entry.getKey()) + ": " + entry.getValue());
                    }
                    return;
                }
                try {
                    this.title = dis.readUTF();
                    break block11;
                }
                catch (EOFException e) {
                    AbstractWiktionaryParser.LOG.log(Level.INFO, "EOF reading split.");
                    dis.close();
                    dis.close();
                    AbstractWiktionaryParser.LOG.info("***COUNTERS***");
                    ** for (entry : this.counters.entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    AbstractWiktionaryParser.LOG.info(String.valueOf(entry.getKey()) + ": " + entry.getValue());
                    continue;
                }
lbl26:
                // 1 sources

                return;
            }
            heading = dis.readUTF();
            bytesLength = dis.readInt();
            bytes = new byte[bytesLength];
            dis.readFully(bytes);
            text = new String(bytes, "UTF8");
            this.parseSection(heading, text);
            if (++pageCount % 1000 != 0) continue;
            AbstractWiktionaryParser.LOG.info("pageCount=" + pageCount);
            continue;
            break;
        }
        catch (Throwable var10_17) {
            dis.close();
            AbstractWiktionaryParser.LOG.info("***COUNTERS***");
            ** for (entry : this.counters.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            AbstractWiktionaryParser.LOG.info(String.valueOf(entry.getKey()) + ": " + entry.getValue());
            continue;
        }
lbl44:
        // 1 sources

        throw var10_17;
    }

    static String trim(String s) {
        return whitespace.matcher(s).replaceAll(" ").trim();
    }

    public void incrementCount(String string2) {
        AtomicInteger counter = (AtomicInteger)this.counters.get(string2);
        if (counter == null) {
            counter = new AtomicInteger();
            this.counters.put(string2, counter);
        }
        counter.incrementAndGet();
    }

    public void addLinkToCurrentEntry(String token, String lang, EntryTypeName entryTypeName) {
        assert (false) : String.valueOf(token) + ", title=" + this.title;
    }

    static void appendNamedArgs(Map<String, String> namedArgs, AppendAndIndexWikiCallback<?> appendAndIndexWikiCallback) {
        for (Map.Entry<String, String> entry : namedArgs.entrySet()) {
            appendAndIndexWikiCallback.builder.append("|");
            appendAndIndexWikiCallback.dispatch(entry.getKey(), null, null);
            appendAndIndexWikiCallback.builder.append("=");
            EntryTypeName entryTypeName = null;
            IndexBuilder indexBuilder = null;
            appendAndIndexWikiCallback.dispatch(entry.getValue(), indexBuilder, entryTypeName);
        }
    }

    static class AppendAndIndexWikiCallback<T extends AbstractWiktionaryParser>
    implements WikiTokenizer.Callback {
        final T parser;
        StringBuilder builder;
        IndexedEntry indexedEntry;
        IndexBuilder indexBuilder;
        final Map<String, FunctionCallback<T>> functionCallbacks = new LinkedHashMap<String, FunctionCallback<T>>();
        boolean entryTypeNameSticks = false;
        EntryTypeName entryTypeName = null;
        final Map<String, AtomicInteger> langCodeToTCount = new LinkedHashMap<String, AtomicInteger>();
        final NameAndArgs<T> nameAndArgs = new NameAndArgs();

        public AppendAndIndexWikiCallback(T parser) {
            this.parser = parser;
        }

        public void reset(StringBuilder builder, IndexedEntry indexedEntry) {
            this.builder = builder;
            this.indexedEntry = indexedEntry;
            this.indexBuilder = null;
            this.entryTypeName = null;
            this.entryTypeNameSticks = false;
        }

        public void dispatch(String wikiText, IndexBuilder indexBuilder, EntryTypeName entryTypeName) {
            IndexBuilder oldIndexBuilder = this.indexBuilder;
            EntryTypeName oldEntryTypeName = this.entryTypeName;
            this.indexBuilder = indexBuilder;
            if (!this.entryTypeNameSticks) {
                this.entryTypeName = EnumUtil.min(entryTypeName, this.entryTypeName);
            }
            if (entryTypeName == null) {
                this.entryTypeName = null;
            }
            WikiTokenizer.dispatch(wikiText, false, this);
            this.indexBuilder = oldIndexBuilder;
            this.entryTypeName = oldEntryTypeName;
        }

        public String dispatch(String wikiText, EntryTypeName entryTypeName) {
            int start = this.builder.length();
            this.dispatch(wikiText, this.indexBuilder, entryTypeName);
            return this.builder.substring(start);
        }

        @Override
        public void onPlainText(String plainText) {
            this.builder.append(plainText);
            if (this.indexBuilder != null && this.entryTypeName != null && this.indexedEntry != null) {
                this.indexBuilder.addEntryWithString(this.indexedEntry, plainText, this.entryTypeName);
            }
        }

        @Override
        public void onWikiLink(WikiTokenizer wikiTokenizer) {
            String text = wikiTokenizer.wikiLinkText();
            String link = wikiTokenizer.wikiLinkDest();
            this.dispatch(text, this.entryTypeName);
        }

        @Override
        public void onFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs) {
            FunctionCallback<T> functionCallback = this.functionCallbacks.get(name);
            if (functionCallback == null || !functionCallback.onWikiFunction(wikiTokenizer, name, args, namedArgs, this.parser, this)) {
                ((AbstractWiktionaryParser)this.parser).removeUselessArgs(namedArgs);
                boolean single = args.isEmpty() && namedArgs.isEmpty();
                this.builder.append(single ? "{" : "{{");
                IndexBuilder oldIndexBuilder = this.indexBuilder;
                this.indexBuilder = null;
                this.nameAndArgs.onWikiFunction(wikiTokenizer, name, args, namedArgs, this.parser, this);
                this.indexBuilder = oldIndexBuilder;
                this.builder.append(single ? "}" : "}}");
            }
        }

        @Override
        public void onHtml(WikiTokenizer wikiTokenizer) {
            if (wikiTokenizer.token().startsWith("<ref>")) {
                return;
            }
            this.builder.append(wikiTokenizer.token());
        }

        @Override
        public void onMarkup(WikiTokenizer wikiTokenizer) {
        }

        @Override
        public final void onComment(WikiTokenizer wikiTokenizer) {
        }

        @Override
        public void onNewline(WikiTokenizer wikiTokenizer) {
            assert (false);
        }

        @Override
        public void onHeading(WikiTokenizer wikiTokenizer) {
            assert (false);
        }

        @Override
        public void onListItem(WikiTokenizer wikiTokenizer) {
            assert (false);
        }
    }

    static final class NameAndArgs<T extends AbstractWiktionaryParser>
    implements FunctionCallback<T> {
        NameAndArgs() {
        }

        @Override
        public boolean onWikiFunction(WikiTokenizer wikiTokenizer, String name, List<String> args, Map<String, String> namedArgs, T parser, AppendAndIndexWikiCallback<T> appendAndIndexWikiCallback) {
            if (name != null) {
                appendAndIndexWikiCallback.dispatch(name, null);
            }
            int i = 0;
            while (i < args.size()) {
                if (args.get(i).length() > 0) {
                    appendAndIndexWikiCallback.builder.append("|");
                    appendAndIndexWikiCallback.dispatch(args.get(i), null, null);
                }
                ++i;
            }
            AbstractWiktionaryParser.appendNamedArgs(namedArgs, appendAndIndexWikiCallback);
            return true;
        }
    }
}

