/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser;

import com.hughes.android.dictionary.parser.WikiTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class WikiTokenizerTest
extends TestCase {
    public void testWikiLink() {
        String wikiText = "[[abc]]";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isWikiLink());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().wikiLinkText());
        WikiTokenizerTest.assertEquals(null, new WikiTokenizer(wikiText).nextToken().wikiLinkDest());
        wikiText = "[[abc|def]]";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isWikiLink());
        WikiTokenizerTest.assertEquals("def", new WikiTokenizer(wikiText).nextToken().wikiLinkText());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().wikiLinkDest());
        wikiText = "[[abc|def|ghi{{a|=2}}p]]";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isWikiLink());
        WikiTokenizerTest.assertEquals("ghi{{a|=2}}p", new WikiTokenizer(wikiText).nextToken().wikiLinkText());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().wikiLinkDest());
        wikiText = "[[abc]][[def]]";
        WikiTokenizerTest.assertEquals("[[abc]]", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().wikiLinkText());
        WikiTokenizerTest.assertEquals("def", new WikiTokenizer(wikiText).nextToken().nextToken().wikiLinkText());
    }

    public void testWikiList() {
        String wikiText = "* This is ''bold''' asdf.";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        wikiText = "* {{a|US}} {{IPA|[\u02c8f\u0254\u0279.w\u025dd]]}}\nasdf\n";
        WikiTokenizerTest.assertEquals("* {{a|US}} {{IPA|[\u02c8f\u0254\u0279.w\u025dd]]}}", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isListItem());
        WikiTokenizerTest.assertEquals("\n", new WikiTokenizer(wikiText).nextToken().nextToken().token());
        wikiText = "* [[asdf|\u2028asdf]]";
        WikiTokenizerTest.assertEquals("* [[asdf|\nasdf]]", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isListItem());
    }

    public void testFunction() {
        WikiTokenizer wt = new WikiTokenizer("'''\u03a0\u03c1\u03bf\u03c3\u03c4\u03b1\u03c4\u03b5\u03c5\u03cc\u03bc\u03b5\u03bd\u03b7 \u039f\u03bd\u03bf\u03bc\u03b1\u03c3\u03af\u03b1 \u03a0\u03c1\u03bf\u03ad\u03bb\u03b5\u03c5\u03c3\u03b7\u03c2''', \"Protected Designation of Origin\" {{");
        while (wt.nextToken() != null) {
            if (!wt.isFunction()) continue;
            WikiTokenizerTest.assertEquals("", wt.functionName());
        }
        String wikiText = "{{abc}}";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isFunction());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().functionName());
        WikiTokenizerTest.assertEquals(0, new WikiTokenizer(wikiText).nextToken().functionPositionArgs().size());
        WikiTokenizerTest.assertEquals(0, new WikiTokenizer(wikiText).nextToken().functionNamedArgs().size());
        wikiText = "{{abc|def}}";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isFunction());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().functionName());
        WikiTokenizerTest.assertEquals(Arrays.asList("def"), new WikiTokenizer(wikiText).nextToken().functionPositionArgs());
        WikiTokenizerTest.assertEquals(0, new WikiTokenizer(wikiText).nextToken().functionNamedArgs().size());
        wikiText = "{{abc|d[[|]]ef|ghi}}";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isFunction());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().functionName());
        WikiTokenizerTest.assertEquals(Arrays.asList("d[[|]]ef", "ghi"), new WikiTokenizer(wikiText).nextToken().functionPositionArgs());
        WikiTokenizerTest.assertEquals(0, new WikiTokenizer(wikiText).nextToken().functionNamedArgs().size());
        wikiText = "{{abc|arg1=101|ghi|arg2=202|arg3={{n1|n2=7|n3}}|{{d}}}}";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isFunction());
        WikiTokenizerTest.assertEquals("abc", new WikiTokenizer(wikiText).nextToken().functionName());
        WikiTokenizerTest.assertEquals(Arrays.asList("ghi", "{{d}}"), new WikiTokenizer(wikiText).nextToken().functionPositionArgs());
        WikiTokenizerTest.assertEquals(3, new WikiTokenizer(wikiText).nextToken().functionNamedArgs().size());
        WikiTokenizerTest.assertEquals("101", new WikiTokenizer(wikiText).nextToken().functionNamedArgs().get("arg1"));
        WikiTokenizerTest.assertEquals("202", new WikiTokenizer(wikiText).nextToken().functionNamedArgs().get("arg2"));
        WikiTokenizerTest.assertEquals("{{n1|n2=7|n3}}", new WikiTokenizer(wikiText).nextToken().functionNamedArgs().get("arg3"));
        wikiText = "{{gloss|asdf}\nAsdf\n\n";
        WikiTokenizerTest.assertEquals("{{gloss|asdf}", new WikiTokenizer(wikiText).nextToken().token());
        wikiText = "#*{{quote-book|year=1960|author={{w|P. G. Wodehouse}}\n|title={{w|Jeeves in the Offing}}\n|section=chapter XI\n|passage=\u201cI'm sorely beset, Jeeves. Do you recall telling me once about someone who told somebody he could tell him something which would make him think a bit? Knitted socks and porcu\npines entered into it, I remember.\u201d \u201cI think you may be referring to the ghost of the father of Hamlet, Prince of Denmark, sir. Addressing his son, he said \u2018I could a tale unfold whos\ne lightest word would harrow up thy soul, freeze thy young blood, make thy two eyes, like stars, start from their spheres, thy knotted and combined locks to part and each particular h\nair to stand on end like quills upon the fretful '''porpentine'''.\u2019&nbsp;\u201d \u201cThat's right. Locks, of course, not socks. Odd that he should have said '''porpentine''' when he meant porc\nupine. Slip of the tongue, no doubt, as so often happens with ghosts.\u201d}}";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
    }

    public void testReturn() {
        String wikiText = "hello\n=Heading=\nhello2";
        WikiTokenizer tokenizer = new WikiTokenizer(wikiText);
        WikiTokenizerTest.assertEquals("hello", tokenizer.nextToken().token());
        tokenizer.returnToLineStart();
        WikiTokenizerTest.assertEquals("hello", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("\n", tokenizer.nextToken().token());
        tokenizer.returnToLineStart();
        WikiTokenizerTest.assertEquals("hello", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("\n", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("=Heading=", tokenizer.nextToken().token());
        tokenizer.returnToLineStart();
        WikiTokenizerTest.assertEquals("=Heading=", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("\n", tokenizer.nextToken().token());
        tokenizer.returnToLineStart();
        WikiTokenizerTest.assertEquals("=Heading=", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("\n", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("hello2", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals(null, tokenizer.nextToken());
        tokenizer.returnToLineStart();
        WikiTokenizerTest.assertEquals("hello2", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals(null, tokenizer.nextToken());
    }

    public void testWikiHeading() {
        String wikiText = "==";
        WikiTokenizerTest.assertEquals("==", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isHeading());
        WikiTokenizerTest.assertEquals(2, new WikiTokenizer(wikiText).nextToken().headingDepth());
        WikiTokenizerTest.assertEquals("", new WikiTokenizer(wikiText).nextToken().headingWikiText());
        WikiTokenizerTest.assertEquals(1, new WikiTokenizer((String)wikiText).nextToken().errors.size());
        wikiText = "=a";
        WikiTokenizerTest.assertEquals("=a", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isHeading());
        WikiTokenizerTest.assertEquals(1, new WikiTokenizer(wikiText).nextToken().headingDepth());
        WikiTokenizerTest.assertEquals("a", new WikiTokenizer(wikiText).nextToken().headingWikiText());
        WikiTokenizerTest.assertEquals(2, new WikiTokenizer((String)wikiText).nextToken().errors.size());
        wikiText = "=a==";
        WikiTokenizerTest.assertEquals("=a==", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isHeading());
        WikiTokenizerTest.assertEquals(1, new WikiTokenizer(wikiText).nextToken().headingDepth());
        WikiTokenizerTest.assertEquals("a", new WikiTokenizer(wikiText).nextToken().headingWikiText());
        WikiTokenizerTest.assertEquals(1, new WikiTokenizer((String)wikiText).nextToken().errors.size());
        wikiText = "a=";
        WikiTokenizerTest.assertEquals("a", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertFalse(new WikiTokenizer(wikiText).nextToken().isHeading());
        wikiText = "=a=";
        WikiTokenizerTest.assertEquals("=a=", new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isHeading());
        WikiTokenizerTest.assertEquals(1, new WikiTokenizer(wikiText).nextToken().headingDepth());
        WikiTokenizerTest.assertEquals("a", new WikiTokenizer(wikiText).nextToken().headingWikiText());
        WikiTokenizerTest.assertEquals(0, new WikiTokenizer((String)wikiText).nextToken().errors.size());
        wikiText = "==aa[[|=]] {{|={{=}} }}==";
        WikiTokenizerTest.assertEquals(wikiText, new WikiTokenizer(wikiText).nextToken().token());
        WikiTokenizerTest.assertTrue(new WikiTokenizer(wikiText).nextToken().isHeading());
        WikiTokenizerTest.assertEquals(2, new WikiTokenizer(wikiText).nextToken().headingDepth());
        WikiTokenizerTest.assertEquals("aa[[|=]] {{|={{=}} }}", new WikiTokenizer(wikiText).nextToken().headingWikiText());
        WikiTokenizerTest.assertEquals(0, new WikiTokenizer((String)wikiText).nextToken().errors.size());
    }

    public void testSimple() {
        WikiTokenizer token;
        String wikiText = "Hi\nHello =thad| you're <!-- not --> '''pretty''' cool '''''over''''' there.\nhi <!--\nmulti-line\n# comment -->\n\nasdf\n{{template_not_in_list}}\n# {{template_in_list}}\n[[wikitext]]:[[wikitext]]\n: but this is a list!\n*:* and so is this :::\nhere's [[some blah|some]] wikitext.\nhere's a {{template|this has an = sign|blah=2|blah2=3|\nblah3=3,[[asdf]|[asdf asdf]|[asdf asdf asdf]],blah4=4}} and some more text.\n== Header 2 ==\n{{some-func|blah={{nested-func|n2}}|blah2=asdf}}\n{{mismatched]]\n[[mismatched}}\n{extraterminated}}\n[extraterminated]]\n=== {{header-template}} ===\n";
        String[] expectedTokens = new String[]{"Hi", "\n", "Hello ", "=", "thad", "|", " you're ", "<!-- not -->", " ", "'''", "pretty", "'''", " cool ", "'''", "''", "over", "'''", "''", " there.", "\n", "hi ", "<!--\nmulti-line\n# comment -->", "\n", "\n", "asdf", "\n", "{{template_not_in_list}}", "\n", "# {{template_in_list}}", "\n", "[[wikitext]]", ":", "[[wikitext]]", "\n", ": but this is a list!", "\n", "*:* and so is this :::", "\n", "here's ", "[[some blah|some]]", " wikitext.", "\n", "here's a ", "{{template|this has an = sign|blah=2|blah2=3|\nblah3=3,[[asdf]|[asdf asdf]|[asdf asdf asdf]],blah4=4}}", " and some more text.", "\n", "== Header 2 ==", "\n", "{{some-func|blah={{nested-func|n2}}|blah2=asdf}}", "\n", "{{mismatched]]", "\n", "[[mismatched}}", "\n", "{extraterminated", "}}", "\n", "[extraterminated", "]]", "\n", "=== {{header-template}} ===", "\n"};
        ArrayList<String> actualTokens = new ArrayList<String>();
        WikiTokenizer wikiTokenizer = new WikiTokenizer("Hi\nHello =thad| you're <!-- not --> '''pretty''' cool '''''over''''' there.\nhi <!--\nmulti-line\n# comment -->\n\nasdf\n{{template_not_in_list}}\n# {{template_in_list}}\n[[wikitext]]:[[wikitext]]\n: but this is a list!\n*:* and so is this :::\nhere's [[some blah|some]] wikitext.\nhere's a {{template|this has an = sign|blah=2|blah2=3|\nblah3=3,[[asdf]|[asdf asdf]|[asdf asdf asdf]],blah4=4}} and some more text.\n== Header 2 ==\n{{some-func|blah={{nested-func|n2}}|blah2=asdf}}\n{{mismatched]]\n[[mismatched}}\n{extraterminated}}\n[extraterminated]]\n=== {{header-template}} ===\n");
        int i = 0;
        while ((token = wikiTokenizer.nextToken()) != null) {
            actualTokens.add(token.token());
            System.out.println("\"" + token.token().replace("\n", "\\n") + "\",");
            WikiTokenizerTest.assertEquals(expectedTokens[i++], token.token());
        }
        WikiTokenizerTest.assertEquals(Arrays.asList(expectedTokens), actualTokens);
    }

    public void testHtml() {
        String wikiText = " zz <pre> asdf </pre> ZZ <math> 1234 </math> XX ";
        WikiTokenizer tokenizer = new WikiTokenizer(wikiText);
        WikiTokenizerTest.assertEquals(" zz ", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("<pre> asdf </pre>", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals(" ZZ ", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals("<math> 1234 </math>", tokenizer.nextToken().token());
        WikiTokenizerTest.assertEquals(" XX ", tokenizer.nextToken().token());
        wikiText = "\n<math> 1234 </math>";
        tokenizer = new WikiTokenizer(wikiText);
        WikiTokenizerTest.assertEquals("<math> 1234 </math>", tokenizer.nextToken().nextToken().token());
        wikiText = "# z'' is the '''free''' variable in \"<math>\\forall x\\exists y:xy=z</math>\".''";
        tokenizer = new WikiTokenizer(wikiText);
        WikiTokenizerTest.assertEquals(wikiText, tokenizer.nextToken().token());
    }
}

