/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.parser;

import com.hughes.android.dictionary.engine.DictionaryBuilder;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.parser.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DictFileParser
implements Parser {
    static final Logger logger = Logger.getLogger(DictFileParser.class.getName());
    public static final Pattern TAB = Pattern.compile("\\t");
    public static final Pattern DOUBLE_COLON = Pattern.compile(" :: ");
    public static final Pattern PIPE = Pattern.compile("\\|");
    static final Pattern SPACES = Pattern.compile("\\s+");
    static final Pattern BRACKETED = Pattern.compile("\\[([^]]+)\\]");
    static final Pattern PARENTHESIZED = Pattern.compile("\\(([^)]+)\\)");
    static final Pattern CURLY_BRACED = Pattern.compile("\\{([^}]+)\\}");
    static final Pattern NON_CHAR_DASH = Pattern.compile("[^-'\\p{L}\\p{M}\\p{N}]+");
    public static final Pattern NON_CHAR = Pattern.compile("[^\\p{L}\\p{M}\\p{N}]+");
    static final Pattern TRIM_PUNC = Pattern.compile("^[^\\p{L}\\p{M}\\p{N}]+|[^\\p{L}\\p{M}\\p{N}]+$");
    final Charset charset;
    final boolean flipCols;
    final Pattern fieldSplit;
    final Pattern subfieldSplit;
    final DictionaryBuilder dictBuilder;
    final IndexBuilder[] langIndexBuilders;
    final IndexBuilder bothIndexBuilder;
    EntrySource entrySource;

    public DictFileParser(Charset charset, boolean flipCols, Pattern fieldSplit, Pattern subfieldSplit, DictionaryBuilder dictBuilder, IndexBuilder[] langIndexBuilders, IndexBuilder bothIndexBuilder) {
        this.charset = charset;
        this.flipCols = flipCols;
        this.fieldSplit = fieldSplit;
        this.subfieldSplit = subfieldSplit;
        this.dictBuilder = dictBuilder;
        this.langIndexBuilders = langIndexBuilders;
        this.bothIndexBuilder = bothIndexBuilder;
    }

    @Override
    public void parse(File file, EntrySource entrySouce, int pageLimit) throws IOException {
        String line;
        this.entrySource = entrySouce;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset));
        int count = 0;
        while ((line = reader.readLine()) != null) {
            if (pageLimit >= 0 && count >= pageLimit) {
                return;
            }
            if (count % 10000 == 0) {
                logger.info("count=" + count + ", line=" + line);
            }
            this.parseLine(line);
            ++count;
        }
    }

    private void parseLine(String line) {
        if (line.startsWith("#") || line.length() == 0) {
            logger.info("Skipping comment line: " + line);
            return;
        }
        String[] fields = this.fieldSplit.split(line);
        if (fields.length < 2 || fields.length > 3) {
            logger.warning("Malformed line: " + line);
            return;
        }
        fields[0] = SPACES.matcher(fields[0]).replaceAll(" ").trim();
        fields[1] = SPACES.matcher(fields[1]).replaceAll(" ").trim();
        if (this.flipCols) {
            String temp = fields[0];
            fields[0] = fields[1];
            fields[1] = temp;
        }
        String[][] subfields = new String[2][];
        if (this.subfieldSplit != null) {
            subfields[0] = this.subfieldSplit.split(fields[0]);
            subfields[1] = this.subfieldSplit.split(fields[1]);
            if (subfields[0].length != subfields[1].length) {
                logger.warning("Number of subfields doesn't match: " + line);
                return;
            }
        } else {
            subfields[0] = new String[]{fields[0]};
            subfields[1] = new String[]{fields[1]};
        }
        PairEntry pairEntry = new PairEntry(this.entrySource);
        int i = 0;
        while (i < subfields[0].length) {
            subfields[0][i] = subfields[0][i].trim();
            subfields[1][i] = subfields[1][i].trim();
            if (subfields[0][i].length() == 0 && subfields[1][i].length() == 0) {
                logger.warning("Empty pair: " + line);
            } else {
                if (subfields[0][i].length() == 0) {
                    subfields[0][i] = "__";
                }
                if (subfields[1][i].length() == 0) {
                    subfields[1][i] = "__";
                }
                pairEntry.pairs.add(new PairEntry.Pair(subfields[0][i], subfields[1][i]));
            }
            ++i;
        }
        IndexedEntry entryData = new IndexedEntry(pairEntry);
        entryData.isValid = true;
        int l = 0;
        while (l < 2) {
            int j = 0;
            while (j < subfields[l].length) {
                String subfield = subfields[l][j];
                IndexBuilder indexBuilder = this.langIndexBuilders[l];
                if (indexBuilder.index.sortLanguage == Language.de) {
                    subfield = this.parseField_DE(indexBuilder, subfield, entryData, j);
                } else if (indexBuilder.index.sortLanguage == Language.en) {
                    subfield = this.parseField_EN(indexBuilder, subfield, entryData, j);
                }
                this.parseFieldGeneric(indexBuilder, subfield, entryData, j, subfields[l].length);
                ++j;
            }
            ++l;
        }
    }

    private void parseFieldGeneric(IndexBuilder indexBuilder, String field, IndexedEntry entryData, int subfieldIdx, int numSubFields) {
        String[] parenTokens;
        String[] bracketedTokens;
        EntryTypeName entryTypeName;
        Matcher matcher;
        StringBuilder bracketed = new StringBuilder();
        StringBuilder parenthesized = new StringBuilder();
        while ((matcher = BRACKETED.matcher(field)).find()) {
            bracketed.append(matcher.group(1)).append(" ");
            field = matcher.replaceFirst(" ");
        }
        while ((matcher = PARENTHESIZED.matcher(field)).find()) {
            parenthesized.append(matcher.group(1)).append(" ");
            field = matcher.replaceFirst(" ");
        }
        field = SPACES.matcher(field).replaceAll(" ").trim();
        String[] tokens = NON_CHAR_DASH.split(field);
        if (numSubFields == 1) {
            assert (subfieldIdx == 0);
            entryTypeName = tokens.length == 1 ? EntryTypeName.ONE_WORD : (tokens.length == 2 ? EntryTypeName.TWO_WORDS : (tokens.length == 3 ? EntryTypeName.THREE_WORDS : (tokens.length == 4 ? EntryTypeName.FOUR_WORDS : EntryTypeName.FIVE_OR_MORE_WORDS)));
        } else {
            assert (numSubFields > 1);
            if (subfieldIdx == 0) {
                entryTypeName = tokens.length == 1 ? EntryTypeName.MULTIROW_HEAD_ONE_WORD : EntryTypeName.MULTIROW_HEAD_MANY_WORDS;
            } else {
                assert (subfieldIdx > 0);
                entryTypeName = tokens.length == 1 ? EntryTypeName.MULTIROW_TAIL_ONE_WORD : EntryTypeName.MULTIROW_TAIL_MANY_WORDS;
            }
        }
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if ((token = TRIM_PUNC.matcher(token).replaceAll("")).length() > 0) {
                indexBuilder.addEntryWithTokens(entryData, Collections.singleton(token), entryTypeName);
                if (token.contains("-")) {
                    String[] dashed;
                    String[] stringArray2 = dashed = token.split("-");
                    int n3 = dashed.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String dashedToken = stringArray2[n4];
                        if (dashedToken.length() > 0) {
                            indexBuilder.addEntryWithTokens(entryData, Collections.singleton(dashedToken), EntryTypeName.PART_OF_HYPHENATED);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        String[] stringArray3 = bracketedTokens = NON_CHAR.split(bracketed.toString());
        int n5 = bracketedTokens.length;
        n = 0;
        while (n < n5) {
            String token = stringArray3[n];
            assert (!token.contains("-"));
            if (token.length() > 0) {
                indexBuilder.addEntryWithTokens(entryData, Collections.singleton(token), EntryTypeName.BRACKETED);
            }
            ++n;
        }
        String[] stringArray4 = parenTokens = NON_CHAR.split(parenthesized.toString());
        int n6 = parenTokens.length;
        n5 = 0;
        while (n5 < n6) {
            String token = stringArray4[n5];
            assert (!token.contains("-"));
            if (token.length() > 0) {
                indexBuilder.addEntryWithTokens(entryData, Collections.singleton(token), EntryTypeName.PARENTHESIZED);
            }
            ++n5;
        }
    }

    private String parseField_DE(IndexBuilder indexBuilder, String field, IndexedEntry entryData, int subfieldIdx) {
        field = CURLY_BRACED.matcher(field).replaceAll(" ");
        return field;
    }

    private String parseField_EN(IndexBuilder indexBuilder, String field, IndexedEntry entryData, int subfieldIdx) {
        if (field.startsWith("to ")) {
            field = field.substring(3);
        }
        return field;
    }

    public static final Set<String> tokenize(String text, Pattern pattern) {
        String[] split = pattern.split(text);
        LinkedHashSet<String> result = new LinkedHashSet<String>(Arrays.asList(split));
        result.remove("");
        return result;
    }
}

