/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.RowMatchType;
import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.regex.Pattern;

public class TokenRow
extends RowBase {
    public final boolean hasMainEntry;

    TokenRow(RandomAccessFile raf, int thisRowIndex, Index index, boolean hasMainEntry) throws IOException {
        super(raf, thisRowIndex, index);
        this.hasMainEntry = hasMainEntry;
    }

    TokenRow(int referenceIndex, int thisRowIndex, Index index, boolean hasMainEntry) {
        super(referenceIndex, thisRowIndex, index);
        this.hasMainEntry = hasMainEntry;
    }

    public String toString() {
        return String.valueOf(this.getToken()) + "@" + this.referenceIndex;
    }

    @Override
    public TokenRow getTokenRow(boolean search) {
        return this;
    }

    @Override
    public void setTokenRow(TokenRow tokenRow) {
        throw new RuntimeException("Shouldn't be setting TokenRow's TokenRow!");
    }

    public String getToken() {
        return this.getIndexEntry().token;
    }

    public Index.IndexEntry getIndexEntry() {
        return this.index.sortedIndexEntries.get(this.referenceIndex);
    }

    @Override
    public void print(PrintStream out) {
        String surrounder = this.hasMainEntry ? "***" : "===";
        out.println(String.valueOf(surrounder) + this.getToken() + surrounder);
        for (HtmlEntry htmlEntry : this.index.sortedIndexEntries.get((int)this.referenceIndex).htmlEntries) {
            out.println("HtmlEntry: " + htmlEntry.title + " <<<" + htmlEntry.getHtml() + ">>>");
        }
    }

    @Override
    public String getRawText(boolean compact) {
        return this.getToken();
    }

    @Override
    public RowMatchType matches(List<String> searchTokens, Pattern orderedMatchPattern, Transliterator normalizer, boolean swapPairEntries) {
        return RowMatchType.NO_MATCH;
    }
}

