/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.AbstractEntry;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.RowMatchType;
import com.hughes.util.raf.RAFListSerializer;
import com.hughes.util.raf.RAFSerializable;
import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.regex.Pattern;

public class TextEntry
extends AbstractEntry
implements RAFSerializable<TextEntry> {
    final String text;

    public TextEntry(Dictionary dictionary, RandomAccessFile raf, int index) throws IOException {
        super(dictionary, raf, index);
        this.text = raf.readUTF();
        throw new RuntimeException();
    }

    @Override
    public void write(RandomAccessFile raf) throws IOException {
        super.write(raf);
        raf.writeUTF(this.text);
    }

    @Override
    public void addToDictionary(Dictionary dictionary) {
        assert (this.index == -1);
        dictionary.textEntries.add(this);
        this.index = dictionary.textEntries.size() - 1;
    }

    @Override
    public RowBase CreateRow(int rowIndex, Index dictionaryIndex) {
        throw new UnsupportedOperationException("TextEntry's don't really exist.");
    }

    public static class Row
    extends RowBase {
        Row(RandomAccessFile raf, int thisRowIndex, Index index) throws IOException {
            super(raf, thisRowIndex, index);
        }

        public TextEntry getEntry() {
            return this.index.dict.textEntries.get(this.referenceIndex);
        }

        @Override
        public void print(PrintStream out) {
            out.println("  " + this.getEntry().text);
        }

        @Override
        public String getRawText(boolean compact) {
            return this.getEntry().text;
        }

        @Override
        public RowMatchType matches(List<String> searchTokens, Pattern orderedMatchPattern, Transliterator normalizer, boolean swapPairEntries) {
            return null;
        }
    }

    static final class Serializer
    implements RAFListSerializer<TextEntry> {
        final Dictionary dictionary;

        Serializer(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public TextEntry read(RandomAccessFile raf, int index) throws IOException {
            return new TextEntry(this.dictionary, raf, index);
        }

        @Override
        public void write(RandomAccessFile raf, TextEntry t) throws IOException {
            t.write(raf);
        }
    }
}

