/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.engine.RowMatchType;
import com.hughes.android.dictionary.engine.TextEntry;
import com.hughes.android.dictionary.engine.TokenRow;
import com.hughes.util.IndexedObject;
import com.hughes.util.raf.RAFListSerializer;
import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public abstract class RowBase
extends IndexedObject {
    public final Index index;
    public final int referenceIndex;
    private TokenRow tokenRow = null;

    RowBase(RandomAccessFile raf, int thisRowIndex, Index index) throws IOException {
        super(thisRowIndex);
        this.index = index;
        this.referenceIndex = raf.readInt();
    }

    public RowBase(int referenceIndex, int thisRowIndex, Index index) {
        super(thisRowIndex);
        this.index = index;
        this.referenceIndex = referenceIndex;
    }

    public RowKey getRowKey() {
        return new RowKey(this.getClass(), this.referenceIndex);
    }

    public TokenRow getTokenRow(boolean search) {
        if (this.tokenRow == null && search) {
            int r = this.index() - 1;
            int rUp = this.index() + 1;
            while (r >= 0) {
                RowBase row = this.index.rows.get(r);
                TokenRow candidate = row.getTokenRow(false);
                if (candidate != null) {
                    ++r;
                    while (r <= this.index()) {
                        this.index.rows.get(r).setTokenRow(candidate);
                        ++r;
                    }
                    break;
                }
                if (rUp < this.index.rows.size()) {
                    RowBase rowUp = this.index.rows.get(rUp);
                    TokenRow candidateUp = rowUp.getTokenRow(false);
                    if (candidateUp != null) {
                        if (candidateUp.index() > this.index()) {
                            int tokenIndex = this.index.sortedIndexEntries.get((int)(candidateUp.referenceIndex - 1)).startRow;
                            candidateUp = (TokenRow)this.index.rows.get(tokenIndex);
                        }
                        --rUp;
                        while (rUp >= this.index()) {
                            this.index.rows.get(rUp).setTokenRow(candidateUp);
                            --rUp;
                        }
                        break;
                    }
                    ++rUp;
                }
                --r;
            }
            assert (this.tokenRow != null);
        }
        return this.tokenRow;
    }

    public void setTokenRow(TokenRow tokenRow) {
        assert (this.tokenRow == null);
        assert (tokenRow != null);
        this.tokenRow = tokenRow;
    }

    public abstract void print(PrintStream var1);

    public abstract String getRawText(boolean var1);

    public abstract RowMatchType matches(List<String> var1, Pattern var2, Transliterator var3, boolean var4);

    public int getSideLength(boolean swapPairEntries) {
        return this.getRawText(false).length();
    }

    public static final class LengthComparator
    implements Comparator<RowBase> {
        final boolean swapPairEntries;

        public LengthComparator(boolean swapPairEntries) {
            this.swapPairEntries = swapPairEntries;
        }

        @Override
        public int compare(RowBase row1, RowBase row2) {
            int l2;
            int l1 = row1.getSideLength(this.swapPairEntries);
            return l1 < (l2 = row2.getSideLength(this.swapPairEntries)) ? -1 : (l1 == l2 ? 0 : 1);
        }
    }

    static final class RowKey {
        final Class<? extends RowBase> rowClass;
        final int referenceIndex;

        private RowKey(Class<? extends RowBase> rowClass, int referenceIndex) {
            this.rowClass = rowClass;
            this.referenceIndex = referenceIndex;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RowKey)) {
                return false;
            }
            RowKey that = (RowKey)o;
            return this.referenceIndex == that.referenceIndex && this.rowClass.equals(that.rowClass);
        }

        public int hashCode() {
            return this.rowClass.hashCode() + this.referenceIndex;
        }
    }

    static class Serializer
    implements RAFListSerializer<RowBase> {
        final Index index;

        Serializer(Index index) {
            this.index = index;
        }

        @Override
        public RowBase read(RandomAccessFile raf, int listIndex) throws IOException {
            byte rowType = raf.readByte();
            if (rowType == 0) {
                return new PairEntry.Row(raf, listIndex, this.index);
            }
            if (rowType == 1 || rowType == 3) {
                return new TokenRow(raf, listIndex, this.index, rowType == 1);
            }
            if (rowType == 2) {
                return new TextEntry.Row(raf, listIndex, this.index);
            }
            if (rowType == 4) {
                return new HtmlEntry.Row(raf, listIndex, this.index);
            }
            throw new RuntimeException("Invalid rowType:" + rowType);
        }

        @Override
        public void write(RandomAccessFile raf, RowBase t) throws IOException {
            if (t instanceof PairEntry.Row) {
                raf.writeByte(0);
            } else if (t instanceof TokenRow) {
                TokenRow tokenRow = (TokenRow)t;
                raf.writeByte(tokenRow.hasMainEntry ? 1 : 3);
            } else if (t instanceof TextEntry.Row) {
                raf.writeByte(2);
            } else if (t instanceof HtmlEntry.Row) {
                raf.writeByte(4);
            }
            raf.writeInt(t.referenceIndex);
        }
    }
}

