/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.AbstractEntry;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.RowMatchType;
import com.hughes.util.raf.RAFListSerializer;
import com.hughes.util.raf.RAFSerializable;
import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class PairEntry
extends AbstractEntry
implements RAFSerializable<PairEntry>,
Comparable<PairEntry> {
    public final List<Pair> pairs;

    public PairEntry(EntrySource entrySource) {
        super(entrySource);
        this.pairs = new ArrayList<Pair>(1);
    }

    public PairEntry(EntrySource entrySource, String lang1, String lang2) {
        this(entrySource);
        this.pairs.add(new Pair(lang1, lang2));
    }

    public PairEntry(Dictionary dictionary, RandomAccessFile raf, int index) throws IOException {
        super(dictionary, raf, index);
        int size = raf.readInt();
        this.pairs = new ArrayList<Pair>(size);
        int i = 0;
        while (i < size) {
            this.pairs.add(new Pair(raf.readUTF(), raf.readUTF()));
            ++i;
        }
    }

    @Override
    public void write(RandomAccessFile raf) throws IOException {
        super.write(raf);
        raf.writeInt(this.pairs.size());
        int i = 0;
        while (i < this.pairs.size()) {
            assert (this.pairs.get((int)i).lang1.length() > 0);
            raf.writeUTF(this.pairs.get((int)i).lang1);
            raf.writeUTF(this.pairs.get((int)i).lang2);
            ++i;
        }
    }

    @Override
    public void addToDictionary(Dictionary dictionary) {
        assert (this.index == -1);
        dictionary.pairEntries.add(this);
        this.index = dictionary.pairEntries.size() - 1;
    }

    @Override
    public RowBase CreateRow(int rowIndex, Index dictionaryIndex) {
        return new Row(this.index, rowIndex, dictionaryIndex);
    }

    public String getRawText(boolean compact) {
        if (compact) {
            return this.pairs.get(0).toStringTab();
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.pairs.size()) {
            if (i > 0) {
                builder.append(" | ");
            }
            builder.append(this.pairs.get((int)i).lang1);
            ++i;
        }
        builder.append("\t");
        i = 0;
        while (i < this.pairs.size()) {
            if (i > 0) {
                builder.append(" | ");
            }
            builder.append(this.pairs.get((int)i).lang2);
            ++i;
        }
        return builder.toString();
    }

    @Override
    public int compareTo(PairEntry that) {
        return this.getRawText(false).compareTo(that.getRawText(false));
    }

    public String toString() {
        return this.getRawText(false);
    }

    public static final class Pair {
        public final String lang1;
        public final String lang2;

        public Pair(String lang1, String lang2) {
            this.lang1 = lang1;
            this.lang2 = lang2;
            if (lang1.trim().length() <= 0 || lang2.trim().length() <= 0) {
                System.err.println("poop");
            }
            assert (lang1.trim().length() > 0 || lang2.trim().length() > 0) : "Empty pair!!!";
            assert (lang1.trim().length() > 0 && lang2.trim().length() > 0) : "Empty pair!!!";
        }

        public Pair(String lang1, String lang2, boolean swap) {
            this(swap ? lang2 : lang1, swap ? lang1 : lang2);
        }

        public String toString() {
            return String.valueOf(this.lang1) + " :: " + this.lang2;
        }

        public String toStringTab() {
            return String.valueOf(this.lang1) + "\t" + this.lang2;
        }

        public String get(int i) {
            if (i == 0) {
                return this.lang1;
            }
            if (i == 1) {
                return this.lang2;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class Row
    extends RowBase {
        Row(RandomAccessFile raf, int thisRowIndex, Index index) throws IOException {
            super(raf, thisRowIndex, index);
        }

        Row(int referenceIndex, int thisRowIndex, Index index) {
            super(referenceIndex, thisRowIndex, index);
        }

        public String toString() {
            return this.getRawText(false);
        }

        public PairEntry getEntry() {
            return this.index.dict.pairEntries.get(this.referenceIndex);
        }

        @Override
        public void print(PrintStream out) {
            PairEntry pairEntry = this.getEntry();
            int i = 0;
            while (i < pairEntry.pairs.size()) {
                out.print(String.valueOf(i == 0 ? "  " : "    ") + pairEntry.pairs.get(i));
                out.println();
                ++i;
            }
        }

        @Override
        public String getRawText(boolean compact) {
            PairEntry pairEntry = this.getEntry();
            return pairEntry.getRawText(compact);
        }

        @Override
        public RowMatchType matches(List<String> searchTokens, Pattern orderedMatchPattern, Transliterator normalizer, boolean swapPairEntries) {
            int side = swapPairEntries ? 1 : 0;
            List<Pair> pairs = this.getEntry().pairs;
            String[] pairSides = new String[pairs.size()];
            int i = 0;
            while (i < pairs.size()) {
                pairSides[i] = normalizer.transform(pairs.get(i).get(side));
                ++i;
            }
            i = searchTokens.size() - 1;
            while (i >= 0) {
                String searchToken = searchTokens.get(i);
                boolean found = false;
                String[] stringArray = pairSides;
                int n = pairSides.length;
                int n2 = 0;
                while (n2 < n) {
                    String pairSide = stringArray[n2];
                    found |= pairSide.contains(searchToken);
                    ++n2;
                }
                if (!found) {
                    return RowMatchType.NO_MATCH;
                }
                --i;
            }
            String[] stringArray = pairSides;
            int n = pairSides.length;
            int n3 = 0;
            while (n3 < n) {
                String pairSide = stringArray[n3];
                if (orderedMatchPattern.matcher(pairSide).find()) {
                    return RowMatchType.ORDERED_MATCH;
                }
                ++n3;
            }
            return RowMatchType.BAG_OF_WORDS_MATCH;
        }

        @Override
        public int getSideLength(boolean swapPairEntries) {
            int result = 0;
            int side = swapPairEntries ? 1 : 0;
            for (Pair pair : this.getEntry().pairs) {
                result += pair.get(side).length();
            }
            return result;
        }
    }

    static final class Serializer
    implements RAFListSerializer<PairEntry> {
        final Dictionary dictionary;

        Serializer(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public PairEntry read(RandomAccessFile raf, int index) throws IOException {
            return new PairEntry(this.dictionary, raf, index);
        }

        @Override
        public void write(RandomAccessFile raf, PairEntry t) throws IOException {
            t.write(raf);
        }
    }
}

