/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.engine.NormalizeComparator;
import com.hughes.android.dictionary.parser.DictFileParser;
import com.hughes.android.dictionary.parser.wiktionary.WiktionaryLangs;
import com.ibm.icu.text.Transliterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;

public class LanguageTest
extends TestCase {
    public void testGermanSort() {
        Transliterator normalizer = Transliterator.createFromRules("", Language.de.getDefaultNormalizerRules(), 0);
        LanguageTest.assertEquals("a\u00fc\u00e4\u00e4ss", normalizer.transform("aueAeAE\u00df"));
        List<String> words = Arrays.asList("er-ben", "erben", "Erben", "Erbse", "Erbsen", "essen", "Essen", "Grosformat", "Grosformats", "Grossformat", "Gro\u00dfformat", "Grossformats", "Gro\u00dfformats", "Gro\u00dfpoo", "Gro\u00dfpoos", "H\u00f6rverm\u00f6gen", "H\u00f6rweite", "hos", "H\u00f6schen", "Hostel", "hulle", "Hulle", "huelle", "Huelle", "h\u00fclle", "H\u00fclle", "Huellen", "H\u00fcllen", "Hum");
        NormalizeComparator comparator = new NormalizeComparator(normalizer, Language.de.getCollator());
        LanguageTest.assertEquals(1, comparator.compare("h\u00fclle", "huelle"));
        LanguageTest.assertEquals(-1, comparator.compare("huelle", "h\u00fclle"));
        LanguageTest.assertEquals(-1, comparator.compare("h\u00fclle", "H\u00fclle"));
        LanguageTest.assertEquals("h\u00fclle", normalizer.transform("H\u00fclle"));
        LanguageTest.assertEquals("hulle", normalizer.transform("Hulle"));
        ArrayList<String> sorted = new ArrayList<String>(words);
        Collections.sort(sorted, comparator);
        System.out.println(((Object)sorted).toString());
        int i = 0;
        while (i < words.size()) {
            System.out.println(String.valueOf(words.get(i)) + "\t" + (String)sorted.get(i));
            LanguageTest.assertEquals(words.get(i), (String)sorted.get(i));
            ++i;
        }
    }

    public void testEnglishSort() {
        Transliterator normalizer = Transliterator.createFromRules("", Language.en.getDefaultNormalizerRules(), 0);
        List<String> words = Arrays.asList("pre-print", "preppie", "preppy", "preprocess");
        ArrayList<String> sorted = new ArrayList<String>(words);
        NormalizeComparator comparator = new NormalizeComparator(normalizer, Language.en.getCollator());
        Collections.sort(sorted, comparator);
        int i = 0;
        while (i < words.size()) {
            if (i > 0) {
                LanguageTest.assertTrue(comparator.compare(words.get(i - 1), words.get(i)) < 0);
            }
            System.out.println(String.valueOf(words.get(i)) + "\t" + (String)sorted.get(i));
            LanguageTest.assertEquals(words.get(i), (String)sorted.get(i));
            ++i;
        }
        LanguageTest.assertTrue(comparator.compare("pre-print", "preppy") < 0);
    }

    public void testLanguage() {
        LanguageTest.assertEquals(Language.de, Language.lookup("de"));
        LanguageTest.assertEquals(Language.en, Language.lookup("en"));
        LanguageTest.assertEquals("es", Language.lookup("es").getIsoCode());
    }

    public void testTextNorm() {
        Transliterator transliterator = Transliterator.createFromRules("", ":: Any-Latin; :: Upper; :: Lower; 'oe' > 'o'; :: NFD; :: [:Nonspacing Mark:] Remove; :: NFC ;", 0);
        LanguageTest.assertEquals("hoschen", transliterator.transliterate("H\u00f6schen"));
        LanguageTest.assertEquals("hoschen", transliterator.transliterate("Hoeschen"));
        LanguageTest.assertEquals("grosspoo", transliterator.transliterate("Gro\u00dfpoo"));
        LanguageTest.assertEquals("kyanpasu", transliterator.transliterate("\u30ad\u30e3\u30f3\u30d1\u30b9"));
        LanguageTest.assertEquals("alphabetikos katalogos", transliterator.transliterate("\u0391\u03bb\u03c6\u03b1\u03b2\u03b7\u03c4\u03b9\u03ba\u03cc\u03c2 \u039a\u03b1\u03c4\u03ac\u03bb\u03bf\u03b3\u03bf\u03c2"));
        LanguageTest.assertEquals("biologiceskom", transliterator.transliterate("\u0431\u0438\u043e\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u043c"));
    }

    public void testHalfTextNorm() {
        Transliterator transliterator = Transliterator.createFromRules("", ":: Any-Latin; ' ' > ; :: Lower; ", 0);
        LanguageTest.assertEquals("kyanpasu", transliterator.transliterate("\u30ad\u30e3\u30f3\u30d1\u30b9"));
        LanguageTest.assertEquals("alphab\u0113tik\u00f3skat\u00e1logos", transliterator.transliterate("\u0391\u03bb\u03c6\u03b1\u03b2\u03b7\u03c4\u03b9\u03ba\u03cc\u03c2 \u039a\u03b1\u03c4\u03ac\u03bb\u03bf\u03b3\u03bf\u03c2"));
        LanguageTest.assertEquals("biologi\u010deskom", transliterator.transliterate("\u0431\u0438\u043e\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u043c"));
        LanguageTest.assertEquals("xi\u00e8xi\u00e8", transliterator.transliterate("\u8b1d\u8b1d"));
        LanguageTest.assertEquals("xi\u00e8xi\u00e8", transliterator.transliterate("\u8c22\u8c22"));
        LanguageTest.assertEquals("di\u00e0nn\u01ceo", transliterator.transliterate("\u96fb\u8166"));
        LanguageTest.assertEquals("di\u00e0nn\u01ceo", transliterator.transliterate("\u7535\u8111"));
        LanguageTest.assertEquals("j\u00ecsu\u00e0nj\u012b", transliterator.transliterate("\u8a08\u7b97\u6a5f"));
        LanguageTest.assertEquals("j\u00ecsu\u00e0nj\u012b", transliterator.transliterate("\u8ba1\u7b97\u673a"));
    }

    public void testChinese() {
        Language cmn = Language.lookup("cmn");
        Transliterator transliterator = Transliterator.createFromRules("", cmn.getDefaultNormalizerRules(), 0);
        LanguageTest.assertEquals("xiexie", transliterator.transliterate("\u8b1d\u8b1d"));
        LanguageTest.assertEquals("xiexie", transliterator.transliterate("\u8c22\u8c22"));
        LanguageTest.assertEquals("diannao", transliterator.transliterate("\u96fb\u8166"));
        LanguageTest.assertEquals("diannao", transliterator.transliterate("\u7535\u8111"));
        LanguageTest.assertEquals("jisuanji", transliterator.transliterate("\u8a08\u7b97\u6a5f"));
        LanguageTest.assertEquals("jisuanji", transliterator.transliterate("\u8ba1\u7b97\u673a"));
        LanguageTest.assertEquals("chengjiu", transliterator.transliterate("\u6210\u5c31"));
    }

    public void testArabic() {
        Language ar = Language.lookup("ar");
        Transliterator transliterator = Transliterator.createFromRules("", ar.getDefaultNormalizerRules(), 0);
        LanguageTest.assertEquals("haswb", transliterator.transliterate("\u062d\u0627\u0633\u0648\u0628"));
        LanguageTest.assertEquals("kmbywtr", transliterator.transliterate("\u0643\u0645\u0628\u064a\u0648\u062a\u0631"));
        LanguageTest.assertEquals("{\u200e \u0643\u0645\u0628\u064a\u0648\u062a\u0631 \u200e}", Language.fixBidiText("{\u0643\u0645\u0628\u064a\u0648\u062a\u0631}"));
        LanguageTest.assertEquals("{a=\u200e \u0643\u0645\u0628\u064a\u0648\u062a\u0631 \u200e}", Language.fixBidiText("{a=\u0643\u0645\u0628\u064a\u0648\u062a\u0631}"));
        LanguageTest.assertEquals("(\u200e \u0643\u0645\u0628\u064a\u0648\u062a\u0631 \u200e)", Language.fixBidiText("(\u0643\u0645\u0628\u064a\u0648\u062a\u0631)"));
        LanguageTest.assertEquals("\u0623\u0646\u062b\u0649 \u0623\u0646\u0652\u062b\u064e\u0649 (\u2019\u00fan\u03b8\u0101) {f}, \u0625\u0646\u0627\u062b (\u2019in\u0101\u03b8) {p}, \u0627\u0646\u0627\u062b\u0649 (\u2019an\u0101\u03b8\u0101) {p}", Language.fixBidiText("\u0623\u0646\u062b\u0649 \u0623\u0646\u0652\u062b\u064e\u0649 (\u2019\u00fan\u03b8\u0101) {f}, \u0625\u0646\u0627\u062b (\u2019in\u0101\u03b8) {p}, \u0627\u0646\u0627\u062b\u0649 (\u2019an\u0101\u03b8\u0101) {p}"));
    }

    public void testThai() {
        Language th = Language.lookup("TH");
        Transliterator transliterator = Transliterator.createFromRules("", th.getDefaultNormalizerRules(), 0);
        LanguageTest.assertEquals("d", transliterator.transliterate("\u0e14"));
        LanguageTest.assertEquals("di", transliterator.transliterate("\u0e14 \u0e35"));
        LanguageTest.assertEquals("dii", transliterator.transliterate("\u0e14\u0e35\u0e35"));
        LanguageTest.assertEquals(Collections.singleton("\u0e14\u0e35\u0e35"), DictFileParser.tokenize("\u0e14\u0e35\u0e35", DictFileParser.NON_CHAR));
    }

    public void testEnWiktionaryNames() {
        LinkedHashSet<String> enLangs = new LinkedHashSet<String>(WiktionaryLangs.isoCodeToEnWikiName.keySet());
        ArrayList<String> names = new ArrayList<String>();
        for (String code : WiktionaryLangs.isoCodeToEnWikiName.keySet()) {
            names.add(WiktionaryLangs.isoCodeToEnWikiName.get(code));
            enLangs.add(code.toLowerCase());
        }
        Collections.sort(names);
        System.out.println(names);
        LanguageTest.assertEquals(enLangs, Language.isoCodeToResources.keySet());
    }
}

