/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class Language {
    public static final Map<String, LanguageResources> isoCodeToResources = new LinkedHashMap<String, LanguageResources>();
    private static final Map<String, Language> registry;
    final String isoCode;
    final Locale locale;
    private Collator collator;
    private static final String rtlChars = "\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc";
    private static final String puncChars = "\\[\\]\\(\\)\\{\\}\\=";
    private static final Pattern RTL_LEFT_BOUNDARY;
    private static final Pattern RTL_RIGHT_BOUNDARY;
    public static final Language en;
    public static final Language fr;
    public static final Language it;
    public static final Language de;

    static {
        isoCodeToResources.put("AF", new LanguageResources("Afrikaans", 2131099649));
        isoCodeToResources.put("SQ", new LanguageResources("Albanian", 2131099650));
        isoCodeToResources.put("AR", new LanguageResources("Arabic", 2131099651));
        isoCodeToResources.put("HY", new LanguageResources("Armenian", 2131099652));
        isoCodeToResources.put("BE", new LanguageResources("Belarusian", 2131099653));
        isoCodeToResources.put("BN", new LanguageResources("Bengali", 2131099654));
        isoCodeToResources.put("BS", new LanguageResources("Bosnian", 2131099655));
        isoCodeToResources.put("BG", new LanguageResources("Bulgarian", 2131099656));
        isoCodeToResources.put("MY", new LanguageResources("Burmese", 2131099657));
        isoCodeToResources.put("ZH", new LanguageResources("Chinese", 2131099658));
        isoCodeToResources.put("cmn", new LanguageResources("Mandarin", 2131099659));
        isoCodeToResources.put("yue", new LanguageResources("Cantonese", 2131099660));
        isoCodeToResources.put("CA", new LanguageResources("Catalan", 2131099661));
        isoCodeToResources.put("HR", new LanguageResources("Croatian", 2131099704));
        isoCodeToResources.put("CS", new LanguageResources("Czech", 2131099662));
        isoCodeToResources.put("DA", new LanguageResources("Danish", 2131099663));
        isoCodeToResources.put("NL", new LanguageResources("Dutch", 2131099664));
        isoCodeToResources.put("EN", new LanguageResources("English", 2131099665));
        isoCodeToResources.put("EO", new LanguageResources("Esperanto", 2131099666));
        isoCodeToResources.put("ET", new LanguageResources("Estonian", 2131099667));
        isoCodeToResources.put("FI", new LanguageResources("Finnish", 2131099668));
        isoCodeToResources.put("FR", new LanguageResources("French", 2131099669));
        isoCodeToResources.put("DE", new LanguageResources("German", 2131099671));
        isoCodeToResources.put("EL", new LanguageResources("Greek", 2131099672));
        isoCodeToResources.put("grc", new LanguageResources("Ancient Greek", 2131099673));
        isoCodeToResources.put("haw", new LanguageResources("Hawaiian", 2131099674));
        isoCodeToResources.put("HE", new LanguageResources("Hebrew", 2131099675));
        isoCodeToResources.put("HI", new LanguageResources("Hindi", 2131099676));
        isoCodeToResources.put("HU", new LanguageResources("Hungarian", 2131099677));
        isoCodeToResources.put("IS", new LanguageResources("Icelandic", 2131099678));
        isoCodeToResources.put("ID", new LanguageResources("Indonesian", 2131099679));
        isoCodeToResources.put("GA", new LanguageResources("Irish", 2131099680));
        isoCodeToResources.put("GD", new LanguageResources("Scottish Gaelic", 2131099670));
        isoCodeToResources.put("IT", new LanguageResources("Italian", 2131099681));
        isoCodeToResources.put("LA", new LanguageResources("Latin", 2131099682));
        isoCodeToResources.put("LV", new LanguageResources("Latvian", 2131099684));
        isoCodeToResources.put("LT", new LanguageResources("Lithuanian", 2131099685));
        isoCodeToResources.put("JA", new LanguageResources("Japanese", 2131099686));
        isoCodeToResources.put("KO", new LanguageResources("Korean", 2131099687));
        isoCodeToResources.put("KU", new LanguageResources("Kurdish", 2131099688));
        isoCodeToResources.put("MS", new LanguageResources("Malay", 2131099689));
        isoCodeToResources.put("MI", new LanguageResources("Maori", 2131099691));
        isoCodeToResources.put("MN", new LanguageResources("Mongolian", 2131099692));
        isoCodeToResources.put("NE", new LanguageResources("Nepali", 2131099693));
        isoCodeToResources.put("NO", new LanguageResources("Norwegian", 2131099694));
        isoCodeToResources.put("FA", new LanguageResources("Persian", 2131099695));
        isoCodeToResources.put("PL", new LanguageResources("Polish", 2131099696));
        isoCodeToResources.put("PT", new LanguageResources("Portuguese", 2131099697));
        isoCodeToResources.put("PA", new LanguageResources("Punjabi", 2131099698));
        isoCodeToResources.put("RO", new LanguageResources("Romanian", 2131099699));
        isoCodeToResources.put("RU", new LanguageResources("Russian", 2131099700));
        isoCodeToResources.put("SA", new LanguageResources("Sanskrit", 2131099701));
        isoCodeToResources.put("SR", new LanguageResources("Serbian", 2131099703));
        isoCodeToResources.put("SK", new LanguageResources("Slovak", 2131099705));
        isoCodeToResources.put("SL", new LanguageResources("Slovenian", 2131099706));
        isoCodeToResources.put("SO", new LanguageResources("Somali", 2131099707));
        isoCodeToResources.put("ES", new LanguageResources("Spanish", 2131099708));
        isoCodeToResources.put("SW", new LanguageResources("Swahili", 2131099709));
        isoCodeToResources.put("SV", new LanguageResources("Swedish", 2131099710));
        isoCodeToResources.put("TL", new LanguageResources("Tagalog", 2131099711));
        isoCodeToResources.put("TG", new LanguageResources("Tajik", 2131099712));
        isoCodeToResources.put("TH", new LanguageResources("Thai", 2131099714));
        isoCodeToResources.put("BO", new LanguageResources("Tibetan", 2131099715));
        isoCodeToResources.put("TR", new LanguageResources("Turkish", 2131099716));
        isoCodeToResources.put("UK", new LanguageResources("Ukrainian", 2131099717));
        isoCodeToResources.put("UR", new LanguageResources("Urdu", 2131099718));
        isoCodeToResources.put("VI", new LanguageResources("Vietnamese", 2131099719));
        isoCodeToResources.put("CI", new LanguageResources("Welsh", 2131099720));
        isoCodeToResources.put("YI", new LanguageResources("Yiddish", 2131099721));
        isoCodeToResources.put("ZU", new LanguageResources("Zulu", 2131099722));
        isoCodeToResources.put("AZ", new LanguageResources("Azeri", 2131099723));
        isoCodeToResources.put("EU", new LanguageResources("Basque", 2131099724));
        isoCodeToResources.put("BR", new LanguageResources("Breton", 2131099725));
        isoCodeToResources.put("MR", new LanguageResources("Burmese", 2131099726));
        isoCodeToResources.put("FO", new LanguageResources("Faroese", 2131099727));
        isoCodeToResources.put("GL", new LanguageResources("Galician", 2131099728));
        isoCodeToResources.put("KA", new LanguageResources("Georgian", 2131099729));
        isoCodeToResources.put("HT", new LanguageResources("Haitian Creole", 2131099730));
        isoCodeToResources.put("LB", new LanguageResources("Luxembourgish", 2131099731));
        isoCodeToResources.put("MK", new LanguageResources("Macedonian", 2131099732));
        isoCodeToResources.put("LO", new LanguageResources("Lao", 2131099683));
        isoCodeToResources.put("ML", new LanguageResources("Malayalam", 2131099690));
        isoCodeToResources.put("SL", new LanguageResources("Slovenian", 2131099706));
        isoCodeToResources.put("TA", new LanguageResources("Tamil", 2131099713));
        isoCodeToResources.put("SH", new LanguageResources("Serbo-Croations", 2131099702));
        for (String isoCode : new ArrayList<String>(isoCodeToResources.keySet())) {
            isoCodeToResources.put(isoCode.toLowerCase(), isoCodeToResources.get(isoCode));
        }
        registry = new LinkedHashMap<String, Language>();
        RTL_LEFT_BOUNDARY = Pattern.compile("([\\[\\]\\(\\)\\{\\}\\=])([\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc])");
        RTL_RIGHT_BOUNDARY = Pattern.compile("([\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc])([\\[\\]\\(\\)\\{\\}\\=])");
        en = new Language(Locale.ENGLISH, "EN");
        fr = new Language(Locale.FRENCH, "FR");
        it = new Language(Locale.ITALIAN, "IT");
        de = new Language(Locale.GERMAN, "DE"){

            @Override
            public String getDefaultNormalizerRules() {
                return ":: Lower; 'ae' > '\u00e4'; 'oe' > '\u00f6'; 'ue' > '\u00fc'; '\u00df' > 'ss'; ";
            }
        };
    }

    private Language(Locale locale, String isoCode) {
        this.locale = locale;
        this.isoCode = isoCode;
        registry.put(isoCode.toLowerCase(), this);
    }

    public String toString() {
        return this.locale.toString();
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public synchronized Collator getCollator() {
        this.collator = Collator.getInstance(this.locale);
        this.collator.setStrength(15);
        return this.collator;
    }

    public String getDefaultNormalizerRules() {
        return ":: Any-Latin; ' ' > ; :: Lower; :: NFD; :: [:Nonspacing Mark:] Remove; :: NFC ;";
    }

    public static String fixBidiText(String text) {
        return text;
    }

    public static synchronized Language lookup(String isoCode) {
        Language lang = registry.get(isoCode.toLowerCase());
        if (lang == null) {
            lang = new Language(new Locale(isoCode), isoCode);
        }
        return lang;
    }

    /* synthetic */ Language(Locale locale, String string2, Language language) {
        this(locale, string2);
    }

    public static final class LanguageResources {
        public final String englishName;
        public final int nameId;
        public final int flagId;

        private LanguageResources(String englishName, int nameId, int flagId) {
            this.englishName = englishName;
            this.nameId = nameId;
            this.flagId = flagId;
        }

        private LanguageResources(String englishName, int nameId) {
            this(englishName, nameId, 0);
        }
    }
}

