/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.DictionaryBuilder;
import com.hughes.android.dictionary.engine.EntryTypeName;
import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.IndexedEntry;
import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.TokenRow;
import com.hughes.android.dictionary.parser.DictFileParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class IndexBuilder {
    final DictionaryBuilder dictionaryBuilder;
    public final Index index;
    final Set<String> stoplist;
    final SortedMap<String, TokenData> tokenToData;

    IndexBuilder(DictionaryBuilder dictionaryBuilder, String shortName, String longName, Language language, String normalizerRules, Set<String> stoplist, boolean swapPairEntries) {
        this.dictionaryBuilder = dictionaryBuilder;
        this.index = new Index(dictionaryBuilder.dictionary, shortName, longName, language, normalizerRules, swapPairEntries, stoplist);
        this.tokenToData = new TreeMap<String, TokenData>(this.index.getSortComparator());
        this.stoplist = stoplist;
    }

    public void build() {
        HashSet<IndexedEntry> tokenIndexedEntries = new HashSet<IndexedEntry>();
        List<RowBase> rows = this.index.rows;
        this.index.mainTokenCount = 0;
        for (TokenData tokenData : this.tokenToData.values()) {
            tokenIndexedEntries.clear();
            int indexIndex = this.index.sortedIndexEntries.size();
            int startRow = rows.size();
            TokenRow tokenRow = null;
            if (!tokenData.htmlEntries.isEmpty()) {
                tokenRow = new TokenRow(indexIndex, rows.size(), this.index, tokenData.hasMainEntry);
                rows.add(tokenRow);
            }
            int numRows = 0;
            for (Map.Entry<EntryTypeName, List<IndexedEntry>> typeToIndexedEntries : tokenData.typeToEntries.entrySet()) {
                for (IndexedEntry indexedEntry : typeToIndexedEntries.getValue()) {
                    if (!indexedEntry.isValid) continue;
                    if (tokenRow == null) {
                        tokenRow = new TokenRow(indexIndex, rows.size(), this.index, tokenData.hasMainEntry);
                        rows.add(tokenRow);
                    }
                    if (indexedEntry.entry.index() == -1) {
                        indexedEntry.entry.addToDictionary(this.dictionaryBuilder.dictionary);
                        assert (indexedEntry.entry.index() >= 0);
                    }
                    if (!tokenIndexedEntries.add(indexedEntry) || tokenData.htmlEntries.contains(indexedEntry.entry)) continue;
                    rows.add(indexedEntry.entry.CreateRow(rows.size(), this.index));
                    ++indexedEntry.entry.entrySource.numEntries;
                    ++numRows;
                }
            }
            if (tokenRow == null) continue;
            if (tokenRow.hasMainEntry) {
                ++this.index.mainTokenCount;
            }
            Index.IndexEntry indexEntry = new Index.IndexEntry(this.index, tokenData.token, this.index.normalizer().transliterate(tokenData.token), startRow, numRows);
            indexEntry.htmlEntries.addAll(tokenData.htmlEntries);
            this.index.sortedIndexEntries.add(indexEntry);
        }
        ArrayList<Index.IndexEntry> entriesSortedByNumRows = new ArrayList<Index.IndexEntry>(this.index.sortedIndexEntries);
        Collections.sort(entriesSortedByNumRows, new Comparator<Index.IndexEntry>(){

            @Override
            public int compare(Index.IndexEntry object1, Index.IndexEntry object2) {
                return object2.numRows - object1.numRows;
            }
        });
        System.out.println("Most common tokens:");
        int i = 0;
        while (i < 50 && i < entriesSortedByNumRows.size()) {
            System.out.println("  " + entriesSortedByNumRows.get(i));
            ++i;
        }
    }

    public TokenData getOrCreateTokenData(String token) {
        TokenData tokenData = (TokenData)this.tokenToData.get(token);
        if (tokenData == null) {
            tokenData = new TokenData(token);
            this.tokenToData.put(token, tokenData);
        }
        return tokenData;
    }

    private List<IndexedEntry> getOrCreateEntries(String token, EntryTypeName entryTypeName) {
        TokenData tokenData = this.getOrCreateTokenData(token);
        List<IndexedEntry> entries = tokenData.typeToEntries.get((Object)entryTypeName);
        if (entryTypeName.mainWord) {
            tokenData.hasMainEntry = true;
        }
        if (entries == null) {
            entries = new ArrayList<IndexedEntry>();
            tokenData.typeToEntries.put(entryTypeName, entries);
        }
        return entries;
    }

    public void addEntryWithTokens(IndexedEntry indexedEntry, Set<String> tokens, EntryTypeName entryTypeName) {
        if (indexedEntry == null) {
            System.out.println("asdfasdf");
        }
        assert (indexedEntry != null);
        for (String token : tokens) {
            if (!entryTypeName.overridesStopList && this.stoplist.contains(token)) continue;
            this.getOrCreateEntries(token, entryTypeName).add(indexedEntry);
        }
    }

    public void addEntryWithString(IndexedEntry indexedEntry, String untokenizedString, EntryTypeName entryTypeName) {
        Set<String> tokens;
        this.addEntryWithTokens(indexedEntry, tokens, (tokens = DictFileParser.tokenize(untokenizedString, DictFileParser.NON_CHAR)).size() == 1 ? entryTypeName.singleWordInstance : entryTypeName);
    }

    public void addEntryWithStringNoSingle(IndexedEntry indexedEntry, String untokenizedString, EntryTypeName entryTypeName) {
        Set<String> tokens = DictFileParser.tokenize(untokenizedString, DictFileParser.NON_CHAR);
        this.addEntryWithTokens(indexedEntry, tokens, entryTypeName);
    }

    public static class TokenData {
        final String token;
        final Map<EntryTypeName, List<IndexedEntry>> typeToEntries = new EnumMap<EntryTypeName, List<IndexedEntry>>(EntryTypeName.class);
        public boolean hasMainEntry = false;
        public List<HtmlEntry> htmlEntries = new ArrayList<HtmlEntry>();

        TokenData(String token) {
            assert (token.equals(token.trim()));
            assert (token.length() > 0);
            this.token = token;
        }
    }
}

