/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.DictionaryInfo;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.engine.NormalizeComparator;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.RowMatchType;
import com.hughes.android.dictionary.engine.TransliteratorManager;
import com.hughes.util.CachingList;
import com.hughes.util.TransformingList;
import com.hughes.util.raf.RAFList;
import com.hughes.util.raf.RAFSerializable;
import com.hughes.util.raf.RAFSerializer;
import com.hughes.util.raf.SerializableSerializer;
import com.hughes.util.raf.UniformRAFList;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public final class Index
implements RAFSerializable<Index> {
    static final int CACHE_SIZE = 5000;
    public final Dictionary dict;
    public final String shortName;
    public final String longName;
    public final Language sortLanguage;
    final String normalizerRules;
    private Transliterator normalizer;
    public final List<IndexEntry> sortedIndexEntries;
    public final Set<String> stoplist;
    public final List<RowBase> rows;
    public final boolean swapPairEntries;
    int mainTokenCount = -1;
    private final RAFSerializer<IndexEntry> indexEntrySerializer = new RAFSerializer<IndexEntry>(){

        @Override
        public IndexEntry read(RandomAccessFile raf) throws IOException {
            return new IndexEntry(Index.this, raf);
        }

        @Override
        public void write(RandomAccessFile raf, IndexEntry t) throws IOException {
            t.write(raf);
        }
    };
    static final TransformingList.Transformer<IndexEntry, String> INDEX_ENTRY_TO_TOKEN = new TransformingList.Transformer<IndexEntry, String>(){

        @Override
        public String transform(IndexEntry t1) {
            return t1.token;
        }
    };
    private static final int MAX_SEARCH_ROWS = 1000;
    private final Map<String, Integer> prefixToNumRows = new LinkedHashMap<String, Integer>();

    public Index(Dictionary dict, String shortName, String longName, Language sortLanguage, String normalizerRules, boolean swapPairEntries, Set<String> stoplist) {
        this.dict = dict;
        this.shortName = shortName;
        this.longName = longName;
        this.sortLanguage = sortLanguage;
        this.normalizerRules = normalizerRules;
        this.swapPairEntries = swapPairEntries;
        this.sortedIndexEntries = new ArrayList<IndexEntry>();
        this.stoplist = stoplist;
        this.rows = new ArrayList<RowBase>();
        this.normalizer = null;
    }

    public synchronized Transliterator normalizer() {
        if (this.normalizer == null) {
            this.normalizer = Transliterator.createFromRules("", this.normalizerRules, 0);
        }
        return this.normalizer;
    }

    public NormalizeComparator getSortComparator() {
        return new NormalizeComparator(this.normalizer(), this.sortLanguage.getCollator());
    }

    public Index(Dictionary dict, RandomAccessFile raf) throws IOException {
        this.dict = dict;
        this.shortName = raf.readUTF();
        this.longName = raf.readUTF();
        String languageCode = raf.readUTF();
        this.sortLanguage = Language.lookup(languageCode);
        this.normalizerRules = raf.readUTF();
        this.swapPairEntries = raf.readBoolean();
        if (this.sortLanguage == null) {
            throw new IOException("Unsupported language: " + languageCode);
        }
        if (dict.dictFileVersion >= 2) {
            this.mainTokenCount = raf.readInt();
        }
        this.sortedIndexEntries = CachingList.create(RAFList.create(raf, this.indexEntrySerializer, raf.getFilePointer()), 5000);
        this.stoplist = dict.dictFileVersion >= 4 ? (Set<Object>)new SerializableSerializer().read(raf) : Collections.emptySet();
        this.rows = CachingList.create(UniformRAFList.create(raf, new RowBase.Serializer(this), raf.getFilePointer()), 5000);
    }

    @Override
    public void write(RandomAccessFile raf) throws IOException {
        raf.writeUTF(this.shortName);
        raf.writeUTF(this.longName);
        raf.writeUTF(this.sortLanguage.getIsoCode());
        raf.writeUTF(this.normalizerRules);
        raf.writeBoolean(this.swapPairEntries);
        if (this.dict.dictFileVersion >= 2) {
            raf.writeInt(this.mainTokenCount);
        }
        RAFList.write(raf, this.sortedIndexEntries, this.indexEntrySerializer);
        new SerializableSerializer<Set<String>>().write(raf, this.stoplist);
        UniformRAFList.write(raf, this.rows, new RowBase.Serializer(this), 5);
    }

    public void print(PrintStream out) {
        for (RowBase row : this.rows) {
            row.print(out);
        }
    }

    public IndexEntry findExact(String exactToken) {
        int result = Collections.binarySearch(TransformingList.create(this.sortedIndexEntries, INDEX_ENTRY_TO_TOKEN), exactToken, this.getSortComparator());
        if (result >= 0) {
            return this.sortedIndexEntries.get(result);
        }
        return null;
    }

    public IndexEntry findInsertionPoint(String token, AtomicBoolean interrupted) {
        int index = this.findInsertionPointIndex(token, interrupted);
        return index != -1 ? this.sortedIndexEntries.get(index) : null;
    }

    public int findInsertionPointIndex(String token, AtomicBoolean interrupted) {
        token = this.normalizeToken(token);
        int start = 0;
        int end = this.sortedIndexEntries.size();
        Collator sortCollator = this.sortLanguage.getCollator();
        while (start < end) {
            int mid = (start + end) / 2;
            if (interrupted.get()) {
                return -1;
            }
            IndexEntry midEntry = this.sortedIndexEntries.get(mid);
            int comp = sortCollator.compare(token, midEntry.normalizedToken());
            if (comp == 0) {
                int result = this.windBackCase(token, mid, interrupted);
                return result;
            }
            if (comp < 0) {
                end = mid;
                continue;
            }
            start = mid + 1;
        }
        int result = Math.min(start, this.sortedIndexEntries.size() - 1);
        result = this.windBackCase(this.sortedIndexEntries.get(result).normalizedToken(), result, interrupted);
        return result;
    }

    private final int windBackCase(String token, int result, AtomicBoolean interrupted) {
        while (result > 0 && this.sortedIndexEntries.get(result - 1).normalizedToken().equals(token)) {
            --result;
            if (!interrupted.get()) continue;
            return result;
        }
        return result;
    }

    public DictionaryInfo.IndexInfo getIndexInfo() {
        return new DictionaryInfo.IndexInfo(this.shortName, this.sortedIndexEntries.size(), this.mainTokenCount);
    }

    private final synchronized int getUpperBoundOnRowsStartingWith(String normalizedPrefix, int maxRows, AtomicBoolean interrupted) {
        Integer numRows = this.prefixToNumRows.get(normalizedPrefix);
        if (numRows != null) {
            return numRows;
        }
        int insertionPointIndex = this.findInsertionPointIndex(normalizedPrefix, interrupted);
        int rowCount = 0;
        int index = insertionPointIndex;
        while (index < this.sortedIndexEntries.size()) {
            if (interrupted.get()) {
                return -1;
            }
            IndexEntry indexEntry = this.sortedIndexEntries.get(index);
            if (!indexEntry.normalizedToken.startsWith(normalizedPrefix)) break;
            if ((rowCount += indexEntry.numRows + indexEntry.htmlEntries.size()) > maxRows) {
                System.out.println("Giving up, too many words with prefix: " + normalizedPrefix);
                break;
            }
            ++index;
        }
        this.prefixToNumRows.put(normalizedPrefix, numRows);
        return rowCount;
    }

    public final List<RowBase> multiWordSearch(String searchText, List<String> searchTokens, AtomicBoolean interrupted) {
        int numRows;
        long startMills = System.currentTimeMillis();
        ArrayList<RowBase> result = new ArrayList<RowBase>();
        LinkedHashSet<String> normalizedNonStoplist = new LinkedHashSet<String>();
        String bestPrefix = null;
        int leastRows = Integer.MAX_VALUE;
        StringBuilder searchTokensRegex = new StringBuilder();
        int i = 0;
        while (i < searchTokens.size()) {
            if (interrupted.get()) {
                return null;
            }
            String searchToken = searchTokens.get(i);
            String normalized = this.normalizeToken(searchTokens.get(i));
            searchTokens.set(i, normalized);
            if (!this.stoplist.contains(searchToken) && normalizedNonStoplist.add(normalized) && (numRows = this.getUpperBoundOnRowsStartingWith(normalized, 1000, interrupted)) != -1 && numRows < leastRows) {
                if (numRows == 0) {
                    return Collections.emptyList();
                }
                leastRows = numRows;
                bestPrefix = normalized;
            }
            if (searchTokensRegex.length() > 0) {
                searchTokensRegex.append("[\\s]*");
            }
            searchTokensRegex.append(Pattern.quote(normalized));
            ++i;
        }
        Pattern pattern = Pattern.compile(searchTokensRegex.toString());
        if (bestPrefix == null) {
            bestPrefix = searchTokens.get(0);
            System.out.println("Everything was in the stoplist!");
        }
        System.out.println("Searching using prefix: " + bestPrefix + ", leastRows=" + leastRows + ", searchTokens=" + searchTokens);
        EnumMap matches = new EnumMap(RowMatchType.class);
        RowMatchType[] rowMatchTypeArray = RowMatchType.values();
        int n = rowMatchTypeArray.length;
        numRows = 0;
        while (numRows < n) {
            RowMatchType rowMatchType = rowMatchTypeArray[numRows];
            if (rowMatchType != RowMatchType.NO_MATCH) {
                matches.put(rowMatchType, new ArrayList());
            }
            ++numRows;
        }
        int matchCount = 0;
        int exactMatchIndex = this.findInsertionPointIndex(searchText, interrupted);
        if (exactMatchIndex != -1) {
            IndexEntry exactMatch = this.sortedIndexEntries.get(exactMatchIndex);
            if (pattern.matcher(exactMatch.token).find()) {
                ((List)matches.get((Object)RowMatchType.TITLE_MATCH)).add(this.rows.get(exactMatch.startRow));
            }
        }
        String searchToken = bestPrefix;
        int insertionPointIndex = this.findInsertionPointIndex(searchToken, interrupted);
        HashSet<RowBase.RowKey> rowsAlreadySeen = new HashSet<RowBase.RowKey>();
        int index = insertionPointIndex;
        while (index < this.sortedIndexEntries.size() && matchCount < 1000) {
            if (interrupted.get()) {
                return null;
            }
            IndexEntry indexEntry = this.sortedIndexEntries.get(index);
            if (!indexEntry.normalizedToken.startsWith(searchToken)) break;
            int rowIndex = indexEntry.startRow + 1;
            while (rowIndex < indexEntry.startRow + 1 + indexEntry.numRows && rowIndex < this.rows.size()) {
                if (interrupted.get()) {
                    return null;
                }
                RowBase row = this.rows.get(rowIndex);
                RowBase.RowKey rowKey = row.getRowKey();
                if (!rowsAlreadySeen.contains(rowKey)) {
                    rowsAlreadySeen.add(rowKey);
                    RowMatchType matchType = row.matches(searchTokens, pattern, this.normalizer(), this.swapPairEntries);
                    if (matchType != RowMatchType.NO_MATCH) {
                        ((List)matches.get((Object)matchType)).add(row);
                        ++matchCount;
                    }
                }
                ++rowIndex;
            }
            ++index;
        }
        RowBase.LengthComparator lengthComparator = new RowBase.LengthComparator(this.swapPairEntries);
        for (Collection rows : matches.values()) {
            ArrayList ordered = new ArrayList(rows);
            Collections.sort(ordered, lengthComparator);
            result.addAll(ordered);
        }
        System.out.println("searchDuration: " + (System.currentTimeMillis() - startMills));
        return result;
    }

    private String normalizeToken(String searchToken) {
        if (TransliteratorManager.init(null)) {
            Transliterator normalizer = this.normalizer();
            return normalizer.transliterate(searchToken);
        }
        return searchToken.toLowerCase();
    }

    public static final class IndexEntry
    implements RAFSerializable<IndexEntry> {
        private final Index index;
        public final String token;
        private final String normalizedToken;
        public final int startRow;
        public final int numRows;
        public final List<HtmlEntry> htmlEntries;

        public IndexEntry(Index index, String token, String normalizedToken, int startRow, int numRows) {
            this.index = index;
            assert (token.equals(token.trim()));
            assert (token.length() > 0);
            this.token = token;
            this.normalizedToken = normalizedToken;
            this.startRow = startRow;
            this.numRows = numRows;
            this.htmlEntries = new ArrayList<HtmlEntry>();
        }

        public IndexEntry(Index index, RandomAccessFile raf) throws IOException {
            this.index = index;
            this.token = raf.readUTF();
            this.startRow = raf.readInt();
            this.numRows = raf.readInt();
            boolean hasNormalizedForm = raf.readBoolean();
            this.normalizedToken = hasNormalizedForm ? raf.readUTF() : this.token;
            this.htmlEntries = index.dict.dictFileVersion >= 6 ? CachingList.create(RAFList.create(raf, index.dict.htmlEntryIndexSerializer, raf.getFilePointer()), 1) : Collections.emptyList();
        }

        @Override
        public void write(RandomAccessFile raf) throws IOException {
            raf.writeUTF(this.token);
            raf.writeInt(this.startRow);
            raf.writeInt(this.numRows);
            boolean hasNormalizedForm = !this.token.equals(this.normalizedToken);
            raf.writeBoolean(hasNormalizedForm);
            if (hasNormalizedForm) {
                raf.writeUTF(this.normalizedToken);
            }
            RAFList.write(raf, this.htmlEntries, this.index.dict.htmlEntryIndexSerializer);
        }

        public String toString() {
            return String.format("%s@%d(%d)", this.token, this.startRow, this.numRows);
        }

        public String normalizedToken() {
            return this.normalizedToken;
        }
    }
}

