/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import android.content.Intent;
import com.hughes.android.dictionary.engine.AbstractEntry;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.RowMatchType;
import com.hughes.util.StringUtil;
import com.hughes.util.raf.RAFListSerializer;
import com.hughes.util.raf.RAFSerializable;
import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.regex.Pattern;

public class HtmlEntry
extends AbstractEntry
implements RAFSerializable<HtmlEntry>,
Comparable<HtmlEntry> {
    public final String title;
    public final LazyHtmlLoader lazyHtmlLoader;
    public String html;

    public HtmlEntry(EntrySource entrySource, String title) {
        super(entrySource);
        this.title = title;
        this.lazyHtmlLoader = null;
    }

    public HtmlEntry(Dictionary dictionary, RandomAccessFile raf, int index) throws IOException {
        super(dictionary, raf, index);
        this.title = raf.readUTF();
        this.lazyHtmlLoader = new LazyHtmlLoader(raf);
        this.html = null;
    }

    @Override
    public void write(RandomAccessFile raf) throws IOException {
        super.write(raf);
        raf.writeUTF(this.title);
        byte[] bytes = this.getHtml().getBytes("UTF-8");
        byte[] zipBytes = StringUtil.zipBytes(bytes);
        raf.writeInt(bytes.length);
        raf.writeInt(zipBytes.length);
        raf.write(zipBytes);
    }

    String getHtml() {
        return this.html != null ? this.html : this.lazyHtmlLoader.getHtml();
    }

    @Override
    public void addToDictionary(Dictionary dictionary) {
        assert (this.index == -1);
        dictionary.htmlEntries.add(this);
        this.index = dictionary.htmlEntries.size() - 1;
    }

    @Override
    public RowBase CreateRow(int rowIndex, Index dictionaryIndex) {
        return new Row(this.index, rowIndex, dictionaryIndex);
    }

    public String getRawText(boolean compact) {
        return String.valueOf(this.title) + ":\n" + this.getHtml();
    }

    @Override
    public int compareTo(HtmlEntry another) {
        if (this.title.compareTo(another.title) != 0) {
            return this.title.compareTo(another.title);
        }
        return this.getHtml().compareTo(another.getHtml());
    }

    public String toString() {
        return this.getRawText(false);
    }

    public static String htmlBody(List<HtmlEntry> htmlEntries, String indexShortName) {
        StringBuilder result = new StringBuilder();
        for (HtmlEntry htmlEntry : htmlEntries) {
            String titleEscaped = StringUtil.escapeUnicodeToPureHtml(htmlEntry.title);
            result.append(String.format("<h1><a href=\"%s\">%s</a></h1>\n<p>%s\n", HtmlEntry.formatQuickdicUrl(indexShortName, titleEscaped), titleEscaped, htmlEntry.getHtml()));
        }
        return result.toString();
    }

    public static String formatQuickdicUrl(String indexShortName, String text) {
        assert (!indexShortName.contains(":"));
        assert (text.length() > 0);
        return String.format("q://d?%s&%s", indexShortName, StringUtil.encodeForUrl(text));
    }

    public static boolean isQuickdicUrl(String url) {
        return url.startsWith("q://d?");
    }

    public static void quickdicUrlToIntent(String url, Intent intent) {
        int firstColon = url.indexOf("?");
        if (firstColon == -1) {
            return;
        }
        int secondColon = url.indexOf("&", firstColon + 1);
        if (secondColon == -1) {
            return;
        }
        intent.putExtra("searchToken", StringUtil.decodeFromUrl(url.substring(secondColon + 1)));
    }

    public static final class LazyHtmlLoader {
        final RandomAccessFile raf;
        final long offset;
        final int numBytes;
        final int numZipBytes;
        volatile SoftReference<String> htmlRef = new SoftReference<Object>(null);

        private LazyHtmlLoader(RandomAccessFile raf) throws IOException {
            this.raf = raf;
            this.numBytes = raf.readInt();
            this.numZipBytes = raf.readInt();
            this.offset = raf.getFilePointer();
            raf.skipBytes(this.numZipBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getHtml() {
            String html = this.htmlRef.get();
            if (html != null) {
                return html;
            }
            System.out.println("Loading Html: numBytes=" + this.numBytes + ", numZipBytes=" + this.numZipBytes);
            byte[] bytes = new byte[this.numBytes];
            byte[] zipBytes = new byte[this.numZipBytes];
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                try {
                    this.raf.seek(this.offset);
                    this.raf.read(zipBytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                StringUtil.unzipFully(zipBytes, bytes);
                html = new String(bytes, "UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.htmlRef = new SoftReference<String>(html);
            return html;
        }
    }

    public static class Row
    extends RowBase {
        boolean isExpanded = false;

        Row(RandomAccessFile raf, int thisRowIndex, Index index) throws IOException {
            super(raf, thisRowIndex, index);
        }

        Row(int referenceIndex, int thisRowIndex, Index index) {
            super(referenceIndex, thisRowIndex, index);
        }

        public String toString() {
            return this.getRawText(false);
        }

        public HtmlEntry getEntry() {
            return this.index.dict.htmlEntries.get(this.referenceIndex);
        }

        @Override
        public void print(PrintStream out) {
            HtmlEntry entry = this.getEntry();
            out.println("See also HtmlEntry:" + entry.title);
        }

        @Override
        public String getRawText(boolean compact) {
            HtmlEntry entry = this.getEntry();
            return entry.getRawText(compact);
        }

        @Override
        public RowMatchType matches(List<String> searchTokens, Pattern orderedMatchPattern, Transliterator normalizer, boolean swapPairEntries) {
            String text = normalizer.transform(this.getRawText(false));
            if (orderedMatchPattern.matcher(text).find()) {
                return RowMatchType.ORDERED_MATCH;
            }
            int i = searchTokens.size() - 1;
            while (i >= 0) {
                String searchToken = searchTokens.get(i);
                if (!text.contains(searchToken)) {
                    return RowMatchType.NO_MATCH;
                }
                --i;
            }
            return RowMatchType.BAG_OF_WORDS_MATCH;
        }
    }

    static final class Serializer
    implements RAFListSerializer<HtmlEntry> {
        final Dictionary dictionary;

        Serializer(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public HtmlEntry read(RandomAccessFile raf, int index) throws IOException {
            return new HtmlEntry(this.dictionary, raf, index);
        }

        @Override
        public void write(RandomAccessFile raf, HtmlEntry t) throws IOException {
            t.write(raf);
        }
    }
}

