/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.util.IndexedObject;
import com.hughes.util.raf.RAFListSerializer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class EntrySource
extends IndexedObject
implements Serializable {
    private static final long serialVersionUID = -1323165134846120269L;
    final String name;
    int numEntries;

    public EntrySource(int index, String name, int numEntries) {
        super(index);
        this.name = name;
        this.numEntries = numEntries;
    }

    public String toString() {
        return this.name;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public String getName() {
        return this.name;
    }

    public static final class Serializer
    implements RAFListSerializer<EntrySource> {
        final Dictionary dictionary;

        Serializer(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public EntrySource read(RandomAccessFile raf, int readIndex) throws IOException {
            String name = raf.readUTF();
            int numEntries = this.dictionary.dictFileVersion >= 3 ? raf.readInt() : 0;
            return new EntrySource(readIndex, name, numEntries);
        }

        @Override
        public void write(RandomAccessFile raf, EntrySource t) throws IOException {
            raf.writeUTF(t.name);
            raf.writeInt(t.numEntries);
        }
    }
}

