/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.TokenRow;
import com.hughes.android.dictionary.engine.TransliteratorManager;
import com.hughes.util.CollectionUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class DictionaryTest
extends TestCase {
    static final String TEST_OUTPUTS = "testdata/outputs/";
    public static final String OUTPUTS = "data/outputs/";

    @Override
    protected void setUp() {
        while (!TransliteratorManager.init(null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void testURLFormatting() {
    }

    public void testEnItWiktionary() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/EN-IT.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index enIndex = dict.indices.get(0);
        RowBase row = enIndex.rows.get(4);
        DictionaryTest.assertEquals("-ical", row.getRawText(false));
        Index itIndex = dict.indices.get(1);
        List<RowBase> rows = itIndex.multiWordSearch("come mai", Arrays.asList("come", "mai"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.get(0).toString().startsWith("come mai@"));
        DictionaryTest.assertTrue(rows.get(0) instanceof TokenRow);
        DictionaryTest.assertTrue(!((TokenRow)rows.get((int)0)).getIndexEntry().htmlEntries.isEmpty());
        rows = itIndex.multiWordSearch("buon g", Arrays.asList("buon", "g"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.get(0).toString().startsWith("buon giorno@"));
        DictionaryTest.assertTrue(rows.get(0) instanceof TokenRow);
        DictionaryTest.assertTrue(!((TokenRow)rows.get((int)0)).getIndexEntry().htmlEntries.isEmpty());
        Index.IndexEntry searchResult = itIndex.findInsertionPoint("azzurro", new AtomicBoolean(false));
        HtmlEntry htmlEntry = searchResult.htmlEntries.get(0);
        System.out.println("azzurro:\n" + htmlEntry.getHtml());
        raf.close();
    }

    public void testDeEnWiktionary() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/DE-EN.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index deIndex = dict.indices.get(0);
        Index.IndexEntry searchResult = deIndex.findInsertionPoint("rot", new AtomicBoolean(false));
        HtmlEntry htmlEntry = searchResult.htmlEntries.get(0);
        System.out.println("rot:\n" + htmlEntry.getHtml());
        raf.close();
    }

    public void testGermanMetadata() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("testdata/outputs/de-en.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index deIndex = dict.indices.get(0);
        DictionaryTest.assertEquals("DE", deIndex.shortName);
        DictionaryTest.assertEquals("DE->EN", deIndex.longName);
        DictionaryTest.assertEquals(2, dict.sources.size());
        DictionaryTest.assertEquals("chemnitz", dict.sources.get((int)0).name);
        DictionaryTest.assertEquals("dictcc", dict.sources.get((int)1).name);
        DictionaryTest.assertEquals("dictcc", dict.pairEntries.get((int)0).entrySource.name);
        DictionaryTest.assertEquals("chemnitz", dict.pairEntries.get((int)1).entrySource.name);
        raf.close();
    }

    public void testGermanIndex() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("testdata/outputs/de-en.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index deIndex = dict.indices.get(0);
        for (Index.IndexEntry indexEntry : deIndex.sortedIndexEntries) {
            System.out.println("testing: " + indexEntry.token);
            Index.IndexEntry searchResult = deIndex.findInsertionPoint(indexEntry.token, new AtomicBoolean(false));
            DictionaryTest.assertEquals("Looked up: " + indexEntry.token, indexEntry.token.toLowerCase(), searchResult.token.toLowerCase());
        }
        this.assertSearchResult("aaac", "aaac", deIndex.findInsertionPoint("aaac", new AtomicBoolean(false)));
        this.assertSearchResult("aaac", "aaac", deIndex.findInsertionPoint("AAAC", new AtomicBoolean(false)));
        this.assertSearchResult("aaac", "aaac", deIndex.findInsertionPoint("AAAc", new AtomicBoolean(false)));
        this.assertSearchResult("aaac", "aaac", deIndex.findInsertionPoint("aAac", new AtomicBoolean(false)));
        this.assertSearchResult("40", "40", deIndex.findInsertionPoint("", new AtomicBoolean(false)));
        this.assertSearchResult("40", "40", deIndex.findInsertionPoint("__", new AtomicBoolean(false)));
        this.assertSearchResult("Zweckorientiertheit", "z\u00e4hlen", deIndex.findInsertionPoint("ZZZZZ", new AtomicBoolean(false)));
        this.assertSearchResult("ab", "aaac", deIndex.findInsertionPoint("aaaca", new AtomicBoolean(false)));
        this.assertSearchResult("machen", "machen", deIndex.findInsertionPoint("m", new AtomicBoolean(false)));
        this.assertSearchResult("machen", "machen", deIndex.findInsertionPoint("macdddd", new AtomicBoolean(false)));
        this.assertSearchResult("\u00fcberpr\u00fcfe", "\u00fcberpr\u00fcfe", deIndex.findInsertionPoint("ueberpr\u00fcfe", new AtomicBoolean(false)));
        this.assertSearchResult("\u00fcberpr\u00fcfe", "\u00fcberpr\u00fcfe", deIndex.findInsertionPoint("ueberpruefe", new AtomicBoolean(false)));
        this.assertSearchResult("\u00fcberpr\u00fcfe", "\u00fcberpr\u00fcfe", deIndex.findInsertionPoint("ueberpBLEH", new AtomicBoolean(false)));
        this.assertSearchResult("\u00fcberpr\u00fcfe", "\u00fcberpr\u00fcfe", deIndex.findInsertionPoint("\u00fcberprBLEH", new AtomicBoolean(false)));
        this.assertSearchResult("\u00fcberpr\u00fcfen", "\u00fcberpr\u00fcfe", deIndex.findInsertionPoint("\u00fcberpr\u00fcfeBLEH", new AtomicBoolean(false)));
        this.assertSearchResult("Alibi", "Alibi", deIndex.findInsertionPoint("alib", new AtomicBoolean(false)));
        System.out.println(deIndex.findInsertionPoint("alib", new AtomicBoolean(false)).toString());
        raf.close();
    }

    private void assertSearchResult(String insertionPoint, String longestPrefix, Index.IndexEntry actual) {
        DictionaryTest.assertEquals(insertionPoint, actual.token);
    }

    public void testGermanTokenRows() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("testdata/outputs/de-en.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index deIndex = dict.indices.get(0);
        int i = 0;
        while (i < deIndex.rows.size()) {
            deIndex.rows.get(i).getTokenRow(true);
            i += 7;
        }
        TokenRow lastTokenRow = null;
        for (RowBase row : deIndex.rows) {
            if (row instanceof TokenRow) {
                lastTokenRow = (TokenRow)row;
            }
            DictionaryTest.assertEquals(lastTokenRow, row.getTokenRow(true));
        }
        for (RowBase row : deIndex.rows) {
            if (row instanceof TokenRow) {
                lastTokenRow = (TokenRow)row;
            }
            DictionaryTest.assertEquals(lastTokenRow, row.getTokenRow(false));
        }
        raf.close();
    }

    public void testChemnitz() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("testdata/outputs/de-en.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index deIndex = dict.indices.get(0);
        this.assertSearchResult("H\u00f6schen", "Hos", deIndex.findInsertionPoint("Hos", new AtomicBoolean(false)));
        this.assertSearchResult("H\u00f6schen", "hos", deIndex.findInsertionPoint("hos", new AtomicBoolean(false)));
        raf.close();
    }

    public void testMultiSearch() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("testdata/outputs/de-en.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index deIndex = dict.indices.get(0);
        List<RowBase> rows = deIndex.multiWordSearch("aaa aaab", Arrays.asList("aaa", "aaab"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        raf.close();
    }

    public void testMultiSearchIt() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/IT.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index index = dict.indices.get(0);
        List<RowBase> rows = index.multiWordSearch("fare centro", Arrays.asList("fare", "centro"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.get(0).toString().startsWith("fare centro@"));
    }

    public void testMultiSearchDeBig() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/DE-EN.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index enIndex = dict.indices.get(1);
        List<RowBase> rows = enIndex.multiWordSearch("train station", Arrays.asList("train", "station"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.get(0).toString().startsWith("train station@"));
        rows = enIndex.multiWordSearch("a train station", Arrays.asList("a", "train", "station"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertEquals("Bahnhofsuhr {{de-noun|g=f|plural=Bahnhofsuhren}}\tstation clock (at a train station)", rows.get(0).toString());
        rows = enIndex.multiWordSearch("a station", Arrays.asList("a", "station"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertEquals("Abfahrthalle {en-noun}\tDeparture room of a station.", rows.get(0).toString());
        rows = enIndex.multiWordSearch("p eat", Arrays.asList("p", "eat"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.toString().contains("verschlingen; verputzen\tto dispatch (eat)"));
        rows = enIndex.multiWordSearch("p p", Arrays.asList("p", "p"), new AtomicBoolean(false));
        DictionaryTest.assertTrue(rows.size() >= 1000);
        rows = enIndex.multiWordSearch("a a", Arrays.asList("a", "a"), new AtomicBoolean(false));
        DictionaryTest.assertTrue(rows.size() >= 1000);
        rows = enIndex.multiWordSearch("b ba", Arrays.asList("b", "ba"), new AtomicBoolean(false));
        DictionaryTest.assertTrue(rows.size() >= 1000);
        rows = enIndex.multiWordSearch("b ba", Arrays.asList("b", "ba"), new AtomicBoolean(false));
        DictionaryTest.assertTrue(rows.size() >= 1000);
        raf.close();
    }

    public void testMultiSearchBigAF() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/AF-EN.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index enIndex = dict.indices.get(1);
        List<RowBase> rows = enIndex.multiWordSearch("pig eats", Arrays.asList("pig", "eats"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertEquals("vark\tpig (someone who overeats or eats rapidly) (noun)", rows.get(0).toString());
        rows = enIndex.multiWordSearch("pig eat", Arrays.asList("pig", "eat"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertEquals("vark\tpig (someone who overeats or eats rapidly) (noun)", rows.get(0).toString());
        rows = enIndex.multiWordSearch("pi ea", Arrays.asList("pi", "ea"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.toString().contains("vark\tpig (someone who overeats or eats rapidly) (noun)"));
        rows = enIndex.multiWordSearch("p eat", Arrays.asList("p", "eat"), new AtomicBoolean(false));
        System.out.println(CollectionUtil.join(rows, "\n  "));
        DictionaryTest.assertTrue(rows.toString(), rows.size() > 0);
        DictionaryTest.assertTrue(rows.toString().contains("vark\tpig (someone who overeats or eats rapidly) (noun)"));
        raf.close();
    }

    public void testExactSearch() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/EN-cmn.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index cmnIndex = dict.indices.get(1);
        Random random = new Random(10L);
        int i = 0;
        while (i < 1000) {
            int ii = random.nextInt(cmnIndex.sortedIndexEntries.size());
            Index.IndexEntry indexEntry = cmnIndex.sortedIndexEntries.get(ii);
            Index.IndexEntry found = cmnIndex.findExact(indexEntry.token);
            DictionaryTest.assertNotNull(found);
            DictionaryTest.assertEquals(indexEntry.token, found.token);
            DictionaryTest.assertEquals(indexEntry, found);
            ++i;
        }
        raf.close();
    }

    public void testThai() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/EN-TH.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index thIndex = dict.indices.get(1);
        Index.IndexEntry entry = thIndex.findInsertionPoint("\u0e14\u0e35", new AtomicBoolean(false));
        DictionaryTest.assertEquals("di", entry.token);
        raf.close();
    }

    public void testNorwegian() throws IOException {
        RandomAccessFile raf = new RandomAccessFile("data/outputs/EN-NL.quickdic", "r");
        Dictionary dict = new Dictionary(raf);
        Index nlIndex = dict.indices.get(1);
        Index.IndexEntry entry = nlIndex.findInsertionPoint("Xhosa", new AtomicBoolean(false));
        DictionaryTest.assertEquals("Xhosa", entry.token);
        entry = nlIndex.findInsertionPoint("Zyne", new AtomicBoolean(false));
        DictionaryTest.assertEquals("Zyne", entry.token);
        raf.close();
    }
}

