/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.DictionaryBuilder;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.parser.wiktionary.WholeSectionToHtmlParser;
import com.hughes.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import junit.framework.TestCase;

public class DictionaryBuilderTest
extends TestCase {
    public static final String TEST_INPUTS = "testdata/inputs/";
    public static final String WIKISPLIT = "data/inputs/wikiSplit/";
    public static final String WIKISPLIT_EN = "data/inputs/wikiSplit/en/";
    public static final String STOPLISTS = "data/inputs/stoplists/";
    public static final String GOLDENS = "testdata/goldens/";
    public static final String TEST_OUTPUTS = "testdata/outputs/";

    public void testItConj() throws Exception {
        String toParse = "{{it-conj-are|d|avere|pres2s=dai|pres3s=d\u00e0|pres3p=danno|prem1s=diedi|prem1s2=detti|prem2s=desti|prem3s=diede|prem3s2=dette|prem1p=demmo|prem2p=deste|prem3p=diedero|prem3p2=dettero|fut1s=dar\u00f2|fut2s=darai|fut3s=dar\u00e0|fut1p=daremo|fut2p=darete|fut3p=daranno|cond1s=darei|cond2s=daresti|cond3s=darebbe|cond1p=daremmo|cond2p=dareste|cond3p=darebbero|sub123s=dia|sub3p=diano|impsub12s=dessi|impsub3s=desse|impsub1p=dessimo|impsub2p=deste|impsub3p=dessero|imp2s=d\u00e0|imp2s2=dai|imp2s3=da'|imp3s=dia|imp3p=diano}}\n{{it-conj-are|accus|avere}}\n{{it-conj-care|pag|avere or essere}}\n{{it-conj-iare|studi|avere}}\n{{it-conj-iare-b|avvi|avere}}\n{{it-conj-ciare|pronunc|avere}}\n{{it-conj-ere|sed|essere|pres1s=siedo|pres1s2=seggo|pres2s=siedi|pres3s=siede|pres3p=siedono|pres3p2=seggono|fut1s2=sieder\u00f2|fut2s2=siederai|fut3s2=sieder\u00e0|fut1p2=siederemo|fut2p2=siederete|fut3p2=siederanno|cond1s2=siederei|cond2s2=siederesti|cond3s2=siederebbe|cond1p2=siederemmo|cond2p2=siedereste|cond3p2=siederebbero|sub123s=sieda|sub3p=siedano|imp2s=siedi|imp3s=sieda|imp3s2=segga|imp3p=siedano|imp3p2=seggano}}\n{{it-conj-ere|persuad|avere|pastp=persuaso|prem1s=persuasi|prem3s=persuase|prem3s2=''|prem3p=persuasero|prem3p2=''}}\n{{it-conj-ere|abbatt|avere}}\n{{it-conj-ire|copr|avere|pastp=coperto|prem1s2=copersi|prem3s2=coperse|prem3p2=copersero}}\n{{it-conj-ire-b|prefer|avere}}\n{{it-conj-urre|prod|avere}}\n{{it-conj-arsi|lav}}\n{{it-conj-ersi|abbatt}}\n{{it-conj-iarsi|annoi}}\n{{it-conj-carsi|coniug}}\n{{it-conj-ciarsi|affacc}}\n{{it-conj-irsi|vest}}\n{{it-conj-irsi-b|fer}}\n{{it-conj-ursi|rid|essere}}\n{{it-conj-cire|ricuc|avere}}\n{{it-conj-iarsi-b|riavvi|essere}}{{it-conj-fare|putre|avere}}\n{{it-conj-cirsi|cuc|essere}}\n{{it-conj-ere|smett|avere|pastp=smesso|prem1s=smisi|prem3s=smise|prem3s2=''|prem3p=smisero|prem3p2=''}}\n{{term||[[cor#Latin|Cor]] [[Carolus#Latin|Carol\u012b]]|Charles' heart}}\n{{term|sc=Grek|\u03bb\u03cc\u03b3\u03bf\u03c2|tr=l\u00f3gos||word}}\n{{term|verbo|verb\u014d|for the word}}\n";
        DictionaryBuilder db = new DictionaryBuilder("", Language.en, Language.it, "", "", Collections.singleton("X"), Collections.singleton("X"));
        WholeSectionToHtmlParser parser = new WholeSectionToHtmlParser(db.indexBuilders.get(0), null, "EN", "IT", "http://en.wiktionary.org/wiki/%s");
        parser.title = "dummyTitle";
        parser.entrySource = new EntrySource(0, "dummySource", 0);
        parser.parseSection("dummyHeading", "{{it-conj-are|d|avere|pres2s=dai|pres3s=d\u00e0|pres3p=danno|prem1s=diedi|prem1s2=detti|prem2s=desti|prem3s=diede|prem3s2=dette|prem1p=demmo|prem2p=deste|prem3p=diedero|prem3p2=dettero|fut1s=dar\u00f2|fut2s=darai|fut3s=dar\u00e0|fut1p=daremo|fut2p=darete|fut3p=daranno|cond1s=darei|cond2s=daresti|cond3s=darebbe|cond1p=daremmo|cond2p=dareste|cond3p=darebbero|sub123s=dia|sub3p=diano|impsub12s=dessi|impsub3s=desse|impsub1p=dessimo|impsub2p=deste|impsub3p=dessero|imp2s=d\u00e0|imp2s2=dai|imp2s3=da'|imp3s=dia|imp3p=diano}}\n{{it-conj-are|accus|avere}}\n{{it-conj-care|pag|avere or essere}}\n{{it-conj-iare|studi|avere}}\n{{it-conj-iare-b|avvi|avere}}\n{{it-conj-ciare|pronunc|avere}}\n{{it-conj-ere|sed|essere|pres1s=siedo|pres1s2=seggo|pres2s=siedi|pres3s=siede|pres3p=siedono|pres3p2=seggono|fut1s2=sieder\u00f2|fut2s2=siederai|fut3s2=sieder\u00e0|fut1p2=siederemo|fut2p2=siederete|fut3p2=siederanno|cond1s2=siederei|cond2s2=siederesti|cond3s2=siederebbe|cond1p2=siederemmo|cond2p2=siedereste|cond3p2=siederebbero|sub123s=sieda|sub3p=siedano|imp2s=siedi|imp3s=sieda|imp3s2=segga|imp3p=siedano|imp3p2=seggano}}\n{{it-conj-ere|persuad|avere|pastp=persuaso|prem1s=persuasi|prem3s=persuase|prem3s2=''|prem3p=persuasero|prem3p2=''}}\n{{it-conj-ere|abbatt|avere}}\n{{it-conj-ire|copr|avere|pastp=coperto|prem1s2=copersi|prem3s2=coperse|prem3p2=copersero}}\n{{it-conj-ire-b|prefer|avere}}\n{{it-conj-urre|prod|avere}}\n{{it-conj-arsi|lav}}\n{{it-conj-ersi|abbatt}}\n{{it-conj-iarsi|annoi}}\n{{it-conj-carsi|coniug}}\n{{it-conj-ciarsi|affacc}}\n{{it-conj-irsi|vest}}\n{{it-conj-irsi-b|fer}}\n{{it-conj-ursi|rid|essere}}\n{{it-conj-cire|ricuc|avere}}\n{{it-conj-iarsi-b|riavvi|essere}}{{it-conj-fare|putre|avere}}\n{{it-conj-cirsi|cuc|essere}}\n{{it-conj-ere|smett|avere|pastp=smesso|prem1s=smisi|prem3s=smise|prem3s2=''|prem3p=smisero|prem3p2=''}}\n{{term||[[cor#Latin|Cor]] [[Carolus#Latin|Carol\u012b]]|Charles' heart}}\n{{term|sc=Grek|\u03bb\u03cc\u03b3\u03bf\u03c2|tr=l\u00f3gos||word}}\n{{term|verbo|verb\u014d|for the word}}\n");
        db.build();
        String dictName = "testItConj.html";
        PrintStream out = new PrintStream(new File(TEST_OUTPUTS, "testItConj.html"));
        db.dictionary.print(out);
        out.close();
        this.assertFilesEqual("testdata/goldens/testItConj.html", "testdata/outputs/testItConj.html");
    }

    public void doTestCustomDict(String name, String lang1, String lang2, String inputFile) throws Exception {
        File result = new File(TEST_OUTPUTS + name);
        System.out.println("Writing to: " + result);
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=" + lang1, "--lang2=" + lang2, "--lang1Stoplist=data/inputs/stoplists/empty.txt", "--lang2Stoplist=data/inputs/stoplists/empty.txt", "--dictInfo=bleh.", "--input1=testdata/inputs/" + inputFile, "--input1Name=my_input_" + name, "--input1Charset=ISO-8859-1", "--input1Format=tab_separated", "--print=" + result.getPath() + ".text"});
        this.checkGolden(name, result);
    }

    public void test_FR_NL() throws Exception {
        this.doTestCustomDict("QuickDic-FR-NL.quickdic", "FR", "NL", "QuickDic-FR-NL.txt");
    }

    public void testWiktionary_en_de2fr() throws Exception {
        this.wiktionaryTestWithEnTrans2Trans("wiktionary.de_fr.quickdic", "DE", "FR");
    }

    public void wiktionaryTestWithEnTrans2Trans(String name, String lang1, String lang2) throws Exception {
        File result = new File(TEST_OUTPUTS + name);
        System.out.println("Writing to: " + result);
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=" + lang1, "--lang2=" + lang2, "--lang1Stoplist=data/inputs/stoplists/empty.txt", "--lang2Stoplist=data/inputs/stoplists/empty.txt", "--dictInfo=SomeWikiDataTrans2Trans", "--input4=data/inputs/wikiSplit/en/EN.data", "--input4Name=" + name, "--input4Format=EnTranslationToTranslation", "--input4LangPattern1=" + lang1, "--input4LangPattern2=" + lang2, "--input4PageLimit=1000", "--print=" + result.getPath() + ".text"});
        this.checkGolden(name, result);
    }

    public void testWiktionary_WholeSection_DE() throws Exception {
        this.enWiktionaryTestWithWholeSectionToHtml("enwiktionary.WholeSection.DE.quickdic", "DE", 100);
    }

    public void testWiktionary_WholeSection_EN() throws Exception {
        this.enWiktionaryTestWithWholeSectionToHtml("enwiktionary.WholeSection.EN.quickdic", "EN", 100);
    }

    public void testWiktionary_WholeSection_IT() throws Exception {
        this.enWiktionaryTestWithWholeSectionToHtml("enwiktionary.WholeSection.IT.quickdic", "IT", 800);
    }

    public void enWiktionaryTestWithWholeSectionToHtml(String name, String langCode, int pageLimit) throws Exception {
        File result = new File(TEST_OUTPUTS + name);
        System.out.println("Writing to: " + result);
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=" + langCode, "--lang2=EN", "--lang1Stoplist=data/inputs/stoplists/empty.txt", "--lang2Stoplist=data/inputs/stoplists/empty.txt", "--dictInfo=SomeWikiDataWholeSection", "--input4=data/inputs/wikiSplit/en/" + langCode + ".data", "--input4Name=" + name, "--input4Format=WholeSectionToHtmlParser", "--input4WiktionaryLang=EN", "--input4SkipLang=" + langCode, "--input4TitleIndex=1", "--input4PageLimit=" + pageLimit, "--print=" + result.getPath() + ".text"});
        this.checkGolden(name, result);
    }

    public void testSingleLang_EN() throws Exception {
        this.wiktionaryTestSingleLang("SingleLang_EN.quickdic", "EN", 100);
    }

    public void testSingleLang_DE() throws Exception {
        this.wiktionaryTestSingleLang("SingleLang_DE.quickdic", "DE", 100);
    }

    public void testSingleLang_IT() throws Exception {
        this.wiktionaryTestSingleLang("SingleLang_IT.quickdic", "IT", 100);
    }

    public void testSingleLang_FR() throws Exception {
        this.wiktionaryTestSingleLang("SingleLang_FR.quickdic", "FR", 100);
    }

    public void wiktionaryTestSingleLang(String name, String langCode, int pageLimit) throws Exception {
        File result = new File(TEST_OUTPUTS + name);
        System.out.println("Writing to: " + result);
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=" + langCode, "--lang1Stoplist=data/inputs/stoplists/empty.txt", "--dictInfo=SomeWikiDataWholeSection", "--input4=data/inputs/wikiSplit/" + langCode.toLowerCase() + "/" + langCode + ".data", "--input4Name=" + name, "--input4Format=WholeSectionToHtmlParser", "--input4WiktionaryLang=" + langCode, "--input4SkipLang=" + langCode, "--input4TitleIndex=1", "--input4PageLimit=" + pageLimit, "--print=" + result.getPath() + ".text"});
        this.checkGolden(name, result);
    }

    public void testWiktionary_IT_EN() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.it_en.quickdic", "IT", "it.txt", "EN.data", "enwiktionary.english", "Italian", "it", 1000);
    }

    public void testWiktionary_cmn_EN() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.cmn_en.quickdic", "cmn", "empty.txt", "EN.data", "enwiktionary.english", "Chinese|Mandarin", "cmn", 1000);
    }

    public void testWiktionary_DE_EN() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.de_en.quickdic", "DE", "de.txt", "EN.data", "enwiktionary.english", "German", "de", 1000);
    }

    public void testWiktionary_IT_IT() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.it_it.quickdic", "IT", "it.txt", "IT.data", "enwiktionary.italian", "Italian", "it", 1000);
    }

    public void testWiktionary_FR_FR() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.fr_fr.quickdic", "FR", "fr.txt", "FR.data", "enwiktionary.french", "French", "fr", 1000);
    }

    public void testWiktionary_AR_AR() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.ar_ar.quickdic", "AR", "empty.txt", "AR.data", "enwiktionary.arabic", "Arabic", "ar", 200);
    }

    public void testWiktionary_cmn_cmn() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.cmn_cmn.quickdic", "cmn", "empty.txt", "cmn.data", "enwiktionary.chinese", "Chinese|Mandarin", "cmn", 1000);
    }

    public void testWiktionary_DE_DE() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.de_de.quickdic", "DE", "de.txt", "DE.data", "enwiktionary.german", "German", "de", 1000);
    }

    public void testWiktionary_TH_TH() throws Exception {
        this.wiktionaryTestWithLangToEn("wiktionary.th_th.quickdic", "TH", "empty.txt", "TH.data", "enwiktionary.thai", "Thai", "th", 1000);
    }

    public void wiktionaryTestWithLangToEn(String name, String lang1, String stoplist, String data, String dictName, String langPattern, String langCode, int pageLimit) throws Exception {
        File result = new File(TEST_OUTPUTS + name);
        System.out.println("Writing to: " + result);
        String type = data.equals("EN.data") ? "EnToTranslation" : "EnForeign";
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=" + lang1, "--lang2=EN", "--lang1Stoplist=data/inputs/stoplists/" + stoplist, "--lang2Stoplist=data/inputs/stoplists/en.txt", "--dictInfo=SomeWikiData", "--input4=data/inputs/wikiSplit/en/" + data, "--input4Name=" + dictName, "--input4Format=enwiktionary", "--input4WiktionaryType=" + type, "--input4LangPattern=" + langPattern, "--input4LangCodePattern=" + langCode, "--input4EnIndex=2", "--input4PageLimit=" + pageLimit, "--print=" + result.getPath() + ".text"});
        this.checkGolden(name, result);
    }

    public void testGermanCombined() throws Exception {
        String name = "de-en.quickdic";
        File result = new File("testdata/outputs/de-en.quickdic");
        System.out.println("Writing to: " + result);
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=DE", "--lang2=EN", "--dictInfo=@testdata/inputs/de-en_dictInfo.txt", "--input1=testdata/inputs/de-en_chemnitz_100", "--input1Name=chemnitz", "--input1Charset=UTF8", "--input1Format=chemnitz", "--input2=testdata/inputs/de-en_dictcc_simulated", "--input2Name=dictcc", "--input2Charset=UTF8", "--input2Format=tab_separated", "--print=" + result.getPath() + ".text"});
        this.checkGolden("de-en.quickdic", result);
    }

    public void testItalianTurkish() throws Exception {
        String name = "it-tr_dictcc.quickdic";
        File result = new File("testdata/outputs/it-tr_dictcc.quickdic");
        System.out.println("Writing to: " + result);
        DictionaryBuilder.main(new String[]{"--dictOut=" + result.getAbsolutePath(), "--lang1=IT", "--lang2=TR", "--dictInfo=it-tr_dictcc_simulated", "--input1=testdata/inputs/it-tr_dictcc_simulated.txt", "--input1Name=dictcc", "--input1Charset=UTF8", "--input1Format=tab_separated", "--print=" + result.getPath() + ".text"});
        this.checkGolden("it-tr_dictcc.quickdic", result);
    }

    private void checkGolden(String dictName, File dictFile) throws IOException, FileNotFoundException {
        this.assertFilesEqual(GOLDENS + dictName + ".text", String.valueOf(dictFile.getPath()) + ".text");
        Dictionary dict = new Dictionary(new RandomAccessFile(dictFile.getAbsolutePath(), "r"));
        PrintStream out = new PrintStream(new File(String.valueOf(dictFile.getPath()) + ".text"));
        dict.print(out);
        out.close();
        this.assertFilesEqual(GOLDENS + dictName + ".text", String.valueOf(dictFile.getPath()) + ".text");
    }

    void assertFilesEqual(String expected, String actual) throws IOException {
        String expectedString = FileUtil.readToString(new File(expected));
        String actualString = FileUtil.readToString(new File(actual));
        DictionaryBuilderTest.assertEquals(expectedString, actualString);
    }
}

