/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.DictionaryBuilder;
import com.hughes.android.dictionary.parser.wiktionary.WiktionaryLangs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class DictionaryBuilderMain
extends TestCase {
    static final String INPUTS = "data/inputs/";
    static final String STOPLISTS = "data/inputs/stoplists/";
    static final String OUTPUTS = "data/outputs/";
    static final String[][] nonEnPairs = new String[][]{{"EN"}, {"DE"}, {"IT"}, {"IT", "EN"}, {"DE", "EN"}, {"DE", "IT"}, {"AR", "DE"}, {"AR", "ES"}, {"AR", "FR"}, {"AR", "HE"}, {"AR", "IT"}, {"AR", "JA"}, {"AR", "RU"}, {"AR", "TR"}, {"AR", "cmn"}, {"DE", "AR"}, {"DE", "FR"}, {"DE", "CA"}, {"DE", "CS"}, {"DE", "EO"}, {"DE", "ES"}, {"DE", "FR"}, {"DE", "HE"}, {"DE", "HU"}, {"DE", "IT"}, {"DE", "JA"}, {"DE", "LA"}, {"DE", "NL"}, {"DE", "PL"}, {"DE", "RU"}, {"DE", "SV"}, {"DE", "TR"}, {"DE", "cmn"}, {"DE", "TA"}, {"ES", "RU"}, {"FR", "BG"}, {"FR", "CS"}, {"FR", "DE"}, {"FR", "ES"}, {"FR", "IT"}, {"FR", "JA"}, {"FR", "LA"}, {"FR", "NL"}, {"FR", "RU"}, {"FR", "TR"}, {"FR", "cmn"}, {"FR", "EL"}, {"IT", "DE"}, {"IT", "EL"}, {"IT", "ES"}, {"IT", "FR"}, {"IT", "HU"}, {"IT", "JA"}, {"IT", "LA"}, {"IT", "LV"}, {"IT", "NL"}, {"IT", "PL"}, {"IT", "RU"}, {"IT", "SV"}, {"IT", "TR"}, {"IT", "cmn"}, {"JA", "cmn"}, {"JA", "AR"}, {"JA", "KO"}, {"cmn", "AR"}, {"cmn", "DE"}, {"cmn", "ES"}, {"cmn", "FR"}, {"cmn", "IT"}, {"cmn", "KO"}, {"NO", "SV"}, {"NO", "FI"}, {"FI", "SV"}, {"PL", "FR"}, {"PL", "RU"}, {"PL", "HU"}, {"PL", "ES"}, {"TR", "EL"}, {"FA", "HY"}, {"FA", "SV"}, {"NL", "PL"}};
    static final Map<String, String> isoToDedication = new LinkedHashMap<String, String>();
    static final Map<String, String> isoToStoplist;

    static {
        isoToDedication.put("AF", "Wiktionary-based Afrikaans dictionary dedicated to Heiko and Mari\u00ebtte Horn.");
        isoToDedication.put("HR", "Wiktionary-based Croatian dictionary dedicated to Ines Viskic and Miro Kresonja.");
        isoToDedication.put("NL", "Wiktionary-based Dutch dictionary dedicated to Mike LeBeau.");
        isoToDedication.put("DE", "@data/inputs/de-en_dedication.txt");
        isoToDedication.put("EL", "Wiktionary-based Greek dictionary dedicated to Noah Egge.");
        isoToDedication.put("IT", "Wiktionary-based Italian dictionary dedicated to Carolina Tropini, my favorite stardust in the whole universe!  Ti amo!");
        isoToDedication.put("KO", "Wiktionary-based Korean dictionary dedicated to Ande Elwood--fall fashion und Fernsehturms!");
        isoToDedication.put("PT", "Wiktionary-based Portuguese dictionary dedicated to Carlos Melo, one Tough Mudder.");
        isoToDedication.put("RO", "Wiktionary-based Romanian dictionary dedicated to Radu Teodorescu.");
        isoToDedication.put("RU", "Wiktionary-based Russian dictionary dedicated to Maxim Aronin--best friend always!.");
        isoToDedication.put("SR", "Wiktionary-based Serbian dictionary dedicated to Filip Crnogorac--thanks for the honey.");
        isoToDedication.put("ES", "Wiktionary-based Spanish dictionary made especially for Carolina Tropini! <3 XoXoXXXXX!");
        isoToDedication.put("SV", "Wiktionary-based Swedish dictionary dedicated to Kajsa Palmblad--bj\u00f6rn kramar!");
        isoToStoplist = new LinkedHashMap<String, String>();
        isoToStoplist.put("DE", "de.txt");
        isoToStoplist.put("EN", "en.txt");
        isoToStoplist.put("ES", "es.txt");
        isoToStoplist.put("IT", "it.txt");
        isoToStoplist.put("FR", "fr.txt");
    }

    private static String getEnDictionaryInfo(String iso) {
        return isoToDedication.containsKey(iso) ? isoToDedication.get(iso) : String.format("Wiktionary-based %s dictionary.", iso);
    }

    private static String getStoplist(String iso) {
        return isoToStoplist.containsKey(iso) ? isoToStoplist.get(iso) : "empty.txt";
    }

    static String getOtherLang(String[] pair, String first) {
        assert (Arrays.asList(pair).contains(first));
        assert (pair.length == 2);
        return pair[0].equals(first) ? pair[1] : pair[0];
    }

    static List<String> getMainArgs(String[] pair) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 1;
        if (pair.length == 1) {
            String lang1 = pair[0];
            String dictFile = String.format("%s/%s.quickdic", OUTPUTS, lang1);
            result.add(String.format("--dictOut=%s", dictFile));
            result.add(String.format("--lang1=%s", lang1));
            result.add(String.format("--lang1Stoplist=%s", STOPLISTS + DictionaryBuilderMain.getStoplist(lang1)));
            result.add(String.format("--dictInfo=Wikitionary-based %s dictionary.", lang1));
            String wikiSplitFile = String.format("%s/wikiSplit/%s/%s.data", INPUTS, lang1.toLowerCase(), lang1);
            if (new File(wikiSplitFile).canRead()) {
                result.add(String.format("--input%d=%s", i, wikiSplitFile));
                result.add(String.format("--input%dName=%s.wiktionary.org", i, lang1.toLowerCase()));
                result.add(String.format("--input%dFormat=%s", i, "WholeSectionToHtmlParser"));
                result.add(String.format("--input%dTitleIndex=%d", i, 1));
                result.add(String.format("--input%dWiktionaryLang=%s", i, lang1));
                result.add(String.format("--input%dSkipLang=%s", i, lang1));
                result.add(String.format("--input%dWebUrlTemplate=http://%s.wiktionary.org/wiki/%%s", i, lang1.toLowerCase()));
                ++i;
            } else {
                System.err.println("Can't read file: " + wikiSplitFile);
            }
            if (lang1.equals("EN") && !lang1.equals("EN")) {
                result.add(String.format("--input%d=%s/wikiSplit/en/%s.data", i, INPUTS, lang1));
                result.add(String.format("--input%dName=ENWiktionary.%s", i, lang1));
                result.add(String.format("--input%dFormat=enwiktionary", i));
                result.add(String.format("--input%dWiktionaryType=EnEnglish", i));
                result.add(String.format("--input%dLangPattern=%s", i, "English"));
                result.add(String.format("--input%dLangCodePattern=%s", i, lang1.toLowerCase()));
                result.add(String.format("--input%dEnIndex=%d", i, 1));
                ++i;
            }
            return result;
        }
        String lang1 = pair[0];
        String lang2 = pair[1];
        String dictFile = String.format("%s/%s-%s.quickdic", OUTPUTS, lang1, lang2);
        result.add(String.format("--dictOut=%s", dictFile));
        result.add(String.format("--lang1Stoplist=%s", STOPLISTS + DictionaryBuilderMain.getStoplist(lang1)));
        result.add(String.format("--lang2Stoplist=%s", STOPLISTS + DictionaryBuilderMain.getStoplist(lang2)));
        for (String wikitionaryLang : Arrays.asList("EN", "DE", "IT", "FR")) {
            if (!Arrays.asList(pair).contains(wikitionaryLang)) continue;
            String foreignIso = DictionaryBuilderMain.getOtherLang(pair, wikitionaryLang);
            String wikiSplitFile = String.format("%s/wikiSplit/%s/%s.data", INPUTS, wikitionaryLang.toLowerCase(), foreignIso);
            if (!new File(wikiSplitFile).canRead()) {
                System.err.println("WARNING: Can't read file: " + wikiSplitFile);
                continue;
            }
            result.add(String.format("--input%d=%s", i, wikiSplitFile));
            result.add(String.format("--input%dName=%s.wiktionary.org", i, wikitionaryLang.toLowerCase()));
            result.add(String.format("--input%dFormat=%s", i, "WholeSectionToHtmlParser"));
            result.add(String.format("--input%dTitleIndex=%d", i, Arrays.asList(pair).indexOf(foreignIso) + 1));
            result.add(String.format("--input%dWiktionaryLang=%s", i, wikitionaryLang));
            result.add(String.format("--input%dSkipLang=%s", i, foreignIso));
            result.add(String.format("--input%dWebUrlTemplate=http://%s.wiktionary.org/wiki/%%s", i, wikitionaryLang.toLowerCase()));
            ++i;
        }
        if (Arrays.asList(pair).contains("EN")) {
            String foreignIso = DictionaryBuilderMain.getOtherLang(pair, "EN");
            String foreignRegex = WiktionaryLangs.isoCodeToEnWikiName.get(foreignIso);
            result.add(String.format("--lang1=%s", lang1));
            result.add(String.format("--lang2=%s", lang2));
            result.add(String.format("--dictInfo=%s", DictionaryBuilderMain.getEnDictionaryInfo(foreignIso)));
            result.add(String.format("--input%d=%s/wikiSplit/en/%s.data", i, INPUTS, foreignIso));
            result.add(String.format("--input%dName=ENWiktionary.%s", i, foreignIso));
            result.add(String.format("--input%dFormat=enwiktionary", i));
            result.add(String.format("--input%dWiktionaryType=EnForeign", i));
            result.add(String.format("--input%dLangPattern=%s", i, foreignRegex));
            result.add(String.format("--input%dLangCodePattern=%s", i, foreignIso.toLowerCase()));
            result.add(String.format("--input%dEnIndex=%d", i, Arrays.asList(pair).indexOf("EN") + 1));
            result.add(String.format("--input%d=%swikiSplit/en/EN.data", ++i, INPUTS));
            result.add(String.format("--input%dName=enwiktionary.english", i));
            result.add(String.format("--input%dFormat=enwiktionary", i));
            result.add(String.format("--input%dWiktionaryType=EnToTranslation", i));
            result.add(String.format("--input%dLangPattern=%s", i, foreignRegex));
            result.add(String.format("--input%dLangCodePattern=%s", i, foreignIso.toLowerCase()));
            result.add(String.format("--input%dEnIndex=%d", i, Arrays.asList(pair).indexOf("EN") + 1));
            ++i;
            if (foreignIso.equals("DE")) {
                result.add(String.format("--input%d=%sde-en_chemnitz.txt", i, INPUTS));
                result.add(String.format("--input%dName=chemnitz", i));
                result.add(String.format("--input%dCharset=UTF8", i));
                result.add(String.format("--input%dFormat=chemnitz", i));
                ++i;
            }
        } else {
            result.add(String.format("--lang1=%s", lang1));
            result.add(String.format("--lang2=%s", lang2));
            result.add(String.format("--dictInfo=Wikitionary-based %s-%s dictionary.", lang1, lang2));
            result.add(String.format("--input%d=%swikiSplit/en/EN.data", i, INPUTS));
            result.add(String.format("--input%dName=BETA!enwiktionary.%s-%s", i, lang1, lang2));
            result.add(String.format("--input%dFormat=%s", i, "EnTranslationToTranslation"));
            result.add(String.format("--input%dLangPattern1=%s", i, lang1));
            result.add(String.format("--input%dLangPattern2=%s", i, lang2));
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Object> allPairs = new ArrayList<Object>();
        allPairs.addAll(Arrays.asList(nonEnPairs));
        for (String isoCode : WiktionaryLangs.isoCodeToEnWikiName.keySet()) {
            if (isoCode.equals("EN")) continue;
            allPairs.add(new String[]{"EN", isoCode});
        }
        LinkedHashSet<List<Object>> done = new LinkedHashSet<List<Object>>();
        boolean go = true;
        for (Object[] objectArray : allPairs) {
            Arrays.sort(objectArray);
            List<Object> pairList = Arrays.asList(objectArray);
            if (done.contains(pairList)) continue;
            done.add(pairList);
            go = pairList.contains("EN") && pairList.contains("DE");
            if (!go) continue;
            DictionaryBuilder.main(DictionaryBuilderMain.getMainArgs((String[])objectArray).toArray(new String[0]));
        }
    }
}

