/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.IndexBuilder;
import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.parser.DictFileParser;
import com.hughes.android.dictionary.parser.wiktionary.EnForeignParser;
import com.hughes.android.dictionary.parser.wiktionary.EnParser;
import com.hughes.android.dictionary.parser.wiktionary.EnToTranslationParser;
import com.hughes.android.dictionary.parser.wiktionary.EnTranslationToTranslationParser;
import com.hughes.android.dictionary.parser.wiktionary.WholeSectionToHtmlParser;
import com.hughes.util.Args;
import com.hughes.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DictionaryBuilder {
    public final Dictionary dictionary;
    public final List<IndexBuilder> indexBuilders = new ArrayList<IndexBuilder>();

    public DictionaryBuilder(String dictInfoString, Language lang0, Language lang1, String normalizerRules1, String normalizerRules2, Set<String> lang1Stoplist, Set<String> lang2Stoplist) {
        this.dictionary = new Dictionary(dictInfoString);
        if (lang1 != null) {
            this.indexBuilders.add(new IndexBuilder(this, lang0.getIsoCode(), String.valueOf(lang0.getIsoCode()) + "->" + lang1.getIsoCode(), lang0, normalizerRules1, lang1Stoplist, false));
            this.indexBuilders.add(new IndexBuilder(this, lang1.getIsoCode(), String.valueOf(lang1.getIsoCode()) + "->" + lang0.getIsoCode(), lang1, normalizerRules2, lang2Stoplist, true));
        } else {
            this.indexBuilders.add(new IndexBuilder(this, lang0.getIsoCode(), lang0.getIsoCode(), lang0, normalizerRules1, lang1Stoplist, false));
        }
    }

    void build() {
        for (IndexBuilder indexBuilder : this.indexBuilders) {
            indexBuilder.build();
            this.dictionary.indices.add(indexBuilder.index);
        }
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        String dictInfo;
        String dictOutFilename;
        System.out.println("Running with arguments:");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.out.println(arg);
            ++n2;
        }
        Map<String, String> keyValueArgs = Args.keyValueArgs(args);
        if (!keyValueArgs.containsKey("lang1")) {
            DictionaryBuilder.fatalError("--lang1= must be specified.");
        }
        Language lang1 = Language.lookup(keyValueArgs.remove("lang1"));
        Language lang2 = keyValueArgs.containsKey("lang2") ? Language.lookup(keyValueArgs.remove("lang2")) : null;
        LinkedHashSet<String> lang1Stoplist = new LinkedHashSet<String>();
        LinkedHashSet<String> lang2Stoplist = new LinkedHashSet<String>();
        String lang1StoplistFile = keyValueArgs.remove("lang1Stoplist");
        String lang2StoplistFile = keyValueArgs.remove("lang2Stoplist");
        if (lang1StoplistFile != null) {
            lang1Stoplist.addAll(FileUtil.readLines(new File(lang1StoplistFile)));
        }
        if (lang2StoplistFile != null) {
            lang2Stoplist.addAll(FileUtil.readLines(new File(lang2StoplistFile)));
        }
        String normalizerRules1 = keyValueArgs.remove("normalizerRules1");
        String normalizerRules2 = keyValueArgs.remove("normalizerRules2");
        if (normalizerRules1 == null) {
            normalizerRules1 = lang1.getDefaultNormalizerRules();
        }
        if (normalizerRules2 == null) {
            String string2 = normalizerRules2 = lang2 == null ? null : lang2.getDefaultNormalizerRules();
        }
        if ((dictOutFilename = keyValueArgs.remove("dictOut")) == null) {
            DictionaryBuilder.fatalError("--dictOut= must be specified.");
        }
        if ((dictInfo = keyValueArgs.remove("dictInfo")) == null) {
            DictionaryBuilder.fatalError("--dictInfo= must be specified.");
        }
        if (dictInfo.startsWith("@")) {
            dictInfo = FileUtil.readToString(new File(dictInfo.substring(1)));
        }
        String printFile = keyValueArgs.remove("print");
        System.out.println("lang1=" + lang1);
        System.out.println("lang2=" + lang2);
        System.out.println("normalizerRules1=" + normalizerRules1);
        System.out.println("normalizerRules2=" + normalizerRules2);
        System.out.println("dictInfo=" + dictInfo);
        System.out.println("dictOut=" + dictOutFilename);
        DictionaryBuilder dictionaryBuilder = new DictionaryBuilder(dictInfo, lang1, lang2, normalizerRules1, normalizerRules2, lang1Stoplist, lang2Stoplist);
        int i = 0;
        while (i < 100) {
            String prefix = "input" + i;
            if (keyValueArgs.containsKey(prefix)) {
                String pageLimitString;
                File file = new File(keyValueArgs.remove(prefix));
                System.out.println("Processing: " + file);
                String charsetName = keyValueArgs.remove(String.valueOf(prefix) + "Charset");
                if (charsetName == null) {
                    charsetName = "UTF8";
                }
                Charset charset = Charset.forName(charsetName);
                String inputName = keyValueArgs.remove(String.valueOf(prefix) + "Name");
                if (inputName == null) {
                    DictionaryBuilder.fatalError("Must specify human readable name for: " + prefix + "Name");
                }
                if ((pageLimitString = keyValueArgs.remove(String.valueOf(prefix) + "PageLimit")) == null) {
                    pageLimitString = "-1";
                }
                int pageLimit = Integer.parseInt(pageLimitString);
                EntrySource entrySource = new EntrySource(dictionaryBuilder.dictionary.sources.size(), inputName, 0);
                System.out.println("");
                String inputFormat = keyValueArgs.remove(String.valueOf(prefix) + "Format");
                if ("tab_separated".equals(inputFormat)) {
                    boolean flipColumns = "true".equals(keyValueArgs.remove(String.valueOf(prefix) + "FlipColumns"));
                    new DictFileParser(charset, flipColumns, DictFileParser.TAB, null, dictionaryBuilder, dictionaryBuilder.indexBuilders.toArray(new IndexBuilder[0]), null).parse(file, entrySource, pageLimit);
                } else if ("chemnitz".equals(inputFormat)) {
                    boolean flipColumns = "true".equals(keyValueArgs.remove(String.valueOf(prefix) + "FlipColumns"));
                    new DictFileParser(charset, flipColumns, DictFileParser.DOUBLE_COLON, DictFileParser.PIPE, dictionaryBuilder, dictionaryBuilder.indexBuilders.toArray(new IndexBuilder[0]), null).parse(file, entrySource, pageLimit);
                } else if ("enwiktionary".equals(inputFormat)) {
                    EnParser parser;
                    String type = keyValueArgs.remove(String.valueOf(prefix) + "WiktionaryType");
                    Pattern langPattern = Pattern.compile(keyValueArgs.remove(String.valueOf(prefix) + "LangPattern"), 2);
                    Pattern langCodePattern = Pattern.compile(keyValueArgs.remove(String.valueOf(prefix) + "LangCodePattern"));
                    int enIndex = Integer.parseInt(keyValueArgs.remove(String.valueOf(prefix) + "EnIndex")) - 1;
                    if (enIndex < 0 || enIndex >= 2) {
                        DictionaryBuilder.fatalError("Must be 1 or 2: " + prefix + "EnIndex");
                    }
                    if ("EnToTranslation".equals(type)) {
                        parser = new EnToTranslationParser(dictionaryBuilder.indexBuilders.get(enIndex), dictionaryBuilder.indexBuilders.get(1 - enIndex), langPattern, langCodePattern, enIndex != 0);
                    } else if ("EnForeign".equals(type)) {
                        parser = new EnForeignParser(dictionaryBuilder.indexBuilders.get(enIndex), dictionaryBuilder.indexBuilders.get(1 - enIndex), langPattern, langCodePattern, enIndex != 0);
                    } else if ("EnEnglish".equals(type)) {
                        parser = new EnForeignParser(dictionaryBuilder.indexBuilders.get(enIndex), dictionaryBuilder.indexBuilders.get(enIndex), langPattern, langCodePattern, true);
                    } else {
                        DictionaryBuilder.fatalError("Invalid WiktionaryType (use EnToTranslation or EnForeign or EnEnglish): " + type);
                        return;
                    }
                    parser.parse(file, entrySource, pageLimit);
                } else if ("EnTranslationToTranslation".equals(inputFormat)) {
                    String code1 = keyValueArgs.remove(String.valueOf(prefix) + "LangPattern1");
                    String code2 = keyValueArgs.remove(String.valueOf(prefix) + "LangPattern2");
                    if (code1 == null || code2 == null) {
                        DictionaryBuilder.fatalError("Must specify LangPattern1 and LangPattern2.");
                        return;
                    }
                    Pattern codePattern1 = Pattern.compile(code1, 2);
                    Pattern codePattern2 = Pattern.compile(code2, 2);
                    new EnTranslationToTranslationParser(dictionaryBuilder.indexBuilders, new Pattern[]{codePattern1, codePattern2}).parse(file, entrySource, pageLimit);
                } else if ("WholeSectionToHtmlParser".equals(inputFormat)) {
                    int titleIndex = Integer.parseInt(keyValueArgs.remove(String.valueOf(prefix) + "TitleIndex")) - 1;
                    String wiktionaryLang = keyValueArgs.remove(String.valueOf(prefix) + "WiktionaryLang");
                    String webUrlTemplate = keyValueArgs.remove(String.valueOf(prefix) + "WebUrlTemplate");
                    String skipLang = keyValueArgs.remove(String.valueOf(prefix) + "SkipLang");
                    if (skipLang == null) {
                        skipLang = "";
                    }
                    new WholeSectionToHtmlParser(dictionaryBuilder.indexBuilders.get(titleIndex), null, wiktionaryLang, skipLang, webUrlTemplate).parse(file, entrySource, pageLimit);
                } else {
                    DictionaryBuilder.fatalError("Invalid or missing input format: " + inputFormat);
                }
                dictionaryBuilder.dictionary.sources.add(entrySource);
                System.out.println("Done: " + file + "\n\n");
            }
            ++i;
        }
        dictionaryBuilder.build();
        if (printFile != null) {
            PrintStream out = new PrintStream(new File(printFile));
            dictionaryBuilder.dictionary.print(out);
            out.close();
        }
        System.out.println("Writing dictionary to: " + dictOutFilename);
        RandomAccessFile dictOut = new RandomAccessFile(dictOutFilename, "rw");
        dictOut.setLength(0L);
        dictionaryBuilder.dictionary.write(dictOut);
        dictOut.close();
        if (!keyValueArgs.isEmpty()) {
            System.err.println("WARNING: couldn't parse arguments: " + keyValueArgs);
            System.exit(1);
        }
    }

    private static void fatalError(String string2) {
        System.err.println(string2);
        System.exit(1);
    }
}

