/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.DictionaryInfo;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.engine.TextEntry;
import com.hughes.util.CachingList;
import com.hughes.util.raf.RAFList;
import com.hughes.util.raf.RAFListSerializer;
import com.hughes.util.raf.RAFSerializable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Dictionary
implements RAFSerializable<Dictionary> {
    static final int CACHE_SIZE = 5000;
    static final int CURRENT_DICT_VERSION = 6;
    static final String END_OF_DICTIONARY = "END OF DICTIONARY";
    final int dictFileVersion;
    final long creationMillis;
    public final String dictInfo;
    public final List<PairEntry> pairEntries;
    public final List<TextEntry> textEntries;
    public final List<HtmlEntry> htmlEntries;
    public final List<EntrySource> sources;
    public final List<Index> indices;
    private final RAFListSerializer<Index> indexSerializer = new RAFListSerializer<Index>(){

        @Override
        public Index read(RandomAccessFile raf, int readIndex) throws IOException {
            return new Index(Dictionary.this, raf);
        }

        @Override
        public void write(RandomAccessFile raf, Index t) throws IOException {
            t.write(raf);
        }
    };
    final RAFListSerializer<HtmlEntry> htmlEntryIndexSerializer = new RAFListSerializer<HtmlEntry>(){

        @Override
        public void write(RandomAccessFile raf, HtmlEntry t) throws IOException {
            if (t.index() == -1) {
                throw new IndexOutOfBoundsException();
            }
            raf.writeInt(t.index());
        }

        @Override
        public HtmlEntry read(RandomAccessFile raf, int readIndex) throws IOException {
            return Dictionary.this.htmlEntries.get(raf.readInt());
        }
    };

    public Dictionary(String dictInfo) {
        this.dictFileVersion = 6;
        this.creationMillis = System.currentTimeMillis();
        this.dictInfo = dictInfo;
        this.pairEntries = new ArrayList<PairEntry>();
        this.textEntries = new ArrayList<TextEntry>();
        this.htmlEntries = new ArrayList<HtmlEntry>();
        this.sources = new ArrayList<EntrySource>();
        this.indices = new ArrayList<Index>();
    }

    public Dictionary(RandomAccessFile raf) throws IOException {
        this.dictFileVersion = raf.readInt();
        if (this.dictFileVersion < 0 || this.dictFileVersion > 6) {
            throw new IOException("Invalid dictionary version: " + this.dictFileVersion);
        }
        this.creationMillis = raf.readLong();
        this.dictInfo = raf.readUTF();
        try {
            RAFList<EntrySource> rafSources = RAFList.create(raf, new EntrySource.Serializer(this), raf.getFilePointer());
            this.sources = new ArrayList<EntrySource>(rafSources);
            raf.seek(rafSources.getEndOffset());
            this.pairEntries = CachingList.create(RAFList.create(raf, new PairEntry.Serializer(this), raf.getFilePointer()), 5000);
            this.textEntries = CachingList.create(RAFList.create(raf, new TextEntry.Serializer(this), raf.getFilePointer()), 5000);
            this.htmlEntries = this.dictFileVersion >= 5 ? CachingList.create(RAFList.create(raf, new HtmlEntry.Serializer(this), raf.getFilePointer()), 5000) : Collections.emptyList();
            this.indices = CachingList.createFullyCached(RAFList.create(raf, this.indexSerializer, raf.getFilePointer()));
        }
        catch (RuntimeException e) {
            IOException ioe = new IOException("RuntimeException loading dictionary");
            ioe.initCause(e);
            throw ioe;
        }
        String end = raf.readUTF();
        if (!end.equals(END_OF_DICTIONARY)) {
            throw new IOException("Dictionary seems corrupt: " + end);
        }
    }

    @Override
    public void write(RandomAccessFile raf) throws IOException {
        raf.writeInt(this.dictFileVersion);
        raf.writeLong(this.creationMillis);
        raf.writeUTF(this.dictInfo);
        RAFList.write(raf, this.sources, new EntrySource.Serializer(this));
        RAFList.write(raf, this.pairEntries, new PairEntry.Serializer(this));
        RAFList.write(raf, this.textEntries, new TextEntry.Serializer(this));
        RAFList.write(raf, this.htmlEntries, new HtmlEntry.Serializer(this));
        RAFList.write(raf, this.indices, this.indexSerializer);
        raf.writeUTF(END_OF_DICTIONARY);
    }

    public void print(PrintStream out) {
        out.println("dictInfo=" + this.dictInfo);
        for (EntrySource entrySource : this.sources) {
            out.printf("EntrySource: %s %d\n", entrySource.name, entrySource.numEntries);
        }
        out.println();
        for (Index index : this.indices) {
            out.printf("Index: %s %s\n", index.shortName, index.longName);
            index.print(out);
            out.println();
        }
    }

    public DictionaryInfo getDictionaryInfo() {
        DictionaryInfo result = new DictionaryInfo();
        result.creationMillis = this.creationMillis;
        result.dictInfo = this.dictInfo;
        for (Index index : this.indices) {
            result.indexInfos.add(index.getIndexInfo());
        }
        return result;
    }

    public static DictionaryInfo getDictionaryInfo(File file) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            Dictionary dict = new Dictionary(raf);
            DictionaryInfo dictionaryInfo = dict.getDictionaryInfo();
            dictionaryInfo.uncompressedFilename = file.getName();
            dictionaryInfo.uncompressedBytes = file.length();
            raf.close();
            DictionaryInfo dictionaryInfo2 = dictionaryInfo;
            return dictionaryInfo2;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

