/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary.engine;

import com.hughes.android.dictionary.DictionaryInfo;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.util.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class CheckDictionariesMain {
    static final String BASE_URL = "http://quickdic-dictionary.googlecode.com/files/";
    static final String VERSION_CODE = "v006";

    public static void main(String[] args) throws IOException {
        File dictDir = new File("data/outputs/");
        PrintWriter dictionaryInfoOut = new PrintWriter(new File("../Dictionary/res/raw/dictionary_info.txt"));
        Object[] files = dictDir.listFiles();
        ArrayList<String> dictNames = new ArrayList<String>();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object dictFile = objectArray[n2];
            if (((File)dictFile).getName().endsWith("quickdic")) {
                System.out.println(((File)dictFile).getPath());
                RandomAccessFile raf = new RandomAccessFile((File)dictFile, "r");
                Dictionary dict = new Dictionary(raf);
                DictionaryInfo dictionaryInfo = dict.getDictionaryInfo();
                dictionaryInfo.uncompressedFilename = ((File)dictFile).getName();
                dictionaryInfo.downloadUrl = BASE_URL + ((File)dictFile).getName() + "." + VERSION_CODE + ".zip";
                dictionaryInfo.uncompressedBytes = ((File)dictFile).length();
                File zipFile = new File(String.valueOf(((File)dictFile).getPath()) + "." + VERSION_CODE + ".zip");
                dictionaryInfo.zipBytes = zipFile.canRead() ? zipFile.length() : -1L;
                System.out.println("Stats...");
                ArrayList<String> indexNames = new ArrayList<String>();
                for (DictionaryInfo.IndexInfo indexInfo : dictionaryInfo.indexInfos) {
                    indexNames.add(indexInfo.shortName);
                }
                dictNames.add(String.valueOf(CollectionUtil.join(indexNames, "-")) + "\n");
                String row = dictionaryInfo.append(new StringBuilder()).toString();
                if (!zipFile.canRead()) {
                    System.err.println("Couldn't read zipfile: " + zipFile);
                }
                System.out.println(String.valueOf(row) + "\n");
                dictionaryInfoOut.println(row);
                dictionaryInfoOut.flush();
                raf.close();
            }
            ++n2;
        }
        Collections.sort(dictNames);
        System.out.println(((Object)dictNames).toString().replaceAll(",", "  *"));
        dictionaryInfoOut.close();
    }
}

