/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import com.hughes.android.dictionary.DictionaryApplication;
import com.hughes.android.dictionary.MyWebView;
import com.hughes.util.StringUtil;

public final class HtmlDisplayActivity
extends Activity {
    static final String LOG = "QuickDic";
    static final String HTML_RES = "html_res";
    static final String HTML = "html";
    static final String TEXT_TO_HIGHLIGHT = "textToHighlight";
    static final String SHOW_OK_BUTTON = "showOKButton";

    public static Intent getHelpLaunchIntent() {
        Intent intent = new Intent();
        intent.setClassName(HtmlDisplayActivity.class.getPackage().getName(), HtmlDisplayActivity.class.getName());
        intent.putExtra(HTML_RES, 2131034113);
        return intent;
    }

    public static Intent getWhatsNewLaunchIntent() {
        Intent intent = new Intent();
        intent.setClassName(HtmlDisplayActivity.class.getPackage().getName(), HtmlDisplayActivity.class.getName());
        intent.putExtra(HTML_RES, 2131034114);
        return intent;
    }

    public static Intent getHtmlIntent(String html, String textToHighlight, boolean showOkButton) {
        Intent intent = new Intent();
        intent.setClassName(HtmlDisplayActivity.class.getPackage().getName(), HtmlDisplayActivity.class.getName());
        intent.putExtra(HTML, html);
        intent.putExtra(TEXT_TO_HIGHLIGHT, textToHighlight);
        intent.putExtra(SHOW_OK_BUTTON, showOkButton);
        return intent;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setTheme(((DictionaryApplication)this.getApplication()).getSelectedTheme().themeId);
        super.onCreate(savedInstanceState);
        this.setContentView(2130903045);
        int htmlRes = this.getIntent().getIntExtra(HTML_RES, -1);
        String html = htmlRes != -1 ? StringUtil.readToString(this.getResources().openRawResource(htmlRes)) : this.getIntent().getStringExtra(HTML);
        MyWebView webView = (MyWebView)this.findViewById(2131427362);
        webView.loadData(html, "text/html", "utf-8");
        webView.activity = this;
        String textToHighlight = this.getIntent().getStringExtra(TEXT_TO_HIGHLIGHT);
        if (textToHighlight != null && !"".equals(textToHighlight)) {
            Log.d((String)LOG, (String)("NOT Highlighting text: " + textToHighlight));
        }
        Button okButton = (Button)this.findViewById(2131427363);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HtmlDisplayActivity.this.finish();
            }
        });
        if (!this.getIntent().getBooleanExtra(SHOW_OK_BUTTON, true)) {
            okButton.setVisibility(8);
        }
    }
}

