/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.hughes.android.dictionary.DictionaryApplication;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DownloadActivity
extends Activity {
    public static final String SOURCE = "source";
    public static final String DEST = "dest";
    public static final String MESSAGE = "message";
    String source;
    String dest;
    String message;
    long bytesProcessed = 0L;
    long contentLength = -1L;
    private final Executor downloadExecutor = Executors.newSingleThreadExecutor();
    private final Handler uiHandler = new Handler();
    final AtomicBoolean stop = new AtomicBoolean(false);

    public static Intent getLaunchIntent(String source, String dest, String message) {
        Intent intent = new Intent();
        intent.setClassName(DownloadActivity.class.getPackage().getName(), DownloadActivity.class.getName());
        intent.putExtra(SOURCE, source);
        intent.putExtra(DEST, dest);
        intent.putExtra(MESSAGE, message);
        return intent;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setTheme(((DictionaryApplication)this.getApplication()).getSelectedTheme().themeId);
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.source = intent.getStringExtra(SOURCE);
        this.dest = intent.getStringExtra(DEST);
        this.message = intent.getStringExtra(MESSAGE);
        if (this.source == null || this.dest == null) {
            throw new RuntimeException("null source or dest.");
        }
        this.setContentView(2130903044);
        TextView sourceTextView = (TextView)this.findViewById(2131427355);
        sourceTextView.setText((CharSequence)this.source);
        TextView destTextView = (TextView)this.findViewById(2131427358);
        destTextView.setText((CharSequence)this.dest);
        TextView messageTextView = (TextView)this.findViewById(2131427360);
        messageTextView.setText((CharSequence)this.message);
        ProgressBar progressBar = (ProgressBar)this.findViewById(2131427359);
        progressBar.setIndeterminate(false);
        progressBar.setMax(100);
        this.bytesProcessed = 0L;
        this.contentLength = 100L;
        this.setDownloadStatus(this.getString(2131099778));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    File destUnzipped;
                    ZipFile zipFile;
                    ZipEntry zipEntry;
                    File destFile = new File(DownloadActivity.this.dest);
                    if (destFile.getAbsoluteFile().getParent() != null) {
                        destFile.getAbsoluteFile().getParentFile().mkdirs();
                    }
                    File destTmpFile = File.createTempFile("dictionaryDownload", "tmp", destFile.getParentFile());
                    destTmpFile.deleteOnExit();
                    URL uri = new URL(DownloadActivity.this.source);
                    URLConnection connection = uri.openConnection();
                    DownloadActivity.this.contentLength = connection.getContentLength();
                    InputStream in = connection.getInputStream();
                    if (in == null) {
                        throw new IOException("Unable to open InputStream from source: " + DownloadActivity.this.source);
                    }
                    FileOutputStream out = new FileOutputStream(destTmpFile);
                    int bytesRead = this.copyStream(in, out, 2131099779);
                    if (bytesRead == -1 && !DownloadActivity.this.stop.get()) {
                        destFile.delete();
                        destTmpFile.renameTo(destFile);
                    } else {
                        Log.d((String)"THAD", (String)"Stopped downloading file.");
                    }
                    if (DownloadActivity.this.dest.toLowerCase().endsWith(".zip") && (zipEntry = (zipFile = new ZipFile(destFile)).getEntry((destUnzipped = new File(DownloadActivity.this.dest.substring(0, DownloadActivity.this.dest.length() - 4))).getName())) != null) {
                        destUnzipped.delete();
                        Log.d((String)"THAD", (String)("Unzipping entry: " + zipEntry.getName() + " to " + destUnzipped));
                        InputStream zipIn = zipFile.getInputStream(zipEntry);
                        FileOutputStream zipOut = new FileOutputStream(destUnzipped);
                        DownloadActivity.this.contentLength = zipEntry.getSize();
                        bytesRead = this.copyStream(zipIn, zipOut, 2131099780);
                        destFile.delete();
                    }
                    DownloadActivity.this.setDownloadStatus(String.format(DownloadActivity.this.getString(2131099781), DownloadActivity.this.bytesProcessed));
                    DownloadActivity.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            DownloadActivity.this.finish();
                        }
                    });
                }
                catch (IOException e) {
                    Log.e((String)"THAD", (String)"Error downloading file", (Throwable)e);
                    DownloadActivity.this.setDownloadStatus(String.format(DownloadActivity.this.getString(2131099782), e.getLocalizedMessage()));
                }
            }

            private int copyStream(InputStream in, OutputStream out, int messageId) throws IOException {
                int bytesRead;
                DownloadActivity.this.bytesProcessed = 0L;
                byte[] bytes = new byte[16384];
                int count = 0;
                while ((bytesRead = in.read(bytes)) != -1 && !DownloadActivity.this.stop.get()) {
                    out.write(bytes, 0, bytesRead);
                    DownloadActivity.this.bytesProcessed += (long)bytesRead;
                    if (count++ % 20 != 0) continue;
                    DownloadActivity.this.setDownloadStatus(DownloadActivity.this.getString(messageId, new Object[]{DownloadActivity.this.bytesProcessed, DownloadActivity.this.contentLength}));
                }
                in.close();
                out.close();
                return bytesRead;
            }
        };
        this.downloadExecutor.execute(runnable);
    }

    protected void onStop() {
        this.stop.set(true);
        super.onStop();
    }

    private void setDownloadStatus(final String status) {
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                ProgressBar progressBar = (ProgressBar)DownloadActivity.this.findViewById(2131427359);
                if (DownloadActivity.this.contentLength > 0L) {
                    progressBar.setProgress((int)(DownloadActivity.this.bytesProcessed * 100L / DownloadActivity.this.contentLength));
                }
                TextView downloadStatus = (TextView)DownloadActivity.this.findViewById(2131427361);
                downloadStatus.setText((CharSequence)status);
            }
        });
    }
}

