/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.hughes.android.dictionary.DictionaryActivity;
import com.hughes.android.dictionary.DictionaryApplication;
import com.hughes.android.dictionary.DictionaryInfo;
import com.hughes.android.dictionary.DownloadActivity;
import com.hughes.android.dictionary.HtmlDisplayActivity;
import com.hughes.android.dictionary.PreferenceActivity;
import com.hughes.android.util.IntentLauncher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DictionaryManagerActivity
extends ListActivity {
    static final String LOG = "QuickDic";
    static boolean blockAutoLaunch = false;
    DictionaryApplication application;
    Adapter adapter;
    EditText filterText;
    CheckBox showLocal;
    Handler uiHandler;

    public static Intent getLaunchIntent() {
        Intent intent = new Intent();
        intent.setClassName(DictionaryManagerActivity.class.getPackage().getName(), DictionaryManagerActivity.class.getName());
        intent.putExtra("canAutoLaunch", false);
        return intent;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setTheme(((DictionaryApplication)this.getApplication()).getSelectedTheme().themeId);
        super.onCreate(savedInstanceState);
        Log.d((String)LOG, (String)("onCreate:" + (Object)((Object)this)));
        this.application = (DictionaryApplication)this.getApplication();
        this.setContentView(2130903043);
        this.filterText = (EditText)this.findViewById(2131427349);
        this.showLocal = (CheckBox)this.findViewById(2131427350);
        this.filterText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                DictionaryManagerActivity.this.onFilterTextChanged();
            }
        });
        this.showLocal.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                DictionaryManagerActivity.this.onShowLocalChanged();
            }
        });
        this.getListView().setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> arg0, View arg1, int index, long id2) {
                DictionaryManagerActivity.this.onClick(index);
            }
        });
        this.getListView().setClickable(true);
        this.registerForContextMenu((View)this.getListView());
        blockAutoLaunch = false;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String thanksForUpdatingLatestVersion = this.getString(2131099748);
        if (!prefs.getString("thanksForUpdatingVersion", "").equals(thanksForUpdatingLatestVersion)) {
            blockAutoLaunch = true;
            this.startActivity(HtmlDisplayActivity.getWhatsNewLaunchIntent());
            prefs.edit().putString("thanksForUpdatingVersion", thanksForUpdatingLatestVersion).commit();
        }
    }

    protected void onStart() {
        super.onStart();
        this.uiHandler = new Handler();
    }

    protected void onStop() {
        super.onStop();
        this.uiHandler = null;
    }

    protected void onResume() {
        super.onResume();
        if (PreferenceActivity.prefsMightHaveChanged) {
            PreferenceActivity.prefsMightHaveChanged = false;
            this.finish();
            this.startActivity(this.getIntent());
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.showLocal.setChecked(prefs.getBoolean("showLocal", false));
        if (!blockAutoLaunch && this.getIntent().getBooleanExtra("canAutoLaunch", true) && prefs.contains("dictFile") && prefs.contains("indexIndex")) {
            Log.d((String)LOG, (String)"Skipping Dictionary List, going straight to dictionary.");
            this.startActivity(DictionaryActivity.getLaunchIntent(new File(prefs.getString("dictFile", "")), prefs.getInt("indexIndex", 0), prefs.getString("searchToken", "")));
            this.finish();
            return;
        }
        this.application.backgroundUpdateDictionaries(new Runnable(){

            @Override
            public void run() {
                if (DictionaryManagerActivity.this.uiHandler == null) {
                    return;
                }
                DictionaryManagerActivity.this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        (this).DictionaryManagerActivity.this.adapter = new Adapter();
                        DictionaryManagerActivity.this.setListAdapter((ListAdapter)(this).DictionaryManagerActivity.this.adapter);
                    }
                });
            }
        });
        this.adapter = new Adapter();
        this.setListAdapter((ListAdapter)this.adapter);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.application.onCreateGlobalOptionsMenu((Context)this, menu);
        return true;
    }

    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, view, menuInfo);
        AdapterView.AdapterContextMenuInfo adapterContextMenuInfo = (AdapterView.AdapterContextMenuInfo)menuInfo;
        int position = adapterContextMenuInfo.position;
        final DictionaryInfo dictionaryInfo = this.adapter.getItem(position);
        if (position > 0 && this.application.isDictionaryOnDevice(dictionaryInfo.uncompressedFilename)) {
            MenuItem moveToTopMenuItem = menu.add(2131099743);
            moveToTopMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DictionaryManagerActivity.this.application.moveDictionaryToTop(dictionaryInfo);
                    DictionaryManagerActivity.this.adapter = new Adapter();
                    DictionaryManagerActivity.this.setListAdapter((ListAdapter)DictionaryManagerActivity.this.adapter);
                    return true;
                }
            });
        }
        MenuItem deleteMenuItem = menu.add(2131099744);
        deleteMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                DictionaryManagerActivity.this.application.deleteDictionary(dictionaryInfo);
                DictionaryManagerActivity.this.adapter = new Adapter();
                DictionaryManagerActivity.this.setListAdapter((ListAdapter)DictionaryManagerActivity.this.adapter);
                return true;
            }
        });
        final DictionaryInfo downloadable = this.application.getDownloadable(dictionaryInfo.uncompressedFilename);
        if (downloadable != null) {
            MenuItem downloadMenuItem = menu.add((CharSequence)this.getString(2131099741, new Object[]{(double)downloadable.zipBytes / 1024.0 / 1024.0}));
            downloadMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    Intent intent = DictionaryManagerActivity.this.getDownloadIntent(downloadable);
                    DictionaryManagerActivity.this.startActivity(intent);
                    DictionaryManagerActivity.this.adapter = new Adapter();
                    DictionaryManagerActivity.this.setListAdapter((ListAdapter)DictionaryManagerActivity.this.adapter);
                    return true;
                }
            });
        }
    }

    private Intent getDownloadIntent(DictionaryInfo downloadable) {
        Intent intent = DownloadActivity.getLaunchIntent(downloadable.downloadUrl, String.valueOf(this.application.getPath(downloadable.uncompressedFilename).getPath()) + ".zip", downloadable.dictInfo);
        return intent;
    }

    private void onFilterTextChanged() {
        this.adapter = new Adapter();
        this.setListAdapter((ListAdapter)this.adapter);
    }

    private void onShowLocalChanged() {
        this.adapter = new Adapter();
        this.setListAdapter((ListAdapter)this.adapter);
        SharedPreferences.Editor prefs = PreferenceManager.getDefaultSharedPreferences((Context)this).edit();
        prefs.putBoolean("showLocal", this.showLocal.isChecked());
        prefs.commit();
    }

    private void onClick(int index) {
        DictionaryInfo dictionaryInfo = this.adapter.getItem(index);
        DictionaryInfo downloadable = this.application.getDownloadable(dictionaryInfo.uncompressedFilename);
        if (!this.application.isDictionaryOnDevice(dictionaryInfo.uncompressedFilename) && downloadable != null) {
            Intent intent = this.getDownloadIntent(downloadable);
            this.startActivity(intent);
        } else {
            Intent intent = DictionaryActivity.getLaunchIntent(this.application.getPath(dictionaryInfo.uncompressedFilename), 0, "");
            this.startActivity(intent);
        }
    }

    class Adapter
    extends BaseAdapter {
        final List<DictionaryInfo> dictionaryInfos = new ArrayList<DictionaryInfo>();

        Adapter() {
            String filter = DictionaryManagerActivity.this.filterText.getText().toString().trim().toLowerCase();
            for (DictionaryInfo dictionaryInfo : DictionaryManagerActivity.this.application.getAllDictionaries()) {
                boolean canShow = true;
                if (DictionaryManagerActivity.this.showLocal.isChecked() && !DictionaryManagerActivity.this.application.isDictionaryOnDevice(dictionaryInfo.uncompressedFilename)) {
                    canShow = false;
                }
                if (canShow && filter.length() > 0 && !DictionaryManagerActivity.this.application.getDictionaryName(dictionaryInfo.uncompressedFilename).toLowerCase().contains(filter)) {
                    canShow = false;
                }
                if (!canShow) continue;
                this.dictionaryInfos.add(dictionaryInfo);
            }
        }

        public int getCount() {
            return this.dictionaryInfos.size();
        }

        public DictionaryInfo getItem(int position) {
            return this.dictionaryInfos.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            LinearLayout result;
            if (convertView instanceof LinearLayout) {
                result = (LinearLayout)convertView;
                result.removeAllViews();
            } else {
                result = new LinearLayout(parent.getContext());
            }
            DictionaryInfo dictionaryInfo = this.getItem(position);
            result.setOrientation(1);
            LinearLayout row = new LinearLayout(parent.getContext());
            row.setOrientation(0);
            result.addView((View)row);
            TextView textView = new TextView(parent.getContext());
            String name = DictionaryManagerActivity.this.application.getDictionaryName(dictionaryInfo.uncompressedFilename);
            textView.setText((CharSequence)name);
            textView.setTextSize(2, 22.0f);
            row.addView((View)textView);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.weight = 1.0f;
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            boolean updateAvailable = DictionaryManagerActivity.this.application.updateAvailable(dictionaryInfo);
            DictionaryInfo downloadable = DictionaryManagerActivity.this.application.getDownloadable(dictionaryInfo.uncompressedFilename);
            if ((!DictionaryManagerActivity.this.application.isDictionaryOnDevice(dictionaryInfo.uncompressedFilename) || updateAvailable) && downloadable != null) {
                Button downloadButton = new Button(parent.getContext());
                downloadButton.setText((CharSequence)DictionaryManagerActivity.this.getString(updateAvailable ? 2131099742 : 2131099741, new Object[]{(double)downloadable.zipBytes / 1024.0 / 1024.0}));
                Intent intent = DictionaryManagerActivity.this.getDownloadIntent(downloadable);
                downloadButton.setOnClickListener((View.OnClickListener)new IntentLauncher(parent.getContext(), intent));
                WindowManager.LayoutParams layoutParams2 = new WindowManager.LayoutParams();
                layoutParams2.width = -2;
                layoutParams2.height = -2;
                downloadButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                row.addView((View)downloadButton);
            } else {
                ImageView checkMark = new ImageView(parent.getContext());
                checkMark.setImageResource(2130837506);
                row.addView((View)checkMark);
            }
            LinearLayout row2 = new LinearLayout(parent.getContext());
            row2.setOrientation(0);
            LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-2, -2);
            row2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            result.addView((View)row2);
            StringBuilder builder = new StringBuilder();
            for (DictionaryInfo.IndexInfo indexInfo : dictionaryInfo.indexInfos) {
                if (builder.length() > 0) {
                    builder.append(" | ");
                }
                builder.append(DictionaryManagerActivity.this.getString(2131099745, new Object[]{indexInfo.shortName, indexInfo.mainTokenCount}));
            }
            TextView indexView = new TextView(parent.getContext());
            indexView.setText((CharSequence)builder.toString());
            row2.addView((View)indexView);
            result.setDescendantFocusability(393216);
            result.setClickable(true);
            result.setFocusable(true);
            result.setLongClickable(true);
            result.setBackgroundResource(17301605);
            result.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DictionaryManagerActivity.this.onClick(position);
                }
            });
            return result;
        }
    }
}

