/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DictionaryInfo
implements Serializable {
    private static final long serialVersionUID = -6850863377577700388L;
    public String uncompressedFilename;
    public String downloadUrl;
    public long uncompressedBytes;
    public long zipBytes;
    public long creationMillis;
    public final List<IndexInfo> indexInfos = new ArrayList<IndexInfo>();
    public String dictInfo;

    public DictionaryInfo() {
    }

    public StringBuilder append(StringBuilder result) {
        result.append(this.uncompressedFilename);
        result.append("\t").append(this.downloadUrl);
        result.append("\t").append(this.creationMillis);
        result.append("\t").append(this.uncompressedBytes);
        result.append("\t").append(this.zipBytes);
        result.append("\t").append(this.indexInfos.size());
        for (IndexInfo indexInfo : this.indexInfos) {
            indexInfo.append(result.append("\t"));
        }
        result.append("\t").append(this.dictInfo.replaceAll("\n", "\\\\n"));
        return result;
    }

    public DictionaryInfo(String line) {
        String[] fields = line.split("\t");
        int i = 0;
        this.uncompressedFilename = fields[i++];
        this.downloadUrl = fields[i++];
        this.creationMillis = Long.parseLong(fields[i++]);
        this.uncompressedBytes = Long.parseLong(fields[i++]);
        this.zipBytes = Long.parseLong(fields[i++]);
        int size = Integer.parseInt(fields[i++]);
        int j = 0;
        while (j < size) {
            this.indexInfos.add(new IndexInfo(fields, i));
            i += 3;
            ++j;
        }
        this.dictInfo = fields[i++].replaceAll("\\\\n", "\n");
    }

    public String toString() {
        return this.uncompressedFilename;
    }

    public static final class IndexInfo
    implements Serializable {
        private static final long serialVersionUID = 6524751236198309438L;
        public final String shortName;
        public final int allTokenCount;
        public final int mainTokenCount;
        public static final int SIZE = 3;

        public IndexInfo(String shortName, int allTokenCount, int mainTokenCount) {
            this.shortName = shortName;
            this.allTokenCount = allTokenCount;
            this.mainTokenCount = mainTokenCount;
        }

        public StringBuilder append(StringBuilder result) {
            result.append(this.shortName);
            result.append("\t").append(this.allTokenCount);
            result.append("\t").append(this.mainTokenCount);
            return result;
        }

        public IndexInfo(String[] fields, int i) {
            this.shortName = fields[i++];
            this.allTokenCount = Integer.parseInt(fields[i++]);
            this.mainTokenCount = Integer.parseInt(fields[i++]);
        }
    }
}

