/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import com.hughes.android.dictionary.AboutActivity;
import com.hughes.android.dictionary.C;
import com.hughes.android.dictionary.DictionaryInfo;
import com.hughes.android.dictionary.DictionaryLink;
import com.hughes.android.dictionary.HtmlDisplayActivity;
import com.hughes.android.dictionary.PreferenceActivity;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.Language;
import com.hughes.android.dictionary.engine.TransliteratorManager;
import com.hughes.android.util.PersistentObjectCache;
import com.hughes.util.ListUtil;
import com.ibm.icu.text.Collator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DictionaryApplication
extends Application {
    static final String LOG = "QuickDicApp";
    static Map<String, DictionaryInfo> DOWNLOADABLE_NAME_TO_INFO = null;
    DictionaryConfig dictionaryConfig = null;
    DictionaryHistory dictionaryHistory = null;
    private File dictDir;
    String defaultLangISO2 = Locale.getDefault().getLanguage().toLowerCase();
    String defaultLangName = null;
    final Map<String, String> fileToNameCache = new LinkedHashMap<String, String>();
    final Collator collator = Collator.getInstance();
    final Comparator<String> uncompressedFilenameComparator = new Comparator<String>(){

        @Override
        public int compare(String uncompressedFilename1, String uncompressedFilename2) {
            String name1 = DictionaryApplication.this.getDictionaryName(uncompressedFilename1);
            String name2 = DictionaryApplication.this.getDictionaryName(uncompressedFilename2);
            if (DictionaryApplication.this.defaultLangName.length() > 0) {
                if (name1.startsWith(DictionaryApplication.this.defaultLangName) && !name2.startsWith(DictionaryApplication.this.defaultLangName)) {
                    return -1;
                }
                if (name2.startsWith(DictionaryApplication.this.defaultLangName) && !name1.startsWith(DictionaryApplication.this.defaultLangName)) {
                    return 1;
                }
            }
            return DictionaryApplication.this.collator.compare(name1, name2);
        }
    };
    final Comparator<DictionaryInfo> dictionaryInfoComparator = new Comparator<DictionaryInfo>(){

        @Override
        public int compare(DictionaryInfo d1, DictionaryInfo d2) {
            if (d1.indexInfos.size() != d2.indexInfos.size()) {
                return d1.indexInfos.size() - d2.indexInfos.size();
            }
            return DictionaryApplication.this.uncompressedFilenameComparator.compare(d1.uncompressedFilename, d2.uncompressedFilename);
        }
    };

    static synchronized void staticInit(Context context) {
        if (DOWNLOADABLE_NAME_TO_INFO != null) {
            return;
        }
        DOWNLOADABLE_NAME_TO_INFO = new LinkedHashMap<String, DictionaryInfo>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(context.getResources().openRawResource(2131034112)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                DictionaryInfo dictionaryInfo = new DictionaryInfo(line);
                DOWNLOADABLE_NAME_TO_INFO.put(dictionaryInfo.uncompressedFilename, dictionaryInfo);
            }
            reader.close();
        }
        catch (IOException e) {
            Log.e((String)LOG, (String)"Failed to load downloadable dictionary lists.", (Throwable)e);
        }
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)"QuickDic", (String)"Application: onCreate");
        TransliteratorManager.init(null);
        DictionaryApplication.staticInit(this.getApplicationContext());
        this.dictionaryConfig = PersistentObjectCache.init(this.getApplicationContext()).read("dictionaryConfigs2", DictionaryConfig.class);
        if (this.dictionaryConfig == null) {
            this.dictionaryConfig = new DictionaryConfig();
        }
        this.setTheme(this.getSelectedTheme().themeId);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        prefs.registerOnSharedPreferenceChangeListener(new SharedPreferences.OnSharedPreferenceChangeListener(){

            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                Log.d((String)"QuickDic", (String)("prefs changed: " + key));
                if (key.equals(DictionaryApplication.this.getString(2131099809))) {
                    DictionaryApplication.this.setTheme(DictionaryApplication.this.getSelectedTheme().themeId);
                }
            }
        });
    }

    public void onCreateGlobalOptionsMenu(final Context context, Menu menu) {
        MenuItem about = menu.add((CharSequence)this.getString(2131099734));
        about.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                Intent intent = new Intent().setClassName(AboutActivity.class.getPackage().getName(), AboutActivity.class.getCanonicalName());
                context.startActivity(intent);
                return false;
            }
        });
        MenuItem help = menu.add((CharSequence)this.getString(2131099736));
        help.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                context.startActivity(HtmlDisplayActivity.getHelpLaunchIntent());
                return false;
            }
        });
        MenuItem preferences = menu.add((CharSequence)this.getString(2131099735));
        preferences.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                PreferenceActivity.prefsMightHaveChanged = true;
                Intent intent = new Intent().setClassName(PreferenceActivity.class.getPackage().getName(), PreferenceActivity.class.getCanonicalName());
                context.startActivity(intent);
                return false;
            }
        });
        MenuItem reportIssue = menu.add((CharSequence)this.getString(2131099737));
        reportIssue.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"http://code.google.com/p/quickdic-dictionary/issues/entry"));
                context.startActivity(intent);
                return false;
            }
        });
    }

    public synchronized File getDictDir() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String dir = prefs.getString(this.getString(2131099783), this.getString(2131099786));
        this.dictDir = new File(dir);
        this.dictDir.mkdirs();
        return this.dictDir;
    }

    public C.Theme getSelectedTheme() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String theme = prefs.getString(this.getString(2131099809), "themeLight");
        if (theme.equals("themeLight")) {
            return C.Theme.LIGHT;
        }
        return C.Theme.DEFAULT;
    }

    public File getPath(String uncompressedFilename) {
        return new File(this.getDictDir(), uncompressedFilename);
    }

    public String getLanguageName(String isoCode) {
        Language.LanguageResources languageResources = Language.isoCodeToResources.get(isoCode);
        String lang = languageResources != null ? this.getApplicationContext().getString(languageResources.nameId) : isoCode;
        return lang;
    }

    public synchronized String getDictionaryName(String uncompressedFilename) {
        String name;
        String currentLocale = Locale.getDefault().getLanguage().toLowerCase();
        if (!currentLocale.equals(this.defaultLangISO2)) {
            this.defaultLangISO2 = currentLocale;
            this.fileToNameCache.clear();
            this.defaultLangName = null;
        }
        if (this.defaultLangName == null) {
            this.defaultLangName = this.getLanguageName(this.defaultLangISO2);
        }
        if ((name = this.fileToNameCache.get(uncompressedFilename)) != null) {
            return name;
        }
        DictionaryInfo dictionaryInfo = DOWNLOADABLE_NAME_TO_INFO.get(uncompressedFilename);
        if (dictionaryInfo != null) {
            StringBuilder nameBuilder = new StringBuilder();
            boolean swapped = false;
            if (dictionaryInfo.indexInfos.size() > 1 && dictionaryInfo.indexInfos.get((int)1).shortName.toLowerCase().equals(this.defaultLangISO2)) {
                ListUtil.swap(dictionaryInfo.indexInfos, 0, 1);
                swapped = true;
            }
            int i = 0;
            while (i < dictionaryInfo.indexInfos.size()) {
                if (i > 0) {
                    nameBuilder.append("-");
                }
                nameBuilder.append(this.getLanguageName(dictionaryInfo.indexInfos.get((int)i).shortName));
                ++i;
            }
            if (swapped) {
                ListUtil.swap(dictionaryInfo.indexInfos, 0, 1);
            }
            name = nameBuilder.toString();
        } else {
            name = uncompressedFilename.replace(".quickdic", "");
        }
        this.fileToNameCache.put(uncompressedFilename, name);
        return name;
    }

    public synchronized void moveDictionaryToTop(DictionaryInfo dictionaryInfo) {
        this.dictionaryConfig.dictionaryFilesOrdered.remove(dictionaryInfo.uncompressedFilename);
        this.dictionaryConfig.dictionaryFilesOrdered.add(0, dictionaryInfo.uncompressedFilename);
        PersistentObjectCache.getInstance().write("dictionaryConfigs2", this.dictionaryConfig);
    }

    public synchronized void deleteDictionary(DictionaryInfo dictionaryInfo) {
        while (this.dictionaryConfig.dictionaryFilesOrdered.remove(dictionaryInfo.uncompressedFilename)) {
        }
        this.dictionaryConfig.dictionaryInfoCache.remove(dictionaryInfo.uncompressedFilename);
        this.getPath(dictionaryInfo.uncompressedFilename).delete();
        PersistentObjectCache.getInstance().write("dictionaryConfigs2", this.dictionaryConfig);
    }

    public void backgroundUpdateDictionaries(final Runnable onUpdateFinished) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object file;
                DictionaryConfig oldDictionaryConfig = new DictionaryConfig();
                8 var2_2 = this;
                synchronized (var2_2) {
                    oldDictionaryConfig.dictionaryFilesOrdered.addAll(DictionaryApplication.this.dictionaryConfig.dictionaryFilesOrdered);
                }
                DictionaryConfig newDictionaryConfig = new DictionaryConfig();
                for (String uncompressedFilename : oldDictionaryConfig.dictionaryFilesOrdered) {
                    File dictFile = DictionaryApplication.this.getPath(uncompressedFilename);
                    DictionaryInfo dictionaryInfo = Dictionary.getDictionaryInfo(dictFile);
                    if (dictionaryInfo == null) continue;
                    newDictionaryConfig.dictionaryFilesOrdered.add(uncompressedFilename);
                    newDictionaryConfig.dictionaryInfoCache.put(uncompressedFilename, dictionaryInfo);
                }
                ArrayList<String> toAddSorted = new ArrayList<String>();
                File[] dictDirFiles = DictionaryApplication.this.getDictDir().listFiles();
                if (dictDirFiles != null) {
                    File[] fileArray = dictDirFiles;
                    int n = dictDirFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        file = fileArray[n2];
                        if (((File)file).getName().endsWith(".zip") && DOWNLOADABLE_NAME_TO_INFO.containsKey(((File)file).getName().replace(".zip", ""))) {
                            ((File)file).delete();
                        }
                        if (((File)file).getName().endsWith(".quickdic") && !newDictionaryConfig.dictionaryInfoCache.containsKey(((File)file).getName())) {
                            DictionaryInfo dictionaryInfo = Dictionary.getDictionaryInfo((File)file);
                            if (dictionaryInfo == null) {
                                Log.e((String)DictionaryApplication.LOG, (String)("Unable to parse dictionary: " + ((File)file).getPath()));
                            } else {
                                toAddSorted.add(((File)file).getName());
                                newDictionaryConfig.dictionaryInfoCache.put(((File)file).getName(), dictionaryInfo);
                            }
                        }
                        ++n2;
                    }
                } else {
                    Log.w((String)DictionaryApplication.LOG, (String)("dictDir is not a diretory: " + DictionaryApplication.this.getDictDir().getPath()));
                }
                if (!toAddSorted.isEmpty()) {
                    Collections.sort(toAddSorted, DictionaryApplication.this.uncompressedFilenameComparator);
                    newDictionaryConfig.dictionaryFilesOrdered.addAll(toAddSorted);
                }
                PersistentObjectCache.getInstance().write("dictionaryConfigs2", newDictionaryConfig);
                file = this;
                synchronized (file) {
                    DictionaryApplication.this.dictionaryConfig = newDictionaryConfig;
                }
                try {
                    onUpdateFinished.run();
                }
                catch (Exception e) {
                    Log.e((String)DictionaryApplication.LOG, (String)"Exception running callback.", (Throwable)e);
                }
            }
        }).start();
    }

    public synchronized List<DictionaryInfo> getUsableDicts() {
        ArrayList<DictionaryInfo> result = new ArrayList<DictionaryInfo>(this.dictionaryConfig.dictionaryFilesOrdered.size());
        for (String uncompressedFilename : this.dictionaryConfig.dictionaryFilesOrdered) {
            DictionaryInfo dictionaryInfo = this.dictionaryConfig.dictionaryInfoCache.get(uncompressedFilename);
            if (dictionaryInfo == null) continue;
            result.add(dictionaryInfo);
        }
        return result;
    }

    public synchronized List<DictionaryInfo> getAllDictionaries() {
        List<DictionaryInfo> result = this.getUsableDicts();
        LinkedHashMap<String, DictionaryInfo> remaining = new LinkedHashMap<String, DictionaryInfo>(DOWNLOADABLE_NAME_TO_INFO);
        remaining.keySet().removeAll(this.dictionaryConfig.dictionaryFilesOrdered);
        ArrayList toAddSorted = new ArrayList(remaining.values());
        Collections.sort(toAddSorted, this.dictionaryInfoComparator);
        result.addAll(toAddSorted);
        return result;
    }

    public synchronized boolean isDictionaryOnDevice(String uncompressedFilename) {
        return this.dictionaryConfig.dictionaryInfoCache.get(uncompressedFilename) != null;
    }

    public boolean updateAvailable(DictionaryInfo dictionaryInfo) {
        DictionaryInfo downloadable = DOWNLOADABLE_NAME_TO_INFO.get(dictionaryInfo.uncompressedFilename);
        return downloadable != null && downloadable.creationMillis > dictionaryInfo.creationMillis;
    }

    public DictionaryInfo getDownloadable(String uncompressedFilename) {
        DictionaryInfo downloadable = DOWNLOADABLE_NAME_TO_INFO.get(uncompressedFilename);
        return downloadable;
    }

    static final class DictionaryConfig
    implements Serializable {
        private static final long serialVersionUID = -1444177164708201263L;
        final List<String> dictionaryFilesOrdered = new ArrayList<String>();
        final Map<String, DictionaryInfo> dictionaryInfoCache = new LinkedHashMap<String, DictionaryInfo>();

        DictionaryConfig() {
        }
    }

    static final class DictionaryHistory
    implements Serializable {
        private static final long serialVersionUID = -4842995032541390284L;
        final List<DictionaryLink> dictionaryLinks = new ArrayList<DictionaryLink>();

        DictionaryHistory() {
        }
    }
}

