/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.android.dictionary;

import android.app.Dialog;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.speech.tts.TextToSpeech;
import android.text.ClipboardManager;
import android.text.Editable;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;
import com.hughes.android.dictionary.C;
import com.hughes.android.dictionary.DictionaryApplication;
import com.hughes.android.dictionary.DictionaryInfo;
import com.hughes.android.dictionary.DictionaryManagerActivity;
import com.hughes.android.dictionary.HtmlDisplayActivity;
import com.hughes.android.dictionary.PreferenceActivity;
import com.hughes.android.dictionary.engine.Dictionary;
import com.hughes.android.dictionary.engine.EntrySource;
import com.hughes.android.dictionary.engine.HtmlEntry;
import com.hughes.android.dictionary.engine.Index;
import com.hughes.android.dictionary.engine.PairEntry;
import com.hughes.android.dictionary.engine.RowBase;
import com.hughes.android.dictionary.engine.TokenRow;
import com.hughes.android.dictionary.engine.TransliteratorManager;
import com.hughes.android.util.IntentLauncher;
import com.hughes.android.util.NonLinkClickableSpan;
import com.hughes.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DictionaryActivity
extends ListActivity {
    static final String LOG = "QuickDic";
    DictionaryApplication application;
    File dictFile = null;
    RandomAccessFile dictRaf = null;
    Dictionary dictionary = null;
    int indexIndex = 0;
    Index index = null;
    List<RowBase> rowsToShow = null;
    final Handler uiHandler = new Handler();
    TextToSpeech textToSpeech;
    volatile boolean ttsReady;
    int textColorFg = -16777216;
    private final Executor searchExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "searchExecutor");
        }
    });
    private SearchOperation currentSearchOperation = null;
    C.Theme theme = C.Theme.LIGHT;
    Typeface typeface;
    int fontSizeSp;
    EditText searchText;
    Button langButton;
    private File wordList = null;
    private boolean saveOnlyFirstSubentry = false;
    private boolean clickOpensContextMenu = false;
    ListAdapter indexAdapter = null;
    final SearchTextWatcher searchTextWatcher = new SearchTextWatcher();
    private volatile boolean indexPrepFinished = false;
    final Random random = new Random();
    private long cursorDelayMillis = 100L;
    static final Pattern WHITESPACE = Pattern.compile("\\s+");
    static ViewGroup.LayoutParams WEIGHT_1 = new LinearLayout.LayoutParams(-2, -1, 1.0f);
    static ViewGroup.LayoutParams WEIGHT_0 = new LinearLayout.LayoutParams(-2, -1, 0.0f);
    static final Pattern CHAR_DASH = Pattern.compile("['\\p{L}\\p{M}\\p{N}]+");
    String selectedSpannableText = null;
    int selectedSpannableIndex = -1;
    final TextViewLongClickListener textViewLongClickListenerIndex0 = new TextViewLongClickListener(0);
    final TextViewLongClickListener textViewLongClickListenerIndex1 = new TextViewLongClickListener(1);

    public static Intent getLaunchIntent(File dictFile, int indexIndex, String searchToken) {
        Intent intent = new Intent();
        intent.setClassName(DictionaryActivity.class.getPackage().getName(), DictionaryActivity.class.getName());
        intent.putExtra("dictFile", dictFile.getPath());
        intent.putExtra("indexIndex", indexIndex);
        intent.putExtra("searchToken", searchToken);
        return intent;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.d((String)LOG, (String)("onSaveInstanceState: " + this.searchText.getText().toString()));
        outState.putInt("indexIndex", this.indexIndex);
        outState.putString("searchToken", this.searchText.getText().toString());
    }

    protected void onRestoreInstanceState(Bundle outState) {
        super.onRestoreInstanceState(outState);
        Log.d((String)LOG, (String)("onRestoreInstanceState: " + outState.getString("searchToken")));
        this.onCreate(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        prefs.edit().remove("indexIndex").commit();
        this.setTheme(((DictionaryApplication)this.getApplication()).getSelectedTheme().themeId);
        Log.d((String)LOG, (String)("onCreate:" + (Object)((Object)this)));
        super.onCreate(savedInstanceState);
        this.application = (DictionaryApplication)this.getApplication();
        this.theme = this.application.getSelectedTheme();
        this.textColorFg = this.getResources().getColor(this.theme.tokenRowFgColor);
        Intent intent = this.getIntent();
        this.dictFile = new File(intent.getStringExtra("dictFile"));
        this.ttsReady = false;
        this.textToSpeech = new TextToSpeech(this.getApplicationContext(), new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                DictionaryActivity.this.ttsReady = true;
                DictionaryActivity.this.updateTTSLanuage();
            }
        });
        try {
            String name = this.application.getDictionaryName(this.dictFile.getName());
            this.setTitle("QuickDic: " + name);
            this.dictRaf = new RandomAccessFile(this.dictFile, "r");
            this.dictionary = new Dictionary(this.dictRaf);
        }
        catch (Exception e) {
            Log.e((String)LOG, (String)"Unable to load dictionary.", (Throwable)e);
            if (this.dictRaf != null) {
                try {
                    this.dictRaf.close();
                }
                catch (IOException e1) {
                    Log.e((String)LOG, (String)"Unable to close dictRaf.", (Throwable)e1);
                }
                this.dictRaf = null;
            }
            Toast.makeText((Context)this, (CharSequence)this.getString(2131099757, new Object[]{"", e.getMessage()}), (int)1).show();
            this.startActivity(DictionaryManagerActivity.getLaunchIntent());
            this.finish();
            return;
        }
        this.indexIndex = intent.getIntExtra("indexIndex", 0);
        if (savedInstanceState != null) {
            this.indexIndex = savedInstanceState.getInt("indexIndex", this.indexIndex);
        }
        this.indexIndex %= this.dictionary.indices.size();
        Log.d((String)LOG, (String)("Loading index " + this.indexIndex));
        this.index = this.dictionary.indices.get(this.indexIndex);
        this.setListAdapter((ListAdapter)new IndexAdapter(this.index));
        new Thread(new Runnable(){

            @Override
            public void run() {
                long startMillis = System.currentTimeMillis();
                try {
                    TransliteratorManager.init(new TransliteratorManager.Callback(){

                        @Override
                        public void onTransliteratorReady() {
                            (this).DictionaryActivity.this.uiHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    DictionaryActivity.this.onSearchTextChange(((this).this).DictionaryActivity.this.searchText.getText().toString());
                                }
                            });
                        }
                    });
                    for (Index index : DictionaryActivity.this.dictionary.indices) {
                        String searchToken = index.sortedIndexEntries.get((int)0).token;
                        Index.IndexEntry entry = index.findExact(searchToken);
                        if (searchToken.equals(entry.token)) continue;
                        Log.e((String)DictionaryActivity.LOG, (String)("Couldn't find token: " + searchToken + ", " + entry.token));
                    }
                    DictionaryActivity.this.indexPrepFinished = true;
                }
                catch (Exception e) {
                    Log.w((String)DictionaryActivity.LOG, (String)"Exception while prepping.  This can happen if dictionary is closed while search is happening.");
                }
                Log.d((String)DictionaryActivity.LOG, (String)("Prepping indices took:" + (System.currentTimeMillis() - startMillis)));
            }
        }).start();
        String fontName = prefs.getString(this.getString(2131099791), "FreeSerif.ttf.jpg");
        if ("SYSTEM".equals(fontName)) {
            this.typeface = Typeface.DEFAULT;
        } else {
            try {
                this.typeface = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)fontName);
            }
            catch (Exception e) {
                Log.w((String)LOG, (String)"Exception trying to use typeface, using default.", (Throwable)e);
                Toast.makeText((Context)this, (CharSequence)this.getString(2131099761, new Object[]{e.getLocalizedMessage()}), (int)1).show();
            }
        }
        if (this.typeface == null) {
            Log.w((String)LOG, (String)"Unable to create typeface, using default.");
            this.typeface = Typeface.DEFAULT;
        }
        String fontSize = prefs.getString(this.getString(2131099794), "14");
        try {
            this.fontSizeSp = Integer.parseInt(fontSize.trim());
        }
        catch (NumberFormatException e) {
            this.fontSizeSp = 14;
        }
        this.setContentView(2130903042);
        this.searchText = (EditText)this.findViewById(2131427344);
        this.searchText.requestFocus();
        this.searchText.addTextChangedListener((TextWatcher)this.searchTextWatcher);
        this.searchText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                Log.d((String)DictionaryActivity.LOG, (String)("searchText onFocusChange hasFocus=" + hasFocus));
            }
        });
        String text = this.getIntent().getStringExtra("searchToken");
        if (savedInstanceState != null) {
            text = savedInstanceState.getString("searchToken");
        }
        if (text == null) {
            text = "";
        }
        this.setSearchText(text, true);
        Log.d((String)LOG, (String)("Trying to restore searchText=" + text));
        View clearSearchTextButton = this.findViewById(2131427345);
        clearSearchTextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryActivity.this.onClearSearchTextButton();
            }
        });
        clearSearchTextButton.setVisibility(PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean(this.getString(2131099803), true) ? 0 : 8);
        this.langButton = (Button)this.findViewById(2131427343);
        this.langButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryActivity.this.onLanguageButton();
            }
        });
        this.langButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                DictionaryActivity.this.onLanguageButtonLongClick(v.getContext());
                return true;
            }
        });
        this.updateLangButton();
        View upButton = this.findViewById(2131427347);
        upButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryActivity.this.onUpDownButton(true);
            }
        });
        View downButton = this.findViewById(2131427346);
        downButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DictionaryActivity.this.onUpDownButton(false);
            }
        });
        upButton.setVisibility(PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean(this.getString(2131099806), true) ? 0 : 8);
        downButton.setVisibility(PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean(this.getString(2131099806), true) ? 0 : 8);
        this.registerForContextMenu((View)this.getListView());
        this.wordList = new File(prefs.getString(this.getString(2131099787), this.getString(2131099790)));
        this.saveOnlyFirstSubentry = prefs.getBoolean(this.getString(2131099797), false);
        this.clickOpensContextMenu = prefs.getBoolean(this.getString(2131099800), false);
        Log.d((String)LOG, (String)("wordList=" + this.wordList + ", saveOnlyFirstSubentry=" + this.saveOnlyFirstSubentry));
        DictionaryActivity.setDictionaryPrefs((Context)this, this.dictFile, this.indexIndex, this.searchText.getText().toString());
    }

    protected void onResume() {
        Log.d((String)LOG, (String)"onResume");
        super.onResume();
        if (PreferenceActivity.prefsMightHaveChanged) {
            PreferenceActivity.prefsMightHaveChanged = false;
            this.finish();
            this.startActivity(this.getIntent());
        }
        this.showKeyboard();
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent result) {
        super.onActivityResult(requestCode, resultCode, result);
        if (result != null && result.hasExtra("searchToken")) {
            Log.d((String)LOG, (String)("onActivityResult: " + result.getStringExtra("searchToken")));
            this.jumpToTextFromHyperLink(result.getStringExtra("searchToken"), this.indexIndex);
        }
    }

    private static void setDictionaryPrefs(Context context, File dictFile, int indexIndex, String searchToken) {
        SharedPreferences.Editor prefs = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        prefs.putString("dictFile", dictFile.getPath());
        prefs.putInt("indexIndex", indexIndex);
        prefs.putString("searchToken", "");
        prefs.commit();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.dictRaf == null) {
            return;
        }
        SearchOperation searchOperation = this.currentSearchOperation;
        this.currentSearchOperation = null;
        if (searchOperation != null) {
            Log.d((String)LOG, (String)"Interrupting search to shut down.");
            this.currentSearchOperation = null;
            searchOperation.interrupted.set(true);
        }
        try {
            Log.d((String)LOG, (String)"Closing RAF.");
            this.dictRaf.close();
        }
        catch (IOException e) {
            Log.e((String)LOG, (String)"Failed to close dictionary", (Throwable)e);
        }
        this.dictRaf = null;
    }

    private void onClearSearchTextButton() {
        this.setSearchText("", true);
        this.showKeyboard();
    }

    private void showKeyboard() {
        this.searchText.postDelayed(new Runnable(){

            @Override
            public void run() {
                Log.d((String)DictionaryActivity.LOG, (String)"Trying to show soft keyboard.");
                boolean searchTextHadFocus = DictionaryActivity.this.searchText.hasFocus();
                DictionaryActivity.this.searchText.requestFocus();
                InputMethodManager manager = (InputMethodManager)DictionaryActivity.this.getSystemService("input_method");
                manager.showSoftInput((View)DictionaryActivity.this.searchText, 1);
                if (!searchTextHadFocus) {
                    DictionaryActivity.this.defocusSearchText();
                }
            }
        }, 100L);
    }

    void updateLangButton() {
        this.langButton.setText((CharSequence)this.index.shortName);
        this.updateTTSLanuage();
    }

    private void updateTTSLanuage() {
        if (!this.ttsReady || this.index == null || this.textToSpeech == null) {
            Log.d((String)LOG, (String)"Can't updateTTSLanguage.");
            return;
        }
        Locale locale = new Locale(this.index.sortLanguage.getIsoCode());
        Log.d((String)LOG, (String)("Setting TTS locale to: " + locale));
        int ttsResult = this.textToSpeech.setLanguage(locale);
        if (ttsResult != 0 || ttsResult != 1) {
            Log.e((String)LOG, (String)("TTS not available in this language: ttsResult=" + ttsResult));
        }
    }

    void onLanguageButton() {
        if (this.currentSearchOperation != null) {
            this.currentSearchOperation.interrupted.set(true);
            this.currentSearchOperation = null;
        }
        this.changeIndexAndResearch((this.indexIndex + 1) % this.dictionary.indices.size());
    }

    void onLanguageButtonLongClick(Context context) {
        final Dialog dialog = new Dialog(context);
        dialog.setContentView(2130903046);
        dialog.setTitle(2131099750);
        final List<DictionaryInfo> installedDicts = ((DictionaryApplication)this.getApplication()).getUsableDicts();
        ListView listView = (ListView)dialog.findViewById(16908298);
        Button button = new Button(listView.getContext());
        String name = this.getString(2131099739);
        button.setText((CharSequence)name);
        IntentLauncher intentLauncher = new IntentLauncher(listView.getContext(), DictionaryManagerActivity.getLaunchIntent()){

            @Override
            protected void onGo() {
                dialog.dismiss();
                DictionaryActivity.this.finish();
            }
        };
        button.setOnClickListener((View.OnClickListener)intentLauncher);
        listView.addHeaderView((View)button);
        listView.setAdapter((ListAdapter)new BaseAdapter(){

            public View getView(int position, View convertView, ViewGroup parent) {
                DictionaryInfo dictionaryInfo = this.getItem(position);
                LinearLayout result = new LinearLayout(parent.getContext());
                int i = 0;
                while (i < dictionaryInfo.indexInfos.size()) {
                    if (i > 0) {
                        TextView dash = new TextView(parent.getContext());
                        dash.setText((CharSequence)"-");
                        result.addView((View)dash);
                    }
                    DictionaryInfo.IndexInfo indexInfo = dictionaryInfo.indexInfos.get(i);
                    Button button = new Button(parent.getContext());
                    button.setText((CharSequence)indexInfo.shortName);
                    IntentLauncher intentLauncher = new IntentLauncher(parent.getContext(), DictionaryActivity.getLaunchIntent(DictionaryActivity.this.application.getPath(dictionaryInfo.uncompressedFilename), i, DictionaryActivity.this.searchText.getText().toString())){

                        @Override
                        protected void onGo() {
                            dialog.dismiss();
                            DictionaryActivity.this.finish();
                        }
                    };
                    button.setOnClickListener((View.OnClickListener)intentLauncher);
                    result.addView((View)button);
                    ++i;
                }
                TextView nameView = new TextView(parent.getContext());
                String name = DictionaryActivity.this.application.getDictionaryName(dictionaryInfo.uncompressedFilename);
                nameView.setText((CharSequence)name);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                layoutParams.width = 0;
                layoutParams.weight = 1.0f;
                nameView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                result.addView((View)nameView);
                return result;
            }

            public long getItemId(int position) {
                return position;
            }

            public DictionaryInfo getItem(int position) {
                return (DictionaryInfo)installedDicts.get(position);
            }

            public int getCount() {
                return installedDicts.size();
            }
        });
        dialog.show();
    }

    private void changeIndexAndResearch(int newIndex) {
        Log.d((String)LOG, (String)("Changing index to: " + newIndex));
        if (newIndex == -1) {
            Log.e((String)LOG, (String)"Invalid index.");
            newIndex = 0;
        }
        this.indexIndex = newIndex;
        this.index = this.dictionary.indices.get(this.indexIndex);
        this.indexAdapter = new IndexAdapter(this.index);
        Log.d((String)LOG, (String)("changingIndex, newLang=" + this.index.longName));
        DictionaryActivity.setDictionaryPrefs((Context)this, this.dictFile, this.indexIndex, this.searchText.getText().toString());
        this.setListAdapter(this.indexAdapter);
        this.updateLangButton();
        this.setSearchText(this.searchText.getText().toString(), true);
    }

    void onUpDownButton(boolean up) {
        if (this.isFiltered()) {
            return;
        }
        int firstVisibleRow = this.getListView().getFirstVisiblePosition();
        RowBase row = this.index.rows.get(firstVisibleRow);
        TokenRow tokenRow = row.getTokenRow(true);
        int destIndexEntry = up ? (row != tokenRow ? tokenRow.referenceIndex : Math.max(tokenRow.referenceIndex - 1, 0)) : Math.min(tokenRow.referenceIndex + 1, this.index.sortedIndexEntries.size());
        Index.IndexEntry dest = this.index.sortedIndexEntries.get(destIndexEntry);
        Log.d((String)LOG, (String)("onUpDownButton, destIndexEntry=" + dest.token));
        this.setSearchText(dest.token, false);
        this.jumpToRow(this.index.sortedIndexEntries.get((int)destIndexEntry).startRow);
        this.defocusSearchText();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.application.onCreateGlobalOptionsMenu((Context)this, menu);
        MenuItem dictionaryList = menu.add((CharSequence)this.getString(2131099739));
        dictionaryList.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                DictionaryActivity.this.startActivity(DictionaryManagerActivity.getLaunchIntent());
                DictionaryActivity.this.finish();
                return false;
            }
        });
        MenuItem aboutDictionary = menu.add((CharSequence)this.getString(2131099759));
        aboutDictionary.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                Context context = DictionaryActivity.this.getListView().getContext();
                Dialog dialog = new Dialog(context);
                dialog.setContentView(2130903041);
                TextView textView = (TextView)dialog.findViewById(2131427341);
                String name = DictionaryActivity.this.application.getDictionaryName(DictionaryActivity.this.dictFile.getName());
                dialog.setTitle((CharSequence)name);
                StringBuilder builder = new StringBuilder();
                DictionaryInfo dictionaryInfo = DictionaryActivity.this.dictionary.getDictionaryInfo();
                dictionaryInfo.uncompressedBytes = DictionaryActivity.this.dictFile.length();
                if (dictionaryInfo != null) {
                    builder.append(dictionaryInfo.dictInfo).append("\n\n");
                    builder.append(DictionaryActivity.this.getString(2131099764, new Object[]{DictionaryActivity.this.dictFile.getPath()})).append("\n");
                    builder.append(DictionaryActivity.this.getString(2131099765, new Object[]{dictionaryInfo.uncompressedBytes})).append("\n");
                    builder.append(DictionaryActivity.this.getString(2131099766, new Object[]{dictionaryInfo.creationMillis})).append("\n");
                    for (DictionaryInfo.IndexInfo indexInfo : dictionaryInfo.indexInfos) {
                        builder.append("\n");
                        builder.append(DictionaryActivity.this.getString(2131099767, new Object[]{indexInfo.shortName})).append("\n");
                        builder.append(DictionaryActivity.this.getString(2131099768, new Object[]{indexInfo.mainTokenCount})).append("\n");
                    }
                    builder.append("\n");
                    builder.append(DictionaryActivity.this.getString(2131099769)).append("\n");
                    for (EntrySource source : DictionaryActivity.this.dictionary.sources) {
                        builder.append(DictionaryActivity.this.getString(2131099770, new Object[]{source.getName(), source.getNumEntries()})).append("\n");
                    }
                }
                textView.setText((CharSequence)builder.toString());
                dialog.show();
                WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
                layoutParams.width = -1;
                layoutParams.height = -1;
                dialog.getWindow().setAttributes(layoutParams);
                return false;
            }
        });
        return true;
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        AdapterView.AdapterContextMenuInfo adapterContextMenuInfo = (AdapterView.AdapterContextMenuInfo)menuInfo;
        final RowBase row = (RowBase)this.getListAdapter().getItem(adapterContextMenuInfo.position);
        MenuItem addToWordlist = menu.add((CharSequence)this.getString(2131099752, new Object[]{this.wordList.getName()}));
        addToWordlist.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                DictionaryActivity.this.onAppendToWordList(row);
                return false;
            }
        });
        MenuItem share = menu.add((CharSequence)"Share");
        share.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                Intent shareIntent = new Intent("android.intent.action.SEND");
                shareIntent.setType("text/plain");
                shareIntent.putExtra("android.intent.extra.SUBJECT", row.getTokenRow(true).getToken());
                shareIntent.putExtra("android.intent.extra.TEXT", row.getRawText(DictionaryActivity.this.saveOnlyFirstSubentry));
                DictionaryActivity.this.startActivity(shareIntent);
                return false;
            }
        });
        MenuItem copy = menu.add(0x1040001);
        copy.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                DictionaryActivity.this.onCopy(row);
                return false;
            }
        });
        if (this.selectedSpannableText != null) {
            final String selectedText = this.selectedSpannableText;
            MenuItem searchForSelection = menu.add((CharSequence)this.getString(2131099753, new Object[]{this.selectedSpannableText}));
            searchForSelection.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DictionaryActivity.this.jumpToTextFromHyperLink(selectedText, DictionaryActivity.this.selectedSpannableIndex);
                    return false;
                }
            });
        }
        if (row instanceof TokenRow && this.ttsReady) {
            MenuItem speak = menu.add(2131099763);
            speak.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DictionaryActivity.this.textToSpeech.speak(((TokenRow)row).getToken(), 0, new HashMap());
                    return false;
                }
            });
        }
    }

    private void jumpToTextFromHyperLink(String selectedText, int defaultIndexToUse) {
        boolean changeIndex;
        int indexToUse = -1;
        int i = 0;
        while (i < this.dictionary.indices.size()) {
            Index index = this.dictionary.indices.get(i);
            if (this.indexPrepFinished) {
                TokenRow tokenRow;
                System.out.println("Doing index lookup: on " + selectedText);
                Index.IndexEntry indexEntry = index.findExact(selectedText);
                if (indexEntry != null && (tokenRow = index.rows.get(indexEntry.startRow).getTokenRow(false)) != null && tokenRow.hasMainEntry) {
                    indexToUse = i;
                    break;
                }
            } else {
                Log.w((String)LOG, (String)("Skipping findExact on index " + index.shortName));
            }
            ++i;
        }
        if (indexToUse == -1) {
            indexToUse = defaultIndexToUse;
        }
        boolean bl = changeIndex = this.indexIndex != indexToUse;
        if (changeIndex) {
            this.setSearchText(selectedText, false);
            this.changeIndexAndResearch(indexToUse);
        } else {
            this.setSearchText(selectedText, true);
        }
    }

    protected void onListItemClick(ListView l, View v, int row, long id2) {
        this.defocusSearchText();
        if (this.clickOpensContextMenu && this.dictRaf != null) {
            this.openContextMenu(v);
        }
    }

    void onAppendToWordList(RowBase row) {
        this.defocusSearchText();
        StringBuilder rawText = new StringBuilder();
        rawText.append(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date())).append("\t");
        rawText.append(this.index.longName).append("\t");
        rawText.append(row.getTokenRow(true).getToken()).append("\t");
        rawText.append(row.getRawText(this.saveOnlyFirstSubentry));
        Log.d((String)LOG, (String)("Writing : " + rawText));
        try {
            this.wordList.getParentFile().mkdirs();
            PrintWriter out = new PrintWriter(new FileWriter(this.wordList, true));
            out.println(rawText.toString());
            out.close();
        }
        catch (IOException e) {
            Log.e((String)LOG, (String)("Unable to append to " + this.wordList.getAbsolutePath()), (Throwable)e);
            Toast.makeText((Context)this, (CharSequence)this.getString(2131099754, new Object[]{this.wordList.getAbsolutePath()}), (int)1).show();
        }
    }

    void defocusSearchText() {
        this.getListView().requestFocus();
    }

    void onCopy(RowBase row) {
        this.defocusSearchText();
        Log.d((String)LOG, (String)("Copy, row=" + row));
        StringBuilder result = new StringBuilder();
        result.append(row.getRawText(false));
        ClipboardManager clipboardManager = (ClipboardManager)this.getSystemService("clipboard");
        clipboardManager.setText((CharSequence)result.toString());
        Log.d((String)LOG, (String)("Copied: " + result));
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getUnicodeChar() != 0) {
            if (!this.searchText.hasFocus()) {
                this.setSearchText("" + (char)event.getUnicodeChar(), true);
            }
            return true;
        }
        if (keyCode == 66) {
            Log.d((String)LOG, (String)"Trying to hide soft keyboard.");
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void setSearchText(String text, boolean triggerSearch) {
        if (!triggerSearch) {
            this.getListView().requestFocus();
        }
        this.searchText.setText((CharSequence)text);
        this.searchText.requestFocus();
        this.moveCursorToRight();
        if (triggerSearch) {
            this.onSearchTextChange(text);
        }
    }

    private void moveCursorToRight() {
        if (this.searchText.getLayout() != null) {
            this.cursorDelayMillis = 100L;
            Selection.moveToRightEdge((Spannable)this.searchText.getText(), (Layout)this.searchText.getLayout());
        } else {
            this.uiHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    DictionaryActivity.this.moveCursorToRight();
                }
            }, this.cursorDelayMillis);
            this.cursorDelayMillis = Math.min(10000L, 2L * this.cursorDelayMillis);
        }
    }

    private void searchFinished(final SearchOperation searchOperation) {
        if (searchOperation.interrupted.get()) {
            Log.d((String)LOG, (String)("Search operation was interrupted: " + searchOperation));
            return;
        }
        if (searchOperation != this.currentSearchOperation) {
            Log.d((String)LOG, (String)("Stale searchOperation finished: " + searchOperation));
            return;
        }
        final Index.IndexEntry searchResult = searchOperation.searchResult;
        Log.d((String)LOG, (String)("searchFinished: " + searchOperation + ", searchResult=" + searchResult));
        this.currentSearchOperation = null;
        this.uiHandler.postDelayed(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (DictionaryActivity.this.currentSearchOperation == null) {
                    if (searchResult != null) {
                        if (DictionaryActivity.this.isFiltered()) {
                            DictionaryActivity.this.clearFiltered();
                        }
                        DictionaryActivity.this.jumpToRow(searchResult.startRow);
                        return;
                    } else {
                        if (searchOperation.multiWordSearchResult == null) throw new IllegalStateException("This should never happen.");
                        DictionaryActivity.this.setFiltered(searchOperation);
                    }
                    return;
                } else {
                    Log.d((String)DictionaryActivity.LOG, (String)"More coming, waiting for currentSearchOperation.");
                }
            }
        }, 20L);
    }

    private final void jumpToRow(int row) {
        boolean refocusSearchText = this.searchText.hasFocus();
        Log.d((String)LOG, (String)("jumpToRow: " + row + ", refocusSearchText=" + refocusSearchText));
        this.getListView().requestFocusFromTouch();
        this.getListView().setSelectionFromTop(row, 0);
        this.getListView().setSelected(true);
        if (refocusSearchText) {
            this.searchText.requestFocus();
        }
    }

    private void createTokenLinkSpans(TextView textView, Spannable spannable, String text) {
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        Matcher matcher = CHAR_DASH.matcher(text);
        while (matcher.find()) {
            spannable.setSpan((Object)new NonLinkClickableSpan(this.textColorFg), matcher.start(), matcher.end(), 17);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.selectedSpannableText = null;
        this.selectedSpannableIndex = -1;
        return super.onTouchEvent(event);
    }

    void onSearchTextChange(String text) {
        if ("thadolina".equals(text)) {
            Dialog dialog = new Dialog(this.getListView().getContext());
            dialog.setContentView(2130903047);
            dialog.setTitle((CharSequence)"Ti amo, amore mio!");
            ImageView imageView = (ImageView)dialog.findViewById(2131427365);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)"https://sites.google.com/site/cfoxroxvday/vday2012"));
                    DictionaryActivity.this.startActivity(intent);
                }
            });
            dialog.show();
        }
        if (this.dictRaf == null) {
            Log.d((String)LOG, (String)"searchText changed during shutdown, doing nothing.");
            return;
        }
        if (!this.searchText.isFocused()) {
            Log.d((String)LOG, (String)"searchText changed without focus, doing nothing.");
            return;
        }
        Log.d((String)LOG, (String)("onSearchTextChange: " + text));
        if (this.currentSearchOperation != null) {
            Log.d((String)LOG, (String)"Interrupting currentSearchOperation.");
            this.currentSearchOperation.interrupted.set(true);
        }
        this.currentSearchOperation = new SearchOperation(text, this.index);
        this.searchExecutor.execute(this.currentSearchOperation);
    }

    boolean isFiltered() {
        return this.rowsToShow != null;
    }

    void setFiltered(SearchOperation searchOperation) {
        ((ImageButton)this.findViewById(2131427347)).setEnabled(false);
        ((ImageButton)this.findViewById(2131427346)).setEnabled(false);
        this.rowsToShow = searchOperation.multiWordSearchResult;
        this.setListAdapter((ListAdapter)new IndexAdapter(this.index, this.rowsToShow, searchOperation.searchTokens));
    }

    void clearFiltered() {
        ((ImageButton)this.findViewById(2131427347)).setEnabled(true);
        ((ImageButton)this.findViewById(2131427346)).setEnabled(true);
        this.setListAdapter((ListAdapter)new IndexAdapter(this.index));
        this.rowsToShow = null;
    }

    final class IndexAdapter
    extends BaseAdapter {
        private static final float PADDING_DEFAULT_DP = 8.0f;
        private static final float PADDING_LARGE_DP = 16.0f;
        final Index index;
        final List<RowBase> rows;
        final Set<String> toHighlight;
        private int mPaddingDefault;
        private int mPaddingLarge;

        IndexAdapter(Index index) {
            this.index = index;
            this.rows = index.rows;
            this.toHighlight = null;
            this.getMetrics();
        }

        IndexAdapter(Index index, List<RowBase> rows, List<String> toHighlight) {
            this.index = index;
            this.rows = rows;
            this.toHighlight = new LinkedHashSet<String>(toHighlight);
            this.getMetrics();
        }

        private void getMetrics() {
            float scale = DictionaryActivity.this.getResources().getDisplayMetrics().density;
            this.mPaddingDefault = (int)(8.0f * scale + 0.5f);
            this.mPaddingLarge = (int)(16.0f * scale + 0.5f);
        }

        public int getCount() {
            return this.rows.size();
        }

        public RowBase getItem(int position) {
            return this.rows.get(position);
        }

        public long getItemId(int position) {
            return this.getItem(position).index();
        }

        public TableLayout getView(int position, View convertView, ViewGroup parent) {
            TableLayout result;
            if (convertView instanceof TableLayout) {
                result = (TableLayout)convertView;
                result.removeAllViews();
            } else {
                result = new TableLayout(parent.getContext());
            }
            RowBase row = this.getItem(position);
            if (row instanceof PairEntry.Row) {
                return this.getView(position, (PairEntry.Row)row, parent, result);
            }
            if (row instanceof TokenRow) {
                return this.getView((TokenRow)row, parent, result);
            }
            if (row instanceof HtmlEntry.Row) {
                return this.getView((HtmlEntry.Row)row, parent, result);
            }
            throw new IllegalArgumentException("Unsupported Row type: " + row.getClass());
        }

        private TableLayout getView(final int position, PairEntry.Row row, ViewGroup parent, TableLayout result) {
            PairEntry entry = row.getEntry();
            int rowCount = entry.pairs.size();
            TableRow.LayoutParams layoutParams = new TableRow.LayoutParams();
            layoutParams.weight = 0.5f;
            layoutParams.leftMargin = this.mPaddingLarge;
            int r = 0;
            while (r < rowCount) {
                TableRow tableRow = new TableRow(result.getContext());
                TextView col1 = new TextView(tableRow.getContext());
                TextView col2 = new TextView(tableRow.getContext());
                if (r > 0) {
                    TextView bullet = new TextView(tableRow.getContext());
                    bullet.setText((CharSequence)" \u2022 ");
                    tableRow.addView((View)bullet);
                }
                tableRow.addView((View)col1, (ViewGroup.LayoutParams)layoutParams);
                TextView margin = new TextView(tableRow.getContext());
                margin.setText((CharSequence)" ");
                tableRow.addView((View)margin);
                if (r > 0) {
                    TextView bullet = new TextView(tableRow.getContext());
                    bullet.setText((CharSequence)" \u2022 ");
                    tableRow.addView((View)bullet);
                }
                tableRow.addView((View)col2, (ViewGroup.LayoutParams)layoutParams);
                col1.setWidth(1);
                col2.setWidth(1);
                PairEntry.Pair pair = entry.pairs.get(r);
                String col1Text = this.index.swapPairEntries ? pair.lang2 : pair.lang1;
                String col2Text = this.index.swapPairEntries ? pair.lang1 : pair.lang2;
                col1.setText((CharSequence)col1Text, TextView.BufferType.SPANNABLE);
                col2.setText((CharSequence)col2Text, TextView.BufferType.SPANNABLE);
                Set<String> toBold = this.toHighlight != null ? this.toHighlight : Collections.singleton(row.getTokenRow(true).getToken());
                Spannable col1Spannable = (Spannable)col1.getText();
                for (String token : toBold) {
                    int startPos = 0;
                    while ((startPos = col1Text.indexOf(token, startPos)) != -1) {
                        col1Spannable.setSpan((Object)new StyleSpan(1), startPos, startPos + token.length(), 17);
                        startPos += token.length();
                    }
                }
                DictionaryActivity.this.createTokenLinkSpans(col1, col1Spannable, col1Text);
                DictionaryActivity.this.createTokenLinkSpans(col2, (Spannable)col2.getText(), col2Text);
                col1.setTypeface(DictionaryActivity.this.typeface);
                col2.setTypeface(DictionaryActivity.this.typeface);
                col1.setTextSize(2, (float)DictionaryActivity.this.fontSizeSp);
                col2.setTextSize(2, (float)DictionaryActivity.this.fontSizeSp);
                if (this.index.swapPairEntries) {
                    col2.setOnLongClickListener((View.OnLongClickListener)DictionaryActivity.this.textViewLongClickListenerIndex0);
                    col1.setOnLongClickListener((View.OnLongClickListener)DictionaryActivity.this.textViewLongClickListenerIndex1);
                } else {
                    col1.setOnLongClickListener((View.OnLongClickListener)DictionaryActivity.this.textViewLongClickListenerIndex0);
                    col2.setOnLongClickListener((View.OnLongClickListener)DictionaryActivity.this.textViewLongClickListenerIndex1);
                }
                result.addView((View)tableRow);
                ++r;
            }
            result.setDescendantFocusability(393216);
            result.setClickable(true);
            result.setFocusable(true);
            result.setLongClickable(true);
            result.setBackgroundResource(17301605);
            result.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DictionaryActivity.this.onListItemClick(DictionaryActivity.this.getListView(), v, position, position);
                }
            });
            return result;
        }

        private TableLayout getPossibleLinkToHtmlEntryView(boolean isTokenRow, String text, boolean hasMainEntry, final List<HtmlEntry> htmlEntries, final String htmlTextToHighlight, ViewGroup parent, TableLayout result) {
            Context context = parent.getContext();
            TableRow tableRow = new TableRow(result.getContext());
            tableRow.setBackgroundResource(hasMainEntry ? DictionaryActivity.this.theme.tokenRowMainBg : DictionaryActivity.this.theme.tokenRowOtherBg);
            if (isTokenRow) {
                tableRow.setPadding(this.mPaddingDefault, this.mPaddingDefault, this.mPaddingDefault, 0);
            } else {
                tableRow.setPadding(this.mPaddingLarge, this.mPaddingDefault, this.mPaddingDefault, 0);
            }
            result.addView((View)tableRow);
            TextView textView = new TextView(context);
            textView.setText((CharSequence)text, TextView.BufferType.SPANNABLE);
            DictionaryActivity.this.createTokenLinkSpans(textView, (Spannable)textView.getText(), text);
            TextViewLongClickListener textViewLongClickListenerIndex0 = new TextViewLongClickListener(0);
            textView.setOnLongClickListener((View.OnLongClickListener)textViewLongClickListenerIndex0);
            result.setLongClickable(true);
            textView.setTypeface(DictionaryActivity.this.typeface);
            TableRow.LayoutParams lp = new TableRow.LayoutParams(0);
            if (isTokenRow) {
                textView.setTextAppearance(context, DictionaryActivity.this.theme.tokenRowFg);
                textView.setTextSize(2, (float)(4 * DictionaryActivity.this.fontSizeSp / 3));
            } else {
                textView.setTextSize(2, (float)DictionaryActivity.this.fontSizeSp);
            }
            lp.weight = 1.0f;
            textView.setLayoutParams((ViewGroup.LayoutParams)lp);
            tableRow.addView((View)textView);
            if (!htmlEntries.isEmpty()) {
                ClickableSpan clickableSpan = new ClickableSpan(){

                    public void onClick(View widget) {
                    }
                };
                ((Spannable)textView.getText()).setSpan((Object)clickableSpan, 0, text.length(), 18);
                result.setClickable(true);
                textView.setClickable(true);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        String html = HtmlEntry.htmlBody(htmlEntries, IndexAdapter.this.index.shortName);
                        DictionaryActivity.this.startActivityForResult(HtmlDisplayActivity.getHtmlIntent(String.format("<html><head></head><body>%s</body></html>", html), htmlTextToHighlight, false), 0);
                    }
                });
            }
            return result;
        }

        private TableLayout getView(TokenRow row, ViewGroup parent, TableLayout result) {
            Index.IndexEntry indexEntry = row.getIndexEntry();
            return this.getPossibleLinkToHtmlEntryView(true, indexEntry.token, row.hasMainEntry, indexEntry.htmlEntries, null, parent, result);
        }

        private TableLayout getView(HtmlEntry.Row row, ViewGroup parent, TableLayout result) {
            HtmlEntry htmlEntry = row.getEntry();
            TokenRow tokenRow = row.getTokenRow(true);
            return this.getPossibleLinkToHtmlEntryView(false, DictionaryActivity.this.getString(2131099762, new Object[]{htmlEntry.title, htmlEntry.entrySource.getName()}), false, Collections.singletonList(htmlEntry), tokenRow.getToken(), parent, result);
        }
    }

    final class SearchOperation
    implements Runnable {
        final AtomicBoolean interrupted = new AtomicBoolean(false);
        final String searchText;
        List<String> searchTokens;
        final Index index;
        long searchStartMillis;
        Index.IndexEntry searchResult;
        List<RowBase> multiWordSearchResult;
        boolean done = false;

        SearchOperation(String searchText, Index index) {
            this.searchText = StringUtil.normalizeWhitespace(searchText);
            this.index = index;
        }

        public String toString() {
            return String.format("SearchOperation(%s,%s)", this.searchText, this.interrupted.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                try {
                    try {
                        this.searchStartMillis = System.currentTimeMillis();
                        String[] searchTokenArray = WHITESPACE.split(this.searchText);
                        if (searchTokenArray.length == 1) {
                            this.searchResult = this.index.findInsertionPoint(this.searchText, this.interrupted);
                        } else {
                            this.searchTokens = Arrays.asList(searchTokenArray);
                            this.multiWordSearchResult = this.index.multiWordSearch(this.searchText, this.searchTokens, this.interrupted);
                        }
                        Log.d((String)DictionaryActivity.LOG, (String)("searchText=" + this.searchText + ", searchDuration=" + (System.currentTimeMillis() - this.searchStartMillis) + ", interrupted=" + this.interrupted.get()));
                        if (!this.interrupted.get()) {
                            DictionaryActivity.this.uiHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    DictionaryActivity.this.searchFinished(SearchOperation.this);
                                }
                            });
                        } else {
                            Log.d((String)DictionaryActivity.LOG, (String)"interrupted, skipping searchFinished.");
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)DictionaryActivity.LOG, (String)"Failure during search (can happen during Activity close.");
                        SearchOperation searchOperation = this;
                        synchronized (searchOperation) {
                            this.done = true;
                            this.notifyAll();
                            break block18;
                        }
                    }
                }
                catch (Throwable throwable) {
                    SearchOperation searchOperation = this;
                    synchronized (searchOperation) {
                        this.done = true;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                SearchOperation searchOperation = this;
                synchronized (searchOperation) {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }
    }

    private class SearchTextWatcher
    implements TextWatcher {
        private SearchTextWatcher() {
        }

        public void afterTextChanged(Editable searchTextEditable) {
            if (DictionaryActivity.this.searchText.hasFocus()) {
                Log.d((String)DictionaryActivity.LOG, (String)("SearchTextWatcher: Search text changed with focus: " + DictionaryActivity.this.searchText.getText()));
                DictionaryActivity.this.onSearchTextChange(DictionaryActivity.this.searchText.getText().toString());
            }
        }

        public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
        }

        public void onTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
        }
    }

    private class TextViewLongClickListener
    implements View.OnLongClickListener {
        final int index;

        private TextViewLongClickListener(int index) {
            this.index = index;
        }

        public boolean onLongClick(View v) {
            TextView textView = (TextView)v;
            int start = textView.getSelectionStart();
            int end = textView.getSelectionEnd();
            if (start >= 0 && end >= 0) {
                DictionaryActivity.this.selectedSpannableText = textView.getText().subSequence(start, end).toString();
                DictionaryActivity.this.selectedSpannableIndex = this.index;
            }
            return false;
        }
    }
}

