from __future__ import absolute_import, division, print_function, unicode_literals

__license__   = 'GPL v3'
__copyright__ = '2020, Philippe Perquin <digitalvideo.digitalvideo@gmail.com>'
__docformat__ = 'restructuredtext en'

import os
import shutil
from random import randint
import sys

from calibre.customize import FileTypePlugin

class IEATFNOM(FileTypePlugin):

    name                = 'IEATFNOM' # Name of the plugin
    description         = 'I have my epub named to "author - title.epub", and now i want calibre to import epub with $authors $title metadata from files names and other metadatas from info in files'
    supported_platforms = ['windows', 'osx', 'linux'] # Platforms this plugin will run on
    author              = 'Philippe Perquin' # The author of this plugin
    version             = (0, 97, 0)   # The version number of this plugin
    file_types          = set(['epub']) # The file types that this plugin will be applied to
    on_import      = True # Run this plugin at import drag and drop
    can_be_disabled = True
    #priority = 100
    minimum_calibre_version = (4, 8, 00)

    def run(self, path_to_ebook):
        from calibre.ebooks.metadata.meta import get_metadata, set_metadata
        
        '''ASK CALIBRE FOR A TEMPORY FILE'''
        CreatedTemporaryFile = self.temporary_file('.epub')

        '''GET INFO FROM ORIGINAL FILE'''
        #ImportExt  = os.path.splitext(path_to_ebook)[-1][1:].lower()
        ImportExt  = 'epub'
        ImportName = os.path.splitext(os.path.basename(path_to_ebook))[0]
        
        '''RETRIEVE AUTHORS AND TITLE FROM ORIGINAL FILE NAME'''
        ImportNameSplit = ImportName.split(" - ")
        epubauthor = ""
        epubtitle = ""
        epubauthor = str(ImportNameSplit[0])
        epubauthor = epubauthor.lower()#+ " titi" #for debug purpose
        
        if len(ImportNameSplit) == 2:
            epubtitle = str(ImportNameSplit[1])#+ " titi" #for debug purpose
            epubtitle = epubtitle.lower()

        
        '''COPY ORIGINAL FILE TO TEMPORY FILE PLACE, WILL BE DELETE BY CALIBRE'''
        shutil.copy2(path_to_ebook, CreatedTemporaryFile.name)
        '''OPEN TEMPORY FILE AND GET METADA'''
        TempFile = open(CreatedTemporaryFile.name, 'r+b')
        TempMeta = get_metadata(TempFile, ImportExt)

        TempMeta.title = epubtitle
        TempMeta.title_sort = epubtitle #active this if you want the same as title in sort
        
        TempMeta.authors = [epubauthor] #transfrom the string in list
        TempMeta.author_sort = epubauthor #active this if you want the same as authors in sort
        #piltempMeta.publisher = 'Hello World2' # acitivate this to show change in main Calibre windows #for debug purpose
        
        '''SET METADATA IN TEMPORY FILE'''
        set_metadata(TempFile, TempMeta, ImportExt)
        
        '''RETURN THE FILE PATH OF TEMPORY FILE TO ADD'''
        return TempFile.name