import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SwingFileChooser implements FileChooser{
    JFileChooser fileChooser;

    public SwingFileChooser(){
        fileChooser=new JFileChooser(".");
        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e){}
    }
    public boolean getFileName(Object window, JTextField tf, String title){
        String name=tf.getText();
        File f=new File(name);
        fileChooser.setSelectedFile(f);
        fileChooser.setCurrentDirectory(new File(f.getPath()));
        if (fileChooser.showDialog((JFrame)window, "OK")==JFileChooser.APPROVE_OPTION){
            tf.setText(fileChooser.getSelectedFile().getPath());
            return true;
        } else {
            return false;
        }
    }
    public boolean getDirName(Object window, JTextField tf, String title){
        String name=tf.getText();
        File f=new File(name);
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fileChooser.setCurrentDirectory(new File(f.getPath()));
        if (fileChooser.showDialog((JFrame)window, "OK")==JFileChooser.APPROVE_OPTION){
            tf.setText(fileChooser.getSelectedFile().getPath());
            return true;
        } else {
            return false;
        }
    }
}