# c2.py

#BUGS
#ignore clear clock on statusline at top that appears occasionally (only when clock is started from term detached)
#fixed AM/PM indicator overlaps 4th digit by 11px and 4th digit overlaps 3rd by about 5px / re- enable writing am/pm only as necessary
#leave time_check takes too long(move to seperate cron controlled script)
#fixed time check output overlays clock - use popen
#fixed time update happens a couple seconds after 0
#fixed wednesday september 24 will be too wide
#fixed digits are too wide, narrow by 40px and adjust fbink
#open  occasional minute refresh is missed - timing issue with sleep? / appears to be 2nd minute after startup only

#MODS
#done add display at bottom battery and wifi status
#done status need padding or line cleared first
#done wifi on/off
#done add date to display e.g. "WEDNESDAY JANUARY 20" - needs padding
#done notify me via email of low battery
#done switch to a low power battery mode (no wifi, updates every 10 minutes), indicate lo-bat status1
#done add ntp time refresh 1/day turn wifi on
#done add mode status, blank 4th digit (start sleep cycle on a minute NN:N0 done)
#done add clock startup at boot, add as a button to kual
#cancel update time when screen pressed during sleep
#     add device sleep/suspend instead of python sleep for low power usage
#     occasionally do a full screen clear
#     go to lowpwr when battery is low

#README
#you will need to updated emailbat.py to work with your email accounts; invocation is commented out here
#you will need to change the TT font to something loaded, or find the bahnshrift font that I am using.
#   The font is only used for the date and status lines. png files are used for the time.

import datetime
import os
import subprocess
import sys
import time
from time import sleep

# set constants
ampm = 99    # flag for ampm previous value to determine if has changed from previous display
bt = 0       # flag for emailing low battery once/day
digit1p = 99 # previous digit value to determine if digit has changed from previous display
digit2p = 99 # previous digit value to determine if digit has changed from previous display
digit3p = 99 # previous digit value to determine if digit has changed from previous display
mode = 'NORMAL' # power saving status
once = 0     # flag for executing code section only once at start
oncex = 0    # flag for executing code section only once at start - first time dispaly at startup
oncedash = 0 # flag of executing code section once - dash display
wifi = 'ON'  # wifi status
days = ["MONDAY","TUESDAY","WEDNESDAY","THURSDAY","FRIDAY","SATURDAY","SUNDAY"]
months = ["JANUARY","FEBRUARY","MARCH","APRIL","MAY","JUNE","JULY","AUGUST","SEPTEMBER","OCTOBER","NOVEMBER","DECEMBER"]

def time_check():
    global wifi
    sp = subprocess.Popen(['lipc-set-prop', 'com.lab126.cmd', 'wirelessEnable', '1'], stdout=subprocess.PIPE)
    wifi = 'OFF'
    loop = 0
    while loop < 40:
        sp = subprocess.Popen(['lipc-get-prop', 'com.lab126.wifid', 'cmState'], stdout=subprocess.PIPE)
        response, _ = sp.communicate()
        if  response.find("CONNECTED") > -1:
            wifi = 'ON'
            break
        else:
            loop +=1
            sleep(1.5)
    if wifi == 'ON':
        subprocess.Popen(['ntpdate', '-u', 'ca.pool.ntp.org'], stdout=subprocess.PIPE).wait()
#       subprocess.Popen(['hwclock', '-w'], stdout=subprocess.PIPE) # is this needed anymore?
        subprocess.Popen(['lipc-set-prop', 'com.lab126.cmd', 'wirelessEnable', '0'], stdout=subprocess.PIPE)
    
def display_status():
    global wifi, mode
    sp = subprocess.Popen(['gasgauge-info', '-s'], stdout=subprocess.PIPE)
    bat, _ = sp.communicate()
    bat = int(bat)
    sp = subprocess.Popen(['lipc-get-prop', 'com.lab126.wifid', 'cmState'], stdout=subprocess.PIPE)
    response, _ = sp.communicate()
    if  response.find("CONNECTED") > -1:
        wifi = 'ON'
    else:
        wifi = 'OFF'
    command = 'fbink -t regular=/mnt/us/clock/bahnschrift.ttf,px=35,top=1410,format "    2BCOOL   MODE {}   WIFI {}   BATTERY {}    " -me'.format(mode,wifi,bat)
    os.system(command)

def display_date():
    global once, wifi, mode, days, months
    now = datetime.datetime.now()
    dom = now.day #1-31
    dowt = days[now.weekday()] #0-7
    montht = months[now.month-1] #1-12
    date = dowt + ' ' + montht + ' ' + str(dom)
    if once == 0:
        command = 'fbink -t regular=/mnt/us/clock/bahnschrift.ttf,px=95,top=600,format "{}"  -mec'.format(date)
    else:
        subprocess.Popen(['eips', '-d', 'l=ff,w=1072,h=95', '-y', '600'], stdout=subprocess.PIPE)
        command = 'fbink -t regular=/mnt/us/clock/bahnschrift.ttf,px=95,top=600,format "{}"  -me'.format(date)
    os.system(command)

def display_time():
    global digit1p, digit2p, digit3p, once, ampm, hour25, wifi, mode, bt, oncedash

# housekeeping done once at startup - display a

    if once == 0:
        print "updating time"
        time_check() # <--------------------- TIME CHECK
        sp = subprocess.Popen(['eips', 'c'], stdout=subprocess.PIPE)      
        display_date()
        display_status()
        
# get the current time and set the digits

    now = datetime.datetime.now()
    hour = now.hour
    hour24 = hour
    if hour > 12:
            hour = hour - 12
    minute = now.minute
    second = now.second
    digit1 = int(hour / 10)
    digit2 = hour % 10
    if digit1 == 0 and digit2 == 0:
            digit1 = 1
            digit2 = 2
    digit3 = int(minute / 10)
    digit4 = minute % 10
# redisplay the date at midnight, do a time check
    if hour24 == 0 and minute == 0:
        display_date()
        time_check # <--------------------- TIME CHECK
        bt = 0 # reset battery check flag

# display 1st digit as needed
    if once != 0:
        if digit1p != digit1:
            if digit1 == 0:
                command = 'echo 0 | fbink -i blank.png -g x=-88 -q'
            else:
                command = 'echo 0 | fbink -i 1.png -g x=-88 -q'
            os.system(command)
    else:
        if digit1 == 0:
            command = 'echo 0 | fbink -i blank.png -g x=-88 -q'
        else:
            command = 'echo 0 | fbink -i 1.png -g x=-88 -q'
        os.system(command)
    digit1p = digit1

# display 2nd digit if it has changed and check battery
    if digit2p != digit2:
        command = 'echo 0 | fbink -i {}.png -g x=161 -q'.format(digit2)
        os.system(command)
        digit2p = digit2
# test battery hourly and call battery low email script if low once/day
#        sp = subprocess.Popen(['gasgauge-info', '-s'], stdout=subprocess.PIPE)
#        bat, _ = sp.communicate()
#        bat = int(bat)
#        if bat < 26 and bt == 0:
#            subprocess.Popen(['python', '/mnt/us/clock/emailbat.py'], stdout=subprocess.PIPE)
#            bt = 1

# display colon only once
    if once == 0:
        command = 'echo 0 | fbink -i colon.png -g x=421 -q'
        os.system(command)
        once = 1
 
# display 3rd digit if it has changed and status line
    if digit3p != digit3:
        command = 'echo 0 | fbink -i {}.png -g x=500 -q'.format(digit3)
        os.system(command)
        digit3p = digit3

# display the 4th digit or '-' during low power every time as it always changes
    if mode == 'NORMAL':
        command = 'echo 0 | fbink -i {}.png -g x=762 -q'.format(digit4)
        os.system(command)
    else:
        if oncedash == 0:
            command = 'echo 0 | fbink -i dash.png -g x=762 -q' # display dash once in low power
            oncedash = 1
            os.system(command)
    
    display_status()

# display the correct am or pm indicator first time through and if it has changed to 0 or 12
    if ampm == 99 or (ampm != hour24 and (hour24 == 0 or hour24 == 12)):
        if hour24 < 12:
            command = 'echo 0 | fbink -i am.png -g x=1014 -q'
        else:
            command = 'echo 0 | fbink -i pm.png -g x=1014 -q'
    os.system(command)
    ampm = hour24
    
try:
    while True:
        second = 99
        now = datetime.datetime.now()
        hour = now.hour
        minute = now.minute
# woke up a little early, wait until on the minute except first time through when we want to display right away
        while second != 0 and oncex !=0:
            now = datetime.datetime.now()
            second = now.second
            sleep(0.1)
        if second == 99:
            second = now.second
        oncex = 1
        display_time()
# sleep for one minute till next time change, or 10 minutes during night to save energy and sync to the top of the minute
# start powersave mode on the 0N minute - bug does not go into low power for another minute n1 because we sleep for 59sec before next display
        if mode == 'NORMAL' and 8 > hour > -1 and minute%10 == 0:
            mode = 'LOWPWR'
            display_time()
            delay = 559 - second      # update only every ten minutes at night time 559
            time.sleep(delay)        #maybe make this small or delete line? to fix bug
        elif mode == 'LOWPWR' and 8 > hour > -1:
            display_time
            delay = 559 - second     # update only every ten minutes at night time 559
            time.sleep(delay)
        else:
            mode = 'NORMAL'
            oncedash = 0
            display_time
            delay = 59 - second   # wait until minute ticks over to sync the tick -1 second to allow for delays
            time.sleep(delay)

except KeyboardInterrupt:
	print ("kb interrupt")
finally:
	print ("exiting clock")
