# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.76"  #Technical Tweaks after compiling with Python 3.8

from polyglot.builtins import iteritems, range, unicode_type

BOOKS = "books"
DATA = "data"
COMMENTS = "comments"
IDENTIFIERS = "identifiers"
COUNTS = ":#"
COLON_PLACEHOLDER = "↑"
BLANK_PLACEHOLDER = "←"
SQL_SINGLE_QUOTE_PLACEHOLDER = "↓"
PSEUDO_COMMA_PLACEHOLDER = "↕"
PSEUDO_COMMA = "ˏ"  #sometimes used in Tags as a 'comma' since cannot use a 'real' comma...may expose a re module-related unicode version deficiency in current software environment...
LEFT_PARENS_PLACEHOLDER = "†"
RIGHT_PARENS_PLACEHOLDER = "‡"
FORWARD_SLASH_PLACEHOLDER = "↰"
ALL_PLACEHOLDERS = COLON_PLACEHOLDER + BLANK_PLACEHOLDER + SQL_SINGLE_QUOTE_PLACEHOLDER \
                                      + PSEUDO_COMMA_PLACEHOLDER + LEFT_PARENS_PLACEHOLDER +RIGHT_PARENS_PLACEHOLDER \
                                      + FORWARD_SLASH_PLACEHOLDER     #define as alphanumeric for regular expression purposes
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
def apply_vl_control(self,DEBUG,parsed_terms_list,type):
    book_id_list = []
    self.vl_get_custom_column_technical_details(self,DEBUG)
    vl_sql,is_valid = self.convert_vl_terms_to_sql(self,DEBUG,parsed_terms_list,type)
    if not is_valid:
        msg = vl_sql
        return book_id_list,is_valid,msg
    vl_sql = self.finalize_vl_sql(self,DEBUG,vl_sql)
    book_id_list,is_valid,msg = self.execute_vl_sql(self,DEBUG,vl_sql)
    return book_id_list,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def execute_vl_sql(self,DEBUG,vl_sql):
    book_id_list = []
    is_valid = True
    msg = ""

    my_db,my_cursor,is_valid = self.apsw_connect_to_library()
    if not is_valid:
        msg = 'Database Connection Error.  Cannot Connect to the Chosen Library.'
        return book_id_list,is_valid,msg

    if "REGEXP" in vl_sql:
        self.vl_apsw_create_user_functions(self,DEBUG,my_db,my_cursor,"REGEXP")
        if not is_valid:
            msg = 'User Function Error.  Cannot Create REGEXP User Function.'
            return book_id_list,is_valid,msg

    try:
        my_cursor.execute(vl_sql)
        tmp_rows = my_cursor.fetchall()
        if tmp_rows is None:
            tmp_rows = []
        for row in tmp_rows:   #  (26080,)
            for col in row:
                book_id_list.append(col)
        #END FOR
        del tmp_rows
    except Exception as e:
        is_valid = False
        msg = "execute_vl_sql: " + bytes(e)
        book_id_list = []
        if DEBUG: print(msg)

    return book_id_list,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_apsw_create_user_functions(self,DEBUG,my_db,my_cursor,func):
    try:
        if func == "REGEXP":
            my_db.createscalarfunction("regexp", self.vl_apsw_user_function_regexp)
            return True
        else:
            return False
    except Exception as e:
        if DEBUG: print("Create_SQLite_User_Function [3] failed...cannot proceed...")
        if DEBUG: print(bytes(e))
        return False
#---------------------------------------------------------------------------------------------------------------------------------------
def finalize_vl_sql(self,DEBUG,vl_sql):

    BEGINNING = "SELECT id AS books_id FROM books WHERE "
    ENDING = "  ;"

    if self.is_sql_negated:  # @usercategory:false in VL
        negated = "NOT "
    else:
        negated = ""

    vl_sql = BEGINNING + negated + vl_sql + ENDING

    vl_sql = vl_sql.replace("WHERE  AND NOT ","WHERE NOT ")
    vl_sql = vl_sql.replace("( AND NOT ","( NOT ")
    vl_sql = vl_sql.replace("( OR )"," OR ")  # artifact from a @usercategory in VL

    if self.is_user_category:
        vl_sql = vl_sql.replace(" REGEXP "," LIKE ")

    if DEBUG: print("SQL Query: ")
    if DEBUG: print("")
    if DEBUG: print(vl_sql)
    if DEBUG: print("")

    return vl_sql
#---------------------------------------------------------------------------------------------------------------------------------------
def convert_vl_terms_to_sql(self,DEBUG,parsed_terms_list,type):

    vl_sql = ""
    is_valid = True

    for term in parsed_terms_list:
        #~ if DEBUG: print(term)
        snip,is_valid = self.convert_vl_term_to_sql_snippet(self,DEBUG,term,type)
        #~ if DEBUG: print("====> snip: ", snip)
        if not is_valid:
            if snip.startswith("ERROR:"):
                vl_sql = "ERROR in VL SQL generation: <br><br>" + snip
            else:
                vl_sql = vl_sql + "     <br><br>ERROR in VL SQL generation for term: <br><br>" + term
            break
        else:
            snip = snip.replace("''","")       # 2 single quotes together that are invalid artifacts
            snip = snip.replace("'!'","''")    # 2 single quotes together that are not artifacts, and were temporarily protected with a !
            snip = snip.replace(SQL_SINGLE_QUOTE_PLACEHOLDER,"''")   # 2 single quotes together that SQLite treats as 1 single quote '   O''Reilly   o''clock
            snip = snip.replace(COLON_PLACEHOLDER,":")   # example:  tags:"=Award↑Hugo"  becomes  tags:"=Award:Hugo"  since temporarily protected with a ↑
            snip = snip.replace(BLANK_PLACEHOLDER," ")
            snip = snip.replace(PSEUDO_COMMA_PLACEHOLDER,PSEUDO_COMMA)
            snip = snip.replace(LEFT_PARENS_PLACEHOLDER,"(")
            snip = snip.replace(RIGHT_PARENS_PLACEHOLDER,")")
            snip = snip.replace(FORWARD_SLASH_PLACEHOLDER,"/")
            vl_sql = vl_sql + snip
    #END FOR

    #~ if DEBUG: print(vl_sql)

    if "AND  AND  AND" in vl_sql:
        vl_sql = vl_sql.replace("AND  AND  AND","AND")
    elif "OR  OR  OR" in vl_sql:
        vl_sql = vl_sql.replace("OR  OR  OR","OR")
    elif "AND NOT  AND NOT  AND NOT" in vl_sql:
        vl_sql = vl_sql.replace("AND NOT  AND NOT  AND NOT","AND NOT")
    elif "AND  AND" in vl_sql:
        vl_sql = vl_sql.replace("AND  AND","AND")
    elif "OR  OR" in vl_sql:
        vl_sql = vl_sql.replace("OR  OR","OR")
    elif "AND NOT  AND NOT" in vl_sql:
        vl_sql = vl_sql.replace("AND NOT  AND NOT","AND NOT")

    return vl_sql,is_valid
#---------------------------------------------------------------------------------------------------------------------------------------
def convert_vl_term_to_sql_snippet(self,DEBUG,term,type):

    is_valid = True
    snip = ""

    if term == "NOT":
        term = "AND NOT"

    if term == "AND" or term == "OR" or term == "AND NOT":
        snip = " " + term + " "
        return snip,is_valid

    if not term in self.sql_dict:
        #~ if DEBUG: print("term to build sql dict for: ", term)
        term = self.vl_build_sql_dict_for_term(self,DEBUG,term,type)

    snip = self.sql_dict[term]

    if snip == "ERROR":
        snip = 'ERROR: Invalid VL Syntax.  Check missing double quotes for search terms having a space.  Example:  tags:=Science Fiction  should be tags:"=Science Fiction" '
        is_valid = False

    return snip,is_valid
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_build_sql_dict_for_term(self,DEBUG,term,type):

    #~ if DEBUG: print("vl_build_sql_dict_for_term[BEGIN]: ", term, "  ", type)

    if not ":" in term:
        if type == "simple":
            if term.strip().upper() == "AND":    # " and "
                term_ = " AND "
                self.sql_dict[term] = term_
                return term
            if term.strip().upper() == " OR ":
                term_ = " OR "
                self.sql_dict[term] = term_
                return term
            if term.strip().upper() == " AND NOT ":
                term_ = " AND NOT "
                self.sql_dict[term] = term_
                return term
            if term.strip().upper() == " NOT ":
                term_ = " NOT "
                self.sql_dict[term] = term_
                return term

        if term.strip() == "(" or term.strip() == ")":
            self.sql_dict[term] = term
            return term
        elif term.strip() == "AND":
            self.sql_dict[term] = term
            return term
        elif term.strip() == "OR":
            self.sql_dict[term] = term
            return term
        elif term.strip() == "AND NOT":
            self.sql_dict[term] = term
            return term
        elif term.strip() == "NOT":
            self.sql_dict[term] = term
            return term
        else:
            if type == "simple":
                self.sql_dict[term] = "ERROR in vl_build_sql_dict_for_term; likely missing double quotes or other user error for: " + term  #example: user error in VL like:   tags:=Science Fiction    instead of  tags:"=Science Fiction"
                return term

    term = term.replace(" AND NOT AND NOT AND NOT "," AND NOT ")
    term = term.replace(" AND NOT AND NOT "," AND NOT ")
    term = term.replace(" NOT NOT NOT "," NOT ")
    term = term.replace(" NOT NOT "," NOT ")
    term = term.replace(" AND AND AND "," AND ")
    term = term.replace(" AND AND "," AND ")
    term = term.replace(" OR OR OR "," OR ")
    term = term.replace(" OR OR "," OR ")

    #~ if DEBUG: print('Original term prior to substitution:" ',term)
    c = term.count(":")
    if c > 0:
        f = term.find(":")
        target = term[ :(f+1)]
        #~ if DEBUG: print("target: ", target)
        value = term.replace(target,"",1)
        #~ if DEBUG: print("value: ", value)
        value = value.replace(":",COLON_PLACEHOLDER)
        value = value.replace(" ",BLANK_PLACEHOLDER)
        value = value.replace("/",FORWARD_SLASH_PLACEHOLDER)
        term = target + value  # example:  tags:"=Award:Hugo"
        #~ if DEBUG: print(' Colon & Blank Placeholders Substituted:" ',term)

    term,target,value,condition,original_value,skip = self.vl_convert_term_to_target_value_condition(self,DEBUG,term,type)

    if skip:   #table identifers vl_sql is always built elsewhere due to its VL syntax flexibility.   Tag and Tag-like '.' hierarchies: ditto.
        return term

    if target in self.custom_columns_label_dict:
        label_dict_tuple = self.custom_columns_label_dict[target]   #  id,label,name,datatype,display,is_multiple_normalized = self.custom_columns_label_dict[label]
        id,label,name,datatype,display,is_multiple,normalized = label_dict_tuple
        if datatype == "int" or datatype == "float":
            is_numeric = True
        else:
            is_numeric = False
        is_bool = False
        if datatype == "bool":
            is_bool = True
            is_numeric = True
        else:
            is_bool = False
            is_numeric = False
        is_custom = True
    else:
        label_dict_tuple = None  #Standard Column
        is_custom = False
        is_bool = False
        if target == "ratings":
            is_numeric = True
        else:
            is_numeric = False

    if not is_bool:
        if original_value == "yes" or original_value == "_yes" or original_value == "checked":
            condition =  " IS NOT NULL "
            value = ""
            is_numeric = False
        elif original_value == "no" or original_value == "_no" or original_value == "unchecked" or original_value == "blank" or original_value == "empty":
            condition =  " IS NULL "
            value = ""
            is_numeric = False
        else:
            pass
    elif is_bool:
        if original_value == "true" or original_value == "yes" or original_value == "_yes" or original_value == "checked":
            condition =  " = "
            value = 1
            is_numeric = True
        elif original_value == "false" or original_value == "no" or original_value == "_no":
            condition =  " = "
            value = 0
            is_numeric = True
        else:
            pass

    if isinstance(value,int) or isinstance(value,float):
        is_numeric = True
        value = bytes(value)

    #~ -------------------------------------------------------------------------------------------
    #~ table1 = "custom_column_N"                     or  "standard"
    #~ table2 = "books_custom_column_N_link"  or  "books_standard_link"
    #~ -------------------------------------------------------------------------------------------

    table1,table2 = self.vl_build_target_table_names(self,DEBUG,target,label_dict_tuple)

    #~ -------------------------------------------------------------------------------------------
    #~ Final SQL = "SELECT id FROM books WHERE   .....................snippet(s)......................     ;  "
    #~ -------------------------------------------------------------------------------------------

    if not table2:
        #unnormalized
        if condition ==  " IS NULL ":
            snippet = "NOT EXISTS (SELECT book FROM [TABLE1] WHERE book = books.id )"
        else:
            snippet = "EXISTS (SELECT book FROM [TABLE1] WHERE book = books.id AND [COLUMN] [CONDITION] [VALUE] )"
        if is_custom:
            #custom column
            snippet = snippet.replace("[TABLE1]",table1)
            snippet = snippet.replace("[COLUMN]","value")
            snippet = snippet.replace("[CONDITION]",condition)
            if not is_numeric:
                snippet = snippet.replace("[VALUE]",("'"+value+"'"))
            else:
                value = bytes(value)
                snippet = snippet.replace("[VALUE]",value)
        else:
            #standard column
            if table1 == DATA:
                #~ if DEBUG: print("elif table1 == DATA:",term)
                column = self.term_column_dict[term]
                datatype = self.table_data_column_datatype_dict[column]
                if datatype == "int":
                    is_numeric = True
                    snippet = snippet.replace("[TABLE1]",table1)
                    snippet = snippet.replace("[COLUMN]",column)
                    snippet = snippet.replace("[CONDITION]",condition)
                else:
                    is_numeric = False
                    snippet = snippet.replace("[TABLE1]",table1)
                    snippet = snippet.replace("[COLUMN]","format")
                    snippet = snippet.replace("[CONDITION]",condition)
                if not is_numeric:
                    snippet = snippet.replace("[VALUE]",("'"+value+"'"))
                else:
                    value = bytes(value)
                    snippet = snippet.replace("[VALUE]",value)
                #~ if DEBUG: print(table1,column,datatype,condition,value)
            elif table1 == COMMENTS:
                column = self.term_column_dict[term]
                snippet = snippet.replace("[TABLE1]",table1)
                snippet = snippet.replace("[COLUMN]",column)
                snippet = snippet.replace("[CONDITION]",condition)
                snippet = snippet.replace("[VALUE]",("'"+value+"'"))
            elif table1 == IDENTIFIERS:
                snippet = "ERROR: table identifiers selected erroneously"
                #~ if DEBUG: print(snippet)
            else:
                snippet = snippet.replace("[TABLE1]",table1)
                snippet = snippet.replace("[COLUMN]","name")
                snippet = snippet.replace("[CONDITION]",condition)
                snippet = snippet.replace("[VALUE]",("'"+value+"'"))
    else:
        #normalized
        #~ -------------------------------------------------------------------------------------------
        if is_custom:
            #custom normalized table
            if condition ==  " IS NULL ":
                snippet = "NOT EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id)"
            elif condition ==  " IS NOT NULL ":
                snippet = "EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id)"
            else:
                snippet = "EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id AND [COLUMN2] IN (SELECT id FROM [TABLE1] WHERE [COLUMN1] [CONDITION] [VALUE]))"
            snippet = snippet.replace("[TABLE2]",table2)
            snippet = snippet.replace("[COLUMN2]","value")
            snippet = snippet.replace("[TABLE1]",table1)
            snippet = snippet.replace("[COLUMN1]","value")
            snippet = snippet.replace("[CONDITION]",condition)
            if not is_numeric:
                snippet = snippet.replace("[VALUE]",("'"+value+"'"))
            else:
                value = bytes(value)
                snippet = snippet.replace("[VALUE]",value)
        #~ -------------------------------------------------------------------------------------------
        elif table1 == BOOKS:
            #standard table "books"
            column = self.term_column_dict[term]      #e.g.  "sort" = ["title_sort:true"]
            datatype = self.table_books_column_datatype_dict[column]     #e.g. "sort" = "text"
            if datatype == "text":  #e.g. title, title_sort, author_sort
                if condition ==  " IS NULL ":
                    snippet = "NOT EXISTS (SELECT id FROM books WHERE ([COLUMN] IS NULL OR [COLUMN] = '!' ) AND (id = books_id))"   #! is temporary.  a simple '' not used due to later artifact removal...
                elif condition ==  " IS NOT NULL ":
                    snippet = "EXISTS (SELECT id FROM books WHERE [COLUMN] IS NOT NULL OR [COLUMN] > '!' ) AND (id = books_id))"   #! is temporary.  a simple '' not used due to later artifact removal...
                else:
                    snippet = "EXISTS (SELECT id FROM books WHERE ([COLUMN] [CONDITION] [VALUE]) AND (id = books_id))"
                    snippet = snippet.replace("[CONDITION]",condition)
                    snippet = snippet.replace("[VALUE]",("'"+value+"'"))
                snippet = snippet.replace("[COLUMN]",column)
            elif datatype == "int":
                if column == "id":   # this is just testing for whether a specific books.id is to be selected at all...   e.g.  "id:123456  OR  id:456789"
                    snippet = "EXISTS (SELECT id FROM books WHERE (id = [VALUE]) AND (id = books_id))"
                    snippet = snippet.replace("[VALUE]",value)
                else:
                     snippet = "ERROR:  Book ID is the only valid table 'books' integer column; this column cannot be used: " + column  # e.g. 'flags'
            elif datatype == "float":  #e.g. series_index
                if condition ==  " IS NULL ":
                    snippet = "EXISTS (SELECT id FROM books WHERE ([COLUMN] IS NULL OR [COLUMN] = 0.0) AND (id = books_id))"
                elif condition ==  " IS NOT NULL ":
                    snippet = "EXISTS (SELECT id FROM books WHERE ([COLUMN] IS NOT NULL OR [COLUMN] >= 0.001) AND (id = books_id))"
                else:
                    snippet = "EXISTS (SELECT id FROM books WHERE ([COLUMN] [CONDITION] [VALUE]) AND (id = books_id))"
                    snippet = snippet.replace("[CONDITION]",condition)
                    snippet = snippet.replace("[VALUE]",value)
                snippet = snippet.replace("[COLUMN]",column)
            elif datatype == "bool":  #e.g. has_cover
                if condition ==  " IS NULL ":       # :false
                    snippet = "EXISTS (SELECT id FROM books WHERE ([COLUMN] IS NULL OR [COLUMN] = 0) AND (id = books_id))"
                elif condition ==  " IS NOT NULL ":   #:true
                    snippet = "EXISTS (SELECT id FROM books WHERE [COLUMN] = 1 '' )"
                else:
                    snippet = "ERROR: Boolean condition for column: " + column + "  " + condition + " in table 'books'"
                snippet = snippet.replace("[COLUMN]",column)
            elif datatype == "timestamp":  #e.g. timestamp, pubdate, last_modified
                if condition ==  " IS NULL ":
                    snippet = "EXISTS (SELECT id FROM books WHERE (subbytes([COLUMN],1,10) = '0101-01-01' ) AND (id = books_id))"
                elif condition ==  " IS NOT NULL ":
                    snippet = "EXISTS (SELECT id FROM books WHERE (subbytes([COLUMN],1,10) > '0101-01-01' ) AND (id = books_id))"
                else:
                    snippet = "EXISTS (SELECT id FROM books WHERE ([COLUMN] [CONDITION] [VALUE]) AND (id = books_id))"
                    snippet = snippet.replace("[CONDITION]",condition)
                    snippet = snippet.replace("[VALUE]",("'"+value+"'"))
                snippet = snippet.replace("[COLUMN]",column)
        #~ -------------------------------------------------------------------------------------------
        #~ -------------------------------------------------------------------------------------------
        else:
            #standard normalized table
            if not table2 in self.standard_column_column_names_dict:  #random user error in defining VL criteria
                self.sql_dict[term] = "ERROR: Unsupported Standard Table: " + table2
                return term
            if condition ==  " IS NULL ":
                snippet = "NOT EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id)"
            elif condition ==  " IS NOT NULL ":
                snippet = "EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id)"
            else:
                snippet = "EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id AND [COLUMN2] IN (SELECT id FROM [TABLE1] WHERE [COLUMN1] [CONDITION] [VALUE]))"
            snippet = snippet.replace("[TABLE2]",table2)
            column2 = self.standard_column_column_names_dict[table2]
            snippet = snippet.replace("[COLUMN2]",column2)
            snippet = snippet.replace("[TABLE1]",table1)
            column1 = self.standard_column_column_names_dict[table1]
            snippet = snippet.replace("[COLUMN1]",column1)
            snippet = snippet.replace("[CONDITION]",condition)
            if not is_numeric:
                snippet = snippet.replace("[VALUE]",("'"+value+"'"))
            else:
                value = bytes(value)
                snippet = snippet.replace("[VALUE]",value)

    #~ if DEBUG: print("vl_build_sql_dict_for_term[END]: ", term, "  ", type, "  snippet: ", snippet)

    self.sql_dict[term] = snippet

    return term
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_convert_term_to_target_value_condition(self,DEBUG,term,type):

    EQUALS = "="
    target = ""
    value = ""
    original_value = ""
    condition = ""

    skip = False

    #~ if DEBUG: print("vl_convert_term_to_target_value_condition for: ",term)

    if COUNTS in term:
        target,value,condition,original_value,skip = self.vl_parse_counts(self,DEBUG,term)
        return term,target,value,condition,original_value,skip #vl_sql for counts is built in self.vl_parse_counts

    if "identifiers:" in term:
        target = IDENTIFIERS
        term,condition,value,original_value,skip = self.vl_parse_identifiers_term(self,DEBUG,term)
        if skip:  #identifiers: uniquely may have multiple colons with complex ramifications, so except for trivial terms, vl_sql for identifiers is built by self.vl_parse_identifiers_term
            return term,target,value,condition,original_value,skip

    if not skip:
        if not target == IDENTIFIERS:
            #~ if DEBUG: print("term: ", term)
            c = term.count(":")
            if c > 0:
                f = term.find(":")
                target = term[0:f].strip()
                target = target.replace(":","")
                #~ if DEBUG: print("vl_convert_term_to_target_value_condition            target: ", target)
                value = term[f+1: ].strip()
                value = value.replace(":",COLON_PLACEHOLDER)   # example:  tags:"=Award:Hugo"
                value = value.replace(" ",BLANK_PLACEHOLDER)
                value = value.replace("/",FORWARD_SLASH_PLACEHOLDER)
                if "(" in value:   # example: #lcead:"=(Bisacsh)History
                    value = value.replace("(",LEFT_PARENS_PLACEHOLDER)
                if ")" in value:
                    value = value.replace(")",RIGHT_PARENS_PLACEHOLDER)
                if PSEUDO_COMMA in value:
                    value = value.replace(PSEUDO_COMMA,PSEUDO_COMMA_PLACEHOLDER)
                #~ if DEBUG: print("vl_convert_term_to_target_value_condition            value: ", value)
            else:
                msg = "[1] vl_convert_term_to_target_value_condition (VL ERROR","ERROR: term had no colon ':' " + term
                if DEBUG: print(msg)
                return term,target,value,condition,original_value,skip

    if target == "rating":  #VL search criterion for table ratings is an exception to naming convention for table names; usually plural:  tags, authors, publishers, etc.
        target = "ratings"
    elif target == "publisher":  #@UserCategory uses the singular
        target = "publishers"
    elif target == "formats":  #common user error
        target = "format"
    elif target == "comment":  #common user error
        target = "comments"

    if target in self.table_books_column_names_dict:
        self.term_column_dict[term] = self.table_books_column_names_dict[target]  #["title_sort"] ["sort"]
        col = self.table_books_column_names_dict[target]   # "timestamp" = ["date"]
        datatype = self.table_books_column_datatype_dict[col]  # "timestamp" = ["pubdate"]
        if datatype == "timestamp":
            value = self.vl_parse_books_timestamp(self,DEBUG,term,value)
        target = BOOKS
    elif target in self.table_data_column_names_dict:
        self.term_column_dict[term] = self.table_data_column_names_dict[target]  # "uncompressed_size" = ["size"]
        target = DATA
    elif target in self.table_comments_column_names_dict:
        self.term_column_dict[term] = self.table_comments_column_names_dict[target]  # "comments" = ["text"]
        target = COMMENTS

    value = value.replace('"','')          # e.g. ensure no double quotes " from :"=xxx"
    value = value.replace("'",SQL_SINGLE_QUOTE_PLACEHOLDER)    # e.g.  O'Reilly becomes O🤐Reilly

    original_value = value

    self.target_is_taglike = False

    if target in self.custom_columns_label_dict:
        id,label,name,datatype,display,is_multiple,normalized = self.custom_columns_label_dict[target]
        if datatype == "text" and is_multiple == 1 and normalized == 1:
            self.target_is_taglike = True
    elif target == "tags":
        self.target_is_taglike = True

    if self.target_is_taglike:
        if value.startswith('=.'):   #special tag/tag-like hierarchy search logic
            term,condition,value,original_value,skip = self.vl_parse_tag_hierarchy_term(self,DEBUG,target,term)
            if skip:  #vl_sql for tag/tag-like '.' hierarchies is built by self.vl_parse_tag_hierarchy_term
                return term,target,value,condition,original_value,skip

    if value.startswith(EQUALS):               #orig_title:=My Book Title
        condition = " " + EQUALS + " "
        value = value.replace(EQUALS,"").strip()
    elif value == "true":                            #orig_title:true
        condition =  " IS NOT NULL "
        value = ""
    elif value == "false":                           #orig_title:false
        condition =  " IS NULL "
        value = ""
    elif value == "yes" or value == "_yes" or value == "checked":           #mybool:yes
        condition =  " = "
        value = 1
    elif value == "no" or value == "_no" or value == "unchecked" or value == "blank" or value == "empty":         #mybool:no
        condition =  " = "
        value = 0
    elif value.startswith("!="):                   #pages:!=20
        condition =  " != "
        value = value.replace("!=","").strip()
    elif value.startswith(">="):                   #pages:>=20
        condition =  " >= "
        value = value.replace(">=","").strip()
    elif value.startswith("<="):                   #pages:<=20
        condition =  " <= "
        value = value.replace("<=","").strip()
    elif value.startswith(">"):                   #pages:>20
        condition =  " > "
        value = value.replace(">","").strip()
    elif value.startswith("<"):                   #pages:<20
        condition =  " < "
        value = value.replace("<","").strip()
    elif value.startswith("~"):                   #title:~Original    pubdate:~2009
        condition =  " REGEXP "
        value = value.replace("~","").strip()
    else: #~ Searches are by default ‘contains’.     #orig_title:My_Book_Title
        condition =  " REGEXP "
        value = value.strip()

    if target == DATA:
        value,condition = self.vl_parse_data_term(self,DEBUG,term,value,condition)  # parses 'size:' only

    skip = False
    return term,target,value,condition,original_value,skip
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_parse_identifiers_term(self,DEBUG,term):

    #~ if DEBUG: print("vl_parse_identifiers_term: ", term)

    s_split = term.split(":")
    target = s_split[0].strip().lower()
    value = s_split[1]

    if value == "true":                            #identifiers:true
        condition =  " IS NOT NULL "
        value = ""
        original_value = ""
        snippet = "EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type IS NOT NULL )"
        self.sql_dict[term] =  snippet
        skip = True   #vl_sql built here
        #~ if DEBUG: print("vl_parse_identifiers_term[0]",condition,value,original_value,skip)
        return term,condition,value,original_value,skip

    if value == "false":                           #identifiers:false
        condition =  " IS NULL "
        value = ""
        original_value = ""
        snippet = "NOT EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type IS NOT NULL )"
        self.sql_dict[term] =  snippet
        skip = True   #vl_sql built here
        #~ if DEBUG: print("vl_parse_identifiers_term[1]",condition,value,original_value,skip)
        return term,condition,value,original_value,skip

    del s_split

    term = term.replace(COLON_PLACEHOLDER,":")  #restore the colons within the value for identifier type

    condition = ""
    value = term[12: ]  #  identifiers:
    original_value = value

    #~ if DEBUG: print("value: ", value)

    if not ":" in value:
        #~ 123 will search for books with any type having a value containing 123.
        #~ =123456789 will search for books with any type having a value equal to 123456789.
        value = value.replace("=","").strip()
        condition = "~"
        snippet = "EXISTS (SELECT book FROM identifiers WHERE book = books.id AND val REGEXP [PATTERN] )"
        snippet = snippet.replace("[PATTERN]",("'" + value + "'"))
        self.sql_dict[term] =  snippet
        skip = True   #vl_sql built here
        #~ if DEBUG: print("vl_parse_identifiers_term[2]",condition,value,original_value,skip)
        return term,condition,value,original_value,skip

    """
    'identifiers:'  plus one of the following:
    i:1                            will find books with a type containing an i having a value containing a 1.
    =isbn:                      will find books with a type equal to isbn having any value
    isbn:true                  will find books with a type equal to isbn having any value
    =isbn:false               will find books with no type equal to isbn.
    =isbn:123                will find books with a type equal to isbn having a value containing 123.
    =isbn:=123456789  will find books with a type equal to isbn having a value equal to 123456789.
    """

    p0 = "(?P<operator>^[=]*)(?P<type>[a-z-_0-9" + ",'" + ALL_PLACEHOLDERS + "]*[:])(?P<exists>[true|false]+)*(?P<valoperator>[=]*)(?P<valvalue>[0-9]*)"
    r0 = self.regex.compile(p0,self.regex.IGNORECASE)
    match_r0 = r0.search(value)
    if not match_r0:
        value = "ERROR in identifiers: not match_r0 for: " + value
        condition = value
        original_value = value
        skip = True
        #~ if DEBUG: print("vl_parse_identifiers_term[3]",condition,value,original_value,skip)
        self.sql_dict[term] = value
        return term,condition,value,original_value,skip

    g_operator = match_r0.group("operator")
    g_type = match_r0.group("type")
    g_exists = match_r0.group("exists")
    g_valoperator = match_r0.group("valoperator")
    g_valvalue = match_r0.group("valvalue")

    g_type = g_type.replace(":","")

    #~ if DEBUG:
        #~ print("g_operator:", g_operator)
        #~ print("g_type: ",g_type)
        #~ print("g_exists: ",g_exists)
        #~ print("g_valoperator:", g_valoperator)
        #~ print("g_valvalue: ",g_valvalue)

    if len(g_operator) > 0:
        is_operator = True
    else:
        is_operator = False

    #~ if DEBUG: print("is_operator: ", is_operator)

    if len(g_type) > 0:
        is_type = True
    else:
        is_type = False
        if DEBUG: print("ERROR: is_type is False...regular expression p0 error...")

    #~ if DEBUG: print("is_type: ", is_type)

    if g_exists is not None:
        is_exists = True
    else:
        is_exists = False

    #~ if DEBUG: print("is_exists: ", is_exists)

    if len(g_valoperator) > 0:
        is_valoperator = True
    else:
        is_valoperator = False

    #~ if DEBUG: print("is_valoperator:", is_valoperator)

    if len(g_valvalue) > 0:
        is_valvalue = True
    else:
        is_valvalue = False

    #~ if DEBUG: print("is_valvalue:", is_valvalue)

    if not is_type:
        condition =  "ERROR in identifiers parsing: not is_type."
        value = "ERROR in identifiers parsing: not is_type."
        original_value = "ERROR in identifiers parsing: not is_type."
        skip = True   #error
        #~ if DEBUG: print("vl_parse_identifiers_term[4]",condition,value,original_value,skip)
        self.sql_dict[term] = value
        return term,condition,value,original_value,skip

    if is_exists:  # isbn:true   =isbn:false
        type = g_type
        value = g_exists.lower().strip()
        if value == "true":  # isbn:true   =isbn:true
            condition =  ""
            value = ""
            original_value = ""
            snippet = "EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type = [TYPE] )"
            snippet = snippet.replace("[TYPE]",("'" + g_type + "'"))
            self.sql_dict[term] = snippet
            skip = True    #vl_sql was built here...
            #~ if DEBUG: print("vl_parse_identifiers_term[5]",condition,value,original_value,skip,snippet)
            self.sql_dict[term] = snippet
            return term,condition,value,original_value,skip
        if value == "false":  # isbn:false   =isbn:false
            condition =  ""
            value = ""
            original_value = ""
            snippet = "NOT EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type = [TYPE] )"
            snippet = snippet.replace("[TYPE]",("'" + g_type + "'"))
            self.sql_dict[term] = snippet
            skip = True    #vl_sql was built here...
            #~ if DEBUG: print("vl_parse_identifiers_term[6]",condition,value,original_value,skip,snippet)
            self.sql_dict[term] = snippet
            return term,condition,value,original_value,skip

    if is_operator:  #  =isbn:   =isbn:123   =isbn:=123456789
        if is_valvalue:             # =isbn:123   =isbn:=123456789
            skip = True
            snippet = "EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type = [TYPE] AND val REGEXP [VALUE] )"
            snippet = snippet.replace("[TYPE]",("'" + g_type + "'"))
            snippet = snippet.replace("[VALUE]",("'" + g_valvalue + "'"))
            #~ if DEBUG: print("vl_parse_identifiers_term[7]",condition,value,original_value,skip,snippet)
            self.sql_dict[term] = snippet
            return term,condition,value,original_value,skip
        else:            #  =isbn:
            skip = True
            snippet = "EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type = [TYPE] )"
            snippet = snippet.replace("[TYPE]",("'" + g_type + "'"))
            #~ if DEBUG: print("vl_parse_identifiers_term[8]",condition,value,original_value,skip,snippet)
            self.sql_dict[term] = snippet
            return term,condition,value,original_value,skip

    else:    #   i:1                            will find books with a type containing an i having a value containing a 1.
        skip = True
        condition = ""
        snippet = "EXISTS (SELECT book FROM identifiers WHERE book = books.id AND type REGEXP [TYPE] AND val REGEXP [VALUE] )"
        snippet = snippet.replace("[TYPE]",("'" + g_type + "'"))
        snippet = snippet.replace("[VALUE]",("'" + g_valvalue + "'"))
        #~ if DEBUG: print("vl_parse_identifiers_term[9]",condition,value,original_value,skip,snippet)
        self.sql_dict[term] = snippet
        return term,condition,value,original_value,skip
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_parse_tag_hierarchy_term(self,DEBUG,target,term):

    condition =  ""
    value = ""
    original_value = ""
    skip = True

    #~ placeholders for characters that might confuse the re module but that should be considered as valid alpha-numerics in the regular expression
    term = term.replace("/",FORWARD_SLASH_PLACEHOLDER)
    if "(" in term:   # example: tags:=.(Bisacsh)History
        term = term.replace("(",LEFT_PARENS_PLACEHOLDER)
    if ")" in term:
        term = term.replace(")",RIGHT_PARENS_PLACEHOLDER)
    if PSEUDO_COMMA in term:
        term = term.replace(PSEUDO_COMMA,PSEUDO_COMMA_PLACEHOLDER)

    placeholders = FORWARD_SLASH_PLACEHOLDER + LEFT_PARENS_PLACEHOLDER + RIGHT_PARENS_PLACEHOLDER + PSEUDO_COMMA_PLACEHOLDER

    p = "[:][=][.][a-zA-Z0-9_ &!]+[.]*[a-zA-Z0-9_ &!]*[.]*[a-zA-Z0-9_ &!]*[.]*[a-zA-Z0-9_ &!]*[.]*[a-zA-Z0-9_ &!]*[.]*[a-zA-Z0-9_ &!]*"       #cs_tag_hierarchy:=.factual.business.finance.accounting.cost.product costing
    p = p.replace("!",placeholders)
    r = self.regex.compile(p,self.regex.IGNORECASE)
    match_p = r.search(term)
    if match_p:
        case = 1
        value = match_p.group()
        value = value.replace(PSEUDO_COMMA_PLACEHOLDER,PSEUDO_COMMA)
        value = value.replace(LEFT_PARENS_PLACEHOLDER,"(")
        value = value.replace(RIGHT_PARENS_PLACEHOLDER,")")
        value = value.replace(FORWARD_SLASH_PLACEHOLDER,"/")
        original_value = value
        if value.startswith(":"):
            value = value[1: ]
        if value.startswith("="):
            value = value[1: ]
        if value.startswith("."):
            value = value[1: ]
        value2 = value
        value1 = "^" + value + "[.]*.*$"
        condition = "REGEXP"
    else:
        case = 0
        value = "ERROR in Tag Hierarchy Search for: " + term

    #~ -------------------------------------------------------------------------------------------
    #~ table1 = "custom_column_N"                     or  "tags"
    #~ table2 = "books_custom_column_N_link"  or  "books_tags_link"
    #~ -------------------------------------------------------------------------------------------
    if target in self.custom_columns_label_dict:
        label_dict_tuple = self.custom_columns_label_dict[target]   #  id,label,name,datatype,display,is_multiple_normalized = self.custom_columns_label_dict[label]
        is_cc = True
    else:
        label_dict_tuple = None
        target = "tags"
        is_cc = False

    table1,table2 = self.vl_build_target_table_names(self,DEBUG,target,label_dict_tuple)

    if case == 1:
        if is_cc:
            #~ ---part1
            snippet = "(EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id AND [COLUMN2] IN (SELECT id FROM [TABLE1] WHERE [COLUMN1] [CONDITION] [VALUE]))"
            snippet = snippet.replace("[TABLE2]",table2)
            snippet = snippet.replace("[COLUMN2]","value")
            snippet = snippet.replace("[TABLE1]",table1)
            snippet = snippet.replace("[COLUMN1]","value")
            snippet = snippet.replace("[CONDITION]",condition)
            snippet1 = snippet.replace("[VALUE]",("'"+value1+"'"))
            #~ ---part2
            snippet = "EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id AND [COLUMN2] IN (SELECT id FROM [TABLE1] WHERE [COLUMN1] [CONDITION] [VALUE]))  )"
            snippet = snippet.replace("[TABLE2]",table2)
            snippet = snippet.replace("[COLUMN2]","value")
            snippet = snippet.replace("[TABLE1]",table1)
            snippet = snippet.replace("[COLUMN1]","value")
            snippet = snippet.replace("[CONDITION]","=")
            snippet2 = snippet.replace("[VALUE]",("'"+value2+"'"))
            #~ ---final
            snippet = snippet1 + " OR " + snippet2
            self.sql_dict[term] =  snippet
            del snippet1
            del snippet2
        else: #table tags
            #~ ---part1
            snippet = "(EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id AND [COLUMN2] IN (SELECT id FROM [TABLE1] WHERE [COLUMN1] [CONDITION] [VALUE]))"
            snippet = snippet.replace("[TABLE2]",table2)
            snippet = snippet.replace("[COLUMN2]","tag")
            snippet = snippet.replace("[TABLE1]",table1)
            snippet = snippet.replace("[COLUMN1]","name")
            snippet = snippet.replace("[CONDITION]",condition)
            snippet1 = snippet.replace("[VALUE]",("'"+value1+"'"))
            #~ ---part2
            snippet = "EXISTS (SELECT book FROM [TABLE2] WHERE book = books.id AND [COLUMN2] IN (SELECT id FROM [TABLE1] WHERE [COLUMN1] [CONDITION] [VALUE]))  )"
            snippet = snippet.replace("[TABLE2]",table2)
            snippet = snippet.replace("[COLUMN2]","tag")
            snippet = snippet.replace("[TABLE1]",table1)
            snippet = snippet.replace("[COLUMN1]","name")
            snippet = snippet.replace("[CONDITION]","=")
            snippet2 = snippet.replace("[VALUE]",("'"+value2+"'"))
            #~ ---final
            snippet = snippet1 + " OR " + snippet2
            self.sql_dict[term] =  snippet
            del snippet1
            del snippet2
    else:
        snippet = "ERROR in Tag/Tag-Like Hierarchy Search with term: " + term
        self.sql_dict[term] =  snippet

    del placeholders
    del p
    del r
    del match_p
    del snippet

    return term,condition,value,original_value,skip
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_parse_data_term(self,DEBUG,term,value,condition):

    if "format:" in term:
        return value,condition

    if not "size:" in term:
        return value,condition

    #~ if DEBUG: print("original term for size: is: ", term)

    original_condition = condition
    #~ if DEBUG: print("original condition for size: is: ", original_condition)

    original_value = value
    #~ if DEBUG: print("original value for size: is: ", value)

    value = value.upper().strip()
    #~ if DEBUG: print("standardized value for size: is: ", value)

    p1 = "[0-9.]+[KM]*"
    r1 = self.regex.compile(p1,self.regex.IGNORECASE)
    match_p1 = r1.search(value)
    if match_p1:
        s = match_p1.group()
        #~ if DEBUG: print("size regex group: ", s)
        value = value.replace(s,"")
        try:
            if "K" in s:
                value = value.replace(s,"")
                s = s.replace("K","").strip()
                s = float(s)
                value = value + bytes(int(s * 1024))
                value = unicode_type(value)
            elif "M" in s:                                        # size:>1.1M
                value = value.replace(s,"")              # size:>
                s = s.replace("M","").strip()            #          1.1
                s = float(s)
                value = value + bytes(int(s * 1048576 ))    # 1.1 * 1048576
                value = unicode_type(value)
            else:  #  size:>1048576
                value = original_value
                condition = original_condition
        except Exception as e:
            if DEBUG: print("Error in vl_parse_data_term for: ", term, "  ", value, "  ", original_value)
            value = "ERROR"
    else:  #should not occur
        value = original_value
        condition = original_condition

    #~ if DEBUG: print("table data size final:  value is: ", value, "  for condition: ", condition, "  for term: ", term)

    del match_p1

    return value,condition
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_parse_books_timestamp(self,DEBUG,term,value):

    kw_list = []
    kw_list.append("_today")
    kw_list.append("today")
    kw_list.append("_yesterday")
    kw_list.append("yesterday")
    kw_list.append("_daysago")
    kw_list.append("daysago")
    kw_list.append("_thismonth")
    kw_list.append("thismonth")

    #~ if DEBUG: print("now: ", bytes(self.now))

    condition = ""

    kw = None
    for word in kw_list:
        if word in value:
            kw = word
            kw = kw.replace("_","")
            break
    #END FOR
    if kw is not None:
        if kw == "today":
            today = self.datetime.today()
            today = today.isoformat()
            value = today[0:10].strip()
            condition = "~"
            value = condition + value
            #~ if DEBUG: print("today: ", value)
            return value
        if kw == "yesterday":
            today = self.datetime.today()
            yesterday = today - self.timedelta(1)
            yesterday = yesterday.isoformat()
            value = yesterday[0:10].strip()
            condition = "~"
            value = condition + value
            #~ if DEBUG: print("yesterday: ", value)
            return value
        if kw == "thismonth":
            today = self.datetime.today()
            today = today.isoformat()
            thismonth = today[0:8]           #  2018-11
            value = thismonth.strip()
            condition = "~"
            value = condition + value
            #~ if DEBUG: print("thismonth: ", value)
            return value
        if kw == "daysago":
            today = self.datetime.today()
            v = value.replace("daysago","").strip()
            if v.isdigit():
                n = int(v)
                daysago = today - self.timedelta(n)
                daysago = daysago.isoformat()
                daysago = daysago[0:10]
            else:
                daysago = "ERROR"
            value = daysago.strip()
            condition = "~"
            value = condition + value
            #~ if DEBUG: print("daysago: ", value)
            return value
    else:
        pass

    n_dashes = value.count("-")

    if n_dashes == 0:      # pubdate:=2009  pubdate:2009   pubdate:true  pubdate:false
        p_yyyy  = "^[=]*[0-9]+$"                               # pubdate:=2009  pubdate:2009       all books published in 2009
        r_yyyy = self.regex.compile(p_yyyy,self.regex.IGNORECASE)
        match_r_yyyy = r_yyyy.search(value)
        if match_r_yyyy:
            condition =  " REGEXP "
            value = match_r_yyyy.group()
            value = value.replace("=","")
            del match_r_yyyy
            condition = "~"
            value = condition + value
            return value
        else:                                                                 # pubdate:true  pubdate:false
            del match_r_yyyy
            value = value.lower()
            if value == "true":
                pass
            elif value == "false":
                pass
            else:
                value = "ERROR in VL date with no dashes" + value
            return value

    if n_dashes == 1:    # pubdate:2000-1  pubdate:=2000-1    pubdate:>2000-1     pubdate:<2000-1
        p_yyyy_mm = "^[=><]+[0-9]+[-][0-9]+"        #pubdate:=2000-1    pubdate:>2000-1     pubdate:<2000-1
        r_yyyy_mm = self.regex.compile(p_yyyy_mm,self.regex.IGNORECASE)
        match_r_yyyy_mm = r_yyyy_mm.search(value)
        if match_r_yyyy_mm:
            if value.startswith("="):
                del match_r_yyyy_mm
                value = value.replace("=","~")
                return value
            else:
                del match_r_yyyy_mm
                return value
        else:
            p_yyyy_mm = "^[0-9]+[-][0-9]+"        # pubdate:2000-1
            r_yyyy_mm = self.regex.compile(p_yyyy_mm,self.regex.IGNORECASE)
            match_r_yyyy_mm = r_yyyy_mm.search(value)
            if match_r_yyyy_mm:
                del match_r_yyyy_mm
                condition = "~"
                value = condition + value
                return value
            else:
                del match_r_yyyy_mm
                value = "ERROR:" + value
                return value

    if n_dashes == 2:  #  pubdate:2000-01-01     pubdate:=2000-01-01  pubdate:>2000-01-01
        p_yyyy_mm_dd = "^[=><]+[0-9]+[-][0-9]+[-][0-9]+"  #  pubdate:2000-01-01     pubdate:=2000-01-01  pubdate:>2000-01-01
        r_yyyy_mm_dd = self.regex.compile(p_yyyy_mm_dd,self.regex.IGNORECASE)
        match_r_yyyy_mm_dd = r_yyyy_mm_dd.search(value)
        if match_r_yyyy_mm_dd:
            if value.startswith("="):
                del match_r_yyyy_mm_dd
                value = value.replace("=","~")
                return value
            else:
                del match_r_yyyy_mm_dd
                return value
        else:
            p_yyyy_mm_dd = "^[0-9]+[-][0-9]+"        # pubdate:2000-1
            r_yyyy_mm_dd = self.regex.compile(p_yyyy_mm_dd,self.regex.IGNORECASE)
            match_r_yyyy_mm = r_yyyy_mm.search(value)
            if match_r_yyyy_mm_dd:
                del match_r_yyyy_mm_dd
                condition = "~"
                value = condition + value
                return value
            else:
                del match_r_yyyy_mm_dd
                value = "ERROR:" + value
                return value

    #  pubdate:>0101-01-01 00:00:00.000
    p_yyy_mm_dd_000000000 = "^[=><]+[0-9]+[-][0-9]+[-][0-9]+[ ][0-9:.]+$"    #  pubdate:>0101-01-01 00:00:00.000
    r_yyy_mm_dd_000000000 = self.regex.compile(p_yyy_mm_dd_000000000,self.regex.IGNORECASE)
    match_r_yyy_mm_dd_000000000 = r_yyy_mm_dd_000000000.search(value)
    if match_r_yyyy_mm_dd_000000000:
        del match_r_yyyy_mm_dd_000000000
        return value
    else:
        del match_r_yyyy_mm_dd_000000000

    #catch-all
    p_operators = "^[=><!]+"     #  =  <=  >=  !=
    r_operators = self.regex.compile(p_operators,self.regex.IGNORECASE)
    match_r_operators = r_operators.search(value)
    if match_r_operators:
        del match_r_operators
        return value
    else:
        del match_r_operators
        condition = "~"
        value = condition + value
        return value
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_parse_counts(self,DEBUG,term):

    condition = ""
    skip = True

    s_split = term.split(COUNTS)
    if len(s_split) == 2:
        target = s_split[0].strip()
        value = s_split[1].strip()
        original_value = value
    else:
        target = "count error for: " + term
        value = "count error for: " + term
        original_value = value
        self.sql_dict[term] = value
        return target,value,condition,original_value,skip

    if value.startswith("<="):
        valoperator = "<="
    elif value.startswith("<"):
        valoperator = "<"
    elif value.startswith(">="):
        valoperator = ">="
    elif value.startswith(">"):
        valoperator = ">"
    elif value.startswith("!="):
        valoperator = "!="
    else:
        valoperator = "="

    value = value.replace(valoperator,"").strip()
    if not value.isdigit():
        value = "ERROR: " + value
        self.sql_dict[term] = value
        return target,value,condition,original_value,skip

    valvalue = value

    if target == "formats":
        snippet = "EXISTS (SELECT count(*) FROM data WHERE data.book = books_id GROUP BY book HAVING count(*) [CONDITION] [VALUE] )"
    elif target == "tags":
        snippet = "EXISTS (SELECT count(*) FROM books_tags_link WHERE books_tags_link.book = books_id GROUP BY book HAVING count(*) [CONDITION] [VALUE] )"
    elif target == "authors":
        snippet = "EXISTS (SELECT count(*) FROM books_authors_link WHERE books_authors_link.book = books_id GROUP BY book HAVING count(*) [CONDITION] [VALUE])"
    elif target == "identifiers":
        snippet = "EXISTS (SELECT count(*) FROM identifiers WHERE identifiers.book = books_id GROUP BY book HAVING count(*) [CONDITION] [VALUE])"
    elif target == "languages":
        snippet = "EXISTS (SELECT count(*) FROM books_languages_link WHERE books_languages_link.book = books_id GROUP BY book HAVING count(*) [CONDITION] [VALUE])"
    elif target.startswith("#"):
        if target in self.custom_columns_label_dict:
            id,label,name,datatype,display,is_multiple,normalized = self.custom_columns_label_dict[target]
        else:
            target = "ERROR-Unsupported Target for COUNTS: " + target
            self.sql_dict[term] = target
            return target,value,condition,original_value,skip
        if not (is_multiple == 1 and normalized == 1):
            target = "ERROR-Unsupported Target for COUNTS: " + target
            self.sql_dict[term] = target
            return target,value,condition,original_value,skip
        snippet = "EXISTS (SELECT count(*) FROM books_custom_column_[NN]_link WHERE books_custom_column_[NN]_link.book = books_id GROUP BY book HAVING count(*) [CONDITION] [VALUE] )"
        snippet = snippet.replace("[NN]",bytes(id))
    else:
        target == "ERROR-Unsupported Target for COUNTS: " + target
        snippet = target

    snippet = snippet.replace("[CONDITION]",valoperator)
    snippet = snippet.replace("[VALUE]",valvalue)

    self.sql_dict[term] = snippet

    return target,value,condition,original_value,skip
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_build_target_table_names(self,DEBUG,target,label_dict_tuple):
    if label_dict_tuple is None:
        #Standard Columns
        if target in self.unnormalized_standard_column_list:  #data; comments; identifiers
            target = target.lower()
            table1 = target
            table2 = None
        elif target == BOOKS:
            table1 = BOOKS
            table2 = BOOKS
        else:
            target = target.lower()
            table1 = target
            table2 = "books_[STANDARDCOLUMN]_link"
            table2 = table2.replace("[STANDARDCOLUMN]",target)
    else:
        #Custom Columns
        id,label,name,datatype,display,is_multiple,normalized = label_dict_tuple
        if normalized == 0:
            table1 = "custom_column_[NN]"
            table1 = table1.replace("[NN]",bytes(id))
            table2 = None
        else:
            table1 = "custom_column_[NN]"
            table2 = "books_custom_column_[NN]_link"
            table1 = table1.replace("[NN]",bytes(id))
            table2 = table2.replace("[NN]",bytes(id))

    del label_dict_tuple

    return table1,table2
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_get_custom_column_technical_details(self,DEBUG):
    my_db,my_cursor,is_valid = self.apsw_connect_to_library()
    if not is_valid:
         return error_dialog(self.gui, _('CalibreSpy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

    self.custom_columns_label_dict = {}  #   #label = id,label,name,datatype,display,is_multiple,normalized
    self.vl_current_custom_columns_list = []  #label

    mysql = "SELECT id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized FROM custom_columns ORDER BY label,name"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        tmp_rows = []
    for row in tmp_rows:
        id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized = row
        label = "#" + label
        self.custom_columns_label_dict[label] = id,label,name,datatype,display,is_multiple,normalized
        self.vl_current_custom_columns_list.append(label)
    #END FOR
    del tmp_rows

    self.vl_current_custom_columns_list.sort()

    my_db.close()
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_build_standard_column_names_dict(self,DEBUG):
    self.standard_column_column_names_dict = {}
    self.standard_column_column_names_dict["authors"] = "name"
    self.standard_column_column_names_dict["books_authors_link"] = "author"
    self.standard_column_column_names_dict["comments"] = "text"
    self.standard_column_column_names_dict["languages"] = "lang_code"
    self.standard_column_column_names_dict["books_languages_link"] = "lang_code"
    self.standard_column_column_names_dict["publishers"] = "name"
    self.standard_column_column_names_dict["books_publishers_link"] = "publisher"
    self.standard_column_column_names_dict["ratings"] = "rating"
    self.standard_column_column_names_dict["books_ratings_link"] = "rating"
    self.standard_column_column_names_dict["series"] = "name"
    self.standard_column_column_names_dict["books_series_link"] = "series"
    self.standard_column_column_names_dict["tags"] = "name"
    self.standard_column_column_names_dict["books_tags_link"] = "tag"

    self.standard_column_column_names_dict["books"] = "books"
    self.standard_column_column_names_dict["data"] = "data"
    self.standard_column_column_names_dict["identifiers"] = "identifiers"

    self.table_books_column_names_dict = {}
    self.table_books_column_names_dict["id"] = "id"
    self.table_books_column_names_dict["title"] = "title"
    self.table_books_column_names_dict["title_sort"] = "sort"
    self.table_books_column_names_dict["added"] = "timestamp"
    self.table_books_column_names_dict["timestamp"] = "timestamp"
    self.table_books_column_names_dict["date"] = "timestamp"
    self.table_books_column_names_dict["pubdate"] = "pubdate"
    self.table_books_column_names_dict["published"] = "pubdate"
    self.table_books_column_names_dict["series_index"] = "series_index"
    self.table_books_column_names_dict["author_sort"] = "author_sort"
    self.table_books_column_names_dict["cover"] = "has_cover"
    self.table_books_column_names_dict["last_modified"] = "last_modified"

    self.table_books_column_datatype_dict = {}
    self.table_books_column_datatype_dict["id"] = "int"
    self.table_books_column_datatype_dict["title"] = "text"
    self.table_books_column_datatype_dict["sort"] = "text"
    self.table_books_column_datatype_dict["timestamp"] = "timestamp"
    self.table_books_column_datatype_dict["pubdate"] = "timestamp"
    self.table_books_column_datatype_dict["series_index"] = "float"
    self.table_books_column_datatype_dict["author_sort"] = "text"
    self.table_books_column_datatype_dict["has_cover"] = "bool"
    self.table_books_column_datatype_dict["last_modified"] = "timestamp"

    self.table_comments_column_names_dict = {}
    self.table_comments_column_names_dict["comments"] = "text"

    self.table_comments_column_datatype_dict = {}
    self.table_comments_column_datatype_dict["text"] = "text"

    self.table_data_column_names_dict = {}
    self.table_data_column_names_dict["size"] = "uncompressed_size"
    self.table_data_column_names_dict["format"] = "format"

    self.table_data_column_datatype_dict = {}
    self.table_data_column_datatype_dict["uncompressed_size"] = "int"
    self.table_data_column_datatype_dict["format"] = "text"

    self.table_identifiers_column_names_dict = {}
    self.table_identifiers_column_names_dict["type"] = "type"
    self.table_identifiers_column_names_dict["val"] = "val"

    self.table_identifiers_column_identifierstype_dict = {}
    self.table_identifiers_column_identifierstype_dict["type"] = "text"
    self.table_identifiers_column_identifierstype_dict["val"] = "text"

    self.unnormalized_standard_column_list = []
    self.unnormalized_standard_column_list.append("comments")
    self.unnormalized_standard_column_list.append("data")
    self.unnormalized_standard_column_list.append("identifiers")

    self.term_column_dict = {}    #example:  self.term_column_dict["title_sort:true"] = "sort"
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_control(self,DEBUG,current_vl_criteria):

    self.is_sql_negated = False
    is_valid = True
    msg = ""

    if "vl:" in current_vl_criteria:
        current_vl_criteria,is_valid,msg = self.vl_search_criteria_parser_another_vl(self,DEBUG,current_vl_criteria)
        if not is_valid:
            type = "unknown"
            parsed_terms_list = []
            return parsed_terms_list,is_valid,msg,type

    if "@" in current_vl_criteria:
        self.is_user_category = True
        current_vl_criteria,is_valid,msg = self.vl_search_criteria_parser_user_categories(self,DEBUG,current_vl_criteria)
        if not is_valid:
            type = "unknown"
            parsed_terms_list = []
            return parsed_terms_list,is_valid,msg,type
    else:
        self.is_user_category = False

    if "search:" in current_vl_criteria:
        current_vl_criteria,is_valid,msg = self.vl_search_criteria_parser_saved_searches(self,DEBUG,current_vl_criteria)
        if not is_valid:
            type = "unknown"
            parsed_terms_list = []
            return parsed_terms_list,is_valid,msg,type

    if current_vl_criteria.startswith("rating:") or current_vl_criteria.startswith("(rating:"):
        current_vl_criteria.replace("rating:","ratings:")  #rating breaks the naming standard regarding searching table names like tags:, publishers:, etc.
    else:
        current_vl_criteria.replace(" rating:"," ratings:")

    current_vl_criteria = current_vl_criteria.replace("!=","!=")

    if "(" in current_vl_criteria:
        type = "complex"
        parsed_terms_list,is_valid,msg = self.vl_search_criteria_parser_complex(self,DEBUG,current_vl_criteria)
    else:
        type = "simple"
        parsed_terms_list,is_valid,msg = self.vl_search_criteria_parser_simple(self,DEBUG,current_vl_criteria)

    return parsed_terms_list,is_valid,msg,type
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_simple(self,DEBUG,current_vl_criteria):

    #~ if DEBUG: print("Simple VL Selected:   ", current_vl_criteria)

    current_vl_criteria = current_vl_criteria.replace("   "," ")
    current_vl_criteria = current_vl_criteria.replace("  "," ")

    parsed_terms_list = []
    is_valid = True
    msg = ""

    current_vl_criteria,is_valid,msg = self.vl_search_criteria_parser_implied_and_handler(self,DEBUG,current_vl_criteria)
    if not is_valid:
        return parsed_terms_list,is_valid,msg

    current_vl_criteria = current_vl_criteria.lower().strip()
    current_vl_criteria = current_vl_criteria.replace(" and "," |AND| ")
    current_vl_criteria = current_vl_criteria.replace(" or "," |OR| ")
    current_vl_criteria = current_vl_criteria.replace(" and not "," |AND NOT| ")
    current_vl_criteria = current_vl_criteria.replace(" not "," |AND NOT| ")

    n_bars = current_vl_criteria.count("|")
    if n_bars == 0:
        term = current_vl_criteria
        term = term.replace('"=','').strip()
        if term.endswith('"'):
            term = term[0:-1].strip()
        parsed_terms_list.append(term)
    else:
        s_split = current_vl_criteria.split("|")
        for term in s_split:
            term = term.replace('"=','').strip()
            if term.endswith('"'):
                term = term[0:-1].strip()
            term = term.replace("'","").strip()
            term = term.replace('"','').strip()
            parsed_terms_list.append(term.strip())
        #END FOR
        del s_split

    del current_vl_criteria

    if len(parsed_terms_list) == 0:
        is_valid = False
        msg = "CalibreSpy failed to parse any criteria in the VL"

    return parsed_terms_list,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_implied_and_handler(self,DEBUG,current_vl_criteria):
    #~ original:                         tags:"=Science Fiction"   #orig_title:"=My Title"   #orig_title:"=My Other Title"
    #~ implicit 'AND's added:  tags:"=Science Fiction" AND #orig_title:"=My Title" AND #orig_title:"=My Other Title"

    is_valid = True
    msg = ""

    n_colons = current_vl_criteria.count(":")
    if n_colons == 1:
        return current_vl_criteria,is_valid,msg

    n_and = current_vl_criteria.count(" and ")
    n_and = n_and + current_vl_criteria.count(" AND ")

    n_or = current_vl_criteria.count(" or ")
    n_or = n_or + current_vl_criteria.count(" OR ")

    n_not = current_vl_criteria.count(" not ")
    n_not = n_not + current_vl_criteria.count(" NOT ")
    n_not = n_not + current_vl_criteria.count(" AND NOT ")

    if n_and == 0 and n_or == 0 and n_not == 0:
        current_vl_criteria = current_vl_criteria.strip()
        #~ if DEBUG: print("original: ", current_vl_criteria)
        p1 = '(?P<G1>"=[0-9a-zA-Z_ ' + ",'" + ALL_PLACEHOLDERS + ']+["])'   #  match:  tags:"=Science Fiction"          not match:  tags:=Fiction
        r1 = self.regex.compile(p1)
        while True:
            match_p1 = r1.search(current_vl_criteria)
            if match_p1:
                g1 = match_p1.group("G1")       #  "=Science Fiction"
                new = g1.replace(" ","@")
                current_vl_criteria = current_vl_criteria.replace(g1,new)   #  "=Science@Fiction"
            else:
                break
        #END WHILE
        del match_p1
        current_vl_criteria = current_vl_criteria.replace("   "," ")
        current_vl_criteria = current_vl_criteria.replace("  "," ")
        current_vl_criteria = current_vl_criteria.replace(" "," AND ")
        current_vl_criteria = current_vl_criteria.replace("@"," ")
        #~ if DEBUG: print("implicit 'AND's added: ", current_vl_criteria)
    else:
        #~ #could be entirely valid, using only ORs or ORs and NOTs...or could be an erroneous mixing of implicit with explicit...
        pass

    if not current_vl_criteria:
        current_vl_criteria = ""
        is_valid = False
        msg = "Selected VL mixes 'implict' ANDs with 'explicit' ORs and/or AND NOTs; cannot convert to CalibreSpy SQL Query.<br><br>Make all VL Criteria ANDs, ORs and AND NOTs 'explicit'."
    else:
        is_valid = True
        msg = ""

    return current_vl_criteria,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_complex(self,DEBUG,current_vl_criteria):

    #~ if DEBUG: print("complex: ", current_vl_criteria)

   #~ VL:  ((#orig_title:"=My Orig Title" and (#ddc:true or #lcc:true )) or ((rating:<3 or rating:>4)) and (#abc_hierarchy:true or #abc_numeric:true))
    #~ VL:  been_read:no AND (NOT #original_title:"myebookbad") AND (NOT #myyesno:yes)  AND (NOT #myinteger:>1)

    current_vl_criteria = current_vl_criteria.lower()

    current_vl_criteria = current_vl_criteria.replace(" and not "," |and not| ")
    current_vl_criteria = current_vl_criteria.replace(" and "," |and| ")
    current_vl_criteria = current_vl_criteria.replace(" or "," |or| ")
    current_vl_criteria = current_vl_criteria.replace(" not "," |and not| ")
    current_vl_criteria = current_vl_criteria.replace("(not ","(|and not| ")

    if current_vl_criteria.startswith("not "):
        current_vl_criteria = current_vl_criteria[4: ]
        current_vl_criteria = "|not| " + current_vl_criteria
    elif current_vl_criteria.startswith("(not "):
        current_vl_criteria = current_vl_criteria[5: ]
        current_vl_criteria = "(|not| " + current_vl_criteria
    elif current_vl_criteria.startswith("((not "):
        current_vl_criteria = current_vl_criteria[6: ]
        current_vl_criteria = "((|not| " + current_vl_criteria
    elif current_vl_criteria.startswith("(((not "):
        current_vl_criteria = current_vl_criteria[7: ]
        current_vl_criteria = "(((|not| " + current_vl_criteria
    elif current_vl_criteria.startswith("((((not "):
        current_vl_criteria = current_vl_criteria[8: ]
        current_vl_criteria = "((((|not| " + current_vl_criteria

    current_vl_criteria = current_vl_criteria.replace("(","|(|")
    current_vl_criteria = current_vl_criteria.replace(")","|)|")

    parsed_terms_list = []

    tmp_list = current_vl_criteria.split("|")

    for term in tmp_list:
        term = term.strip()
        if term == "and" or term == "or" or term == "not" or term == "and not":
            term = " " + term.upper() + " "
        if term > " ":
            parsed_terms_list.append(term)
    #END FOR
    del tmp_list

    #~ if DEBUG:
        #~ print("Final Parsed Terms List:")
        #~ for term in parsed_terms_list:
            #~ print(term)
        #~ #END FOR

    is_valid = True
    msg = ""

    return parsed_terms_list,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_user_categories(self,DEBUG,current_vl_criteria):

    original_vl_criteria = current_vl_criteria
    is_valid = True
    msg = ""

    if current_vl_criteria.count("@") > 1:
        is_valid = False
        msg = "Only one (1) @UserCategory allowed per VL: " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg
    elif current_vl_criteria.startswith("@"):
        current_vl_criteria = current_vl_criteria[1: ].strip()
    else:
        is_valid = False
        msg = "@UserCategory not located at the start of the VL criteria. " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    s_split = current_vl_criteria.split(":")
    if len(s_split) != 2:
        is_valid = False
        msg = "@UserCategory:true or :false are the only valid specifications for a User Category:  " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    user_category = s_split[0].strip()
    condition = s_split[1].lower().strip()
    del s_split

    if condition == "true":             # “everything matching *an* (i.e., any) item in the category” indicated by a single green plus sign.
        self.is_sql_negated = False
    elif condition == "false":         # “everything not matching *an* (i.e., any) item in the category” shown by a single red minus sign.
        self.is_sql_negated = True
    else:
        is_valid = False
        msg = "@UserCategory:true and :false are the only 2 valid conditions for a User Category:  " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    criteria_list = []

    import json
    from calibre.utils.config import from_json

    my_db,my_cursor,is_valid = self.apsw_connect_to_library()
    if not is_valid:
         return error_dialog(None, _('CalibreSpy'),_('Database Connection Error.  Cannot Connect to the Chosen Library.'), show=True)
    mysql = "SELECT key,val FROM preferences WHERE key = 'user_categories'   "
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    my_db.close()
    is_valid = False
    if tmp_rows is None:
        tmp_rows = []
    for row in tmp_rows:
        key,raw = row
        if not isinstance(raw, unicode):
            raw = raw.decode(preferred_encoding)
        val = json.loads(raw, object_hook=from_json)
        #~ for k,v in val.iteritems():
        for k,v in iteritems(val):
            if user_category.lower() == k.lower():
                is_valid = True
                msg = ""
                try:
                    for item in v:
                        #~ if DEBUG: print("item in user category: ", bytes(item) )
                        item_list = list(item)   #  [u'green', u'#mytaglike', 0]
                        val = item_list[0]
                        val = bytes(val)
                        val = val.decode("utf8")
                        if PSEUDO_COMMA in val:  #sometimes used in Tags as a 'comma' since cannot use a 'real' comma...and causes data issues with current "old" version of Unicode in current Python RE module.
                            val = val.replace(PSEUDO_COMMA,PSEUDO_COMMA_PLACEHOLDER)
                        target = item_list[1]
                        row = target,val
                        criteria_list.append(row)
                    #END FOR
                except Exception as e:
                    msg = "ERROR in @User Category item conversion to a list: " + bytes(e) + " >>> " + bytes(item) + " for: " + user_category
                    current_vl_criteria = "User Category Error: " + user_category
                    is_valid = False
                    if DEBUG: print(msg)
                    return current_vl_criteria,is_valid,msg
                break
            else:
                continue
        #END FOR
    #END FOR

    del json
    del from_json

    if not is_valid:
        msg = "@UserCategory not found in Calibre:  " + user_category
        current_vl_criteria = "User Category Error: " + user_category
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    if len(criteria_list) == 0:
        msg = "@UserCategory has no usable criteria:  " + user_category
        current_vl_criteria = "User Category Error: " + user_category
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    criteria_list.sort()  #target,val

    new_criteria_list = []

    old_target = None
    for row in criteria_list:
        target,value = row
        if old_target is None:
            new_criteria_list.append("(")
            old_target = target
        if target != old_target:
            new_criteria_list.append(")")
            new_criteria_list.append(" OR ")  # “everything matching *an* (i.e., any) item in the category” indicated by a single green plus sign.
            new_criteria_list.append("(")
            old_target = target

        target = unicode_type(target)
        if target == "publisher":  #@UCs do this
            target = "publishers"
        value = unicode_type(value)
        value = value.replace(":",COLON_PLACEHOLDER)   # example:  tags:"=Award:Hugo"
        value = value.replace(" ",BLANK_PLACEHOLDER)   # example:  tags:"=Award:European Literature Prize"
        value = value.replace("/",FORWARD_SLASH_PLACEHOLDER)  # example:  #mytaglike:"=X/Y"
        if "(" in value:   # example: #lcead:"=(Bisacsh)History
            value = value.replace("(",LEFT_PARENS_PLACEHOLDER)
        if ")" in value:
            value = value.replace(")",RIGHT_PARENS_PLACEHOLDER)
        if PSEUDO_COMMA in value:  #sometimes used in Tags as a 'comma' since cannot use a 'real' comma...currently may expose an re module related unicode deficiency...
            value = value.replace(PSEUDO_COMMA,PSEUDO_COMMA_PLACEHOLDER)
        item = target + ':' + '"=' + value + '"'
        new_criteria_list.append(item)
        new_criteria_list.append(" OR ")
    #END FOR
    new_criteria_list.append(")")

    new_vl_criteria = ""

    for row in new_criteria_list:
        new_vl_criteria = new_vl_criteria + row
    #END FOR

    new_vl_criteria = new_vl_criteria.replace("OR )"," )")

    #~ if DEBUG: print("Final @UserCategory new_vl_criteria: ", new_vl_criteria)

    is_valid = True
    msg = ""

    return new_vl_criteria,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_saved_searches(self,DEBUG,current_vl_criteria):
    #~ this function just substitutes the table preferences jsonized saved search criteria for the VL's current_vl_criteria.
    #~ example:   current_vl_criteria = "search:example_1"
    #~ {
      #~ "example_1": "#ddc:\"=641.5\" or #orig_title:False or authors:\"=Alan Burt Akers\" or authors:\"=DaltonSt\" not  tags:\"=Fiction\"",
      #~ "example_2": "pubdate:<2013-08"
    #~ }
    #~    current_vl_criteria becomes:  "#ddc:"=641.5" or #orig_title:False or authors:"=Alan Burt Akers" or authors:"=DaltonSt" not  tags:"=Fiction""

    original_vl_criteria = current_vl_criteria
    is_valid = True
    msg = ""

    if current_vl_criteria.count("search:") != 1:
        is_valid = False
        msg = "One (1) Saved Search is required and allowed for VL: " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg
    elif current_vl_criteria.startswith("search:"):
        pass
    else:
        is_valid = False
        msg = "Saved Search not located at the start of the VL criteria. " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    s_split = current_vl_criteria.split(":")
    if len(s_split) != 2:
        is_valid = False
        msg = "Saved Search Name Parsing Error; too many colons ':' in Saved Search Name for:  " + original_vl_criteria
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    saved_search_name = s_split[1].lower().strip()     # example_1
    del s_split

    import json
    from calibre.utils.config import from_json

    my_db,my_cursor,is_valid = self.apsw_connect_to_library()
    if not is_valid:
         return error_dialog(None, _('CalibreSpy'),_('Database Connection Error.  Cannot Connect to the Chosen Library.'), show=True)
    mysql = "SELECT key,val FROM preferences WHERE key = 'saved_searches'   "
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    my_db.close()
    is_valid = False
    if tmp_rows is None:
        tmp_rows = []
    for row in tmp_rows:
        key,raw = row
        if not isinstance(raw, unicode):
            raw = raw.decode(preferred_encoding)     #  "#ddc:\"=641.5\" or #orig_title:False or authors:\"=Alan Burt Akers\" or authors:\"=DaltonSt\" not  tags:\"=Fiction\""
        val = json.loads(raw, object_hook=from_json)
        #~ for k,v in val.iteritems():       #  "example_1"     "#ddc:"=641.5" or #orig_title:False or authors:"=Alan Burt Akers" or authors:"=DaltonSt" not  tags:"=Fiction""
        for k,v in iteritems(val):
            if saved_search_name.lower() == k.lower():
                is_valid = True
                msg = ""
                current_vl_criteria = v.strip()   #    "#ddc:"=641.5" or #orig_title:False or authors:"=Alan Burt Akers" or authors:"=DaltonSt" not  tags:"=Fiction""
                break
            else:
                continue
        #END FOR
    #END FOR

    del json
    del from_json

    if not is_valid:
        msg = "Saved Search not found in Calibre:  " + saved_search_name
        current_vl_criteria = "Saved Search Error: " + saved_search_name
        if DEBUG: print(msg)
        return current_vl_criteria,is_valid,msg

    return current_vl_criteria,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
def vl_search_criteria_parser_another_vl(self,DEBUG,current_vl_criteria):

    is_valid = True
    msg = ""

    #~ if DEBUG: print("original criteria with 'vl:'   ", current_vl_criteria)

    expanded_list = []
    for x in range(4):  # VL within VL within VL ...
        #~ for vl_name,vl_criteria in self.virtual_libraries_dict.iteritems():
        for vl_name,vl_criteria in iteritems(self.virtual_libraries_dict):
            vl = "vl:" + vl_name    #example:   CalibreSpy must-pass: complex parsing[1]     note the spaces, requiring double-quotes in the VL gui editor...but not saved to table preferences...
            found = False
            if vl in current_vl_criteria:
                found = True
            else:
                vl = "vl:" + '"' + vl_name + '"'   #above example:  vl:"CalibreSpy must-pass: complex parsing[1]"     note the spaces, requiring double-quotes in the VL gui editor
                if vl in current_vl_criteria:
                    found = True
            if found:
                if not vl in expanded_list:
                    expanded_list.append(vl)
                    if "@" in vl_criteria:
                        current_vl_criteria = vl_criteria
                        break
                    elif "search:" in vl_criteria:
                        current_vl_criteria = vl_criteria
                        break
                    else:
                        term = " ( " + vl_criteria + " ) "
                        current_vl_criteria = current_vl_criteria.replace(vl,term)
        #END FOR
        if "@" in current_vl_criteria:
            break
        elif "search:" in current_vl_criteria:
            break
    #END FOR
    del expanded_list

    #~ if DEBUG: print("expanded 'vl:' criteria: ", current_vl_criteria)

    return current_vl_criteria,is_valid,msg
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#~ end of virtual_library_utils.py