# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.76"  #Technical Tweaks after compiling with Python 3.8

import os,apsw

from PyQt5.Qt import Qt, QTextEdit, QVBoxLayout, QDialog, QPushButton, QTextOption, QAbstractScrollArea

from calibre import isbytestring
from calibre.constants import filesystem_encoding, iswindows, DEBUG
from calibre.gui2 import error_dialog

from polyglot.builtins import is_py3, unicode_type

if is_py3:
    import pickle as cPickle
else:
    import cPickle

FORMATSPY_DEFAULT_WIDTH = 800

class FormatSpyDialog(QDialog):
    def __init__(self,icon_calibrespy,library_path,path,bookid,authors,title,timestamp,font,normal_fontsize,style_text):
        super(FormatSpyDialog, self).__init__()

        self.library_path = library_path
        self.bookid = int(bookid)
        self.authors = authors
        self.title = title
        self.timestamp = timestamp

        self.font = font
        self.normal_fontsize = normal_fontsize
        self.font.setPointSize(self.normal_fontsize + 2)

        self.setStyleSheet(style_text)
        #~ self.setStyleSheet("QToolTip { color: #000000; background-color: #ffffcc; border: 1px solid white; }")

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon_calibrespy)
        title = 'CalibreSpy:  FormatSpy'
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.format_info_qtextedit =  QTextEdit("")
        self.format_info_qtextedit.setFont(self.font)
        self.format_info_qtextedit.setReadOnly(True)
        self.format_info_qtextedit.setWordWrapMode(QTextOption.WordWrap)
        self.format_info_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.AdjustToContents)
        self.format_info_qtextedit.setMinimumWidth(FORMATSPY_DEFAULT_WIDTH)
        self.format_info_qtextedit.setMaximumWidth(FORMATSPY_DEFAULT_WIDTH)
        self.format_info_qtextedit.clear()
        self.layout.addWidget(self.format_info_qtextedit)

        self.resize(self.format_info_qtextedit.size())

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)

        self.show_format_info()
    #-----------------------------------------------------
    #-----------------------------------------------------
    def show_format_info(self):
        try:
            #---------------------------
            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if not is_valid:
                 return error_dialog(self, _('CalibreSpy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            #-------------------------------------
            mysql = "SELECT id,path FROM books WHERE id = ?"
            my_cursor.execute(mysql,([self.bookid]))
            tmp_rows = my_cursor.fetchall()
            for row in tmp_rows:
                id,path = row
            #END FOR
            del tmp_rows
            #-------------------------------------
            mysql = "SELECT book,data FROM conversion_options WHERE book = ? AND format = 'PIPE'   "
            my_cursor.execute(mysql,([self.bookid]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            if len(tmp_rows) > 0:
                for row in tmp_rows:
                    book,data = row
                    has_conversion_options = True
                    if is_py3:
                        self.data = cPickle.loads(data, encoding='utf-8')  # fix_imports=True ?   https://stackoverflow.com/questions/50283123/python-3-pickle-load-from-python-2
                    else:
                        self.data = cPickle.loads(bytes(data))
                #END FOR
                del data
            else:
                self.data = None
                has_conversion_options = False
            #END FOR
            del tmp_rows
            #-------------------------------------
            mysql = "SELECT id,format,uncompressed_size,name FROM data WHERE book = ? ORDER BY id"
            my_cursor.execute(mysql,([self.bookid]))
            data_rows = my_cursor.fetchall()
            if not data_rows:
                data_rows = []
            #---------------------------
            my_db.close()
            #---------------------------
        except Exception as e:
            if DEBUG: print("[1] Exception in: class FormatSpyDialog, def show_format_info:", bytes(e))
            return
            #--------------------------------------
            #--------------------------------------
        try:
            #---------------------------
            details = "<pre>"
            #---------------------------
            details = details + "<b>Book ID:</b>  " + bytes(self.bookid) + "<br><br>"
            #---------------------------
            details = details + "<b>Date Added:</b>  " + self.timestamp + "<br><br>"
            #---------------------------
            details = details + "<b>Library Path:</b>  '" + bytes(path) + "'<br><br>"
            #---------------------------
            details = details + "<b>Formats in Import/Polishing/Modification/Conversion Sequence:</b><br>"
            seq = 0
            for row in data_rows:
                id,format,uncompressed_size,name = row
                seq = seq + 1
                format = format + "        "
                format = format[0:6]
                uc = bytes(uncompressed_size)
                uc = uc + "            "
                uc = uc[0:10]
                details = details + "#" + bytes(seq) + ":  "  + format + " - Raw File Size: " + uc.strip() + "  - File Name:  "
                self.font.setPointSize(self.normal_fontsize - 1)
                details = details + name + "<br>"
                self.font.setPointSize(self.normal_fontsize + 2)
            #END FOR
            del data_rows
            #---------------------------
            details = details + "<br>"
            #---------------------------
            details = details + "<b>Author Count:</b>   " + bytes(self.authors.count("&") + 1) + "<br>"
            details = details + "<b>Author(s):</b>   " + self.authors + "<br><br>"
            #---------------------------
            details = details + "<b>Title:</b>  " + self.title + "<br><br>"
            #---------------------------
            if not has_conversion_options:
                details = details + "<b>Conversion Options Exist?</b>  " + bytes(has_conversion_options) + "<br><br>"
            else:
                details = details + "<b>Conversion Options:</b><br><br>"
            #---------------------------
            if has_conversion_options:
                conversion_options,is_valid = self.convert_string_to_list(self.data)
                if is_valid:
                    conversion_options.sort()
                    for row in conversion_options:
                        row = bytes(row).strip()
                        if ":" in row:
                            if row.startswith('"') or row.startswith("'"):
                                details = details + bytes(row) + "<br>"
                    #END FOR
                else:
                    details = details + "<b>Conversion Options:</b>  " + "Could not be displayed...<br>"
                del conversion_options
            else:
                pass
            #---------------------------
            details = details + "</pre>"
            #---------------------------
            self.format_info_qtextedit.setHtml(details)
            #---------------------------

            t = "<p style='white-space:wrap'>The 'Format Sequence' <b>is highly influenced</b> by Polishing, the 'Modify EPUB' plug-in, and Conversion of a pre-existing format. \
                                                                    <br><br>For example, if you originally import an 'EPUB', and then immediately convert it to 'PDF', the first Sequence will be 'EPUB' \
                                                                    and the second Sequence will be 'PDF'.  If you then Polish the 'EPUB' format, the 'EPUB' will be assigned a Sequence of #2, and the 'PDF \
                                                                    will be assigned a Sequence of #1.  \
                                                                    <br><br>If you wish to retain the implicit 'Original Format Sequence', you must immediately Polish and otherwise finish reconverting and modifying the original format <b>before</b> converting \
                                                                    that original format to additional formats.  Or, reconvert all of the additional formats <b>after</b> the original format has been changed. \
                                                                    <br><br>One guaranteed method of retaining the original format type is to use a Calibre 'File-Type Plug-in' designed to add the 'original file name', including its file extension, as metadata.\
                                                                    <br><br>Another guaranteed method is to track the exact date and time that every format (plus almost all other metadata) was created or changed by installing the 'Audit Log Plug-in'."

            self.format_info_qtextedit.setToolTip(t)
            #---------------------------
        except Exception as e:
            if DEBUG: print("[2] Exception in: class FormatSpyDialog, def show_format_info:", bytes(e))
            return

#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
    def apsw_connect_to_library(self):

        path = self.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", bytes(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
#---------------------------------------------------------------------------------------------------------------------------------------
    def convert_string_to_list(self,slist):
        slist = unicode_type(slist)
        n = slist.find("{")  # json:{
        slist = slist[n+1: ].strip()
        slist = slist[0:-1]  # }
        slist = slist.replace("\n"," ")
        slist = slist.replace("\r"," ")
        slist = slist.replace("\t"," ")
        slist = slist.replace("\\"," ")
        slist = slist.replace("  "," ").strip()
        slist = slist.split(", ")
        #~ if DEBUG: print("slist: ", bytes(slist))
        if not isinstance(slist,list):
            return None,False
        else:
            return slist,True
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------

#END OF formatspy_dialog.py