# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.76"  #Technical Tweaks after compiling with Python 3.8

from PyQt5.Qt import (Qt, QDialog, QFont, QIcon, QGroupBox,
                                       QHBoxLayout, QVBoxLayout, QWidget, QSpinBox,
                                       QLabel, QLineEdit, QComboBox, QColor, QCheckBox)

from calibre.constants import DEBUG, iswindows
from calibre.gui2 import gprefs, error_dialog,info_dialog
from calibre.utils.config import JSONConfig
from calibre.utils.config import prefs as mainprefs

from polyglot.builtins import iteritems, unicode_type

#~ ------------------------------------------------------------------------
#~ never change these integer values or all user settings will break.
#~ ------------------------------------------------------------------------
AUTHORS_COLUMN = 0
TITLE_COLUMN = 1
SERIES_COLUMN = 2
INDEX_COLUMN = 3
TAGS_COLUMN = 4
PUBLISHED_COLUMN = 5
PUBLISHER_COLUMN = 6
LANGUAGES_COLUMN = 7
ADDED_COLUMN = 8
MODIFIED_COLUMN = 9
PATH_COLUMN = 10
CUSTOM_COLUMN_1_COLUMN = 11
CUSTOM_COLUMN_2_COLUMN = 12
CUSTOM_COLUMN_3_COLUMN = 13
CUSTOM_COLUMN_4_COLUMN = 14
CUSTOM_COLUMN_5_COLUMN = 15
CUSTOM_COLUMN_6_COLUMN = 16
CUSTOM_COLUMN_7_COLUMN = 17
CUSTOM_COLUMN_8_COLUMN = 18
CUSTOM_COLUMN_9_COLUMN = 19  #  add new columns just below.
IDENTIFIERS_COLUMN = 20      # Version 1.0.43
RATINGS_COLUMN = 21            #Version 1.0.52


#~ ------------------------------------------------------------------------
MATRIX_MAXIMUM_COLUMNS_COUNT = 22  #increment for new columns.    #Version 1.0.52
#~ ------------------------------------------------------------------------
#~ ------------------------------------------------------------------------
CUSTOM_COLUMN_1_COMBOBOX_HEADER = "Custom Column #1"
CUSTOM_COLUMN_2_COMBOBOX_HEADER = "Custom Column #2"
CUSTOM_COLUMN_3_COMBOBOX_HEADER = "Custom Column #3"
CUSTOM_COLUMN_4_COMBOBOX_HEADER = "Custom Column #4"
CUSTOM_COLUMN_5_COMBOBOX_HEADER = "Custom Column #5"
CUSTOM_COLUMN_6_COMBOBOX_HEADER = "Custom Column #6"
CUSTOM_COLUMN_7_COMBOBOX_HEADER = "Custom Column #7"
CUSTOM_COLUMN_8_COMBOBOX_HEADER = "Custom Column #8"
CUSTOM_COLUMN_9_COMBOBOX_HEADER = "Custom Column #9"
#~ ------------------------------------------------------------------------
# This is where in Calibre's config directory that CalibreSpy's .json file will stored:
prefs = JSONConfig('plugins/CalibreSpy')

# Set defaults
prefs.defaults['CALIBRESPY_GLOBALLY_CONFIGURED'] = 0

if iswindows:
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_EDITOR'] = "ebook-edit.exe"
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_VIEWER'] = "ebook-viewer.exe"
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_OTHER'] = ""
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_OTHER_ICON'] = ""
    prefs.defaults['CALIBRESPY_COMMAND_FILE_PATH_EMAIL'] = 'C:/Users/USERNAME/AppData/Roaming/calibre/plugins/calibrespy_cli/CalibreSpy_calibre-smtp_send_email.bat'
else:
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_EDITOR'] = "ebook-edit"
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_VIEWER'] = "ebook-viewer"
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_OTHER'] = ""
    prefs.defaults['CALIBRESPY_PROGRAM_PATH_OTHER_ICON'] = ""
    prefs.defaults['CALIBRESPY_COMMAND_FILE_PATH_EMAIL'] = '/calibre/plugins/calibrespy_cli/CalibreSpy_calibre-smtp_send_email'

prefs.defaults['CALIBRESPY_TEXT_COLOR'] = "midnightblue"
prefs.defaults['CALIBRESPY_BACKGROUND_COLOR'] = "snow"
prefs.defaults['CALIBRESPY_ALTERNATING_COLOR'] = "mintcream"
prefs.defaults['CALIBRESPY_LOAD_SERIES'] = 0
prefs.defaults['CALIBRESPY_LOAD_PUBLISHER'] = 0
prefs.defaults['CALIBRESPY_LOAD_TAGS'] = 0
prefs.defaults['CALIBRESPY_LOAD_LANGUAGES'] = 0
prefs.defaults['CALIBRESPY_LOAD_TIMESTAMP'] = 0
prefs.defaults['CALIBRESPY_LOAD_MODIFIED'] = 0
prefs.defaults['CALIBRESPY_LOAD_IDENTIFIERS'] = 0                      # Version 1.0.43
prefs.defaults['CALIBRESPY_LOAD_RATINGS'] = 0                            #Version 1.0.52
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_1'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_2'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_3'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_4'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_5'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_6'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_7'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_8'] = 0
prefs.defaults['CALIBRESPY_LOAD_CUSTOM_COLUMN_9'] = 0
prefs.defaults['CALIBRESPY_ENABLE_GUI_EXECUTION'] = 0
DISPLAY_SIZE_TINY = "Device Display Size: Tiny"
DISPLAY_SIZE_SMALL = "Device Display Size: Small"
DISPLAY_SIZE_NORMAL = "Device Display Size: Normal"
prefs.defaults['CALIBRESPY_DEVICE_DISPLAY_SIZE'] = DISPLAY_SIZE_NORMAL
prefs.defaults['CALIBRESPY_ROW_HEIGHT_CHANGE_VALUE'] = -15
prefs.defaults["CALIBRESPY_CLI_SUBDIRECTORY"] = ""
prefs.defaults['AUTHORS_COLUMN'] = AUTHORS_COLUMN
prefs.defaults['TITLE_COLUMN'] = TITLE_COLUMN
prefs.defaults['SERIES_COLUMN'] = SERIES_COLUMN
prefs.defaults['INDEX_COLUMN'] = INDEX_COLUMN
prefs.defaults['TAGS_COLUMN'] = TAGS_COLUMN
prefs.defaults['PUBLISHED_COLUMN'] = PUBLISHED_COLUMN
prefs.defaults['PUBLISHER_COLUMN'] = PUBLISHER_COLUMN
prefs.defaults['LANGUAGES_COLUMN'] = LANGUAGES_COLUMN
prefs.defaults['ADDED_COLUMN'] = ADDED_COLUMN
prefs.defaults['MODIFIED_COLUMN'] = MODIFIED_COLUMN
prefs.defaults['IDENTIFIERS_COLUMN'] = IDENTIFIERS_COLUMN  # Version 1.0.43
prefs.defaults['RATINGS_COLUMN'] = RATINGS_COLUMN             #Version 1.0.52      # add new columns just below.
prefs.defaults['PATH_COLUMN'] = PATH_COLUMN
prefs.defaults['CUSTOM_COLUMN_1_COLUMN'] = CUSTOM_COLUMN_1_COLUMN
prefs.defaults['CUSTOM_COLUMN_2_COLUMN'] = CUSTOM_COLUMN_2_COLUMN
prefs.defaults['CUSTOM_COLUMN_3_COLUMN'] = CUSTOM_COLUMN_3_COLUMN
prefs.defaults['CUSTOM_COLUMN_4_COLUMN'] = CUSTOM_COLUMN_4_COLUMN
prefs.defaults['CUSTOM_COLUMN_5_COLUMN'] = CUSTOM_COLUMN_5_COLUMN
prefs.defaults['CUSTOM_COLUMN_6_COLUMN'] = CUSTOM_COLUMN_6_COLUMN
prefs.defaults['CUSTOM_COLUMN_7_COLUMN'] = CUSTOM_COLUMN_7_COLUMN
prefs.defaults['CUSTOM_COLUMN_8_COLUMN'] = CUSTOM_COLUMN_8_COLUMN
prefs.defaults['CUSTOM_COLUMN_9_COLUMN'] = CUSTOM_COLUMN_9_COLUMN
prefs.defaults['CUSTOM_COLUMN_1_SELECTED'] = CUSTOM_COLUMN_1_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_2_SELECTED'] = CUSTOM_COLUMN_2_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_3_SELECTED'] = CUSTOM_COLUMN_3_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_4_SELECTED'] = CUSTOM_COLUMN_4_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_5_SELECTED'] = CUSTOM_COLUMN_5_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_6_SELECTED'] = CUSTOM_COLUMN_6_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_7_SELECTED'] = CUSTOM_COLUMN_7_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_8_SELECTED'] = CUSTOM_COLUMN_8_COMBOBOX_HEADER
prefs.defaults['CUSTOM_COLUMN_9_SELECTED'] = CUSTOM_COLUMN_9_COMBOBOX_HEADER
prefs.defaults['DEFAULT_FONT_FAMILY'] =  0
prefs.defaults['DEFAULT_FONT_SIZE'] = 0
prefs.defaults['PREFERRED_OUTPUT_FORMAT'] = 0
prefs.defaults['DEFAULT_MATRIX_ROW_HEIGHT'] = 30
prefs.defaults['DIALOG_SIZE_WIDTH_LAST'] = 400
prefs.defaults['DIALOG_SIZE_HEIGHT_LAST'] = 400
prefs.defaults['HISTORICAL_FILTERING_EVENTS'] = ""
prefs.defaults['HISTORICAL_SEARCH_EXPRESSIONS'] = ""
prefs.defaults['CALIBRESPY_MARKED_ROW_SNAPSHOT'] = ""
prefs.defaults['CALIBRESPY_LAST_LIBRARY_SELECTED'] = ""
prefs.defaults['CALIBRESPY_LAST_UPDATED_DATETIME'] = ""
prefs.defaults['CALIBRESPY_LAST_UPDATED_USERNAME'] = ""
prefs.defaults['CALIBRESPY_ORPHANED_MULTIUSER_LOCK_ELAPSED_HOURS'] = 8
prefs.defaults['CALIBRESPY_LAST_SHUTDOWN_WAS_GRACEFUL'] = 1
prefs.defaults['CALIBRESPY_LAST_STARTUP_WAS_GRACEFUL'] = 1
prefs.defaults['CUSTOMIZE_SIZE_WIDTH_LAST'] = 400
prefs.defaults['CUSTOMIZE_SIZE_HEIGHT_LAST'] = 400
prefs.defaults['CALIBRESPY_FTP_ENCODING_ENABLED'] = 0
prefs.defaults['CALIBRESPY_FTP_HOST'] = "192.168.1.100"
prefs.defaults['CALIBRESPY_FTP_HOST_DIRECTORY'] = "/hostfolder/"
prefs.defaults['CALIBRESPY_FTP_HOST_PORT'] = "21"
prefs.defaults['CALIBRESPY_FTP_USERID'] = ""
prefs.defaults['CALIBRESPY_FTP_PASSWORD'] = ""
prefs.defaults['CALIBRESPY_FTP_TARGET_DEVICES_LIST'] = unicode_type([])
history_list = []
if iswindows:
    history_list.append("C:/Program Files/Agent Ransack/AgentRansack.exe")
    history_list.append("C:/Program Files/Calibre2/calibre.exe")
    history_list.append("C:/Program Files/LibreOffice/program/soffice.exe")
    history_list.append("C:/Program Files/Mozilla Firefox/firefox.exe")
    history_list.append("C:/Program Files/7-Zip/7zFM.exe")
    history_list.append("C:/Windows/explorer.exe")
    history_list.append("C:/Windows/notepad.exe")
    history_list.append("C:/Windows/regedit.exe")
    history_list.append("C:/Windows/write.exe")
    history_list.sort()
#~ history_list = bytes(history_list)
prefs.defaults['CALIBRESPY_ARBITRARY_PROGRAMS_HISTORY_LIST'] = unicode_type(history_list)
prefs.defaults['CALIBRESPY_ARBITRARY_PROGRAMS_HISTORY_LIST_LAST_SELECTED'] = ""
prefs.defaults['CALIBRESPY_ARBITRARY_PROGRAMS_HISTORY_LIST_CURRENT_DIRECTORY'] = ""
del history_list
prefs.defaults['VISUALIZE_METADATA_DEFAULT_EXPORT_DIRECTORY'] = ""
prefs.defaults['CALIBRESPY_SAVE_COPY_DIRECTORY'] = ""
prefs.defaults['SQL_QUERY_RAW_LAST_SAVED'] = "SELECT book FROM comments WHERE text REGEXP '^.+$' "
prefs.defaults['SQL_QUERY_RAW_LAST_CURRENT'] = "SELECT book FROM comments WHERE text REGEXP '^.+$' "
prefs.defaults['LIBRARY_BROWSER_SEARCH_ENGINE_URL'] = "https://www.google.com/search?q="
#--------------------------------------------------
#--------------------------------------------------
class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        #~ for k,v in prefs.defaults.iteritems():
        for k,v in iteritems(prefs.defaults):
            if not k in prefs:
                prefs[k] = v
                prefs
        #END FOR

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.setFont(font)

        self.global_tip = "<p style='white-space:wrap'>\
              CalibreSpy preferences are Library-specific, \
              but when first created are always originally defaulted from these 'Global Defaults'.\
             <br><br>Once CalibreSpy has been used for a specific Library, \
             that Library will no longer reference these Global Defaults, \
             but thereafter will reference and update the Library-specific preferences set within CalibreSpy itself."

        self.setToolTip(self.global_tip)

        self.layout_top = QVBoxLayout()
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)

        font.setPointSize(14)
        font.setBold(True)
        self.global_defaults_message_qlabel = QLabel()
        self.global_defaults_message_qlabel.setTextFormat(1)
        self.global_defaults_message_qlabel.setText("Global Default Preferences for Libraries")
        self.global_defaults_message_qlabel.setAlignment(Qt.AlignCenter)
        self.global_defaults_message_qlabel.setToolTip(self.global_tip)
        self.global_defaults_message_qlabel.setFont(font)
        self.layout_top.addWidget(self.global_defaults_message_qlabel)
        font.setBold(False)
        font.setPointSize(10)

        self.paths_groupbox = QGroupBox("CalibreSpy Paths:")
        self.layout_top.addWidget(self.paths_groupbox)

        self.paths_layout = QVBoxLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        minwidth = 300
        maxwidth = 300

        #--------------------------------------------------
        self.layout_book_viewer = QHBoxLayout()
        self.layout_book_viewer.setAlignment(Qt.AlignLeft)
        self.paths_layout.addLayout(self.layout_book_viewer)

        self.book_viewer_qlabel = QLabel()
        self.book_viewer_qlabel.setTextFormat(1)
        self.book_viewer_qlabel.setText("Book Viewer Path: ")
        self.book_viewer_qlabel.setFont(font)
        self.layout_book_viewer.addWidget(self.book_viewer_qlabel)

        self.path_book_viewer_qlineedit = QLineEdit()
        self.path_book_viewer_qlineedit.setText(prefs['CALIBRESPY_PROGRAM_PATH_VIEWER'])
        self.path_book_viewer_qlineedit.setFont(font)
        self.path_book_viewer_qlineedit.setToolTip("<p style='white-space:wrap'>This is the path to the application that you desire to be launched to 'View' the currently selected book in CalibreSpy.")
        self.path_book_viewer_qlineedit.setCursorPosition(0)
        self.path_book_viewer_qlineedit.setMinimumWidth(minwidth)
        self.path_book_viewer_qlineedit.setMaximumWidth(maxwidth)
        self.layout_book_viewer.addWidget(self.path_book_viewer_qlineedit)
        #--------------------------------------------------
        self.layout_book_editor = QHBoxLayout()
        self.layout_book_editor.setAlignment(Qt.AlignLeft)
        self.paths_layout.addLayout(self.layout_book_editor)

        self.book_editor_qlabel = QLabel()
        self.book_editor_qlabel.setTextFormat(1)
        self.book_editor_qlabel.setText("Book Editor Path: ")
        self.book_editor_qlabel.setFont(font)
        self.layout_book_editor.addWidget(self.book_editor_qlabel)

        self.path_book_editor_qlineedit = QLineEdit()
        self.path_book_editor_qlineedit.setText(prefs['CALIBRESPY_PROGRAM_PATH_EDITOR'])
        self.path_book_editor_qlineedit.setFont(font)
        self.path_book_editor_qlineedit.setToolTip("<p style='white-space:wrap'>This is the path to the application that you desire to be launched to 'Edit' the currently selected book in CalibreSpy.")
        self.path_book_editor_qlineedit.setCursorPosition(0)
        self.path_book_editor_qlineedit.setMinimumWidth(minwidth)
        self.path_book_editor_qlineedit.setMaximumWidth(maxwidth)
        self.layout_book_editor.addWidget(self.path_book_editor_qlineedit)
        #--------------------------------------------------
        self.layout_book_other = QHBoxLayout()
        self.layout_book_other.setAlignment(Qt.AlignLeft)
        self.paths_layout.addLayout(self.layout_book_other)

        self.book_other_qlabel = QLabel()
        self.book_other_qlabel.setTextFormat(1)
        self.book_other_qlabel.setText("Book Other Program Path: ")
        self.book_other_qlabel.setFont(font)
        self.layout_book_other.addWidget(self.book_other_qlabel)

        self.path_book_other_qlineedit = QLineEdit()
        self.path_book_other_qlineedit.setText(prefs['CALIBRESPY_PROGRAM_PATH_OTHER'])
        self.path_book_other_qlineedit.setFont(font)
        self.path_book_other_qlineedit.setToolTip("<p style='white-space:wrap'>This is the path to any application that you desire to be launched to interact with the currently selected book in CalibreSpy.")
        self.path_book_other_qlineedit.setCursorPosition(0)
        self.path_book_other_qlineedit.setMinimumWidth(minwidth)
        self.path_book_other_qlineedit.setMaximumWidth(maxwidth)
        self.layout_book_other.addWidget(self.path_book_other_qlineedit)
        #--------------------------------------------------
        self.layout_book_other_icon = QHBoxLayout()
        self.layout_book_other_icon.setAlignment(Qt.AlignLeft)
        self.paths_layout.addLayout(self.layout_book_other_icon)

        self.book_other_icon_qlabel = QLabel()
        self.book_other_icon_qlabel.setTextFormat(1)
        self.book_other_icon_qlabel.setText("Book Other Program Icon Path: ")
        self.book_other_icon_qlabel.setFont(font)
        self.layout_book_other_icon.addWidget(self.book_other_icon_qlabel)

        self.path_book_other_icon_qlineedit = QLineEdit()
        self.path_book_other_icon_qlineedit.setText(prefs['CALIBRESPY_PROGRAM_PATH_OTHER_ICON'])
        self.path_book_other_icon_qlineedit.setFont(font)
        self.path_book_other_icon_qlineedit.setToolTip("<p style='white-space:wrap'>This is the path to the icon file used for the Other Program.")
        self.path_book_other_icon_qlineedit.setCursorPosition(0)
        self.path_book_other_icon_qlineedit.setMinimumWidth(minwidth)
        self.path_book_other_icon_qlineedit.setMaximumWidth(maxwidth)
        self.layout_book_other_icon.addWidget(self.path_book_other_icon_qlineedit)
        #--------------------------------------------------
        self.groupbox_matrix_colors = QGroupBox('CalibreSpy Row Colors && Height:')
        self.groupbox_matrix_colors.setToolTip("<p style='white-space:wrap'>This changes the colors of CalibreSpy, and the height of each row.")
        self.layout_top.addWidget(self.groupbox_matrix_colors)

        self.layout_matrix_groupbox = QVBoxLayout()
        self.groupbox_matrix_colors.setLayout(self.layout_matrix_groupbox)

        self.layout_matrix_colors = QHBoxLayout()
        self.layout_matrix_colors.setAlignment(Qt.AlignLeft)

        self.layout_matrix_groupbox.addLayout(self.layout_matrix_colors)

        self.text_color_label = QLabel("Text:")
        self.text_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the text colors available to choose from.  'Black' is the default neutral color.")
        self.layout_matrix_colors.addWidget(self.text_color_label)

        self.text_color_combobox = QComboBox()
        self.text_color_combobox.setEditable(False)
        self.text_color_combobox.setFont(font)
        self.text_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the text colors available to choose from.  'Black' is the default neutral color.")
        self.layout_matrix_colors.addWidget(self.text_color_combobox)

        self.background_color_label = QLabel("BG 1:")
        self.background_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the background colors available to choose from.  'Snow' is the default neutral color.")
        self.layout_matrix_colors.addWidget(self.background_color_label)

        self.background_color_combobox = QComboBox()
        self.background_color_combobox.setEditable(False)
        self.background_color_combobox.setFont(font)
        self.background_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the background colors available to choose from.  'Snow' is the default neutral color.")
        self.layout_matrix_colors.addWidget(self.background_color_combobox)

        self.alternating_color_label = QLabel("BG 2:")
        self.alternating_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the alternate background colors available to choose from.  'Gainsboro' is the default neutral color.")
        self.layout_matrix_colors.addWidget(self.alternating_color_label)

        self.alternating_color_combobox = QComboBox()
        self.alternating_color_combobox.setEditable(False)
        self.alternating_color_combobox.setFont(font)
        self.alternating_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the alternate background colors available to choose from.  'Gainsboro' is the default neutral color.")
        self.layout_matrix_colors.addWidget(self.alternating_color_combobox)

        color_list = QColor.colorNames()
        for color in color_list:
            self.text_color_combobox.addItem(color)
            self.background_color_combobox.addItem(color)
            self.alternating_color_combobox.addItem(color)
        #END FOR

        tc = prefs['CALIBRESPY_TEXT_COLOR']
        bc = prefs['CALIBRESPY_BACKGROUND_COLOR']
        ac = prefs['CALIBRESPY_ALTERNATING_COLOR']

        self.text_color_combobox.setCurrentText(tc)
        self.background_color_combobox.setCurrentText(bc)
        self.alternating_color_combobox.setCurrentText(ac)

        self.text_color_combobox.setEditable(False)
        self.background_color_combobox.setEditable(False)
        self.alternating_color_combobox.setEditable(False)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.text_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.background_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",ac)
        self.alternating_color_combobox.setStyleSheet(style_text)

        n = prefs['CALIBRESPY_ROW_HEIGHT_CHANGE_VALUE']

        self.row_height_adjustment_qspinbox = QSpinBox()
        self.row_height_adjustment_qspinbox.setSuffix("          :Extra Row Height Spacing in Pixels (may be negative)")
        self.row_height_adjustment_qspinbox.setMaximumWidth(400)
        self.row_height_adjustment_qspinbox.setRange(-20,100)
        self.row_height_adjustment_qspinbox.setValue(int(n))  #will ignore setting value unless min/max already set...
        self.row_height_adjustment_qspinbox.setToolTip("<p style='white-space:wrap'>The matrix row height may be increased or decreased by this number of pixels.")
        self.layout_matrix_groupbox.addWidget(self.row_height_adjustment_qspinbox)

        self.row_height_adjustment_qspinbox.valueChanged.connect(self.event_qspinbox_value_changed)

        #--------------------------------------------------
        #--------------------------------------------------
        self.groupbox_metadata = QGroupBox('CalibreSpy Optional Metadata:')
        self.groupbox_metadata.setToolTip("<p style='white-space:wrap'>Select optional Calibre Standard Columns to load.  Note that Tags and Publisher might significantly increase CalibreSpy initialization time.")
        self.layout_top.addWidget(self.groupbox_metadata)

        self.layout_metadata_groupbox = QVBoxLayout()
        self.groupbox_metadata.setLayout(self.layout_metadata_groupbox)

        self.load_series_qcheckbox = QCheckBox("Load Series?")
        self.load_series_qcheckbox.setChecked(prefs['CALIBRESPY_LOAD_SERIES'])
        self.load_series_qcheckbox.setFont(font)
        self.load_series_qcheckbox.setToolTip("<p style='white-space:wrap'>Do you wish CalibreSpy to load Series and Series Index?  This could noticeably increase startup time.")
        self.layout_metadata_groupbox.addWidget(self.load_series_qcheckbox)

        self.load_publisher_qcheckbox = QCheckBox("Load Publisher?")
        self.load_publisher_qcheckbox.setChecked(prefs['CALIBRESPY_LOAD_PUBLISHER'])
        self.load_publisher_qcheckbox.setFont(font)
        self.load_publisher_qcheckbox.setToolTip("<p style='white-space:wrap'>Do you wish CalibreSpy to load Publisher?  This could noticeably increase startup time.")
        self.layout_metadata_groupbox.addWidget(self.load_publisher_qcheckbox)

        self.load_tags_qcheckbox = QCheckBox("Load Tags?")
        self.load_tags_qcheckbox.setChecked(prefs['CALIBRESPY_LOAD_TAGS'])
        self.load_tags_qcheckbox.setFont(font)
        self.load_tags_qcheckbox.setToolTip("<p style='white-space:wrap'>Do you wish CalibreSpy to load Tags?  This could significantly increase startup time.")
        self.layout_metadata_groupbox.addWidget(self.load_tags_qcheckbox)

        self.load_languages_qcheckbox = QCheckBox("Load Languages?")
        self.load_languages_qcheckbox.setChecked(prefs['CALIBRESPY_LOAD_LANGUAGES'])
        self.load_languages_qcheckbox.setFont(font)
        self.load_languages_qcheckbox.setToolTip("<p style='white-space:wrap'>Do you wish CalibreSpy to load Languages?  This will slightly increase startup time.")
        self.layout_metadata_groupbox.addWidget(self.load_languages_qcheckbox)

        self.load_timestamp_qcheckbox = QCheckBox("Load Date Added?")
        self.load_timestamp_qcheckbox.setChecked(prefs['CALIBRESPY_LOAD_TIMESTAMP'])
        self.load_timestamp_qcheckbox.setFont(font)
        self.load_timestamp_qcheckbox.setToolTip("<p style='white-space:wrap'>Do you wish CalibreSpy to load Date Added?  This will slightly increase startup time.")
        self.layout_metadata_groupbox.addWidget(self.load_timestamp_qcheckbox)

        self.load_modified_qcheckbox = QCheckBox("Load Modified Date?")
        self.load_modified_qcheckbox.setChecked(prefs['CALIBRESPY_LOAD_MODIFIED'])
        self.load_modified_qcheckbox.setFont(font)
        self.load_modified_qcheckbox.setToolTip("<p style='white-space:wrap'>Do you wish CalibreSpy to load Modified Date?  This will slightly increase startup time.")
        self.layout_metadata_groupbox.addWidget(self.load_modified_qcheckbox)
        #--------------------------------------------------
        #--------------------------------------------------
        self.enable_gui_execution_qcheckbox = QCheckBox("Enable Execution of CalibreSpy within the Calibre GUI?")
        self.enable_gui_execution_qcheckbox.setChecked(prefs['CALIBRESPY_ENABLE_GUI_EXECUTION'])
        self.enable_gui_execution_qcheckbox.setFont(font)
        self.enable_gui_execution_qcheckbox.setToolTip("<p style='white-space:wrap'>You may execute CalibreSpy by clicking on its Icon in the Calibre ToolBar or Menu, in which case it will shut down simultaneously with the Calibre GUI as <b>it</b> shuts down.\
                                                                                         <br><br>Important: Running normally via a Command File (CLI) allows many instances of CalibreSpy to spy on many different Calibre Libraries simultaneously.\
                                                                                         <br><br>Running via the Calibre GUI only supports one (1) instance of CalibreSpy at any given moment. That instance of CalibreSpy can spy on <b>any</b> single Calibre Library that you choose, just as is possible for the CLI method.")
        self.layout_top.addWidget(self.enable_gui_execution_qcheckbox)
        #--------------------------------------------------
        #--------------------------------------------------
        self.display_size_combobox = QComboBox()
        self.display_size_combobox.setMaximumWidth(400)
        self.display_size_combobox.setEditable(False)
        self.display_size_combobox.setFont(font)
        self.display_size_combobox.setToolTip("<p style='white-space:wrap'>Tiny Tablets that are running CalibreSpy require some accomodation for their smaller size. ")
        self.layout_top.addWidget(self.display_size_combobox)

        self.display_size_combobox.addItem(DISPLAY_SIZE_NORMAL)
        self.display_size_combobox.addItem(DISPLAY_SIZE_SMALL)
        self.display_size_combobox.addItem(DISPLAY_SIZE_TINY)

        size = prefs['CALIBRESPY_DEVICE_DISPLAY_SIZE']
        self.display_size_combobox.setCurrentText(size)
        #--------------------------------------------------
        #--------------------------------------------------
        self.text_color_combobox.activated.connect(self.event_combo_box_colors_changed)
        self.background_color_combobox.activated.connect(self.event_combo_box_colors_changed)
        self.alternating_color_combobox.activated.connect(self.event_combo_box_colors_changed)
        #--------------------------------------------------
        self.path_book_editor_qlineedit.textEdited.connect(self.event_qlineedits_text_changed)
        self.path_book_viewer_qlineedit.textEdited.connect(self.event_qlineedits_text_changed)
        self.path_book_other_qlineedit.textEdited.connect(self.event_qlineedits_text_changed)
        self.path_book_other_icon_qlineedit.textEdited.connect(self.event_qlineedits_text_changed)
        #--------------------------------------------------
        self.load_series_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        self.load_publisher_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        self.load_tags_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        self.load_languages_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        self.load_timestamp_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        self.load_modified_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        #--------------------------------------------------
        self.enable_gui_execution_qcheckbox.toggled.connect(self.event_any_checkboxes_changed)
        #--------------------------------------------------
        self.display_size_combobox.activated.connect(self.event_combo_box_display_size_changed)
        #--------------------------------------------------
        self.resize(self.sizeHint())
        #--------------------------------------------------
        if  'CALIBRESPY_CONFIGURED' in prefs:  #deprecated
            del prefs['CALIBRESPY_CONFIGURED']
            prefs
    #--------------------------------------------------
    #--------------------------------------------------
    def event_qlineedits_text_changed(self):
        prefs['CALIBRESPY_PROGRAM_PATH_EDITOR'] = self.path_book_editor_qlineedit.text().replace("\\","/").strip()
        prefs['CALIBRESPY_PROGRAM_PATH_VIEWER'] = self.path_book_viewer_qlineedit.text().replace("\\","/").strip()
        prefs['CALIBRESPY_PROGRAM_PATH_OTHER'] = self.path_book_other_qlineedit.text().replace("\\","/").strip()
        prefs['CALIBRESPY_PROGRAM_PATH_OTHER_ICON'] = self.path_book_other_icon_qlineedit.text().replace("\\","/").strip()
        prefs

        if prefs['CALIBRESPY_GLOBALLY_CONFIGURED'] == 0:
            info_dialog(self, 'CalibreSpy Default Global Preferences',self.global_tip).show()
            prefs['CALIBRESPY_GLOBALLY_CONFIGURED'] = 1
            prefs
    #--------------------------------------------------
    #--------------------------------------------------
    def event_combo_box_colors_changed(self):

        prefs['CALIBRESPY_TEXT_COLOR'] = self.text_color_combobox.currentText()
        prefs['CALIBRESPY_BACKGROUND_COLOR'] = self.background_color_combobox.currentText()
        prefs['CALIBRESPY_ALTERNATING_COLOR'] =  self.alternating_color_combobox.currentText()
        prefs

        tc = prefs['CALIBRESPY_TEXT_COLOR']
        bc = prefs['CALIBRESPY_BACKGROUND_COLOR']
        ac = prefs['CALIBRESPY_ALTERNATING_COLOR']

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.text_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.background_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",ac)
        self.alternating_color_combobox.setStyleSheet(style_text)

        if prefs['CALIBRESPY_GLOBALLY_CONFIGURED'] == 0:
            info_dialog(self, 'CalibreSpy Default Global Preferences',self.global_tip).show()
            prefs['CALIBRESPY_GLOBALLY_CONFIGURED'] = 1
            prefs
#--------------------------------------------------
#--------------------------------------------------
    def event_any_checkboxes_changed(self,state):

        if self.load_series_qcheckbox.isChecked():
            prefs['CALIBRESPY_LOAD_SERIES'] = 1
        else:
            prefs['CALIBRESPY_LOAD_SERIES'] = 0

        if self.load_publisher_qcheckbox.isChecked():
            prefs['CALIBRESPY_LOAD_PUBLISHER'] = 1
        else:
            prefs['CALIBRESPY_LOAD_PUBLISHER'] = 0

        if self.load_tags_qcheckbox.isChecked():
            prefs['CALIBRESPY_LOAD_TAGS'] = 1
        else:
            prefs['CALIBRESPY_LOAD_TAGS'] = 0

        if self.load_languages_qcheckbox.isChecked():
            prefs['CALIBRESPY_LOAD_LANGUAGES'] = 1
        else:
            prefs['CALIBRESPY_LOAD_LANGUAGES'] = 0

        if self.load_timestamp_qcheckbox.isChecked():
            prefs['CALIBRESPY_LOAD_TIMESTAMP'] = 1
        else:
            prefs['CALIBRESPY_LOAD_TIMESTAMP'] = 0

        if self.load_modified_qcheckbox.isChecked():
            prefs['CALIBRESPY_LOAD_MODIFIED'] = 1
        else:
            prefs['CALIBRESPY_LOAD_MODIFIED'] = 0

        if self.enable_gui_execution_qcheckbox.isChecked():
            prefs['CALIBRESPY_ENABLE_GUI_EXECUTION'] = 1
        else:
            prefs['CALIBRESPY_ENABLE_GUI_EXECUTION'] = 0

        prefs

        if prefs['CALIBRESPY_GLOBALLY_CONFIGURED'] == 0:
            info_dialog(self, 'CalibreSpy Default Global Preferences',self.global_tip).show()
            prefs['CALIBRESPY_GLOBALLY_CONFIGURED'] = 1
            prefs

#--------------------------------------------------
#--------------------------------------------------
    def event_combo_box_display_size_changed(self):
        prefs['CALIBRESPY_DEVICE_DISPLAY_SIZE'] = self.display_size_combobox.currentText()
        prefs
#--------------------------------------------------
#--------------------------------------------------
    def event_qspinbox_value_changed(self,i):
        prefs['CALIBRESPY_ROW_HEIGHT_CHANGE_VALUE'] = self.row_height_adjustment_qspinbox.value()
        prefs
#--------------------------------------------------
#--------------------------------------------------
    def validate(self):
        return True
#--------------------------------------------------
#--------------------------------------------------
#END of config.py

