# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.76"  #Technical Tweaks after compiling with Python 3.8

from calibre.customize import InterfaceActionBase

class ActionBaseCalibreSpy(InterfaceActionBase):

    name                    = 'CalibreSpy'
    description           = 'Light GUI for browsing, viewing, searching using VLs and many other search tools, and using many libraries simultaneously by multiple users without running the Calibre GUI itself.'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 76)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin       = 'calibre_plugins.calibrespy.ui:ActionCalibreSpy'

    gui_name = 'CalibreSpy'

    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.calibrespy.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        return
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    #----------       calibre-debug -r "CalibreSpy"  -- --"S:\Calibre\CalibreJobSpyTest2"  --ros   --reset
    def cli_main(self,args):  # executed from  debug.py:   plugin.cli_main([plugin.name] + args[1:])  =>   (union of 2 lists) => 1 argument
        from calibre_plugins.calibrespy.calibrespy_dialog import EXEC_SOURCE_CLI, CalibreSpyDialog
        from PyQt5.Qt import QApplication
        cs_qtapp = QApplication([])
        username = self.get_username()
        calibre_spy_dialog = CalibreSpyDialog(execution_source=EXEC_SOURCE_CLI,cli_args_list=args,username=username,qtapp=cs_qtapp)
        del CalibreSpyDialog
        del QApplication
        calibre_spy_dialog.exec_()
        import sys
        sys.exit(0)
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    def get_username(self):
        from calibre.constants import DEBUG
        import os
        try:
            username = os.path.expanduser('~')
            del os
        except Exception as e:
            if DEBUG: print("get_username error: ", bytes(e))
            username = "unknown user"
        return username
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__.py