#!/bin/bash

parse_emits () {
    if echo $line | grep -q "^emits"; then
        echo "  ${line}"
    fi
}

parse_start () {
    if echo $line | grep -q "^start on"; then
        raw_line=$(echo ${line#"start on "} | tr -d '(' | tr -d ')')
        raw_line=${raw_line%%#*}
        mode='empty'
        for word in $raw_line; do
            case $mode in
                empty )
                    echo -n "  start on "
                    case $word in
                        started | starting | stopped | stopping )
                            echo -n "$word (job: "
                            mode='job'
                            ;;
                        * )
                            echo -n "$word (job:, env:"
                            mode='env'
                            ;;
                    esac
                    ;;
                job )
                    echo -n "$word, env:"
                    mode='env'
                    ;;
                env )
                    if [[ $word == *"="* ]]; then
                        echo -n " $word"
                    elif [[ $word == "["*"]" ]]; then
                        echo -n " RUNLEVEL=$word"
                        mode='empty'
                    else
                        echo ')'
                        mode='empty'
                    fi
                    ;;
                and | or)
                    echo ')'
                    mode=empty
                    ;;
            esac
        done
        echo ')'
    fi
}

parse_stop () {
    if echo $line | grep -q "^stop on"; then
        raw_line=$(echo ${line#"stop on "} | tr -d '(' | tr -d ')')
        mode='empty'
        for word in $raw_line; do
            case $mode in
                empty )
                    echo -n "  stop on "
                    case $word in
                        started | starting | stopped | stopping )
                            echo -n "$word (job: "
                            mode='job'
                            ;;
                        * )
                            echo -n "$word (job:, env:"
                            mode='env'
                    esac
                    ;;
                job )
                    echo -n "$word, env:"
                    mode='env'
                    ;;
                env )
                    if [[ $word == *"="* ]]; then
                        echo -n " $word"
                    else
                        echo ')'
                        mode='empty'
                    fi
                    ;;
                and | or )
                    echo ')'
                    mode='empty'
            esac
        done
        echo ')'
    fi
}



parse_file () {
    echo ${2%.conf}
    while read -r line; do
        parse_emits $line
        parse_start $line
        parse_stop  $line
    done < "$1"
}

for file in `ls $1/*.conf`; do
    parse_file $file $(basename $file)
done
