#!/bin/sh
read_cfg() { 
bookstore_config=`cat /mnt/ext1/system/config/global.cfg | awk -F = '/^bookstore_config=/ {print $2}'`
partner_web=`cat /mnt/ext1/system/config/global.cfg | grep '^partner_web='|sed -e "s/[0-9a-zA-Z_]*=//"`
partner_id=`cat /mnt/ext1/system/config/global.cfg | awk -F = '/^partner_id=/ {print $2}'`
partner_email=`cat /mnt/ext1/system/config/global.cfg|grep '^partner_email='|sed -e "s/[0-9a-zA-Z_]*=//"`
partner_password=`cat /mnt/ext1/system/config/global.cfg|grep '^partner_password='|sed -e "s/[0-9a-zA-Z_]*=//"`
}
connect=/ebrmain/bin/auto_connect.app
if ! [ -f "$connect" ]; then
connect="/ebrmain/bin/netagent connect"
fi
connected=
while [ -z "$connected" ]
do
	$connect
	proxy_auth=
	export http_proxy=
	if [ -f /var/etc/proxy ]; then
		proxy_have_auth=`grep "@" /var/etc/proxy`
		if [ -z "$proxy_have_auth" ]; then
# http://host:port
#		proxy_port=`cat /var/etc/proxy | awk -F : '{print $3}'`
#		proxy_host=`cat /var/etc/proxy | awk -F : '{print $2}' | sed -e "s/^\/\/*//"`
		export http_proxy="`cat /var/etc/proxy`"
		else
# http://login:pass@host:port
		hostport=`cat /var/etc/proxy | awk -F @ '{print $2}'`
		loginpass=`cat /var/etc/proxy | awk -F @ '{print $1}'`
		proxy_host=`echo $hostport|awk -F : '{print $1}'`
		proxy_port=`echo $hostport|awk -F : '{print $2}'`
		proxy_login=`echo $loginpass|awk -F : '{print $2}' | sed -e "s/^\/\/*//"`
		proxy_pass=`echo $loginpass|awk -F : '{print $3}'`
		export http_proxy="http://$proxy_host:$proxy_port"
		proxy_auth="--proxy-user=$proxy_login --proxy-password=$proxy_pass"
		fi
	fi
	query_script=http://start.obreey.com/deviceconfig?sn=`cat /var/run/serial`
	if wget $proxy_auth -O /tmp/query_script.txt $query_script 
	then
		connected=yes
	else
                /ebrmain/bin/netagent disconnect
                /ebrmain/bin/dialog 2 "" "@WantToConnectMessage"
                want_connect=$?
                echo "want_connect=$want_connect"
                if ! [ "$want_connect" = 1 ]; then
                        exit 1
                fi
	fi
	
done

if [ -n "$connected" ]
then
	bookstore_url=`cat /ebrmain/config/device.cfg|grep '^bookstore_url='|sed -e "s/[0-9a-zA-Z_]*=//"`
	brand=`cat /ebrmain/config/device.cfg|grep '^brand='|sed -e "s/[0-9a-zA-Z_]*=//"`
	if [ -n "$bookstore_url" ]; then
		img_param="-img /ebrmain/share/book_store.bmp"
		if [ "$brand" = Titelive ]; then
			bookstore_config=`cat /mnt/ext1/system/config/global.cfg|grep '^bookstore_config='|sed -e "s/[0-9a-zA-Z_]*=//"`
			partner_email=`cat /mnt/ext1/system/config/global.cfg|grep '^partner_email='|sed -e "s/[0-9a-zA-Z_]*=//"`
			partner_password=`cat /mnt/ext1/system/config/global.cfg|grep '^partner_password='|sed -e "s/[0-9a-zA-Z_]*=//"`
			pressed=
			[ "$bookstore_config" = 3 ] && pressed="save"
			while [ -z "$pressed" ] || [ -z "echo \"$partner_email\"|grep \"\w\w*@\w\w*\"" ];
			do
				sed -e "/^bookstore_config=/ d" -i /mnt/ext1/system/config/global.cfg
				/ebrmain/bin/register.app -partners_store
				bookstore_config=`cat /mnt/ext1/system/config/global.cfg|grep '^bookstore_config='|sed -e "s/[0-9a-zA-Z_]*=//"`
				partner_email=`cat /mnt/ext1/system/config/global.cfg|grep '^partner_email='|sed -e "s/[0-9a-zA-Z_]*=//"`
				partner_password=`cat /mnt/ext1/system/config/global.cfg|grep '^partner_password='|sed -e "s/[0-9a-zA-Z_]*=//"`
				[ "$bookstore_config" = 0 ] && pressed="skip"
				[ "$bookstore_config" = 3 ] && pressed="save"
			done
			[ -f /ebrmain/share/book_store_$brand.bmp ] && 	img_param="-img /ebrmain/share/book_store_$brand.bmp"
			if [ "$pressed" = "skip" ]; then
				echo "Skip: return to main menu"
				exit 0
			fi
		fi
		if [ "$brand" = Ebookit ]; then
			bookstore_url="http://shop.ebookit.ch"
			read_cfg
			while [ "$bookstore_config" = "0" ]
			do
				/ebrmain/bin/register.app -partners_store
				read_cfg
			done
			if [ -n "${partner_web}" ]; then
				bookstore_url="http://$partner_web"
				if [ -n "$partner_id" ]; then
				bookstore_url="${bookstore_url}?shop=${partner_id}"
				fi
			fi
			
		fi
		pixelratio=1
		hwconfig -d
		display=$?
		if [ "$display" = 4 ]; then
		#define HWC_DISPLAY_6INCH_758 (HWC_DISPLAY == 4) // display 1024x758 6" HD
			pixelratio="1.263"
		fi	
		if [ -n "$pixelratio" ]; then
			add_param="$add_param -pixelratio $pixelratio"
		fi
		if [ "$brand" = Tea ]; then
		/ebrmain/bin/openbook /ebrmain/bin/browser.app -notoolbar $bookstore_url
		else
		/ebrmain/bin/openbook /ebrmain/bin/browser.app -simpletoolbar $add_param $img_param $bookstore_url
		fi
	else
	cp /tmp/query_script.txt /mnt/ext1/system/bookstore.cfg
	url=`cat /tmp/query_script.txt|grep "^url="|awk -F = '{print $2}'`
	if [ "${url:0:4}" = "http" ]; then
#	browser
		echo "hide ObreeySync.app"
		rm -f /mnt/ext1/applications/ObreeySync.app /mnt/ext1/applications/UniversalSync.app
		img=`cat /tmp/query_script.txt|grep "^img="|awk -F = '{print $2}'`
		img_param="-img /ebrmain/share/book_store.bmp"
		if [ -n "$img" ]; then
			if [ "${img:0:4}" = "http" ]; then
			# download image
				if wget -O /tmp/book_store_logo.bmp "$img"; then
				img_param="-img /tmp/book_store_logo.bmp"
				fi
			else
			# use image
				if [ -f /ebrmain/share/$img ]; then
				img_param="-img ebrmain/share/$img"
				fi
			fi
		fi
		pixelratio=1
		hwconfig -d
		display=$?
		if [ "$display" = 4 ]; then
		#define HWC_DISPLAY_6INCH_758 (HWC_DISPLAY == 4) // display 1024x758 6" HD
			pixelratio="1.263"
		fi	
		if [ -n "$pixelratio" ]; then
			add_param="$add_param -pixelratio $pixelratio"
		fi
		/ebrmain/bin/openbook /ebrmain/bin/browser.app -simpletoolbar $add_param $img_param http://start.obreey.com		
	else
# application
	echo "native=1" > /mnt/ext1/system/bookstore.cfg
		logo1="`cat /tmp/query_script.txt|awk -F = '/^logo1=/ {print $2}'|head -1`"
		logo2="`cat /tmp/query_script.txt|awk -F = '/^logo2=/ {print $2}'|head -1`"
		logo3="`cat /tmp/query_script.txt|awk -F = '/^logo3=/ {print $2}'|head -1`"
		logo1name=`basename "$logo1"`
		logo2name=`basename "$logo2"`
		logo3name=`basename "$logo3"`
		mkdir -p /mnt/ext1/system/bookstore
		if [ -n "$logo1" ] && ! [ -f /mnt/ext1/system/bookstore/$logo1name ]; then
			echo "Download $logo1name"
			wget -O /mnt/ext1/system/bookstore/$logo1name $logo1
  			ln -s /mnt/ext1/system/bookstore/$logo1name /mnt/ext1/system/bookstore/logo1
		fi
		if [ -n "$logo2" ] && ! [ -f /mnt/ext1/system/bookstore/$logo2name ]; then
			echo "Download $logo2name"
			wget -O /mnt/ext1/system/bookstore/$logo2name $logo2  
			ln -s /mnt/ext1/system/bookstore/$logo2name /mnt/ext1/system/bookstore/logo2
		fi
		if [ -n "$logo3" ] && ! [ -f /mnt/ext1/system/bookstore/$logo3name ]; then
			echo "Download $logo3name"
			wget -O /mnt/ext1/system/bookstore/$logo3name $logo3  
			ln -s /mnt/ext1/system/bookstore/$logo3name /mnt/ext1/system/bookstore/logo3
		fi
	echo "logo1=$logo1name" >> /mnt/ext1/system/bookstore.cfg
	echo "logo2=$logo2name" >> /mnt/ext1/system/bookstore.cfg
	echo "logo3=$logo3name" >> /mnt/ext1/system/bookstore.cfg
	store_name="`cat /tmp/query_script.txt|awk -F = '/^store_name=/ {print $2}'|head -1`"
	if [ -n "$store_name" ]; then
		echo "store_name=$store_name" >> /mnt/ext1/system/bookstore.cfg
	fi
	! [ -f /mnt/ext1/applications/ObreeySync.app ] && [ -f /ebrmain/bin/ObreeySync.app ] && echo "#!/bin/sh
exec /ebrmain/bin/ObreeySync.app" > /mnt/ext1/applications/ObreeySync.app
	! [ -f /mnt/ext1/applications/UniversalSync.app ] && [ -f /ebrmain/bin/UniversalSync.app ] && echo "#!/bin/sh
exec /ebrmain/bin/UniversalSync.app" > /mnt/ext1/applications/UniversalSync.app
	/ebrmain/bin/obreeystore.app
	fi # "${url:0:4}" = "http"
	fi # [ -n "$bookstore_url" ] 
else
exit 1
fi
