#!/ebrmain/bin/run_script -clear_screen -bitmap=browser_logo

read_cfg_file()
{
#usage read_cfg_file config prefix
while read x
do
x1=`echo $x|cut -d = -f 1|sed -e "s/[^a-zA-Z0-9_]//g"`
x2=`echo $x|cut -d = -f 2-`
eval ${2}${x1}='$x2'
done < $1 || false
}

network_up()
{
	/ebrmain/bin/netagent status  > /tmp/netagent_status_wb
	read_cfg_file  /tmp/netagent_status_wb netagent_
	if [ "$netagent_nagtpid" -gt 0 ]; then
:
	#network enabled
	else
		echo "Network now disabled"
		/ebrmain/bin/dialog 5 "" @NeedInternet @Cancel @TurnOnWiFi
                want_connect=$?
                echo "want_connect=$want_connect"
                if ! [ "$want_connect" = 2 ]; then
                        exit 1
                fi

		/ebrmain/bin/netagent net on
	fi
	/ebrmain/bin/netagent connect
}

PB_BRAND=$(awk -F = '/^brand=/ {print $2}' /ebrmain/config/device.cfg |tr [:lower:] [:upper:] )

startpage= 
browser_params=

#[ -n "$1" ] && startpage="$1"
	if [ -z "$PB_BRAND" ]; then
		startpage=http://start.obreey.com/
	fi

	if [ "$PB_BRAND" = "EMPIK" ]; then
		startpage=http://m.empik.com
	fi
	if [ "$PB_BRAND" = "ALZA" ]; then
		startpage=http://m.alza.cz/elektronicke-knihy/18853710.htm
	fi
	if [ "$PB_BRAND" = "TEA" ]; then
                startpage=http://hub-ereader.tea-ebook.com/pocketbook/browser
        fi
        if [ "$PB_BRAND" = "OSIANDER" ]; then
		browser_params="-pixelratio 1"
                startpage='http://www.osiander.de/mobil/index.cfm?action=list&lstcat_id=74'
        fi
        if [ "$PB_BRAND" = "MAYERSCHE" ]; then
                startpage=http://www.mayersche.de/
        fi
	if [ "$PB_BRAND" = "TITLELIVE" ]; then
                startpage=http://start.obreey.com/
        fi
	if [ "$PB_BRAND" = "LIBRONET" ]; then
                startpage='http://calibro.com/start'
	fi
	if [ "$PB_BRAND" = "APOLLO" ]; then
                startpage='http://www.google.com'
	fi

while [ -n "$1" ]; do
	if [ -z "$2" ]; then
	# last parameter
	startpage="$1"
	else
	browser_params="$browser_params $1"
	fi
	shift
done

while pidof tea-store-launcher.app; do
        echo "Kill tea-store-launcher.app"
        killall tea-store-launcher.app
        usleep 300000
done
while pidof browser.app; do
        echo "Kill browser.app"
        killall browser.app
        usleep 300000
done


echo "browser_params=$browser_params startpage=$startpage"
browser_pid="$(pidof browser.app)"

if [ ${startpage:0:4} = http ]; then
	network_up
fi

if [ -z "$browser_pid" ]; then
               /ebrmain/bin/openbook /ebrmain/bin/browser.app $browser_params "$startpage" ; exit $?
else
        for p in $browser_pid; do
                echo "examine $p"
                p_params=
		while read pp; do
		p_params="$p_params$pp\t"
		done << EEEE
$(cat /proc/$p/cmdline | tr \\000 \\n )
EEEE
                want_params=
		for ww in /ebrmain/bin/browser.app $browser_params "$startpage" ; do
		want_params="$want_params$ww\t"
		done
                want_params_l=
		for ww in /ebrmain/bin/browser.app $browser_params ; do
		want_params_l="$want_params_l$ww\t"
		done
                echo "   p_params='$p_params'"
                echo "want_params='$want_params'"
                echo "want_params_l='$want_params_l'"
		can_fg=
		if [ "$p_params" = "$want_params" ]; then
			can_fg=yes
		fi
		len_m=${#want_params_l}
		echo "examine 1st $len_m chars"
		echo $p_params|cut -b -$len_m
		echo $want_params|cut -b -$len_m

		if [ "`echo $p_params|cut -b -$len_m`" = "`echo $want_params|cut -b -$len_m`" ] ; then
			# difference only in last parameter = url
			last_param="`echo $p_params|cut -b ${len_m}- |cut -b 2-`" 
			echo last_param=$last_param
			if [ "${last_param:0:1}" = "/" ] ||  [ "${last_param:0:4}" = "http" ]; then
			can_fg=yes
			fi
			
		fi
                if [ "$can_fg" = "yes" ]; then
                        echo "parameters matches, try foreground"
                        /ebrmain/bin/openbook /ebrmain/bin/browser.app ; exit $?
                else
                        echo "kill and reboot"
                        killall browser.app
			echo "Wait until browser really killed"
			timer=2000000 # 2s
			browser_pid=`/ebrmain/bin/iv2sh FindTaskByAppName browser.app`
			while [ "$browser_pid" -gt 0 ] && [ $timer -gt 0 ]
			do
				usleep 100000
				timer=`expr $timer - 100000`
				browser_pid=`/ebrmain/bin/iv2sh FindTaskByAppName browser.app`
			done
                        /ebrmain/bin/openbook /ebrmain/bin/browser.app $browser_params "$startpage" ; exit $?
                fi
        done
fi

