import java.lang.Runtime;
import java.util.Date;
import java.util.Locale;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.Properties;
import java.util.Locale;
import java.util.ResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.InputStreamReader;
import java.io.IOException;
import java.text.DateFormat;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import javax.swing.ScrollPaneLayout;
import javax.swing.BorderFactory;
import javax.swing.border.EtchedBorder;
import javax.swing.KeyStroke;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import java.awt.Image;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

public class Catalog implements ActionListener, MouseListener, KeyListener{
    //--- Variables ------------------------------------------------------------
    private final static String PRG="Catalog";
    private final static String AUTHOR="T.Berndt";
    private final static String VERSION="0.7";
    private static String[] labels={
        /*  0 */ "eBook-Catalog",
        /*  1 */ "Authors",
        /*  2 */ "Titles",
        /*  3 */ "Book",
        /*  4 */ "Author",
        /*  5 */ "Title",        
        /*  6 */ "Genre",
        /*  7 */ "Series",
        /*  8 */ "File",
        /*  9 */ "Image",
        /* 10 */ "Description",
        /* 11 */ "New",
        /* 12 */ "Add",
        /* 13 */ "Save",
        /* 14 */ "Delete",
        /* 15 */ "eBook",
        /* 16 */ "Edit",
        /* 17 */ "Cancel",
        /* 18 */ "Open"
    };
    private static String[] dialogStr={
        /*  0 */ "Catalog-Error",
        /*  1 */ "An error occurred loading the booklist.",
        /*  2 */ "No filename given.",
        /*  3 */ "No desitination path given.",
        /*  4 */ "Cannot create destination directory.",
        /*  5 */ "The given file does not exist.",
        /*  6 */ "Cannot copy the book.",
        /*  7 */ "Cannot copy the image.",
        /*  8 */ "Cannot write Manifest file",
        /*  9 */ "Select file",
        /* 10 */ "Select image",
        /* 11 */ "Path to the eBook:",
        /* 12 */ "Catalog-Dialog",
        /* 13 */ "A runtime error occurred."
    };        

    //--- Variables ------------------------------------------------------------
    private final static Catalog instance=new Catalog();
    Books books=Books.getInstance();
    Book book;
    Book backup;
    JFrame window;
    JList authorList;
    JList titleList;
    DefaultListModel authorModel;
    DefaultListModel titleModel;
    JTextField authorText;
    JTextField titleText;
    JComboBox genreCB;
    DefaultComboBoxModel genreModel;
    JTextField seriesText;
    JButton fileBT;
    JTextField fileText;
    JButton imageBT;
    JTextField imageText;
    JLabel imageLabel;
    JEditorPane descriptionText;
    JButton newBT;
    JButton addBT;
    JButton saveBT;
    JButton deleteBT;
    JButton eBookBT;
    JButton openBT;
    JToggleButton editBT;
    JButton cancelBT;
    FileChooser fc;
    String eBookPath;
    String propFile;
    boolean canOpen;
    Locale locale;
    
    //--- Methods --------------------------------------------------------------
    public static void main(String[] args){
        Catalog app=Catalog.getInstance();
        app.init(args);
    }
    public static Catalog getInstance(){return instance;}
    public Book getBook(){return book;}
    public void init(String[] args){
        loadPrefs(args);
        initUI();
        loadBooks();
        window.validate();
        window.pack();
        window.setVisible(true);
    }
    public void loadPrefs(String[] args){
        String lang=null;
        int selectedUnit=0;
        
        //--- Get the properties as stored to disk
        propFile=System.getProperties().getProperty("user.home")
            +File.separator
            +"."+PRG
            +".rc";
        try{
            Properties config=new Properties();
            config.load(new FileInputStream(new File(propFile)));
            lang=config.getProperty("lang");
            eBookPath=config.getProperty("path");
        } catch (IOException e){}
        
        //--- Get the arguments from the command line, overriding properties
        for (int i=0; i<args.length; i++){
            if (args[i].equals("-lang") && i+1<args.length) lang=args[i+1];
            if (args[i].equals("-path") && i+1<args.length) eBookPath=args[i+1];
        }
        //--- Init and set-up the locale
        initLocale(lang);
    }
    void savePrefs(){
        try{
            PrintWriter f=new PrintWriter(new FileWriter(propFile));
            String lang=locale.getCountry();
            if (lang.length()>0) f.println("lang: "+lang);
            f.println("path: "+eBookPath);
            f.close();
        } catch (IOException ex){}        
    }    
    void initLocale(String lang){
    	if (lang==null) {
            locale=Locale.getDefault();
    	} else {
	    // example lang = "en_IE.UTF-8"
            String[] langcountry = lang.replaceFirst("[.].*", "").split("_", 2);
            locale=(langcountry.length==2?new Locale(langcountry[0], langcountry[1]): new Locale (lang));                
    	}
        try{
            ResourceBundle msgs=ResourceBundle.getBundle("catalogMsgs", locale);
            labels[ 0]=msgs.getString("label_window_title");
            labels[ 1]=msgs.getString("label_authors");
            labels[ 2]=msgs.getString("label_titles");
            labels[ 3]=msgs.getString("label_book");
            labels[ 4]=msgs.getString("label_author");
            labels[ 5]=msgs.getString("label_title");
            labels[ 6]=msgs.getString("label_genre");
            labels[ 7]=msgs.getString("label_series");
            labels[ 8]=msgs.getString("label_file");
            labels[ 9]=msgs.getString("label_image");
            labels[10]=msgs.getString("label_desc");
            labels[11]=msgs.getString("label_new");
            labels[12]=msgs.getString("label_add");
            labels[13]=msgs.getString("label_save");
            labels[14]=msgs.getString("label_delete");
            labels[15]=msgs.getString("label_ebook");
            labels[16]=msgs.getString("label_edit");
            labels[17]=msgs.getString("label_cancel");
            labels[18]=msgs.getString("label_open");

            dialogStr[ 0]=msgs.getString("dialog_err");
            dialogStr[ 1]=msgs.getString("dialog_load_err");
            dialogStr[ 2]=msgs.getString("dialog_no_file");
            dialogStr[ 3]=msgs.getString("dialog_no_path");
            dialogStr[ 4]=msgs.getString("dialog_dir_err");
            dialogStr[ 5]=msgs.getString("dialog_file_nex");
            dialogStr[ 6]=msgs.getString("dialog_cant_copy_book");
            dialogStr[ 7]=msgs.getString("dialog_cant_copy_image");
            dialogStr[ 8]=msgs.getString("dialog_cant_write_manif");
            dialogStr[ 9]=msgs.getString("dialog_select_file");
            dialogStr[10]=msgs.getString("dialog_select_image");
            dialogStr[11]=msgs.getString("dialog_device_path");
            dialogStr[12]=msgs.getString("dialog_dialog");
            dialogStr[13]=msgs.getString("dialog_runtime_err");

            //--- save the current prefs
            savePrefs();
        } catch (Exception e){
            e.printStackTrace();            
            System.err.println("Warning: Resource file not found; using default (EN)");
        }
    }
    void initUI(){
        //--- Honor the OS 
        String osType = System.getProperty("os.name").toLowerCase();
        int mask=java.awt.Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (osType.indexOf("mac")!=-1){
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            canOpen=true;
            fc=new AWTFileChooser();
        } else {
            fc=new SwingFileChooser();
        }
        
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e){}

        //--- author list/panel
        authorModel=new DefaultListModel();
        authorList=new JList(authorModel);
        authorList.addMouseListener(this);
        authorList.addKeyListener(this);
        JScrollPane authorScroller=new JScrollPane(authorList);
        JPanel authorPanel=new JPanel(new BorderLayout());
        authorPanel.setBorder(BorderFactory.createTitledBorder(labels[1]));
        authorPanel.add(authorScroller);
        authorPanel.setPreferredSize(new Dimension(250, 120));

        //--- title list/panel
        titleModel=new DefaultListModel();
        titleList=new JList(titleModel);
        titleList.addMouseListener(this);
        titleList.addKeyListener(this);
        
        JScrollPane titleScroller=new JScrollPane(titleList);
        JPanel titlePanel=new JPanel(new BorderLayout());
        titlePanel.setBorder(BorderFactory.createTitledBorder(labels[2]));
        titlePanel.add(titleScroller);
        titlePanel.setPreferredSize(new Dimension(250, 120));

        //--- book panel
        JPanel bookPanel=new JPanel();
        bookPanel.setLayout(new BoxLayout(bookPanel, BoxLayout.Y_AXIS));
        bookPanel.setBorder(BorderFactory.createTitledBorder(labels[3]));

        //---- author
        authorText=UIFactory.newTextField(20, "",Book.keys[1], this, this);
        authorText.setEnabled(false);
        bookPanel.add(UIFactory.addElements(labels[4], authorText));

        //--- title
        titleText=UIFactory.newTextField(20, "",Book.keys[2], this, this);
        titleText.setEnabled(false);
        bookPanel.add(UIFactory.addElements(labels[5], titleText));

        //--- genre
        genreModel=new DefaultComboBoxModel();
        genreCB=UIFactory.newComboBox(genreModel, Book.keys[3], null);
        genreCB.setEnabled(false);
        genreCB.setEditable(true);
        bookPanel.add(UIFactory.addElements(labels[6], genreCB));

        //--- series
        seriesText=UIFactory.newTextField(20, "", Book.keys[4], this, this);
        seriesText.setEnabled(false);
        bookPanel.add(UIFactory.addElements(labels[7], seriesText));

        //--- file
        fileBT=UIFactory.newButton(labels[8], "BT:"+labels[8], 'F', this);
        fileBT.setEnabled(false);
        fileText=UIFactory.newTextField(20, "",Book.keys[5], this, this);
        fileText.setEnabled(false);
        UIFactory.addElements(bookPanel, fileBT, fileText);

        //--- image
        imageBT=UIFactory.newButton(labels[9], "BT:"+labels[9], 'I', this);
        imageBT.setEnabled(false);
        imageText=UIFactory.newTextField(20, "", Book.keys[6], this, this);
        imageText.setEnabled(false);
        UIFactory.addElements(bookPanel, imageBT, imageText);

        //--- image icon
        JPanel imagePanel=new JPanel(new FlowLayout(FlowLayout.TRAILING));
        imageLabel=new JLabel();
        imagePanel.setPreferredSize(new Dimension(200, 200));
        imagePanel.add(imageLabel);
        bookPanel.add(imagePanel);
        
        //--- description
        JPanel editorPanel=new JPanel(new BorderLayout());
        descriptionText=new JEditorPane();
        descriptionText.addKeyListener(this);
        descriptionText.setPreferredSize(new Dimension(400, 120));
        descriptionText.setEnabled(false);
        editorPanel.setBorder(BorderFactory.createTitledBorder(labels[10]));
        editorPanel.add(new JScrollPane(descriptionText), BorderLayout.CENTER);
        bookPanel.add(editorPanel);
        bookPanel.setBorder(BorderFactory.createTitledBorder(labels[3]));
        
        //--- put it all together
        JPanel mainPanel=new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
        mainPanel.add(authorPanel);
        mainPanel.add(titlePanel);
        mainPanel.add(bookPanel);

        //--- buttons
        JPanel buttonPanel=new JPanel(new FlowLayout());

        newBT=UIFactory.newButton(labels[11], "BT:"+labels[11], 'N', this);
        addBT=UIFactory.newButton(labels[12], "BT:"+labels[12], 'A', this);
        saveBT=UIFactory.newButton(labels[13], "BT:"+labels[13], 'S', this);
        deleteBT=UIFactory.newButton(labels[14], "BT:"+labels[14], 'D', this);
        eBookBT=UIFactory.newButton(labels[15], "BT:"+labels[15], 'B', this);
        editBT=new JToggleButton(labels[16]);
        editBT.setActionCommand("BT:"+labels[16]);
        editBT.setMnemonic('E');
        editBT.addActionListener(this);
        cancelBT=UIFactory.newButton(labels[17], "BT:"+labels[17], 'C', this);
        openBT=UIFactory.newButton(labels[18], "BT:"+labels[18], 'O', this);
        openBT.setVisible(canOpen);
        
        buttonPanel.add(newBT);
        buttonPanel.add(editBT);
        buttonPanel.add(addBT);
        buttonPanel.add(cancelBT);
        buttonPanel.add(saveBT);
        buttonPanel.add(deleteBT);
        buttonPanel.add(eBookBT);
        buttonPanel.add(openBT);

        //--- set visibility/enabled
        addBT.setVisible(false);
        cancelBT.setVisible(false);

        //--- window panel
        JPanel windowPanel=new JPanel(new BorderLayout());
        windowPanel.add(mainPanel, BorderLayout.CENTER);
        windowPanel.add(buttonPanel, BorderLayout.SOUTH);

        //--- window
        window=new JFrame(labels[0]);
        window.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);        
        window.setContentPane(windowPanel);
    }    
    void makeAuthorList(){
        int j=0;
        int n=books.size();
        String[] authorArray=new String[n+1];
        authorArray[n]="*";
        for (int i=0; i<n; i++) authorArray[j++]=books.get(i).getAuthor();
        Arrays.sort(authorArray);
        authorModel.removeAllElements();
        for (int i=0; i<=j; i++){
            if (!authorModel.contains(authorArray[i])){
                authorModel.addElement(authorArray[i]);
            }
        }
        authorList.setSelectedIndex(0);
    }
    void makeTitleList(String author, String guid){
        int j=0;
        int index=-1;
        int n=books.size();
        Title[] titleArray=new Title[n];
        Book b;
        
        if (author==null) author=book.getAuthor();
        if (n==0) return;
        //--- get the guid of the currently selected title
        if (guid==null && titleList.getSelectedIndex()!=-1){
            guid=((Title)titleList.getSelectedValue()).guid;
        }
        
        titleModel.removeAllElements();
        //--- sacrifice performance for elegance
        //--- create list of titles for the given author or all (*)
        for (int i=0; i<n; i++){
            b=books.get(i);
            if (author.equals("*") || author.equals(b.getAuthor())){
                titleArray[j++]=new Title(b.getGUID(), b.getTitle(), b.getSeries(), i);
            }
        }

        //--- sort the titles
        Arrays.sort(titleArray, 0, j);
        for (int i=0; i<j; i++){
            titleModel.addElement(titleArray[i]);
            //--- check the prev selected book is contained in this list
            if (titleArray[i].guid==guid) index=i;
        }
        
        if (titleArray.length>0){
            titleList.setSelectedIndex(index!=-1?index:0);
            titleList.ensureIndexIsVisible(index);
            titleList.grabFocus();
            setBook();
        }
        
        //--- set the window Title
        window.setTitle(labels[0]
                        +" ("+ labels[1]+": "+authorModel.size()
                        +", "+labels[2]+": "+titleModel.getSize()
                        +"/"+books.size()+")");
    }
    void makeTitleList(String author){makeTitleList(author, null);}
    void loadBooks(){
        if (!books.load()){
            errorMsg(dialogStr[1]);
            return;
        }
        if (books.size()>0){
            makeAuthorList();
            makeTitleList("*");

            //--- make the list of genres
            ArrayList<String> list=new ArrayList<String>();
            for (int i=0; i<books.size(); i++){
                String genre=books.get(i).getGenre();
                if (!list.contains(genre)) list.add(genre);
            }
            Object[] genres=list.toArray();
            Arrays.sort(genres);
            for (int i=0; i<genres.length; i++) genreModel.addElement(genres[i]);
        } else {
            newBook();
        }
    }
    void saveBooks(){books.save();}
    void setBook(){
        int i=titleList.getSelectedIndex();
        if (i<0) return;
        Title t=(Title)titleList.getSelectedValue();

        book=books.get(t.pos);
        authorText.setText(book.getAuthor());
        titleText.setText(book.getTitle());
        genreCB.setSelectedItem(book.getGenre());
        seriesText.setText(book.getSeries());
        fileText.setText(book.getFileName());
        imageText.setText(book.getImageName());
        descriptionText.setText(book.getDescription());
        setImage();
    }
    void setImage(){
        String imageName=book.getImageName();
        if (imageName!=null && imageName.length()>0){
            ImageIcon icon=new ImageIcon(imageName);
            Image img=icon.getImage();
            icon.setImage(img.getScaledInstance(150, 150, Image.SCALE_SMOOTH));
            imageLabel.setIcon(icon);
        } else {
            imageLabel.setIcon(null);
        }        
    }
    void clearBook(){        
        authorText.setText("");
        titleText.setText("");
        genreCB.setSelectedIndex(-1);
        seriesText.setText("");
        fileText.setText("");
        imageText.setText("");
        descriptionText.setText("");

        //--- clear the image
        if (book!=null){
            book.setImageName("");
            setImage();
        }
    }
    void newBook(){
        String authorStr=(String)authorList.getSelectedValue();
        clearBook();
        backup=book;                    // get the current book as backup
        book=new Book();                // create the new book
        book.createGUID();
        books.add(book);
        setEditable(true);
        editBT.setVisible(false);
        addBT.setVisible(true);

        //--- is this the first book? only adding is possible
        if (books.size()<=1) buttonsOff();
        
        //--- has an author been selected? provide this name as default
        if (authorStr!=null && !authorStr.equals("*")){
            authorText.setText(authorStr);
            book.setAuthor(authorStr);
        }
        authorText.grabFocus();
    }
    void addBook(){        
        //--- add the book only, if we have author and title
        if (book.getAuthor().length()==0 && book.getTitle().length()==0){
            if (titleModel.size()<=0){  // do we have any titles?
                //--- NO, force the user to enter a book
                authorText.grabFocus();
                return;
            }            
            //--- remove this one, it's not filled correctly, assume cancelled
            cancelEdit();
            return;
        }
        
        //--- after adding a book set the lists
        String author=book.getAuthor();
        if (!authorModel.contains(author)) makeAuthorList();
        authorList.setSelectedValue(author, true);
        setEditable(false);
        editBT.setVisible(true);
    }
    void deleteBook(){
        int i=titleList.getSelectedIndex();
        int n=titleModel.size()-1;
        Title t=(Title)titleList.getSelectedValue();

        books.remove(t.pos);
        //--- are there still books to be deleted?
        if (books.size()<=0){
            authorModel.clear();
            titleModel.clear();
            clearBook();
            buttonsOff();            
            return;
        }

        //--- update the author- and title lists
        makeTitleList((String)authorList.getSelectedValue());
        
        //--- have we deleted all this author's books?
        if (n>0){                           // NO, pick the next one
            if (i>=n) i--;                  // was it the hindmost title?
            titleList.setSelectedIndex(i);  
        } else {                            // YES, change to all authors
            makeAuthorList();
            makeTitleList("*");
        }
    }
    void cancelEdit(){
        if (addBT.isVisible()){             // cancel creating a new book
            books.remove(books.size()-1);
            setBook();
            editBT.setVisible(true);
        } else {                            // cancel editing an existing book
            if (titleList.getSelectedIndex()<0) return;
            books.set(((Title)titleList.getSelectedValue()).pos, backup);
            editBT.setSelected(false);
        }
        setEditable(false);        
    }
    
    void setEditable(boolean editable){
        if (editable){
            //--- enable the text fields
            authorText.setEnabled(true);
            titleText.setEnabled(true);
            genreCB.setEnabled(true);
            seriesText.setEnabled(true);
            fileBT.setEnabled(true);
            fileText.setEnabled(true);
            imageBT.setEnabled(true);
            imageText.setEnabled(true);
            descriptionText.setEnabled(true);

            //--- disable/enable; show/hide the buttons
            newBT.setVisible(false);
            deleteBT.setVisible(false);
            eBookBT.setVisible(false);
            cancelBT.setVisible(true);
            saveBT.setVisible(false);
            openBT.setVisible(false);
            
            //--- disable the lists 
            authorList.setEnabled(false);
            titleList.setEnabled(false);

            //--- awake the genreComboBox to sleep
            genreCB.addActionListener(this);

            //--- activate the authorTextField
            authorText.grabFocus();
        } else {
            //--- disable the text fields
            authorText.setEnabled(false);
            titleText.setEnabled(false);
            genreCB.setEnabled(false);
            seriesText.setEnabled(false);
            fileBT.setEnabled(false);
            fileText.setEnabled(false);
            imageBT.setEnabled(false);
            imageText.setEnabled(false);
            descriptionText.setEnabled(false);

            //--- enable/disable; hide/show the buttons
            addBT.setVisible(false);
            newBT.setVisible(true);
            deleteBT.setVisible(true); 
            eBookBT.setVisible(true);
            cancelBT.setVisible(false);            
            saveBT.setVisible(true);
            openBT.setVisible(true);

            //--- enable the lists 
            authorList.setEnabled(true);
            titleList.setEnabled(true);

            //--- send the genreComboBox to sleep
            genreCB.removeActionListener(this);            
            
            //--- activate the titles list
            String author=(String)authorList.getSelectedValue();
            //--- do we have to update the authorlist?
            if (!author.equals(book.getAuthor())){
                makeAuthorList();
                authorList.setSelectedValue((Object)book.getAuthor(), true);
            }
            makeTitleList(book.getAuthor(), book.getGUID());
        }
    }
    void buttonsOff(){            
        editBT.setVisible(false);
        deleteBT.setVisible(false);
        eBookBT.setVisible(false);
        cancelBT.setVisible(false);
        saveBT.setVisible(false);
    }
    void sendBook(){
        if (book==null) return;
        String s=(String)JOptionPane.showInputDialog(window,
                                                     dialogStr[11],
                                                     dialogStr[12],
                                                     JOptionPane.PLAIN_MESSAGE,
                                                     null,
                                                     null,
                                                     eBookPath);
        if (s==null) return;
        if (!s.equals(eBookPath)){
            eBookPath=s;
            savePrefs();
        }

        String srcBook=book.getFileName();
        String srcImage=book.getImageName();
        String dirName=null;
        String destBook=null;
        String destImage=null;
        File f;        

        //--- sanity checks
        if (srcBook.length()==0){
            errorMsg(dialogStr[2]);
            return ;
        }
        if (eBookPath.length()==0){
            errorMsg(dialogStr[3]);
            return;
        }

        //--- finish the path with a proper seperator
        if (!eBookPath.endsWith(File.separator)) eBookPath+=File.separator;

        //--- construct the target directory's name
        dirName=eBookPath+book.getTitle()+File.separator;
        f=new File(dirName);
        if (!f.exists() && !f.mkdir()){
            errorMsg(dialogStr[4]+" '"+dirName+"'");
            return;
        }
        
        //--- copy the book
        f=new File(srcBook);
        if (!f.exists()){
            errorMsg(dialogStr[5]);
            return;
        }
        
        destBook=f.getName();
        if (!copy(srcBook, dirName+destBook)){
            errorMsg(dialogStr[6]);
            return;
        }

        //--- copy the image
        if (srcImage!=null && srcImage.length()>0){
            f=new File(book.getImageName());
            if (f.exists()){
                destImage=f.getName();
                if (!copy(srcImage, dirName+destImage)){
                    errorMsg(dialogStr[7]);
                    return;
                }
            } else {
                destImage="";
            }
        }
        
        //--- create the manifest
        Date today=new Date();
        DateFormat date=DateFormat.getDateInstance(DateFormat.LONG, Locale.getDefault());

        //--- Write the manifest
        try{
            PrintWriter out=new PrintWriter(new FileWriter(dirName+"manifest.xml"));
            out.println(
                        "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"+
                        "<!--manifest generated by "+PRG+" V"+VERSION+"-->\n"+
                        "<package>\n"+
                        "  <metadata>\n"+
                        "    <dc-metadata>\n"+
                        "      <Title>"+book.getTitle()+"</Title>\n"+
                        "      <Description>"+book.getAuthor()+(book.getSeries().length()>0?" - "+book.getSeries():"")+"</Description>\n"+
                        "      <Date>"+date.format(today)+"</Date>\n"+
                        "    </dc-metadata>\n"+
                        "    <y-metadata>\n"+
                        "      <startpage>"+destBook+"</startpage>\n"+
                        "      <image>"+destImage+"</image>\n"+
                        "      <version>000</version>\n"+
                        "    </y-metadata>\n"+
                        "  </metadata>\n"+
                        "</package>");
            out.close();
        } catch (IOException e){
            errorMsg(dialogStr[8]);
        }
    }
    boolean copy(String src, String dest){
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(src));
            BufferedWriter out = new BufferedWriter(new FileWriter(dest));

            while ((c = in.read()) != -1) out.write(c);
            in.close();
            out.close();
        } catch (IOException e){
            return false;
        }
        return true;
    }
    void openBook(){
        /* Dear reader, 
         * If you come this far and wonder why you don't see the 'Open'
         * button, it's likely that you don't have a Mac!
         * The reason why the 'Open' button is shown only on Macs is
         * due to my lack of knowledge, I simply don't know how to do 
         * the equivalent hack for Windows, Linux or whatever.
         * So, this hack only works on the Mac, and it's getting even
         * dirtier: copy the book to /tmp and execute the Mac's native
         * Preview app (via the open cmd) with that tmp-file
         */
        String bookName=book.getFileName();
        if (bookName==null|| bookName.length()==0) return;
        String fileName="/tmp/catalogFile";
        copy(bookName, fileName);
        
        Runtime runtime=Runtime.getRuntime();
        try{
            String[] cmd=new String[4];
            cmd[0]="open";
            cmd[1]="-a";
            cmd[2]="/Applications/Preview.app/Contents/MacOS/Preview";
            cmd[3]=fileName;            
            
            Process p=runtime.exec(cmd);            

            //--- read the output from the command
//             BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
//             String s;
//             System.out.println("Here is the standard output of the command:\n");
//             while ((s = stdInput.readLine()) != null) {
//                 System.out.println(s);
//             }
            
            //--- read any errors from the attempted command
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            if (stdErr.ready()){
                StringBuffer buffer=new StringBuffer();
                while (stdErr.ready()) buffer.append(stdErr.readLine());
                System.out.println("STDERR\n"+buffer);
            }
        } catch (Exception e){
            errorMsg(dialogStr[13]);
        }
    }
    
    void errorMsg(String msg){
        JOptionPane.showMessageDialog(window, 
                                             msg, 
                                             dialogStr[0], 
                                             JOptionPane.ERROR_MESSAGE);
    }
    void addGenre(String genre){
        genreModel.addElement(genre);
        ArrayList<String> list=new ArrayList<String>();
        for (int i=0; i<genreModel.getSize(); i++) list.add((String)genreModel.getElementAt(i));
        Object[] genres=list.toArray();
        Arrays.sort(genres);
        genreModel.removeAllElements();
        for (int i=0; i<genres.length; i++) genreModel.addElement(genres[i]);
    }    
    //--- Interface Methods ----------------------------------------------------
    public void actionPerformed(ActionEvent e){
        Object uiEl=e.getSource();
        String cmd=e.getActionCommand();
        if (cmd.equals(Book.keys[1])){              // author
            titleText.grabFocus();
        } else if (cmd.equals(Book.keys[2])){       // title
            genreCB.grabFocus();
        } else if (cmd.equals(Book.keys[3])){       // genre
            String genre=(String)genreCB.getSelectedItem();
            if (genreCB.getSelectedIndex()==-1){
                addGenre(genre);
                genreModel.setSelectedItem(genre);
            }
            book.setGenre(genre);
            seriesText.grabFocus();
        } else if (cmd.equals(Book.keys[4])){       // series
            fileText.grabFocus();
        } else if (cmd.equals(Book.keys[5])){       // file
            imageText.grabFocus();
        } else if (cmd.equals(Book.keys[6])){       // image
            descriptionText.grabFocus();
        } else if (cmd.equals("BT:"+labels[8])){    // file 
            if (fc.getFileName((Object)window, fileText, dialogStr[9])){
                book.setFileName(fileText.getText());
            }
        } else if (cmd.equals("BT:"+labels[9])){    // image
            if (fc.getFileName((Object)window, imageText, dialogStr[10])){
                book.setImageName(imageText.getText());
                setImage();
            }            
        } else if (cmd.equals("BT:"+labels[11])){   // new
            newBook();
        } else if (cmd.equals("BT:"+labels[12])){   // add
            addBook();
        } else if (cmd.equals("BT:"+labels[13])){   // save
            saveBooks();
        } else if (cmd.equals("BT:"+labels[14])){   // delete
            deleteBook();
        } else if (cmd.equals("BT:"+labels[15])){   // clear
            sendBook();
        } else if (cmd.equals("BT:"+labels[16])){   // edit
            backup=book.clone();
            setEditable(editBT.isSelected());
        } else if (cmd.equals("BT:"+labels[17])){   // cancel
            cancelEdit();
        } else if (cmd.equals("BT:"+labels[18])){   // open
            openBook();
        }   
    }
    public void mouseReleased(MouseEvent e){
        if (e.getClickCount()<1) return;
        Object uiEl=e.getSource();
        if (uiEl==authorList){
            makeTitleList((String)authorList.getSelectedValue());
        } else if (uiEl==titleList){
            setBook();
        }
    }
    public void mousePressed(MouseEvent e){}
    public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}
    public void mouseClicked(MouseEvent e){}
    public void keyPressed(KeyEvent e){}
    public void keyReleased(KeyEvent e){
        Object uiEl=e.getSource();
        if (uiEl==authorText){
            book.setAuthor(authorText.getText());
        } else if (uiEl==titleText){
            book.setTitle(titleText.getText());
        } else if (uiEl==seriesText){
            book.setSeries(seriesText.getText());
        } else if (uiEl==fileText){
            book.setFileName(fileText.getText());
        } else if (uiEl==imageText){
            book.setImageName(imageText.getText());
            setImage();
        } else if (uiEl==descriptionText){
            book.setDescription(descriptionText.getText());
        } else if (uiEl==authorList){
            makeTitleList((String)authorList.getSelectedValue());
            authorList.grabFocus();
        } else if (uiEl==titleList){
            setBook();
        }   
    }
    public void keyTyped(KeyEvent e){}
}
