import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Book{
    //--- Variables ------------------------------------------------------------
    private final static String VERSION="0.1";

    String guid=null;
    String author="";
    String title="";
    String genre="";
    String series="";
    String file="";
    String image="";
    String description="";

    public final static String keys[]={
        /* 0 */ "BOOK::GUID",
        /* 1 */ "BOOK::AUTHOR",
        /* 2 */ "BOOK::TITLE",
        /* 3 */ "BOOK::GENRE",
        /* 4 */ "BOOK::SERIES",
        /* 5 */ "BOOK::FILE",
        /* 6 */ "BOOK::IMAGE",
        /* 7 */ "BOOK::DESCRIPTION"
    };    
    
    //--- Methods --------------------------------------------------------------
    public void createGUID(){
        if (guid!=null) return;
	String zero="00000000";
	String hashCode=""+this.hashCode();
	int l=10-hashCode.length(); 
	String s=zero.substring(0, l)+hashCode;
	guid=s+"."+System.currentTimeMillis();
    }
    public String getGUID(){return guid;}
    public void setGUID(String s){guid=s;}
    public String getAuthor(){return author;}
    public void setAuthor(String s){author=s;}
    public String getTitle(){return title;}
    public void setTitle(String s){title=s;}
    public String getGenre(){return genre;}
    public void setGenre(String s){genre=s;}
    public String getSeries(){return series;}
    public void setSeries(String s){series=s;}
    public String getFileName(){return file;}
    public void setFileName(String s){file=s;}
    public String getImageName(){return image;}
    public void setImageName(String s){image=s;}
    public String getDescription(){return description;}
    public void setDescription(String s){description=s;}

    public String get(String key){
        if (key.equals(keys[0])){
            return getGUID();
        } else if (key.equals(keys[1])){
            return getAuthor();
        } else if (key.equals(keys[2])){
            return getTitle();
        } else if (key.equals(keys[3])){
            return getGenre();
        } else if (key.equals(keys[4])){
            return getSeries();
        } else if (key.equals(keys[5])){
            return getFileName();
        } else if (key.equals(keys[6])){
            return getImageName();
        } else if (key.equals(keys[7])){
            return getDescription();
        } else {
            return null;
        }
    }
    public void set(String key, String s){
        if (key.equals(keys[0])){
            setGUID(s);
        } else if (key.equals(keys[1])){
            setAuthor(s);
        } else if (key.equals(keys[2])){
            setTitle(s);
        } else if (key.equals(keys[3])){
            setGenre(s);
        } else if (key.equals(keys[4])){
            setSeries(s);
        } else if (key.equals(keys[5])){
            setFileName(s);
        } else if (key.equals(keys[6])){
            setImageName(s);
        } else if (key.equals(keys[7])){
            setDescription(s);
        } else {
            return;
        }
    }

    public boolean find(String key, String s){return s.equals(get(key));}
    public int match(String key, String s){return get(key).indexOf(s);}
    
    public boolean read(BufferedReader f){
        try{
            for (int i=0; i<keys.length-1; i++) set(keys[i], f.readLine().trim());
            //--- read the description until "<<<END" is found
            StringBuffer buffer=new StringBuffer();
            String line=f.readLine().trim();
            while (!line.equals("<<<END")){
                if (line.length()>0)  buffer.append(line+"\n");
                line=f.readLine().trim();
            }
            setDescription(buffer.toString());
        } catch (Exception e){
            System.err.println("WARNING: Book record corrupt!!!\n"+this);
            return false;
        }
        if (guid.length()==0) return false;
        return true;
    }
    public void write(BufferedWriter f) throws IOException{
        for (int i=0; i<keys.length; i++){
            f.write(get(keys[i]));
            f.newLine();
        }    //f.println(get(keys[i]));
        //f.println("<<<END");
        f.write("<<<END");
        f.newLine();
    }
    public Book clone(){
        Book b=new Book();
        for (int i=0; i<keys.length; i++) b.set(keys[i], get(keys[i]));
        return b;
    }
    
    public String toString(){
        return 
            "\nguid        : "+guid+
            "\nauthor      : "+author+
            "\ntitle       : "+title+
            "\ngenre       : "+genre+
            "\nseries      : "+series+
            "\nfile        : "+file+
            "\nimage       : "+image+
            "\ndescription : "+description;
    }
}
