import javax.swing.JFrame;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.BorderFactory;
import javax.swing.SpringLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;

public class UIFactory{
    public static JLabel newLabel(String text){
        return new JLabel(text, javax.swing.SwingConstants.RIGHT);
    }
    public static JTextField newTextField(int len, 
                                          String s,
                                          String cmd,
                                          Object o1,
                                          Object o2){
        JTextField textField;
        textField=(len>0?new JTextField(len):new JTextField());
        if (s!=null) textField.setText(s);
        if (o1!=null) textField.addActionListener((ActionListener)o1);
        if (o2!=null) textField.addKeyListener((KeyListener)o2);
        if (cmd!=null) textField.setActionCommand(cmd);
        return textField;
    }
    public static JTextField newTextField(String text, 
                                          String cmd,
                                          Object o1,
                                          Object o2){
        return newTextField(0, text, cmd, o1, o2);
    }
    public static JTextField newTextField(String text, 
                                          String cmd,
                                          Object object){
        return newTextField(0, text, cmd, object, null);
    }
    public static JTextField newTextField(int len, 
                                          String cmd,
                                          Object o1,
                                          Object o2){
        return newTextField(len, null, cmd, o1, o2);
    }
    public static JTextField newTextField(int len, 
                                          String cmd,
                                          Object object){
        return newTextField(len, null, cmd, object, null);
    }
    public static JButton newButton(String label,
                                    String cmd,
                                    char c, 
                                    Object object){
        JButton button=new JButton(label);
        button.addActionListener((ActionListener)object);
        button.setActionCommand(cmd);
        if (c>0) button.setMnemonic(c);
        return button;
    }
    public static JCheckBox newCheckBox(String label,
                                        String cmd,
                                        char c, 
                                        Object object){
        JCheckBox checkBox=new JCheckBox(label);
        checkBox.addActionListener((ActionListener)object);
        checkBox.setActionCommand(cmd);
        if (c>0) checkBox.setMnemonic(c);
        return checkBox;
    }
    public static JComboBox newComboBox(ComboBoxModel model,
                                       String cmd,
                                       Object object){
        JComboBox comboBox=new JComboBox(model);
        comboBox.addActionListener((ActionListener)object);
        comboBox.setActionCommand(cmd);
        return comboBox;
    }
    public static void addElements(JComponent/*JPanel*/ parent, 
                                   JComponent label, 
                                   JComponent text){
        JPanel panel=new JPanel(new FlowLayout(FlowLayout.TRAILING));
        //JPanel panel=new JPanel(new FlowLayout(FlowLayout.LEADING));
        if (label!=null) panel.add(label);
        if (text!=null) panel.add(text);
        parent.add(panel);
    }
    public static JPanel addElements(String string,
                                     JComponent text,
                                     char c){
        JLabel label=newLabel(string);
        label.setLabelFor(text);
        if (c!=0) label.setDisplayedMnemonic(c);
        JPanel panel=new JPanel(new FlowLayout(FlowLayout.TRAILING));
        panel.add(label);
        panel.add(text);
            
        return panel;
    }
    public static JPanel addElements(String label, JComponent text){
        return addElements(label, text, (char)0);
    }    
}
