import java.io.File;
import java.io.IOException;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.util.ArrayList;

public class Books{
    //--- Variables ------------------------------------------------------------
    private final static String VERSION="0.1";
    private static final String fileName="books.dat";

    //--- This is to be a singleton class
    private final static Books instance=new Books();
    static ArrayList<Book> books=new ArrayList<Book>();

    //--- Methods --------------------------------------------------------------
    private Books(){}
    public static Books getInstance(){return instance;}
    public void add(Book b){books.add(b);}
    public Book get(int i){return books.get(i);}
    public void set(int i, Book b){books.set(i, b);}
    public void remove(int i){books.remove(i);}
    public int size(){return books.size();}
    public boolean load(){
        books.clear();
        try{
            File file=new File(fileName);
            if (!file.exists()) return true;
            BufferedReader f=new BufferedReader(new FileReader(file));
            boolean ok=true;
            while (f.ready() && ok){
                Book book=new Book();
                if (book.read(f)){
                    books.add(book);
                } else {
                    System.out.println(books.get(books.size()-1));
                    break;
                }
            }
            f.close();
        } catch (IOException e){return false;}
        return true;        
    }
    public boolean save(){
        try{
            BufferedWriter f=new BufferedWriter(new FileWriter(fileName));
            for (int i=0; i<books.size(); i++){
                books.get(i).write(f);
            }       
            f.close();
        } catch (IOException e){return false;}
        return true;
    }        
}
